/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.particles.TargetColorParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public abstract class CraftParticle<D>
implements Keyed {
    private static final Registry<CraftParticle<?>> CRAFT_PARTICLE_REGISTRY = new CraftParticleRegistry(CraftRegistry.getMinecraftRegistry(Registries.PARTICLE_TYPE));
    private final NamespacedKey key;
    private final ParticleType<?> particle;
    private final Class<D> clazz;

    public static Particle minecraftToBukkit(ParticleType<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.PARTICLE_TYPE);
        Particle bukkit = (Particle)Registry.PARTICLE_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.getResourceKey(minecraft).orElseThrow().location()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static ParticleType<?> bukkitToMinecraft(Particle bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (ParticleType)CraftRegistry.getMinecraftRegistry(Registries.PARTICLE_TYPE).getOptional(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static <D> ParticleOptions createParticleParam(Particle particle, D data) {
        CraftParticle craftParticle;
        Preconditions.checkArgument((particle != null ? 1 : 0) != 0, (Object)"particle cannot be null");
        data = CraftParticle.convertLegacy(data);
        if (particle.getDataType() != Void.class) {
            Preconditions.checkArgument((data != null ? 1 : 0) != 0, (String)"missing required data %s", (Object)particle.getDataType());
        }
        if (data != null) {
            Preconditions.checkArgument((boolean)particle.getDataType().isInstance(data), (String)"data (%s) should be %s", data.getClass(), (Object)particle.getDataType());
        }
        Preconditions.checkArgument(((craftParticle = (CraftParticle)CRAFT_PARTICLE_REGISTRY.get(particle.getKey())) != null ? 1 : 0) != 0);
        return craftParticle.createParticleParam(data);
    }

    public static <T> T convertLegacy(T object) {
        if (object instanceof MaterialData) {
            MaterialData mat = (MaterialData)object;
            return (T)CraftBlockData.fromData(CraftMagicNumbers.getBlock(mat));
        }
        return object;
    }

    public CraftParticle(NamespacedKey key, ParticleType<?> particle, Class<D> clazz) {
        this.key = key;
        this.particle = particle;
        this.clazz = clazz;
    }

    public ParticleType<?> getHandle() {
        return this.particle;
    }

    public abstract ParticleOptions createParticleParam(D var1);

    public NamespacedKey getKey() {
        return this.key;
    }

    public static class CraftParticleRegistry
    extends CraftRegistry<CraftParticle<?>, ParticleType<?>> {
        private static final Map<NamespacedKey, BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>>> PARTICLE_MAP = new HashMap();
        private static final BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> VOID_FUNCTION = (name, particle) -> new CraftParticle<Void>(name, particle, Void.class){

            @Override
            public ParticleOptions createParticleParam(Void data) {
                return (SimpleParticleType)this.getHandle();
            }
        };

        private static void add(String name, BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> function) {
            PARTICLE_MAP.put(NamespacedKey.fromString((String)name), function);
        }

        public CraftParticleRegistry(net.minecraft.core.Registry<ParticleType<?>> minecraftRegistry) {
            super(CraftParticle.class, minecraftRegistry, null, FieldRename.PARTICLE_TYPE_RENAME);
        }

        @Override
        public CraftParticle<?> createBukkit(NamespacedKey namespacedKey, ParticleType<?> particle) {
            if (particle == null) {
                return null;
            }
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> function = PARTICLE_MAP.getOrDefault(namespacedKey, VOID_FUNCTION);
            return function.apply(namespacedKey, particle);
        }

        static {
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> dustOptionsFunction = (name, particle) -> new CraftParticle<Particle.DustOptions>(name, particle, Particle.DustOptions.class){

                @Override
                public ParticleOptions createParticleParam(Particle.DustOptions data) {
                    Color color = data.getColor();
                    return new DustParticleOptions(color.asRGB(), data.getSize());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> itemStackFunction = (name, particle) -> new CraftParticle<ItemStack>(name, particle, ItemStack.class){

                @Override
                public ParticleOptions createParticleParam(ItemStack data) {
                    return new ItemParticleOption(this.getHandle(), CraftItemStack.asNMSCopy(data));
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> blockDataFunction = (name, particle) -> new CraftParticle<BlockData>(name, particle, BlockData.class){

                @Override
                public ParticleOptions createParticleParam(BlockData data) {
                    return new BlockParticleOption(this.getHandle(), ((CraftBlockData)data).getState());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> dustTransitionFunction = (name, particle) -> new CraftParticle<Particle.DustTransition>(name, particle, Particle.DustTransition.class){

                @Override
                public ParticleOptions createParticleParam(Particle.DustTransition data) {
                    Color from = data.getColor();
                    Color to = data.getToColor();
                    return new DustColorTransitionOptions(from.asRGB(), to.asRGB(), data.getSize());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> vibrationFunction = (name, particle) -> new CraftParticle<Vibration>(name, particle, Vibration.class){

                @Override
                public ParticleOptions createParticleParam(Vibration data) {
                    PositionSource source;
                    if (data.getDestination() instanceof Vibration.Destination.BlockDestination) {
                        Location destination = ((Vibration.Destination.BlockDestination)data.getDestination()).getLocation();
                        source = new BlockPositionSource(CraftLocation.toBlockPosition(destination));
                    } else if (data.getDestination() instanceof Vibration.Destination.EntityDestination) {
                        Entity destination = ((CraftEntity)((Vibration.Destination.EntityDestination)data.getDestination()).getEntity()).getHandle();
                        source = new EntityPositionSource(destination, destination.getEyeHeight());
                    } else {
                        throw new IllegalArgumentException("Unknown vibration destination " + String.valueOf(data.getDestination()));
                    }
                    return new VibrationParticleOption(source, data.getArrivalTime());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> floatFunction = (name, particle) -> new CraftParticle<Float>(name, particle, Float.class){

                @Override
                public ParticleOptions createParticleParam(Float data) {
                    return new SculkChargeParticleOptions(data.floatValue());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> integerFunction = (name, particle) -> new CraftParticle<Integer>(name, particle, Integer.class){

                @Override
                public ParticleOptions createParticleParam(Integer data) {
                    return new ShriekParticleOption(data);
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> colorFunction = (name, particle) -> new CraftParticle<Color>(name, particle, Color.class){

                @Override
                public ParticleOptions createParticleParam(Color color) {
                    return ColorParticleOption.create(particle, color.asARGB());
                }
            };
            BiFunction<NamespacedKey, ParticleType<?>, CraftParticle<?>> targetColorFunction = (name, particle) -> new CraftParticle<Particle.TargetColor>(name, particle, Particle.TargetColor.class){

                @Override
                public ParticleOptions createParticleParam(Particle.TargetColor data) {
                    return new TargetColorParticleOption(CraftLocation.toVec3D(data.getTarget()), data.getColor().asRGB());
                }
            };
            CraftParticleRegistry.add("dust", dustOptionsFunction);
            CraftParticleRegistry.add("item", itemStackFunction);
            CraftParticleRegistry.add("block", blockDataFunction);
            CraftParticleRegistry.add("falling_dust", blockDataFunction);
            CraftParticleRegistry.add("dust_color_transition", dustTransitionFunction);
            CraftParticleRegistry.add("vibration", vibrationFunction);
            CraftParticleRegistry.add("sculk_charge", floatFunction);
            CraftParticleRegistry.add("shriek", integerFunction);
            CraftParticleRegistry.add("block_marker", blockDataFunction);
            CraftParticleRegistry.add("entity_effect", colorFunction);
            CraftParticleRegistry.add("dust_pillar", blockDataFunction);
            CraftParticleRegistry.add("block_crumble", blockDataFunction);
            CraftParticleRegistry.add("trail", targetColorFunction);
        }
    }
}

