/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftSound
implements Sound,
Handleable<SoundEvent> {
    private static int count = 0;
    private final NamespacedKey key;
    private final SoundEvent soundEffect;
    private final String name;
    private final int ordinal;

    public static Sound minecraftToBukkit(SoundEvent minecraft) {
        return (Sound)CraftRegistry.minecraftToBukkit(minecraft, Registries.SOUND_EVENT, Registry.SOUNDS);
    }

    public static SoundEvent bukkitToMinecraft(Sound bukkit) {
        return (SoundEvent)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<SoundEvent> bukkitToMinecraftHolder(Sound bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.SOUND_EVENT);
        Holder<SoundEvent> holder = registry.wrapAsHolder(CraftSound.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.Reference) {
            Holder.Reference holder2 = (Holder.Reference)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public CraftSound(NamespacedKey key, SoundEvent soundEffect) {
        this.key = key;
        this.soundEffect = soundEffect;
        this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT).replace('.', '_') : key.toString();
        this.ordinal = count++;
    }

    @Override
    public SoundEvent getHandle() {
        return this.soundEffect;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public int compareTo(@NotNull Sound sound) {
        return this.ordinal - sound.ordinal();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftSound)) {
            return false;
        }
        CraftSound otherSound = (CraftSound)other;
        return this.getKey().equals((Object)otherSound.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public static String getSound(Sound sound) {
        return sound.getKey().getKey();
    }
}

