/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.util.ChunkSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.StackWalkerUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.sound.Sound;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.CraftEffect;
import org.bukkit.craftbukkit.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.CraftHeightMap;
import org.bukkit.craftbukkit.CraftParticle;
import org.bukkit.craftbukkit.CraftRaid;
import org.bukkit.craftbukkit.CraftRegionAccessor;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.CraftWorldBorder;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.generator.structure.CraftGeneratedStructure;
import org.bukkit.craftbukkit.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftBiomeSearchResult;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.CraftRayTraceResult;
import org.bukkit.craftbukkit.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.util.CraftStructureSearchResult;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BiomeSearchResult;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.StructureSearchResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.AsyncCatcher;

public class CraftWorld
extends CraftRegionAccessor
implements World {
    public static final int CUSTOM_DIMENSION_OFFSET = 10;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private final ServerLevel world;
    private WorldBorder worldBorder;
    private World.Environment environment;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    private final org.bukkit.generator.ChunkGenerator generator;
    private final BiomeProvider biomeProvider;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit = new Object2IntOpenHashMap();
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private Pointers adventure$pointers;
    private boolean voidDamageEnabled;
    private float voidDamageAmount;
    private double voidDamageMinBuildHeightOffset;
    private static final Random rand = new Random();
    private Map<String, GameRules.Key<?>> gamerules;
    private Map<String, GameRules.Type<?>> gameruleDefinitions;
    private final World.Spigot spigot = new World.Spigot(){

        public LightningStrike strikeLightning(Location loc, boolean isSilent) {
            return CraftWorld.this.strikeLightning(loc);
        }

        public LightningStrike strikeLightningEffect(Location loc, boolean isSilent) {
            return CraftWorld.this.strikeLightningEffect(loc);
        }
    };

    public boolean isVoidDamageEnabled() {
        return this.voidDamageEnabled;
    }

    public void setVoidDamageEnabled(boolean enabled) {
        this.voidDamageEnabled = enabled;
    }

    public float getVoidDamageAmount() {
        return this.voidDamageAmount;
    }

    public void setVoidDamageAmount(float voidDamageAmount) {
        this.voidDamageAmount = voidDamageAmount;
    }

    public double getVoidDamageMinBuildHeightOffset() {
        return this.voidDamageMinBuildHeightOffset;
    }

    public void setVoidDamageMinBuildHeightOffset(double minBuildHeightOffset) {
        this.voidDamageMinBuildHeightOffset = minBuildHeightOffset;
    }

    public int getEntityCount() {
        int ret = 0;
        for (net.minecraft.world.entity.Entity entity : this.world.getEntities().getAll()) {
            if (!entity.isChunkLoaded()) continue;
            ++ret;
        }
        return ret;
    }

    public int getTileEntityCount() {
        int size = 0;
        for (ChunkHolder playerchunk : ChunkSystem.getVisibleChunkHolders(this.world)) {
            LevelChunk chunk = playerchunk.getTickingChunk();
            if (chunk == null) continue;
            size += chunk.blockEntities.size();
        }
        return size;
    }

    public int getTickableTileEntityCount() {
        return this.world.blockEntityTickers.size();
    }

    public int getChunkCount() {
        return this.world.getChunkSource().getFullChunksCount();
    }

    public int getPlayerCount() {
        return this.world.players().size();
    }

    public BiomeProvider vanillaBiomeProvider() {
        BiomeSource biomeSource;
        ServerChunkCache serverCache = this.getHandle().chunkSource;
        ChunkGenerator gen = serverCache.getGenerator();
        if (gen instanceof CustomChunkGenerator) {
            CustomChunkGenerator custom = (CustomChunkGenerator)gen;
            biomeSource = custom.getDelegate().getBiomeSource();
        } else {
            biomeSource = gen.getBiomeSource();
        }
        if (biomeSource instanceof CustomWorldChunkManager) {
            CustomWorldChunkManager customBiomeSource = (CustomWorldChunkManager)biomeSource;
            biomeSource = customBiomeSource.vanillaBiomeSource;
        }
        final BiomeSource finalBiomeSource = biomeSource;
        final Climate.Sampler sampler = serverCache.randomState().sampler();
        final List<org.bukkit.block.Biome> possibleBiomes = finalBiomeSource.possibleBiomes().stream().map(CraftBiome::minecraftHolderToBukkit).toList();
        return new BiomeProvider(this){

            public org.bukkit.block.Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
                return CraftBiome.minecraftHolderToBukkit(finalBiomeSource.getNoiseBiome(x >> 2, y >> 2, z >> 2, sampler));
            }

            public List<org.bukkit.block.Biome> getBiomes(WorldInfo worldInfo) {
                return possibleBiomes;
            }
        };
    }

    public boolean hasStructureAt(Position position, Structure structure) {
        return this.world.structureManager().getStructureWithPieceAt(MCUtil.toBlockPos(position), CraftStructure.bukkitToMinecraft(structure)).isValid();
    }

    public CraftWorld(ServerLevel world, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.world = world;
        this.generator = gen;
        this.biomeProvider = biomeProvider;
        this.environment = env;
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.setSpawnLimit(spawnCategory, this.world.paperConfig().entities.spawning.spawnLimits.getInt((Object)CraftSpawnCategory.toNMS(spawnCategory)));
        }
        this.voidDamageEnabled = this.world.paperConfig().environment.voidDamageAmount.enabled();
        this.voidDamageMinBuildHeightOffset = this.world.paperConfig().environment.voidDamageMinBuildHeightOffset;
        this.voidDamageAmount = (float)this.world.paperConfig().environment.voidDamageAmount.or(0.0);
    }

    public org.bukkit.block.Block getBlockAt(int x, int y, int z) {
        return CraftBlock.at(this.world, new BlockPos(x, y, z));
    }

    public Location getSpawnLocation() {
        BlockPos spawn = this.world.getSharedSpawnPos();
        float yaw = this.world.getSharedSpawnAngle();
        return CraftLocation.toBukkit(spawn, (World)this, yaw, 0.0f);
    }

    public boolean setSpawnLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        return this.equals(location.getWorld()) ? this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getYaw()) : false;
    }

    public boolean setSpawnLocation(int x, int y, int z, float angle) {
        try {
            this.world.setDefaultSpawnPos(new BlockPos(x, y, z), angle);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setSpawnLocation(int x, int y, int z) {
        return this.setSpawnLocation(x, y, z, 0.0f);
    }

    private static void warnUnsafeChunk(String reason, int x, int z) {
        if (x > 1875000 || z > 1875000 || x < -1875000 || z < -1875000) {
            JavaPlugin plugin = StackWalkerUtil.getFirstPluginCaller();
            if (plugin != null) {
                plugin.getLogger().warning("Plugin is %s at (%s, %s), this might cause issues.".formatted(reason, x, z));
            }
            if (MinecraftServer.getServer().isDebugging()) {
                TraceUtil.dumpTraceForThread("Dangerous chunk retrieval");
            }
        }
    }

    public Chunk getChunkAt(int x, int z) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk", x, z);
        LevelChunk chunk = (LevelChunk)this.world.getChunk(x, z, ChunkStatus.FULL, true);
        return new CraftChunk(chunk);
    }

    @NotNull
    public Chunk getChunkAt(int x, int z, boolean generate) {
        if (generate) {
            return this.getChunkAt(x, z);
        }
        return new CraftChunk(this.getHandle(), x, z);
    }

    public Chunk getChunkAt(org.bukkit.block.Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"null block");
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.world.getChunkSource().isChunkLoaded(x, z);
    }

    public boolean isChunkGenerated(int x, int z) {
        if (!Bukkit.isPrimaryThread()) {
            return CompletableFuture.supplyAsync(() -> this.isChunkGenerated(x, z), this.world.getChunkSource().mainThreadProcessor).join();
        }
        ChunkAccess chunk = this.world.getChunkSource().getChunkAtImmediately(x, z);
        if (chunk != null) {
            return chunk instanceof ImposterProtoChunk || chunk instanceof LevelChunk;
        }
        CompletableFuture future = new CompletableFuture();
        ChunkSystem.scheduleChunkLoad(this.world, x, z, false, ChunkStatus.EMPTY, true, Priority.NORMAL, future::complete);
        this.world.getChunkSource().mainThreadProcessor.managedBlock(future::isDone);
        return (Boolean)((CompletableFuture)future.thenApply(c -> {
            if (c != null) {
                return c.getPersistedStatus() == ChunkStatus.FULL;
            }
            return false;
        })).join();
    }

    public Chunk[] getLoadedChunks() {
        List<ChunkHolder> chunks = ChunkSystem.getVisibleChunkHolders(this.world);
        return (Chunk[])chunks.stream().map(ChunkHolder::getFullChunkNow).filter(Objects::nonNull).map(CraftChunk::new).toArray(Chunk[]::new);
    }

    public void loadChunk(int x, int z) {
        this.loadChunk(x, z, true);
    }

    public boolean unloadChunk(Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    public boolean unloadChunk(int x, int z, boolean save) {
        return this.unloadChunk0(x, z, save);
    }

    public boolean unloadChunkRequest(int x, int z) {
        AsyncCatcher.catchOp("chunk unload");
        if (this.isChunkLoaded(x, z)) {
            this.world.getChunkSource().removeRegionTicket(TicketType.PLUGIN, new ChunkPos(x, z), 1, Unit.INSTANCE);
        }
        return true;
    }

    private boolean unloadChunk0(int x, int z, boolean save) {
        AsyncCatcher.catchOp("chunk unload");
        if (!this.isChunkLoaded(x, z)) {
            return true;
        }
        LevelChunk chunk = this.world.getChunk(x, z);
        if (!save) {
            chunk.tryMarkSaved();
        }
        this.unloadChunkRequest(x, z);
        this.world.getChunkSource().purgeUnload();
        return !this.isChunkLoaded(x, z);
    }

    public boolean regenerateChunk(int x, int z) {
        AsyncCatcher.catchOp("chunk regenerate");
        throw new UnsupportedOperationException("Not supported in this Minecraft version! Unless you can fix it, this is not a bug :)");
    }

    public boolean refreshChunk(int x, int z) {
        ChunkHolder playerChunk = this.world.getChunkSource().chunkMap.getVisibleChunkIfPresent(ChunkPos.asLong(x, z));
        if (playerChunk == null) {
            return false;
        }
        LevelChunk chunk = playerChunk.getChunkToSend();
        if (chunk == null) {
            return false;
        }
        List<ServerPlayer> playersInRange = playerChunk.playerProvider.getPlayers(playerChunk.getPos(), false);
        if (playersInRange.isEmpty()) {
            return true;
        }
        HashMap<Object, ClientboundLevelChunkWithLightPacket> refreshPackets = new HashMap<Object, ClientboundLevelChunkWithLightPacket>();
        for (ServerPlayer player : playersInRange) {
            if (player.connection == null) continue;
            Boolean shouldModify = chunk.getLevel().chunkPacketBlockController.shouldModify(player, chunk);
            player.connection.send(refreshPackets.computeIfAbsent(shouldModify, s -> new ClientboundLevelChunkWithLightPacket(chunk, this.world.getLightEngine(), null, null, (Boolean)s)));
        }
        return true;
    }

    public Collection<org.bukkit.entity.Player> getPlayersSeeingChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"chunk cannot be null");
        return this.getPlayersSeeingChunk(chunk.getX(), chunk.getZ());
    }

    public Collection<org.bukkit.entity.Player> getPlayersSeeingChunk(int x, int z) {
        if (!this.isChunkLoaded(x, z)) {
            return Collections.emptySet();
        }
        List<ServerPlayer> players = this.world.getChunkSource().chunkMap.getPlayers(new ChunkPos(x, z), false);
        if (players.isEmpty()) {
            return Collections.emptySet();
        }
        return players.stream().filter(Objects::nonNull).map(ServerPlayer::getBukkitEntity).collect(Collectors.toUnmodifiableSet());
    }

    public boolean isChunkInUse(int x, int z) {
        return this.isChunkLoaded(x, z);
    }

    public boolean loadChunk(int x, int z, boolean generate) {
        AsyncCatcher.catchOp("chunk load");
        CraftWorld.warnUnsafeChunk("loading a faraway chunk", x, z);
        ChunkAccess chunk = this.world.getChunkSource().getChunk(x, z, generate || this.isChunkGenerated(x, z) ? ChunkStatus.FULL : ChunkStatus.EMPTY, true);
        if (chunk instanceof ImposterProtoChunk) {
            chunk = this.world.getChunkSource().getChunk(x, z, ChunkStatus.FULL, true);
        }
        if (chunk instanceof LevelChunk) {
            this.world.getChunkSource().addRegionTicket(TicketType.PLUGIN, new ChunkPos(x, z), 1, Unit.INSTANCE);
            return true;
        }
        return false;
    }

    public boolean isChunkLoaded(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    public void loadChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        this.loadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean addPluginChunkTicket(int x, int z, Plugin plugin) {
        CraftWorld.warnUnsafeChunk("adding a faraway chunk ticket", x, z);
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"null plugin");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (Object)"plugin is not enabled");
        ChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.getChunkSource().chunkMap.distanceManager;
        if (chunkDistanceManager.addRegionTicketAtDistance(TicketType.PLUGIN_TICKET, new ChunkPos(x, z), 2, plugin)) {
            this.getChunkAt(x, z);
            return true;
        }
        return false;
    }

    public boolean removePluginChunkTicket(int x, int z, Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        ChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.getChunkSource().chunkMap.distanceManager;
        return chunkDistanceManager.removeRegionTicketAtDistance(TicketType.PLUGIN_TICKET, new ChunkPos(x, z), 2, plugin);
    }

    public void removePluginChunkTickets(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        ChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.getChunkSource().chunkMap.distanceManager;
        chunkDistanceManager.removeAllTicketsFor(TicketType.PLUGIN_TICKET, 31, plugin);
    }

    public Collection<Plugin> getPluginChunkTickets(int x, int z) {
        ChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.getChunkSource().chunkMap.distanceManager;
        return chunkDistanceManager.moonrise$getChunkHolderManager().getPluginChunkTickets(x, z);
    }

    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        HashMap<Plugin, ImmutableList.Builder> ret = new HashMap<Plugin, ImmutableList.Builder>();
        ChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.getChunkSource().chunkMap.distanceManager;
        for (Long2ObjectMap.Entry chunkTickets : chunkDistanceManager.moonrise$getChunkHolderManager().getTicketsCopy().long2ObjectEntrySet()) {
            long chunkKey = chunkTickets.getLongKey();
            SortedArraySet tickets = (SortedArraySet)chunkTickets.getValue();
            Chunk chunk = null;
            for (Ticket ticket : tickets) {
                if (ticket.getType() != TicketType.PLUGIN_TICKET) continue;
                if (chunk == null) {
                    chunk = this.getChunkAt(ChunkPos.getX(chunkKey), ChunkPos.getZ(chunkKey));
                }
                ret.computeIfAbsent((Plugin)ticket.key, key -> ImmutableList.builder()).add((Object)chunk);
            }
        }
        return (Map)ret.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableList.Builder)entry.getValue()).build()));
    }

    @NotNull
    public Collection<Chunk> getIntersectingChunks(@NotNull BoundingBox boundingBox) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int minX = NumberConversions.floor((double)boundingBox.getMinX()) >> 4;
        int maxX = NumberConversions.floor((double)boundingBox.getMaxX()) >> 4;
        int minZ = NumberConversions.floor((double)boundingBox.getMinZ()) >> 4;
        int maxZ = NumberConversions.floor((double)boundingBox.getMaxZ()) >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                chunks.add(this.getChunkAt(x, z, false));
            }
        }
        return chunks;
    }

    public boolean isChunkForceLoaded(int x, int z) {
        return this.getHandle().getForcedChunks().contains(ChunkPos.asLong(x, z));
    }

    public void setChunkForceLoaded(int x, int z, boolean forced) {
        CraftWorld.warnUnsafeChunk("forceloading a faraway chunk", x, z);
        this.getHandle().setChunkForced(x, z, forced);
    }

    public Collection<Chunk> getForceLoadedChunks() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        LongIterator longIterator = this.getHandle().getForcedChunks().iterator();
        while (longIterator.hasNext()) {
            long coord = (Long)longIterator.next();
            chunks.add(this.getChunkAt(ChunkPos.getX(coord), ChunkPos.getZ(coord)));
        }
        return Collections.unmodifiableCollection(chunks);
    }

    @Override
    public ServerLevel getHandle() {
        return this.world;
    }

    public Item dropItem(Location loc, ItemStack item) {
        return this.dropItem(loc, item, null);
    }

    public Item dropItem(Location loc, ItemStack item, Consumer<? super Item> function) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        ItemEntity entity = new ItemEntity(this.world, loc.getX(), loc.getY(), loc.getZ(), CraftItemStack.asNMSCopy(item));
        Item itemEntity = (Item)entity.getBukkitEntity();
        entity.pickupDelay = 10;
        if (function != null) {
            function.accept((Item)itemEntity);
        }
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return itemEntity;
    }

    public Item dropItemNaturally(Location loc, ItemStack item) {
        return this.dropItemNaturally(loc, item, null);
    }

    public Item dropItemNaturally(Location loc, ItemStack item, Consumer<? super Item> function) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        double xs = Mth.nextDouble(this.world.random, -0.25, 0.25);
        double ys = Mth.nextDouble(this.world.random, -0.25, 0.25) - (double)EntityType.ITEM.getHeight() / 2.0;
        double zs = Mth.nextDouble(this.world.random, -0.25, 0.25);
        loc = loc.clone().add(xs, ys, zs);
        return this.dropItem(loc, item, function);
    }

    public Arrow spawnArrow(Location loc, Vector velocity, float speed, float spread) {
        return this.spawnArrow(loc, velocity, speed, spread, Arrow.class);
    }

    public <T extends AbstractArrow> T spawnArrow(Location loc, Vector velocity, float speed, float spread, Class<T> clazz) {
        net.minecraft.world.entity.projectile.AbstractArrow arrow;
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"Vector cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz Entity for the arrow cannot be null");
        if (TippedArrow.class.isAssignableFrom(clazz)) {
            arrow = EntityType.ARROW.create(this.world, EntitySpawnReason.COMMAND);
            ((Arrow)arrow.getBukkitEntity()).setBasePotionType(PotionType.WATER);
        } else {
            arrow = SpectralArrow.class.isAssignableFrom(clazz) ? (net.minecraft.world.entity.projectile.AbstractArrow)EntityType.SPECTRAL_ARROW.create(this.world, EntitySpawnReason.COMMAND) : (Trident.class.isAssignableFrom(clazz) ? (net.minecraft.world.entity.projectile.AbstractArrow)EntityType.TRIDENT.create(this.world, EntitySpawnReason.COMMAND) : (net.minecraft.world.entity.projectile.AbstractArrow)EntityType.ARROW.create(this.world, EntitySpawnReason.COMMAND));
        }
        arrow.moveTo(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        arrow.shoot(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
        this.world.addFreshEntity(arrow);
        return (T)((AbstractArrow)arrow.getBukkitEntity());
    }

    public LightningStrike strikeLightning(Location loc) {
        return this.strikeLightning0(loc, false);
    }

    public LightningStrike strikeLightningEffect(Location loc) {
        return this.strikeLightning0(loc, true);
    }

    private LightningStrike strikeLightning0(Location loc, boolean isVisual) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        LightningBolt lightning = EntityType.LIGHTNING_BOLT.create(this.world, EntitySpawnReason.COMMAND);
        lightning.moveTo(loc.getX(), loc.getY(), loc.getZ());
        lightning.isEffect = isVisual;
        this.world.strikeLightning(lightning, LightningStrikeEvent.Cause.CUSTOM);
        return (LightningStrike)lightning.getBukkitEntity();
    }

    public Location findLightningRod(Location location) {
        return this.world.findLightningRod(MCUtil.toBlockPosition(location)).map(blockPos -> MCUtil.toLocation(this.world, blockPos).subtract(0.0, 1.0, 0.0)).orElse(null);
    }

    public Location findLightningTarget(Location location) {
        BlockPos pos = this.world.findLightningTargetAround(MCUtil.toBlockPosition(location), true);
        return pos == null ? null : MCUtil.toLocation(this.world, pos);
    }

    public boolean generateTree(Location loc, TreeType type) {
        return this.generateTree(loc, rand, type);
    }

    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        this.world.captureTreeGeneration = true;
        this.world.captureBlockStates = true;
        boolean grownTree = this.generateTree(loc, type);
        this.world.captureBlockStates = false;
        this.world.captureTreeGeneration = false;
        if (grownTree) {
            for (org.bukkit.block.BlockState blockState : this.world.capturedBlockStates.values()) {
                BlockPos position = ((CraftBlockState)blockState).getPosition();
                BlockState oldBlock = this.world.getBlockState(position);
                int flag = ((CraftBlockState)blockState).getFlag();
                delegate.setBlockData(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getBlockData());
                BlockState newBlock = this.world.getBlockState(position);
                this.world.notifyAndUpdatePhysics(position, null, oldBlock, newBlock, newBlock, flag, 512);
            }
            this.world.capturedBlockStates.clear();
            return true;
        }
        this.world.capturedBlockStates.clear();
        return false;
    }

    public String getName() {
        return this.world.serverLevelData.getLevelName();
    }

    public UUID getUID() {
        return this.world.uuid;
    }

    @Override
    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.world.dimension().location());
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + "}";
    }

    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    public long getFullTime() {
        return this.world.getDayTime();
    }

    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent((World)this, TimeSkipEvent.SkipReason.CUSTOM, time - this.world.getDayTime());
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.world.setDayTime(this.world.getDayTime() + event.getSkipAmount());
        for (org.bukkit.entity.Player p : this.getPlayers()) {
            CraftPlayer cp = (CraftPlayer)p;
            if (cp.getHandle().connection == null) continue;
            cp.getHandle().connection.send(new ClientboundSetTimePacket(cp.getHandle().level().getGameTime(), cp.getHandle().getPlayerTime(), cp.getHandle().serverLevel().getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
        }
    }

    public boolean isDayTime() {
        return this.getHandle().isDay();
    }

    public long getGameTime() {
        return this.world.levelData.getGameTime();
    }

    public boolean createExplosion(double x, double y, double z, float power) {
        return this.createExplosion(x, y, z, power, false, true);
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        return this.createExplosion(x, y, z, power, setFire, true);
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(x, y, z, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, Entity source) {
        return this.createExplosion(x, y, z, power, setFire, breakBlocks, source, null);
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, Entity source, Consumer<ServerExplosion> configurator) {
        Level.ExplosionInteraction explosionType = !breakBlocks ? Level.ExplosionInteraction.NONE : (source == null ? Level.ExplosionInteraction.STANDARD : Level.ExplosionInteraction.MOB);
        net.minecraft.world.entity.Entity entity = source == null ? null : ((CraftEntity)source).getHandle();
        return !this.world.explode0((net.minecraft.world.entity.Entity)entity, (DamageSource)Explosion.getDefaultDamageSource((Level)this.world, (net.minecraft.world.entity.Entity)entity), null, (double)x, (double)y, (double)z, (float)power, (boolean)setFire, (Level.ExplosionInteraction)explosionType, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE, configurator).wasCanceled;
    }

    public boolean createExplosion(Entity source, Location loc, float power, boolean setFire, boolean breakBlocks, boolean excludeSourceFromDamage) {
        return this.createExplosion(loc.x(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source, e -> {
            e.excludeSourceFromDamage = excludeSourceFromDamage;
        });
    }

    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc, power, setFire, true);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(loc, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location is null");
        Preconditions.checkArgument((boolean)this.equals(loc.getWorld()), (Object)"Location not in world");
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source);
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public org.bukkit.block.Block getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public org.bukkit.generator.ChunkGenerator getGenerator() {
        return this.generator;
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    @NotNull
    public <T extends LivingEntity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @NotNull CreatureSpawnEvent.SpawnReason spawnReason, boolean randomizeData, @Nullable Consumer<? super T> function) throws IllegalArgumentException {
        Preconditions.checkArgument((spawnReason != null ? 1 : 0) != 0, (Object)"Spawn reason cannot be null");
        return (T)((LivingEntity)this.spawn(location, clazz, function, spawnReason, randomizeData));
    }

    public org.bukkit.block.Block getHighestBlockAt(int x, int z) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z), z);
    }

    public org.bukkit.block.Block getHighestBlockAt(Location location) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(int x, int z, HeightMap heightMap) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk", x >> 4, z >> 4);
        return this.world.getChunk(x >> 4, z >> 4).getHeight(CraftHeightMap.toNMS(heightMap), x, z);
    }

    public org.bukkit.block.Block getHighestBlockAt(int x, int z, HeightMap heightMap) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z, heightMap), z);
    }

    public org.bukkit.block.Block getHighestBlockAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    public org.bukkit.block.Biome getBiome(int x, int z) {
        return this.getBiome(x, 0, z);
    }

    public void setBiome(int x, int z, org.bukkit.block.Biome bio) {
        for (int y = this.getMinHeight(); y < this.getMaxHeight(); ++y) {
            this.setBiome(x, y, z, bio);
        }
    }

    @Override
    public void setBiome(int x, int y, int z, Holder<Biome> bb) {
        LevelChunk chunk;
        BlockPos pos = new BlockPos(x, 0, z);
        if (this.world.hasChunkAt(pos) && (chunk = this.world.getChunkAt(pos)) != null) {
            chunk.setBiome(x >> 2, y >> 2, z >> 2, bb);
            chunk.markUnsaved();
        }
    }

    public double getTemperature(int x, int z) {
        return this.getTemperature(x, 0, z);
    }

    public double getTemperature(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        return this.world.getNoiseBiome(x >> 2, y >> 2, z >> 2).value().getTemperature(pos, this.world.getSeaLevel());
    }

    public double getHumidity(int x, int z) {
        return this.getHumidity(x, 0, z);
    }

    public double getHumidity(int x, int y, int z) {
        return this.world.getNoiseBiome((int)(x >> 2), (int)(y >> 2), (int)(z >> 2)).value().climateSettings.downfall();
    }

    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    @Override
    public Iterable<net.minecraft.world.entity.Entity> getNMSEntities() {
        return this.getHandle().getEntities().getAll();
    }

    @Override
    public void addEntityToWorld(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().addFreshEntity(entity, reason);
    }

    @Override
    public void addEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().tryAddFreshEntityWithPassengers(entity, reason);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        return this.getNearbyEntities(location, x, y, z, null);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z, Predicate<? super Entity> filter) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((boolean)this.equals(location.getWorld()), (Object)"Location cannot be in a different world");
        BoundingBox aabb = BoundingBox.of((Location)location, (double)x, (double)y, (double)z);
        return this.getNearbyEntities(aabb, filter);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox) {
        return this.getNearbyEntities(boundingBox, null);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<? super Entity> filter) {
        AsyncCatcher.catchOp("getNearbyEntities");
        Preconditions.checkArgument((boundingBox != null ? 1 : 0) != 0, (Object)"BoundingBox cannot be null");
        AABB bb = new AABB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List<net.minecraft.world.entity.Entity> entityList = this.getHandle().getEntities((net.minecraft.world.entity.Entity)null, bb, (Predicate<? super net.minecraft.world.entity.Entity>)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        for (net.minecraft.world.entity.Entity entity : entityList) {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (filter != null && !filter.test(bukkitEntity)) continue;
            bukkitEntityList.add(bukkitEntity);
        }
        return bukkitEntityList;
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance) {
        return this.rayTraceEntities(start, direction, maxDistance, null);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize) {
        return this.rayTraceEntities(start, direction, maxDistance, raySize, null);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, Predicate<? super Entity> filter) {
        return this.rayTraceEntities(start, direction, maxDistance, 0.0, filter);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<? super Entity> filter) {
        return this.rayTraceEntities((Position)start, direction, maxDistance, raySize, filter);
    }

    public RayTraceResult rayTraceEntities(Position start, Vector direction, double maxDistance, double raySize, Predicate<? super Entity> filter) {
        Location location;
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((!(start instanceof Location) || this.equals((location = (Location)start).getWorld()) ? 1 : 0) != 0, (Object)"Location start cannot be in a different world");
        Preconditions.checkArgument((boolean)start.isFinite(), (Object)"Location start is not finite");
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection<Entity> entities = this.getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance) {
        return this.rayTraceBlocks(start, direction, maxDistance, FluidCollisionMode.NEVER, false);
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        return this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, false);
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        return this.rayTraceBlocks((Position)start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks, null);
    }

    public RayTraceResult rayTraceBlocks(Position start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, Predicate<? super org.bukkit.block.Block> canCollide) {
        Location location;
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((!(start instanceof Location) || this.equals((location = (Location)start).getWorld()) ? 1 : 0) != 0, (Object)"Location start cannot be in a different world");
        Preconditions.checkArgument((boolean)start.isFinite(), (Object)"Location start is not finite");
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        Preconditions.checkArgument((fluidCollisionMode != null ? 1 : 0) != 0, (Object)"FluidCollisionMode cannot be null");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        Vec3 startPos = MCUtil.toVec3(start);
        Vec3 endPos = startPos.add(dir.getX(), dir.getY(), dir.getZ());
        BlockHitResult nmsHitResult = this.getHandle().clip(new ClipContext(startPos, endPos, ignorePassableBlocks ? ClipContext.Block.COLLIDER : ClipContext.Block.OUTLINE, CraftFluidCollisionMode.toNMS(fluidCollisionMode), CollisionContext.empty()), canCollide);
        return CraftRayTraceResult.fromNMS(this, nmsHitResult);
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<? super Entity> filter) {
        return this.rayTrace((Position)start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks, raySize, filter, null);
    }

    public RayTraceResult rayTrace(Position start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<? super Entity> filter, Predicate<? super org.bukkit.block.Block> canCollide) {
        RayTraceResult blockHit = this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks, canCollide);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = startVec.distance(blockHit.getHitPosition());
        }
        RayTraceResult entityHit = this.rayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        if (entityHitDistanceSquared < blockHitDistance * blockHitDistance) {
            return entityHit;
        }
        return blockHit;
    }

    public List<org.bukkit.entity.Player> getPlayers() {
        ArrayList<org.bukkit.entity.Player> list = new ArrayList<org.bukkit.entity.Player>(this.world.players().size());
        for (Player player : this.world.players()) {
            CraftHumanEntity bukkitEntity = player.getBukkitEntity();
            if (bukkitEntity == null || !(bukkitEntity instanceof org.bukkit.entity.Player)) continue;
            list.add((org.bukkit.entity.Player)bukkitEntity);
        }
        return list;
    }

    public Entity getEntity(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        net.minecraft.world.entity.Entity entity = this.world.getEntity(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void save() {
        AsyncCatcher.catchOp("world save");
        this.server.checkSaveState();
        boolean oldSave = this.world.noSave;
        this.world.noSave = false;
        this.world.save(null, false, false);
        this.world.noSave = oldSave;
    }

    public boolean isAutoSave() {
        return !this.world.noSave;
    }

    public void setAutoSave(boolean value) {
        this.world.noSave = !value;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().getServer().setDifficulty(this.getHandle(), net.minecraft.world.Difficulty.byId(difficulty.getValue()), true);
    }

    public Difficulty getDifficulty() {
        return Difficulty.getByValue((int)this.getHandle().getDifficulty().ordinal());
    }

    public int getViewDistance() {
        return this.getHandle().moonrise$getPlayerChunkLoader().getAPIViewDistance();
    }

    public int getSimulationDistance() {
        return this.getHandle().moonrise$getPlayerChunkLoader().getAPITickDistance();
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    public boolean hasStorm() {
        return this.world.levelData.isRaining();
    }

    public void setStorm(boolean hasStorm) {
        this.world.serverLevelData.setRaining(hasStorm, WeatherChangeEvent.Cause.PLUGIN);
        this.setWeatherDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getWeatherDuration() {
        return this.world.serverLevelData.getRainTime();
    }

    public void setWeatherDuration(int duration) {
        this.world.serverLevelData.setRainTime(duration);
    }

    public boolean isThundering() {
        return this.world.levelData.isThundering();
    }

    public void setThundering(boolean thundering) {
        this.world.serverLevelData.setThundering(thundering, ThunderChangeEvent.Cause.PLUGIN);
        this.setThunderDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getThunderDuration() {
        return this.world.serverLevelData.getThunderTime();
    }

    public void setThunderDuration(int duration) {
        this.world.serverLevelData.setThunderTime(duration);
    }

    public boolean isClearWeather() {
        return !this.hasStorm() && !this.isThundering();
    }

    public void setClearWeatherDuration(int duration) {
        this.world.serverLevelData.setClearWeatherTime(duration);
    }

    public int getClearWeatherDuration() {
        return this.world.serverLevelData.getClearWeatherTime();
    }

    public long getSeed() {
        return this.world.getSeed();
    }

    public boolean getPVP() {
        return this.world.pvpMode;
    }

    public void setPVP(boolean pvp) {
        this.world.pvpMode = pvp;
    }

    public void playEffect(org.bukkit.entity.Player player, Effect effect, int data) {
        this.playEffect(player.getLocation(), effect, data, 0);
    }

    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)effect);
            Preconditions.checkArgument((boolean)effect.isApplicable(data), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)effect);
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)effect);
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue, radius);
    }

    public void playEffect(Location location, Effect effect, int data, int radius) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World of Location cannot be null");
        int packetData = effect.getId();
        ClientboundLevelEventPacket packet = new ClientboundLevelEventPacket(packetData, CraftLocation.toBlockPosition(location), data, false);
        radius *= radius;
        for (org.bukkit.entity.Player player : this.getPlayers()) {
            int distance;
            if (((CraftPlayer)player).getHandle().connection == null || !location.getWorld().equals((Object)player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
            ((CraftPlayer)player).getHandle().connection.send(packet);
        }
    }

    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isBlock(), (String)"Material.%s must be a block", (Object)material);
        FallingBlockEntity entity = new FallingBlockEntity(this.world, location.getX(), location.getY(), location.getZ(), CraftBlockType.bukkitToMinecraft(material).defaultBlockState());
        entity.time = 1;
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        FallingBlockEntity entity = new FallingBlockEntity(this.world, location.getX(), location.getY(), location.getZ(), ((CraftBlockData)data).getState());
        entity.time = 1;
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public ChunkSnapshot getEmptyChunkSnapshot(int x, int z, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x, z, this, includeBiome, includeBiomeTempRain);
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.getChunkSource().setSpawnSettings(allowMonsters, allowAnimals);
    }

    public boolean getAllowAnimals() {
        return this.world.getChunkSource().spawnFriendlies;
    }

    public boolean getAllowMonsters() {
        return this.world.getChunkSource().spawnEnemies;
    }

    public int getMinHeight() {
        return this.world.getMinY();
    }

    public int getMaxHeight() {
        return this.world.getMaxY() + 1;
    }

    public int getMaxY() {
        return this.world.getMaxY();
    }

    public int getLogicalHeight() {
        return this.world.dimensionType().logicalHeight();
    }

    public boolean isNatural() {
        return this.world.dimensionType().natural();
    }

    public boolean isBedWorks() {
        return this.world.dimensionType().bedWorks();
    }

    public boolean hasSkyLight() {
        return this.world.dimensionType().hasSkyLight();
    }

    public boolean hasCeiling() {
        return this.world.dimensionType().hasCeiling();
    }

    public boolean isPiglinSafe() {
        return this.world.dimensionType().piglinSafe();
    }

    public boolean isRespawnAnchorWorks() {
        return this.world.dimensionType().respawnAnchorWorks();
    }

    public boolean hasRaids() {
        return this.world.dimensionType().hasRaids();
    }

    public boolean isUltraWarm() {
        return this.world.dimensionType().ultraWarm();
    }

    public int getSeaLevel() {
        return this.world.getSeaLevel();
    }

    public boolean getKeepSpawnInMemory() {
        return (Integer)this.getGameRuleValue(GameRule.SPAWN_CHUNK_RADIUS) > 0;
    }

    public void setKeepSpawnInMemory(boolean keepLoaded) {
        if (keepLoaded) {
            this.setGameRule(GameRule.SPAWN_CHUNK_RADIUS, (Integer)this.getGameRuleDefault(GameRule.SPAWN_CHUNK_RADIUS));
        } else {
            this.setGameRule(GameRule.SPAWN_CHUNK_RADIUS, 0);
        }
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    public File getWorldFolder() {
        return this.world.convertable.getLevelPath(LevelResource.ROOT).toFile().getParentFile();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (org.bukkit.entity.Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (org.bukkit.entity.Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public WorldType getWorldType() {
        return this.world.isFlat() ? WorldType.FLAT : WorldType.NORMAL;
    }

    public boolean canGenerateStructures() {
        return this.world.serverLevelData.worldGenOptions().generateStructures();
    }

    public boolean isHardcore() {
        return this.world.getLevelData().isHardcore();
    }

    public void setHardcore(boolean hardcore) {
        this.world.serverLevelData.settings.hardcore = hardcore;
    }

    @Deprecated
    public long getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.setTicksPerSpawns(SpawnCategory.ANIMAL, ticksPerAnimalSpawns);
    }

    @Deprecated
    public long getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Deprecated
    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.MONSTER, ticksPerMonsterSpawns);
    }

    @Deprecated
    public long getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_ANIMAL, ticksPerWaterSpawns);
    }

    @Deprecated
    public long getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public void setTicksPerWaterAmbientSpawns(int ticksPerWaterAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_AMBIENT, ticksPerWaterAmbientSpawns);
    }

    @Deprecated
    public long getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public void setTicksPerWaterUndergroundCreatureSpawns(int ticksPerWaterUndergroundCreatureSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE, ticksPerWaterUndergroundCreatureSpawns);
    }

    @Deprecated
    public long getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    @Deprecated
    public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.AMBIENT, ticksPerAmbientSpawns);
    }

    public void setTicksPerSpawns(SpawnCategory spawnCategory, int ticksPerCategorySpawn) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.world.ticksPerSpawnCategory.put((Object)spawnCategory, (long)ticksPerCategorySpawn);
    }

    public long getTicksPerSpawns(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.world.ticksPerSpawnCategory.getLong((Object)spawnCategory);
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Deprecated
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Deprecated
    public void setMonsterSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.MONSTER, limit);
    }

    @Deprecated
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public void setAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.ANIMAL, limit);
    }

    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public void setWaterAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_ANIMAL, limit);
    }

    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public void setWaterAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_AMBIENT, limit);
    }

    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public void setWaterUndergroundCreatureSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE, limit);
    }

    @Deprecated
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    @Deprecated
    public void setAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.AMBIENT, limit);
    }

    public int getSpawnLimit(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.getSpawnLimitUnsafe(spawnCategory);
    }

    public final int getSpawnLimitUnsafe(SpawnCategory spawnCategory) {
        int limit = this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
        if (limit < 0) {
            limit = this.server.getSpawnLimitUnsafe(spawnCategory);
        }
        return limit;
    }

    public void setSpawnLimit(SpawnCategory spawnCategory, int limit) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.spawnCategoryLimit.put((Object)spawnCategory, limit);
    }

    public void playNote(@NotNull Location loc, @NotNull Instrument instrument, @NotNull Note note) {
        this.playSound(loc, instrument.getSound(), SoundCategory.RECORDS, 3.0f, note.getPitch());
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        AsyncCatcher.catchOp("play sound");
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        this.getHandle().playSeededSound(null, x, y, z, CraftSound.bukkitToMinecraft(sound), SoundSource.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch, long seed) {
        AsyncCatcher.catchOp("play sound");
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        ClientboundSoundPacket packet = new ClientboundSoundPacket(Holder.direct(SoundEvent.createVariableRangeEvent(ResourceLocation.parse(sound))), SoundSource.valueOf(category.name()), x, y, z, volume, pitch, seed);
        this.world.getServer().getPlayerList().broadcast(null, x, y, z, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.world.dimension(), packet);
    }

    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, String sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                AsyncCatcher.catchOp("play sound");
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        ClientboundSoundEntityPacket packet = new ClientboundSoundEntityPacket(CraftSound.bukkitToMinecraftHolder(sound), SoundSource.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, seed);
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)this.getHandle().getChunkSource().chunkMap.entityMap.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.broadcastAndSend(packet);
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound) {
        AsyncCatcher.catchOp("play sound");
        long seed = sound.seed().orElseGet(this.world.getRandom()::nextLong);
        for (ServerPlayer player : this.getHandle().players()) {
            player.connection.send(PaperAdventure.asSoundPacket(sound, player.getX(), player.getY(), player.getZ(), seed, null));
        }
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch, long seed) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                AsyncCatcher.catchOp("play sound");
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        ClientboundSoundEntityPacket packet = new ClientboundSoundEntityPacket(Holder.direct(SoundEvent.createVariableRangeEvent(ResourceLocation.parse(sound))), SoundSource.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, seed);
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)this.getHandle().getChunkSource().chunkMap.entityMap.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.broadcastAndSend(packet);
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, double x, double y, double z) {
        AsyncCatcher.catchOp("play sound");
        PaperAdventure.asSoundPacket(sound, x, y, z, sound.seed().orElseGet(this.world.getRandom()::nextLong), this.playSound0(x, y, z));
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, Sound.Emitter emitter) {
        AsyncCatcher.catchOp("play sound");
        long seed = sound.seed().orElseGet(this.getHandle().getRandom()::nextLong);
        if (emitter == Sound.Emitter.self()) {
            for (ServerPlayer player : this.getHandle().players()) {
                player.connection.send(PaperAdventure.asSoundPacket(sound, player, seed, null));
            }
        } else if (emitter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)emitter;
            net.minecraft.world.entity.Entity entity = craftEntity.getHandle();
            PaperAdventure.asSoundPacket(sound, entity, seed, this.playSound0(entity.getX(), entity.getY(), entity.getZ()));
        } else {
            throw new IllegalArgumentException("Sound emitter must be an Entity or self(), but was: " + String.valueOf(emitter));
        }
    }

    private BiConsumer<Packet<?>, Float> playSound0(double x, double y, double z) {
        return (packet, distance) -> this.world.getServer().getPlayerList().broadcast(null, x, y, z, distance.floatValue(), this.world.dimension(), (Packet<?>)packet);
    }

    public synchronized Map<String, GameRules.Key<?>> getGameRulesNMS() {
        if (this.gamerules != null) {
            return this.gamerules;
        }
        this.gamerules = CraftWorld.getGameRulesNMS(this.getHandle().getGameRules());
        return this.gamerules;
    }

    public static Map<String, GameRules.Key<?>> getGameRulesNMS(GameRules gameRules) {
        final HashMap gamerules = new HashMap();
        gameRules.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            @Override
            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                gamerules.put(key.getId(), key);
            }
        });
        return gamerules;
    }

    public synchronized Map<String, GameRules.Type<?>> getGameRuleDefinitions() {
        if (this.gameruleDefinitions != null) {
            return this.gameruleDefinitions;
        }
        final HashMap gameruleDefinitions = new HashMap();
        this.getHandle().getGameRules().visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            @Override
            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                gameruleDefinitions.put(key.getId(), type);
            }
        });
        this.gameruleDefinitions = gameruleDefinitions;
        return this.gameruleDefinitions;
    }

    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        Object value = this.getHandle().getGameRules().getRule(this.getGameRulesNMS().get(rule));
        return value != null ? ((GameRules.Value)value).toString() : "";
    }

    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        GameRule gameRule = GameRule.getByName((String)rule);
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, gameRule, value);
        if (!event.callEvent()) {
            return false;
        }
        Object handle = this.getHandle().getGameRules().getRule(this.getGameRulesNMS().get(rule));
        ((GameRules.Value)handle).deserialize(event.getValue());
        ((GameRules.Value)handle).onChanged(this.getHandle());
        return true;
    }

    public String[] getGameRules() {
        return this.getGameRulesNMS().keySet().toArray(new String[this.getGameRulesNMS().size()]);
    }

    public boolean isGameRule(String rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"String rule cannot be null");
        Preconditions.checkArgument((!rule.isEmpty() ? 1 : 0) != 0, (Object)"String rule cannot be empty");
        return this.getGameRulesNMS().containsKey(rule);
    }

    public <T> T getGameRuleValue(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        return this.convert(rule, (GameRules.Value<?>)this.getHandle().getGameRules().getRule(this.getGameRulesNMS().get(rule.getName())));
    }

    public <T> T getGameRuleDefault(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        return this.convert(rule, (GameRules.Value<?>)this.getGameRuleDefinitions().get(rule.getName()).createRule());
    }

    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        Preconditions.checkArgument((newValue != null ? 1 : 0) != 0, (Object)"GameRule value cannot be null");
        if (!this.isGameRule(rule.getName())) {
            return false;
        }
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, rule, String.valueOf(newValue));
        if (!event.callEvent()) {
            return false;
        }
        Object handle = this.getHandle().getGameRules().getRule(this.getGameRulesNMS().get(rule.getName()));
        ((GameRules.Value)handle).deserialize(event.getValue());
        ((GameRules.Value)handle).onChanged(this.getHandle());
        return true;
    }

    private <T> T convert(GameRule<T> rule, GameRules.Value<?> value) {
        if (value == null) {
            return null;
        }
        if (value instanceof GameRules.BooleanValue) {
            return rule.getType().cast(((GameRules.BooleanValue)value).get());
        }
        if (value instanceof GameRules.IntegerValue) {
            return rule.getType().cast(value.getCommandResult());
        }
        throw new IllegalArgumentException("Invalid GameRule type (" + String.valueOf(value) + ") for GameRule " + rule.getName());
    }

    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new CraftWorldBorder(this);
        }
        return this.worldBorder;
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, null, null, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, List<org.bukkit.entity.Player> receivers, org.bukkit.entity.Player sender, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        if ((data = CraftParticle.convertLegacy(data)) != null) {
            Preconditions.checkArgument((boolean)particle.getDataType().isInstance(data), (String)"data (%s) should be %s", data.getClass(), (Object)particle.getDataType());
        }
        this.getHandle().sendParticles(receivers == null ? this.getHandle().players() : receivers.stream().map(player -> ((CraftPlayer)player).getHandle()).collect(Collectors.toList()), sender != null ? ((CraftPlayer)sender).getHandle() : null, CraftParticle.createParticleParam(particle, data), x, y, z, count, offsetX, offsetY, offsetZ, extra, force);
    }

    @Deprecated
    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        StructureSearchResult result = null;
        if (StructureType.MINESHAFT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.MINESHAFT, radius, findUnexplored);
        } else if (StructureType.VILLAGE == structureType) {
            result = this.locateNearestStructure(origin, List.of(Structure.VILLAGE_DESERT, Structure.VILLAGE_PLAINS, Structure.VILLAGE_SAVANNA, Structure.VILLAGE_SNOWY, Structure.VILLAGE_TAIGA), radius, findUnexplored);
        } else if (StructureType.NETHER_FORTRESS == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.FORTRESS, radius, findUnexplored);
        } else if (StructureType.STRONGHOLD == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.STRONGHOLD, radius, findUnexplored);
        } else if (StructureType.JUNGLE_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.JUNGLE_TEMPLE, radius, findUnexplored);
        } else if (StructureType.OCEAN_RUIN == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_RUIN, radius, findUnexplored);
        } else if (StructureType.DESERT_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.DESERT_PYRAMID, radius, findUnexplored);
        } else if (StructureType.IGLOO == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.IGLOO, radius, findUnexplored);
        } else if (StructureType.SWAMP_HUT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SWAMP_HUT, radius, findUnexplored);
        } else if (StructureType.OCEAN_MONUMENT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_MONUMENT, radius, findUnexplored);
        } else if (StructureType.END_CITY == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.END_CITY, radius, findUnexplored);
        } else if (StructureType.WOODLAND_MANSION == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.WOODLAND_MANSION, radius, findUnexplored);
        } else if (StructureType.BURIED_TREASURE == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.BURIED_TREASURE, radius, findUnexplored);
        } else if (StructureType.SHIPWRECK == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SHIPWRECK, radius, findUnexplored);
        } else if (StructureType.PILLAGER_OUTPOST == structureType) {
            result = this.locateNearestStructure(origin, Structure.PILLAGER_OUTPOST, radius, findUnexplored);
        } else if (StructureType.NETHER_FOSSIL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.NETHER_FOSSIL, radius, findUnexplored);
        } else if (StructureType.RUINED_PORTAL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.RUINED_PORTAL, radius, findUnexplored);
        } else if (StructureType.BASTION_REMNANT == structureType) {
            result = this.locateNearestStructure(origin, Structure.BASTION_REMNANT, radius, findUnexplored);
        }
        return result == null ? null : result.getLocation();
    }

    public StructureSearchResult locateNearestStructure(Location origin, org.bukkit.generator.structure.StructureType structureType, int radius, boolean findUnexplored) {
        ArrayList<Structure> structures = new ArrayList<Structure>();
        for (Structure structure : Registry.STRUCTURE) {
            if (structure.getStructureType() != structureType) continue;
            structures.add(structure);
        }
        return this.locateNearestStructure(origin, structures, radius, findUnexplored);
    }

    public StructureSearchResult locateNearestStructure(Location origin, Structure structure, int radius, boolean findUnexplored) {
        return this.locateNearestStructure(origin, List.of(structure), radius, findUnexplored);
    }

    public StructureSearchResult locateNearestStructure(Location origin, List<Structure> structures, int radius, boolean findUnexplored) {
        BlockPos originPos = BlockPos.containing(origin.getX(), origin.getY(), origin.getZ());
        ArrayList<Holder<net.minecraft.world.level.levelgen.structure.Structure>> holders = new ArrayList<Holder<net.minecraft.world.level.levelgen.structure.Structure>>();
        for (Structure structure : structures) {
            holders.add(Holder.direct(CraftStructure.bukkitToMinecraft(structure)));
        }
        Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> found = this.getHandle().getChunkSource().getGenerator().findNearestMapStructure(this.getHandle(), HolderSet.direct(holders), originPos, radius, findUnexplored);
        if (found == null) {
            return null;
        }
        return new CraftStructureSearchResult(CraftStructure.minecraftToBukkit((net.minecraft.world.level.levelgen.structure.Structure)((Holder)found.getSecond()).value()), CraftLocation.toBukkit((BlockPos)found.getFirst(), (World)this));
    }

    public double getCoordinateScale() {
        return this.getHandle().dimensionType().coordinateScale();
    }

    public boolean isFixedTime() {
        return this.getHandle().dimensionType().hasFixedTime();
    }

    public Collection<Material> getInfiniburn() {
        return Sets.newHashSet((Iterator)Iterators.transform(BuiltInRegistries.BLOCK.getTagOrEmpty(this.getHandle().dimensionType().infiniburn()).iterator(), blockHolder -> CraftBlockType.minecraftToBukkit((Block)blockHolder.value())));
    }

    public void sendGameEvent(Entity sourceEntity, GameEvent gameEvent, Vector position) {
        this.getHandle().gameEvent(sourceEntity != null ? ((CraftEntity)sourceEntity).getHandle() : null, (Holder<net.minecraft.world.level.gameevent.GameEvent>)BuiltInRegistries.GAME_EVENT.get(CraftNamespacedKey.toMinecraft(gameEvent.getKey())).orElseThrow(), CraftVector.toBlockPos(position));
    }

    public BiomeSearchResult locateNearestBiome(Location origin, int radius, org.bukkit.block.Biome ... biomes) {
        return this.locateNearestBiome(origin, radius, 32, 64, biomes);
    }

    public BiomeSearchResult locateNearestBiome(Location origin, int radius, int horizontalInterval, int verticalInterval, org.bukkit.block.Biome ... biomes) {
        BlockPos originPos = BlockPos.containing(origin.getX(), origin.getY(), origin.getZ());
        HashSet<Holder<Biome>> holders = new HashSet<Holder<Biome>>();
        for (org.bukkit.block.Biome biome : biomes) {
            holders.add(CraftBiome.bukkitToMinecraftHolder(biome));
        }
        Climate.Sampler sampler = this.getHandle().getChunkSource().randomState().sampler();
        Pair<BlockPos, Holder<Biome>> found = this.getHandle().getChunkSource().getGenerator().getBiomeSource().findClosestBiome3d(originPos, radius, horizontalInterval, verticalInterval, holders::contains, sampler, this.getHandle());
        if (found == null) {
            return null;
        }
        return new CraftBiomeSearchResult(CraftBiome.minecraftHolderToBukkit((Holder)found.getSecond()), new Location((World)this, (double)((BlockPos)found.getFirst()).getX(), (double)((BlockPos)found.getFirst()).getY(), (double)((BlockPos)found.getFirst()).getZ()));
    }

    public Raid locateNearestRaid(Location location, int radius) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (String)"Radius value (%s) cannot be negative", (int)radius);
        Raids persistentRaid = this.world.getRaids();
        net.minecraft.world.entity.raid.Raid raid = persistentRaid.getNearbyRaid(CraftLocation.toBlockPosition(location), radius * radius);
        return raid == null ? null : new CraftRaid(raid);
    }

    @Nullable
    public Raid getRaid(int id) {
        @Nullable net.minecraft.world.entity.raid.Raid nmsRaid = this.world.getRaids().raidMap.get(id);
        return nmsRaid != null ? new CraftRaid(nmsRaid) : null;
    }

    public List<Raid> getRaids() {
        Raids persistentRaid = this.world.getRaids();
        return persistentRaid.raidMap.values().stream().map(CraftRaid::new).collect(Collectors.toList());
    }

    public DragonBattle getEnderDragonBattle() {
        return this.getHandle().getDragonFight() == null ? null : new CraftDragonBattle(this.getHandle().getDragonFight());
    }

    public Collection<GeneratedStructure> getStructures(int x, int z) {
        return this.getStructures(x, z, (net.minecraft.world.level.levelgen.structure.Structure struct) -> true);
    }

    public Collection<GeneratedStructure> getStructures(int x, int z, Structure structure) {
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.STRUCTURE);
        ResourceLocation key = registry.getKey(CraftStructure.bukkitToMinecraft(structure));
        return this.getStructures(x, z, (net.minecraft.world.level.levelgen.structure.Structure struct) -> registry.getKey(struct).equals(key));
    }

    private List<GeneratedStructure> getStructures(int x, int z, Predicate<net.minecraft.world.level.levelgen.structure.Structure> predicate) {
        ArrayList<GeneratedStructure> structures = new ArrayList<GeneratedStructure>();
        for (StructureStart start : this.getHandle().structureManager().startsForStructure(new ChunkPos(x, z), predicate)) {
            structures.add(new CraftGeneratedStructure(start));
        }
        return structures;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public void storeBukkitValues(CompoundTag c) {
        if (!this.persistentDataContainer.isEmpty()) {
            c.put("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(Tag c) {
        if (c instanceof CompoundTag) {
            this.persistentDataContainer.putAll((CompoundTag)c);
        }
    }

    public World.Spigot spigot() {
        return this.spigot;
    }

    public void getChunkAtAsync(int x, int z, boolean gen, boolean urgent, @NotNull Consumer<? super Chunk> cb) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk async", x, z);
        ChunkSystem.scheduleChunkLoad(this.getHandle(), x, z, gen, ChunkStatus.FULL, true, urgent ? Priority.HIGHER : Priority.NORMAL, chunk -> cb.accept(chunk == null ? null : new CraftChunk((LevelChunk)chunk)));
    }

    public void getChunksAtAsync(int minX, int minZ, int maxX, int maxZ, boolean urgent, Runnable cb) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk async", minX, minZ);
        CraftWorld.warnUnsafeChunk("getting a faraway chunk async", maxX, maxZ);
        this.getHandle().loadChunks(minX, minZ, maxX, maxZ, urgent ? Priority.HIGHER : Priority.NORMAL, chunks -> cb.run());
    }

    public void setViewDistance(int viewDistance) {
        if (viewDistance < 2 || viewDistance > 32) {
            throw new IllegalArgumentException("View distance " + viewDistance + " is out of range of [2, 32]");
        }
        this.getHandle().chunkSource.chunkMap.setServerViewDistance(viewDistance);
    }

    public void setSimulationDistance(int simulationDistance) {
        if (simulationDistance < 2 || simulationDistance > 32) {
            throw new IllegalArgumentException("Simulation distance " + simulationDistance + " is out of range of [2, 32]");
        }
        this.getHandle().chunkSource.setSimulationDistance(simulationDistance);
    }

    public int getSendViewDistance() {
        return this.getHandle().moonrise$getPlayerChunkLoader().getAPISendViewDistance();
    }

    public void setSendViewDistance(int viewDistance) {
        this.getHandle().chunkSource.setSendViewDistance(viewDistance);
    }

    public Pointers pointers() {
        if (this.adventure$pointers == null) {
            this.adventure$pointers = (Pointers)Pointers.builder().withDynamic(Identity.NAME, this::getName).withDynamic(Identity.UUID, this::getUID).build();
        }
        return this.adventure$pointers;
    }
}

