/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.Handleable;
import org.jetbrains.annotations.NotNull;

public class CraftBiome
implements Biome,
Handleable<net.minecraft.world.level.biome.Biome> {
    private static int count = 0;
    private final NamespacedKey key;
    private final net.minecraft.world.level.biome.Biome biomeBase;
    private final String name;
    private final int ordinal;

    public static Biome minecraftToBukkit(net.minecraft.world.level.biome.Biome minecraft) {
        return (Biome)CraftRegistry.minecraftToBukkit(minecraft, Registries.BIOME, Registry.BIOME);
    }

    public static Biome minecraftHolderToBukkit(Holder<net.minecraft.world.level.biome.Biome> minecraft) {
        return CraftBiome.minecraftToBukkit(minecraft.value());
    }

    public static net.minecraft.world.level.biome.Biome bukkitToMinecraft(Biome bukkit) {
        if (bukkit == Biome.CUSTOM) {
            return null;
        }
        return (net.minecraft.world.level.biome.Biome)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<net.minecraft.world.level.biome.Biome> bukkitToMinecraftHolder(Biome bukkit) {
        if (bukkit == Biome.CUSTOM) {
            return null;
        }
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.BIOME);
        Holder<net.minecraft.world.level.biome.Biome> holder = registry.wrapAsHolder(CraftBiome.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.Reference) {
            Holder.Reference holder2 = (Holder.Reference)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own biome base with out properly registering it.");
    }

    public CraftBiome(NamespacedKey key, net.minecraft.world.level.biome.Biome biomeBase) {
        this.key = key;
        this.biomeBase = biomeBase;
        this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT) : key.toString();
        this.ordinal = count++;
    }

    @Override
    public net.minecraft.world.level.biome.Biome getHandle() {
        return this.biomeBase;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    public int compareTo(@NotNull Biome biome) {
        return this.ordinal - biome.ordinal();
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftBiome)) {
            return false;
        }
        CraftBiome otherBiome = (CraftBiome)other;
        return this.getKey().equals((Object)otherBiome.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

