/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBanner;
import org.bukkit.craftbukkit.block.CraftBarrel;
import org.bukkit.craftbukkit.block.CraftBeacon;
import org.bukkit.craftbukkit.block.CraftBed;
import org.bukkit.craftbukkit.block.CraftBeehive;
import org.bukkit.craftbukkit.block.CraftBell;
import org.bukkit.craftbukkit.block.CraftBlastFurnace;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.block.CraftBrewingStand;
import org.bukkit.craftbukkit.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.block.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.block.CraftCampfire;
import org.bukkit.craftbukkit.block.CraftChest;
import org.bukkit.craftbukkit.block.CraftChiseledBookshelf;
import org.bukkit.craftbukkit.block.CraftCommandBlock;
import org.bukkit.craftbukkit.block.CraftComparator;
import org.bukkit.craftbukkit.block.CraftConduit;
import org.bukkit.craftbukkit.block.CraftCrafter;
import org.bukkit.craftbukkit.block.CraftCreakingHeart;
import org.bukkit.craftbukkit.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.block.CraftDaylightDetector;
import org.bukkit.craftbukkit.block.CraftDecoratedPot;
import org.bukkit.craftbukkit.block.CraftDispenser;
import org.bukkit.craftbukkit.block.CraftDropper;
import org.bukkit.craftbukkit.block.CraftEnchantingTable;
import org.bukkit.craftbukkit.block.CraftEndGateway;
import org.bukkit.craftbukkit.block.CraftEndPortal;
import org.bukkit.craftbukkit.block.CraftEnderChest;
import org.bukkit.craftbukkit.block.CraftFurnaceFurnace;
import org.bukkit.craftbukkit.block.CraftHangingSign;
import org.bukkit.craftbukkit.block.CraftHopper;
import org.bukkit.craftbukkit.block.CraftJigsaw;
import org.bukkit.craftbukkit.block.CraftJukebox;
import org.bukkit.craftbukkit.block.CraftLectern;
import org.bukkit.craftbukkit.block.CraftMovingPiston;
import org.bukkit.craftbukkit.block.CraftSculkCatalyst;
import org.bukkit.craftbukkit.block.CraftSculkSensor;
import org.bukkit.craftbukkit.block.CraftSculkShrieker;
import org.bukkit.craftbukkit.block.CraftShulkerBox;
import org.bukkit.craftbukkit.block.CraftSign;
import org.bukkit.craftbukkit.block.CraftSkull;
import org.bukkit.craftbukkit.block.CraftSmoker;
import org.bukkit.craftbukkit.block.CraftStructureBlock;
import org.bukkit.craftbukkit.block.CraftTrialSpawner;
import org.bukkit.craftbukkit.block.CraftVault;

public final class CraftBlockStates {
    private static final Map<Material, BlockStateFactory<?>> FACTORIES = new HashMap();
    private static final BlockStateFactory<?> DEFAULT_FACTORY = new BlockStateFactory<CraftBlockState>(CraftBlockState.class){

        @Override
        public CraftBlockState createBlockState(World world, BlockPos blockPosition, net.minecraft.world.level.block.state.BlockState blockData, BlockEntity tileEntity) {
            Preconditions.checkState((tileEntity == null ? 1 : 0) != 0, (String)"Unexpected BlockState for %s", (Object)CraftBlockType.minecraftToBukkit(blockData.getBlock()));
            return new CraftBlockState(world, blockPosition, blockData);
        }
    };
    private static final Map<BlockEntityType<?>, BlockStateFactory<?>> FACTORIES_BY_BLOCK_ENTITY_TYPE = new HashMap();

    private static void register(BlockEntityType<?> type, BlockStateFactory<?> factory) {
        FACTORIES_BY_BLOCK_ENTITY_TYPE.put(type, factory);
    }

    private static void register(Material blockType, BlockStateFactory<?> factory) {
        FACTORIES.put(blockType, factory);
    }

    private static <T extends BlockEntity, B extends CraftBlockEntityState<T>> void register(BlockEntityType<? extends T> blockEntityType, Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor) {
        BlockEntityStateFactory<? extends T, B> factory = new BlockEntityStateFactory<T, B>(blockStateType, blockStateConstructor, blockEntityType);
        for (Block block : blockEntityType.validBlocks) {
            CraftBlockStates.register(CraftBlockType.minecraftToBukkit(block), factory);
        }
        CraftBlockStates.register(blockEntityType, factory);
    }

    private static BlockStateFactory<?> getFactory(Material material) {
        return FACTORIES.getOrDefault(material, DEFAULT_FACTORY);
    }

    private static BlockStateFactory<?> getFactory(Material material, BlockEntityType<?> type) {
        if (type != null) {
            return FACTORIES_BY_BLOCK_ENTITY_TYPE.getOrDefault(type, CraftBlockStates.getFactory(material));
        }
        return CraftBlockStates.getFactory(material);
    }

    public static Class<? extends CraftBlockState> getBlockStateType(Material material) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        return CraftBlockStates.getFactory((Material)material).blockStateType;
    }

    public static BlockEntity createNewTileEntity(Material material) {
        BlockStateFactory<?> factory = CraftBlockStates.getFactory(material);
        if (factory instanceof BlockEntityStateFactory) {
            return ((BlockEntityStateFactory)factory).createTileEntity(BlockPos.ZERO, CraftBlockType.bukkitToMinecraft(material).defaultBlockState());
        }
        return null;
    }

    public static Class<? extends CraftBlockState> getBlockStateType(BlockEntityType<?> blockEntityType) {
        Preconditions.checkNotNull(blockEntityType, (Object)"blockEntityType is null");
        return CraftBlockStates.getFactory(null, blockEntityType).blockStateType;
    }

    public static BlockState getBlockState(org.bukkit.block.Block block) {
        return CraftBlockStates.getBlockState(block, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockState getBlockState(org.bukkit.block.Block block, boolean useSnapshot) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        BlockPos blockPosition = craftBlock.getPosition();
        net.minecraft.world.level.block.state.BlockState blockData = craftBlock.getNMS();
        BlockEntity tileEntity = craftBlock.getHandle().getBlockEntity(blockPosition);
        boolean prev = CraftBlockEntityState.DISABLE_SNAPSHOT;
        CraftBlockEntityState.DISABLE_SNAPSHOT = !useSnapshot;
        try {
            CraftBlockState blockState = CraftBlockStates.getBlockState(world, blockPosition, blockData, tileEntity);
            blockState.setWorldHandle(craftBlock.getHandle());
            CraftBlockState craftBlockState = blockState;
            return craftBlockState;
        }
        finally {
            CraftBlockEntityState.DISABLE_SNAPSHOT = prev;
        }
    }

    @Deprecated
    public static BlockState getBlockState(BlockPos blockPosition, Material material, @Nullable CompoundTag blockEntityTag) {
        return CraftBlockStates.getBlockState(MinecraftServer.getDefaultRegistryAccess(), blockPosition, material, blockEntityTag);
    }

    public static BlockState getBlockState(LevelReader world, BlockPos blockPosition, Material material, @Nullable CompoundTag blockEntityTag) {
        return CraftBlockStates.getBlockState(world.registryAccess(), blockPosition, material, blockEntityTag);
    }

    public static BlockState getBlockState(RegistryAccess registry, BlockPos blockPosition, Material material, @Nullable CompoundTag blockEntityTag) {
        Preconditions.checkNotNull((Object)material, (Object)"material is null");
        net.minecraft.world.level.block.state.BlockState blockData = CraftBlockType.bukkitToMinecraft(material).defaultBlockState();
        return CraftBlockStates.getBlockState(registry, blockPosition, blockData, blockEntityTag);
    }

    @Deprecated
    public static BlockState getBlockState(net.minecraft.world.level.block.state.BlockState blockData, @Nullable CompoundTag blockEntityTag) {
        return CraftBlockStates.getBlockState(MinecraftServer.getDefaultRegistryAccess(), BlockPos.ZERO, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(LevelReader world, BlockPos blockPosition, net.minecraft.world.level.block.state.BlockState blockData, @Nullable CompoundTag blockEntityTag) {
        return CraftBlockStates.getBlockState(world.registryAccess(), blockPosition, blockData, blockEntityTag);
    }

    public static BlockState getBlockState(RegistryAccess registry, BlockPos blockPosition, net.minecraft.world.level.block.state.BlockState blockData, @Nullable CompoundTag blockEntityTag) {
        Preconditions.checkNotNull((Object)blockPosition, (Object)"blockPosition is null");
        Preconditions.checkNotNull((Object)blockData, (Object)"blockData is null");
        BlockEntity tileEntity = blockEntityTag == null ? null : BlockEntity.loadStatic(blockPosition, blockData, blockEntityTag, registry);
        return CraftBlockStates.getBlockState(null, blockPosition, blockData, tileEntity);
    }

    public static CraftBlockState getBlockState(World world, BlockPos blockPosition, net.minecraft.world.level.block.state.BlockState blockData, BlockEntity tileEntity) {
        Material material = CraftBlockType.minecraftToBukkit(blockData.getBlock());
        BlockStateFactory<?> factory = world != null && tileEntity == null && CraftBlockStates.isTileEntityOptional(material) ? DEFAULT_FACTORY : CraftBlockStates.getFactory(material, tileEntity != null ? tileEntity.getType() : null);
        return factory.createBlockState(world, blockPosition, blockData, tileEntity);
    }

    public static boolean isTileEntityOptional(Material material) {
        return material == Material.MOVING_PISTON;
    }

    public static CraftBlockState getBlockState(LevelAccessor world, BlockPos pos) {
        return new CraftBlockState(CraftBlock.at(world, pos));
    }

    public static CraftBlockState getBlockState(LevelAccessor world, BlockPos pos, int flag) {
        return new CraftBlockState(CraftBlock.at(world, pos), flag);
    }

    @Nullable
    public static BlockEntityType<?> getBlockEntityType(Material material) {
        BlockEntityType blockEntityType;
        BlockStateFactory<?> factory = FACTORIES.get(material);
        if (factory instanceof BlockEntityStateFactory) {
            BlockEntityStateFactory blockEntityStateFactory = (BlockEntityStateFactory)factory;
            blockEntityType = blockEntityStateFactory.tileEntityConstructor;
        } else {
            blockEntityType = null;
        }
        return blockEntityType;
    }

    private CraftBlockStates() {
    }

    static {
        CraftBlockStates.register(BlockEntityType.SIGN, CraftSign.class, CraftSign::new);
        CraftBlockStates.register(BlockEntityType.HANGING_SIGN, CraftHangingSign.class, CraftHangingSign::new);
        CraftBlockStates.register(BlockEntityType.SKULL, CraftSkull.class, CraftSkull::new);
        CraftBlockStates.register(BlockEntityType.COMMAND_BLOCK, CraftCommandBlock.class, CraftCommandBlock::new);
        CraftBlockStates.register(BlockEntityType.BANNER, CraftBanner.class, CraftBanner::new);
        CraftBlockStates.register(BlockEntityType.SHULKER_BOX, CraftShulkerBox.class, CraftShulkerBox::new);
        CraftBlockStates.register(BlockEntityType.BED, CraftBed.class, CraftBed::new);
        CraftBlockStates.register(BlockEntityType.BEEHIVE, CraftBeehive.class, CraftBeehive::new);
        CraftBlockStates.register(BlockEntityType.CAMPFIRE, CraftCampfire.class, CraftCampfire::new);
        CraftBlockStates.register(BlockEntityType.BARREL, CraftBarrel.class, CraftBarrel::new);
        CraftBlockStates.register(BlockEntityType.BEACON, CraftBeacon.class, CraftBeacon::new);
        CraftBlockStates.register(BlockEntityType.BELL, CraftBell.class, CraftBell::new);
        CraftBlockStates.register(BlockEntityType.BLAST_FURNACE, CraftBlastFurnace.class, CraftBlastFurnace::new);
        CraftBlockStates.register(BlockEntityType.BREWING_STAND, CraftBrewingStand.class, CraftBrewingStand::new);
        CraftBlockStates.register(BlockEntityType.CHEST, CraftChest.class, CraftChest::new);
        CraftBlockStates.register(BlockEntityType.CHISELED_BOOKSHELF, CraftChiseledBookshelf.class, CraftChiseledBookshelf::new);
        CraftBlockStates.register(BlockEntityType.COMPARATOR, CraftComparator.class, CraftComparator::new);
        CraftBlockStates.register(BlockEntityType.CONDUIT, CraftConduit.class, CraftConduit::new);
        CraftBlockStates.register(BlockEntityType.CREAKING_HEART, CraftCreakingHeart.class, CraftCreakingHeart::new);
        CraftBlockStates.register(BlockEntityType.DAYLIGHT_DETECTOR, CraftDaylightDetector.class, CraftDaylightDetector::new);
        CraftBlockStates.register(BlockEntityType.DECORATED_POT, CraftDecoratedPot.class, CraftDecoratedPot::new);
        CraftBlockStates.register(BlockEntityType.DISPENSER, CraftDispenser.class, CraftDispenser::new);
        CraftBlockStates.register(BlockEntityType.DROPPER, CraftDropper.class, CraftDropper::new);
        CraftBlockStates.register(BlockEntityType.ENCHANTING_TABLE, CraftEnchantingTable.class, CraftEnchantingTable::new);
        CraftBlockStates.register(BlockEntityType.ENDER_CHEST, CraftEnderChest.class, CraftEnderChest::new);
        CraftBlockStates.register(BlockEntityType.END_GATEWAY, CraftEndGateway.class, CraftEndGateway::new);
        CraftBlockStates.register(BlockEntityType.END_PORTAL, CraftEndPortal.class, CraftEndPortal::new);
        CraftBlockStates.register(BlockEntityType.FURNACE, CraftFurnaceFurnace.class, CraftFurnaceFurnace::new);
        CraftBlockStates.register(BlockEntityType.HOPPER, CraftHopper.class, CraftHopper::new);
        CraftBlockStates.register(BlockEntityType.JIGSAW, CraftJigsaw.class, CraftJigsaw::new);
        CraftBlockStates.register(BlockEntityType.JUKEBOX, CraftJukebox.class, CraftJukebox::new);
        CraftBlockStates.register(BlockEntityType.LECTERN, CraftLectern.class, CraftLectern::new);
        CraftBlockStates.register(BlockEntityType.PISTON, CraftMovingPiston.class, CraftMovingPiston::new);
        CraftBlockStates.register(BlockEntityType.SCULK_CATALYST, CraftSculkCatalyst.class, CraftSculkCatalyst::new);
        CraftBlockStates.register(BlockEntityType.SCULK_SENSOR, CraftSculkSensor.class, CraftSculkSensor::new);
        CraftBlockStates.register(BlockEntityType.SCULK_SHRIEKER, CraftSculkShrieker.class, CraftSculkShrieker::new);
        CraftBlockStates.register(BlockEntityType.CALIBRATED_SCULK_SENSOR, CraftCalibratedSculkSensor.class, CraftCalibratedSculkSensor::new);
        CraftBlockStates.register(BlockEntityType.SMOKER, CraftSmoker.class, CraftSmoker::new);
        CraftBlockStates.register(BlockEntityType.MOB_SPAWNER, CraftCreatureSpawner.class, CraftCreatureSpawner::new);
        CraftBlockStates.register(BlockEntityType.STRUCTURE_BLOCK, CraftStructureBlock.class, CraftStructureBlock::new);
        CraftBlockStates.register(BlockEntityType.BRUSHABLE_BLOCK, CraftBrushableBlock.class, CraftBrushableBlock::new);
        CraftBlockStates.register(BlockEntityType.TRAPPED_CHEST, CraftChest.class, CraftChest::new);
        CraftBlockStates.register(BlockEntityType.CRAFTER, CraftCrafter.class, CraftCrafter::new);
        CraftBlockStates.register(BlockEntityType.TRIAL_SPAWNER, CraftTrialSpawner.class, CraftTrialSpawner::new);
        CraftBlockStates.register(BlockEntityType.VAULT, CraftVault.class, CraftVault::new);
    }

    private static class BlockEntityStateFactory<T extends BlockEntity, B extends CraftBlockEntityState<T>>
    extends BlockStateFactory<B> {
        private final BiFunction<World, T, B> blockStateConstructor;
        private final BlockEntityType<? extends T> tileEntityConstructor;

        protected BlockEntityStateFactory(Class<B> blockStateType, BiFunction<World, T, B> blockStateConstructor, BlockEntityType<? extends T> tileEntityConstructor) {
            super(blockStateType);
            this.blockStateConstructor = blockStateConstructor;
            this.tileEntityConstructor = tileEntityConstructor;
        }

        @Override
        public final B createBlockState(World world, BlockPos blockPosition, net.minecraft.world.level.block.state.BlockState blockData, BlockEntity tileEntity) {
            if (world != null) {
                Preconditions.checkState((tileEntity != null ? 1 : 0) != 0, (String)"Tile is null, asynchronous access? %s", (Object)CraftBlock.at(((CraftWorld)world).getHandle(), blockPosition));
            } else if (tileEntity == null) {
                tileEntity = this.createTileEntity(blockPosition, blockData);
            }
            return this.createBlockState(world, tileEntity);
        }

        private T createTileEntity(BlockPos blockPosition, net.minecraft.world.level.block.state.BlockState blockData) {
            return this.tileEntityConstructor.create(blockPosition, blockData);
        }

        private B createBlockState(World world, T tileEntity) {
            return (B)((CraftBlockEntityState)this.blockStateConstructor.apply(world, (World)tileEntity));
        }
    }

    private static abstract class BlockStateFactory<B extends CraftBlockState> {
        public final Class<B> blockStateType;

        public BlockStateFactory(Class<B> blockStateType) {
            this.blockStateType = blockStateType;
        }

        public abstract B createBlockState(World var1, BlockPos var2, net.minecraft.world.level.block.state.BlockState var3, BlockEntity var4);
    }
}

