/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.util.TriState;
import net.minecraft.world.entity.item.ItemEntity;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftItem
extends CraftEntity
implements Item {
    private static final int NO_AGE_TIME = Short.MIN_VALUE;
    private static final int NO_PICKUP_TIME = Short.MAX_VALUE;

    public CraftItem(CraftServer server, ItemEntity entity) {
        super(server, entity);
    }

    @Override
    public ItemEntity getHandle() {
        return (ItemEntity)this.entity;
    }

    public ItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.getHandle().getItem());
    }

    public void setItemStack(ItemStack stack) {
        this.getHandle().setItem(CraftItemStack.asNMSCopy(stack));
    }

    public int getPickupDelay() {
        return this.getHandle().pickupDelay;
    }

    public void setPickupDelay(int delay) {
        this.getHandle().pickupDelay = Math.min(delay, Short.MAX_VALUE);
    }

    public void setUnlimitedLifetime(boolean unlimited) {
        this.getHandle().age = unlimited ? Short.MIN_VALUE : this.getTicksLived();
    }

    public boolean isUnlimitedLifetime() {
        return this.getHandle().age == Short.MIN_VALUE;
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        if (!this.isUnlimitedLifetime()) {
            this.getHandle().age = value;
        }
    }

    public boolean canMobPickup() {
        return this.getHandle().canMobPickup;
    }

    public void setCanMobPickup(boolean canMobPickup) {
        this.getHandle().canMobPickup = canMobPickup;
    }

    public boolean canPlayerPickup() {
        return this.getHandle().pickupDelay != Short.MAX_VALUE;
    }

    public void setCanPlayerPickup(boolean canPlayerPickup) {
        this.getHandle().pickupDelay = canPlayerPickup ? 0 : Short.MAX_VALUE;
    }

    public boolean willAge() {
        return this.getHandle().age != Short.MIN_VALUE;
    }

    public void setWillAge(boolean willAge) {
        this.getHandle().age = willAge ? 0 : Short.MIN_VALUE;
    }

    @NotNull
    public TriState getFrictionState() {
        return this.getHandle().frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Objects.requireNonNull(state, "state may not be null");
        this.getHandle().frictionState = state;
    }

    public int getHealth() {
        return this.getHandle().health;
    }

    public void setHealth(int health) {
        if (health <= 0) {
            this.getHandle().getItem().onDestroyed(this.getHandle());
            this.getHandle().discard(EntityRemoveEvent.Cause.PLUGIN);
        } else {
            this.getHandle().health = health;
        }
    }

    public void setOwner(UUID uuid) {
        this.getHandle().setTarget(uuid);
    }

    public UUID getOwner() {
        return this.getHandle().target;
    }

    public void setThrower(UUID uuid) {
        this.getHandle().thrower = uuid;
    }

    public UUID getThrower() {
        return this.getHandle().thrower;
    }

    @Override
    public String toString() {
        return "CraftItem";
    }
}

