/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;

public class CraftMinecartFurnace
extends CraftMinecart
implements PoweredMinecart {
    public CraftMinecartFurnace(CraftServer server, MinecartFurnace entity) {
        super(server, entity);
    }

    @Override
    public MinecartFurnace getHandle() {
        return (MinecartFurnace)this.entity;
    }

    public int getFuel() {
        return this.getHandle().fuel;
    }

    public void setFuel(int fuel) {
        Preconditions.checkArgument((fuel >= 0 ? 1 : 0) != 0, (Object)"ticks cannot be negative");
        this.getHandle().fuel = fuel;
    }

    public double getPushX() {
        return this.getHandle().push.x;
    }

    public double getPushZ() {
        return this.getHandle().push.z;
    }

    public void setPushX(double xPush) {
        Vec3 push = this.getHandle().push;
        this.getHandle().push = new Vec3(xPush, push.y, push.z);
    }

    public void setPushZ(double zPush) {
        Vec3 push = this.getHandle().push;
        this.getHandle().push = new Vec3(push.x, push.y, zPush);
    }

    @Override
    public String toString() {
        return "CraftMinecartFurnace";
    }
}

