/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.world.flag.PaperFeatureDependent;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.util.CraftMenus;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;

public class CraftMenuType<V extends InventoryView>
implements MenuType.Typed<V>,
Handleable<net.minecraft.world.inventory.MenuType<?>>,
PaperFeatureDependent {
    private final NamespacedKey key;
    private final net.minecraft.world.inventory.MenuType<?> handle;
    private final Supplier<CraftMenus.MenuTypeData<V>> typeData;

    public CraftMenuType(NamespacedKey key, net.minecraft.world.inventory.MenuType<?> handle) {
        this.key = key;
        this.handle = handle;
        this.typeData = Suppliers.memoize(() -> CraftMenus.getMenuTypeData(this));
    }

    @Override
    public net.minecraft.world.inventory.MenuType<?> getHandle() {
        return this.handle;
    }

    public V create(HumanEntity player, String title) {
        return this.create(player, (Component)LegacyComponentSerializer.legacySection().deserialize(title));
    }

    public V create(HumanEntity player, Component title) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"The given title must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof ServerPlayer), (Object)"The given player must be an EntityPlayer");
        ServerPlayer serverPlayer = (ServerPlayer)craftHuman.getHandle();
        AbstractContainerMenu container = this.typeData.get().menuBuilder().build(serverPlayer, this.handle);
        container.setTitle(PaperAdventure.asVanilla(title));
        container.checkReachable = false;
        return (V)container.getBukkitView();
    }

    public MenuType.Typed<InventoryView> typed() {
        return this.typed(InventoryView.class);
    }

    public <V extends InventoryView> MenuType.Typed<V> typed(Class<V> clazz) {
        if (clazz.isAssignableFrom(this.typeData.get().viewClass())) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type InventoryView " + this.key.toString() + " to InventoryView type " + clazz.getSimpleName());
    }

    public Class<? extends InventoryView> getInventoryViewClass() {
        return this.typeData.get().viewClass();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public static net.minecraft.world.inventory.MenuType<?> bukkitToMinecraft(MenuType bukkit) {
        return (net.minecraft.world.inventory.MenuType)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static MenuType minecraftToBukkit(net.minecraft.world.inventory.MenuType<?> minecraft) {
        return (MenuType)CraftRegistry.minecraftToBukkit(minecraft, Registries.MENU, Registry.MENU);
    }

    public static MenuType minecraftHolderToBukkit(Holder<net.minecraft.world.inventory.MenuType<?>> minecraft) {
        return CraftMenuType.minecraftToBukkit(minecraft.value());
    }
}

