/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.map;

import io.papermc.paper.adventure.PaperAdventure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.map.CraftMapCursor;
import org.bukkit.craftbukkit.map.CraftMapView;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class CraftMapRenderer
extends MapRenderer {
    private final MapItemSavedData worldMap;

    public CraftMapRenderer(CraftMapView mapView, MapItemSavedData worldMap) {
        super(false);
        this.worldMap = worldMap;
    }

    public void render(MapView map, MapCanvas canvas, Player player) {
        for (int y = 0; y < 128; ++y) {
            for (int x = 0; x < 128; ++x) {
                canvas.setPixel(x, y, this.worldMap.colors[y * 128 + x]);
            }
        }
        MapCursorCollection cursors = canvas.getCursors();
        while (cursors.size() > 0) {
            cursors.removeCursor(cursors.getCursor(0));
        }
        for (String key : this.worldMap.decorations.keySet()) {
            Player other = Bukkit.getPlayerExact((String)key);
            if (other != null && !player.canSee(other)) continue;
            MapDecoration decoration = this.worldMap.decorations.get(key);
            cursors.addCursor(new MapCursor(decoration.x(), decoration.y(), (byte)(decoration.rot() & 0xF), CraftMapCursor.CraftType.minecraftHolderToBukkit(decoration.type()), true, decoration.name().isEmpty() ? null : PaperAdventure.asAdventure(decoration.name().get())));
        }
    }
}

