/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.UUID;
import java.util.logging.Logger;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.RestartCommand;
import org.spigotmc.SpigotConfig;

public class WatchdogThread
extends TickThread {
    public static final boolean DISABLE_WATCHDOG = Boolean.getBoolean("disable.watchdog");
    private static WatchdogThread instance;
    private long timeoutTime;
    private boolean restart;
    private final long earlyWarningEvery;
    private final long earlyWarningDelay;
    public static volatile boolean hasStarted;
    private long lastEarlyWarning;
    private volatile long lastTick;
    private volatile boolean stopping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpEntity(Entity entity) {
        Vec3 moveVec;
        double moveStartZ;
        double moveStartY;
        double moveStartX;
        Vec3 mot;
        double posZ;
        double posY;
        double posX;
        Logger log = Bukkit.getServer().getLogger();
        Object object = entity.posLock;
        synchronized (object) {
            posX = entity.getX();
            posY = entity.getY();
            posZ = entity.getZ();
            mot = entity.getDeltaMovement();
            moveStartX = entity.getMoveStartX();
            moveStartY = entity.getMoveStartY();
            moveStartZ = entity.getMoveStartZ();
            moveVec = entity.getMoveVector();
        }
        String entityType = EntityType.getKey(entity.getType()).toString();
        UUID entityUUID = entity.getUUID();
        Level world = entity.level();
        log.log(java.util.logging.Level.SEVERE, "Ticking entity: " + entityType + ", entity class: " + entity.getClass().getName());
        log.log(java.util.logging.Level.SEVERE, "Entity status: removed: " + entity.isRemoved() + ", valid: " + entity.valid + ", alive: " + entity.isAlive() + ", is passenger: " + entity.isPassenger());
        log.log(java.util.logging.Level.SEVERE, "Entity UUID: " + String.valueOf(entityUUID));
        log.log(java.util.logging.Level.SEVERE, "Position: world: '" + (world == null ? "unknown world?" : world.getWorld().getName()) + "' at location (" + posX + ", " + posY + ", " + posZ + ")");
        log.log(java.util.logging.Level.SEVERE, "Velocity: " + (mot == null ? "unknown velocity" : mot.toString()) + " (in blocks per tick)");
        log.log(java.util.logging.Level.SEVERE, "Entity AABB: " + String.valueOf(entity.getBoundingBox()));
        if (moveVec != null) {
            log.log(java.util.logging.Level.SEVERE, "Move call information: ");
            log.log(java.util.logging.Level.SEVERE, "Start position: (" + moveStartX + ", " + moveStartY + ", " + moveStartZ + ")");
            log.log(java.util.logging.Level.SEVERE, "Move vector: " + moveVec.toString());
        }
    }

    private void dumpTickingInfo() {
        Logger log = Bukkit.getServer().getLogger();
        for (Entity entity : ServerLevel.getCurrentlyTickingEntities()) {
            this.dumpEntity(entity);
            Entity vehicle = entity.getVehicle();
            if (vehicle == null) continue;
            log.log(java.util.logging.Level.SEVERE, "Detailing vehicle for above entity:");
            this.dumpEntity(vehicle);
        }
        for (PacketListener packetListener : PacketUtils.getCurrentPacketProcessors()) {
            if (packetListener instanceof ServerGamePacketListenerImpl) {
                ServerPlayer player = ((ServerGamePacketListenerImpl)packetListener).player;
                long totalPackets = PacketUtils.getTotalProcessedPackets();
                if (player == null) {
                    log.log(java.util.logging.Level.SEVERE, "Handling packet for player connection or ticking player connection (null player): " + String.valueOf(packetListener));
                    log.log(java.util.logging.Level.SEVERE, "Total packets processed on the main thread for all players: " + totalPackets);
                    continue;
                }
                this.dumpEntity(player);
                Entity vehicle = player.getVehicle();
                if (vehicle != null) {
                    log.log(java.util.logging.Level.SEVERE, "Detailing vehicle for above entity:");
                    this.dumpEntity(vehicle);
                }
                log.log(java.util.logging.Level.SEVERE, "Total packets processed on the main thread for all players: " + totalPackets);
                continue;
            }
            log.log(java.util.logging.Level.SEVERE, "Handling packet for connection: " + String.valueOf(packetListener));
        }
    }

    private WatchdogThread(long timeoutTime, boolean restart) {
        super("Paper Watchdog Thread");
        this.timeoutTime = timeoutTime;
        this.restart = restart;
        this.earlyWarningEvery = Math.min((long)GlobalConfiguration.get().watchdog.earlyWarningEvery, timeoutTime);
        this.earlyWarningDelay = Math.min((long)GlobalConfiguration.get().watchdog.earlyWarningDelay, timeoutTime);
    }

    private static long monotonicMillis() {
        return System.nanoTime() / 1000000L;
    }

    public static void doStart(int timeoutTime, boolean restart) {
        if (instance == null) {
            if (timeoutTime <= 0) {
                timeoutTime = 300;
            }
            instance = new WatchdogThread((long)timeoutTime * 1000L, restart);
            instance.start();
        } else {
            WatchdogThread.instance.timeoutTime = (long)timeoutTime * 1000L;
            WatchdogThread.instance.restart = restart;
        }
    }

    public static void tick() {
        WatchdogThread.instance.lastTick = WatchdogThread.monotonicMillis();
    }

    public static void doStop() {
        if (instance != null) {
            WatchdogThread.instance.stopping = true;
        }
    }

    @Override
    public void run() {
        while (!this.stopping) {
            Logger log = Bukkit.getServer().getLogger();
            long currentTime = WatchdogThread.monotonicMillis();
            MinecraftServer server = MinecraftServer.getServer();
            if (this.lastTick != 0L && this.timeoutTime > 0L && hasStarted && (!server.isRunning() || currentTime > this.lastTick + this.earlyWarningEvery && !DISABLE_WATCHDOG)) {
                boolean isLongTimeout;
                boolean bl = isLongTimeout = currentTime > this.lastTick + this.timeoutTime || !server.isRunning() && !server.hasStopped() && currentTime > this.lastTick + 1000L;
                if (!isLongTimeout && (this.earlyWarningEvery <= 0L || !hasStarted || currentTime < this.lastEarlyWarning + this.earlyWarningEvery || currentTime < this.lastTick + this.earlyWarningDelay) || !isLongTimeout && server.hasStopped()) continue;
                this.lastEarlyWarning = currentTime;
                if (isLongTimeout) {
                    log.log(java.util.logging.Level.SEVERE, "------------------------------");
                    log.log(java.util.logging.Level.SEVERE, "The server has stopped responding! This is (probably) not a Paper bug.");
                    log.log(java.util.logging.Level.SEVERE, "If you see a plugin in the Server thread dump below, then please report it to that author");
                    log.log(java.util.logging.Level.SEVERE, "\t *Especially* if it looks like HTTP or MySQL operations are occurring");
                    log.log(java.util.logging.Level.SEVERE, "If you see a world save or edit, then it means you did far more than your server can handle at once");
                    log.log(java.util.logging.Level.SEVERE, "\t If this is the case, consider increasing timeout-time in spigot.yml but note that this will replace the crash with LARGE lag spikes");
                    log.log(java.util.logging.Level.SEVERE, "If you are unsure or still think this is a Paper bug, please report this to https://github.com/PaperMC/Paper/issues");
                    log.log(java.util.logging.Level.SEVERE, "Be sure to include ALL relevant console errors and Minecraft crash reports");
                    log.log(java.util.logging.Level.SEVERE, "Paper version: " + Bukkit.getServer().getVersion());
                    if (Level.lastPhysicsProblem != null) {
                        log.log(java.util.logging.Level.SEVERE, "------------------------------");
                        log.log(java.util.logging.Level.SEVERE, "During the run of the server, a physics stackoverflow was supressed");
                        log.log(java.util.logging.Level.SEVERE, "near " + String.valueOf(Level.lastPhysicsProblem));
                    }
                    if (CraftServer.excessiveVelEx != null) {
                        log.log(java.util.logging.Level.SEVERE, "------------------------------");
                        log.log(java.util.logging.Level.SEVERE, "During the run of the server, a plugin set an excessive velocity on an entity");
                        log.log(java.util.logging.Level.SEVERE, "This may be the cause of the issue, or it may be entirely unrelated");
                        log.log(java.util.logging.Level.SEVERE, CraftServer.excessiveVelEx.getMessage());
                        for (StackTraceElement stack : CraftServer.excessiveVelEx.getStackTrace()) {
                            log.log(java.util.logging.Level.SEVERE, "\t\t" + String.valueOf(stack));
                        }
                    }
                } else {
                    log.log(java.util.logging.Level.SEVERE, "--- DO NOT REPORT THIS TO PAPER - THIS IS NOT A BUG OR A CRASH  - " + Bukkit.getServer().getVersion() + " ---");
                    log.log(java.util.logging.Level.SEVERE, "The server has not responded for " + (currentTime - this.lastTick) / 1000L + " seconds! Creating thread dump");
                }
                log.log(java.util.logging.Level.SEVERE, "------------------------------");
                log.log(java.util.logging.Level.SEVERE, "Server thread dump (Look for plugins here before reporting to Paper!):");
                ChunkTaskScheduler.dumpAllChunkLoadInfo(MinecraftServer.getServer(), isLongTimeout);
                this.dumpTickingInfo();
                WatchdogThread.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(MinecraftServer.getServer().serverThread.getId(), Integer.MAX_VALUE), log);
                log.log(java.util.logging.Level.SEVERE, "------------------------------");
                if (isLongTimeout) {
                    ThreadInfo[] threads;
                    log.log(java.util.logging.Level.SEVERE, "Entire Thread Dump:");
                    for (ThreadInfo thread : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                        WatchdogThread.dumpThread(thread, log);
                    }
                } else {
                    log.log(java.util.logging.Level.SEVERE, "--- DO NOT REPORT THIS TO PAPER - THIS IS NOT A BUG OR A CRASH ---");
                }
                log.log(java.util.logging.Level.SEVERE, "------------------------------");
                if (isLongTimeout) {
                    if (server.hasStopped()) break;
                    AsyncCatcher.enabled = false;
                    server.forceTicks = true;
                    if (this.restart) {
                        RestartCommand.addShutdownHook(SpigotConfig.restartScript);
                    }
                    server.abnormalExit = true;
                    server.safeShutdown(false, this.restart);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (server.hasStopped()) break;
                    server.close();
                    break;
                }
            }
            try {
                WatchdogThread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.interrupt();
            }
        }
    }

    private static void dumpThread(ThreadInfo thread, Logger log) {
        log.log(java.util.logging.Level.SEVERE, "------------------------------");
        log.log(java.util.logging.Level.SEVERE, "Current Thread: " + thread.getThreadName());
        log.log(java.util.logging.Level.SEVERE, "\tPID: " + thread.getThreadId() + " | Suspended: " + thread.isSuspended() + " | Native: " + thread.isInNative() + " | State: " + String.valueOf((Object)thread.getThreadState()));
        if (thread.getLockedMonitors().length != 0) {
            log.log(java.util.logging.Level.SEVERE, "\tThread is waiting on monitor(s):");
            for (MonitorInfo monitor : thread.getLockedMonitors()) {
                log.log(java.util.logging.Level.SEVERE, "\t\tLocked on:" + String.valueOf(monitor.getLockedStackFrame()));
            }
        }
        log.log(java.util.logging.Level.SEVERE, "\tStack:");
        for (StackTraceElement stack : StacktraceDeobfuscator.INSTANCE.deobfuscateStacktrace(thread.getStackTrace())) {
            log.log(java.util.logging.Level.SEVERE, "\t\t" + String.valueOf(stack));
        }
    }
}

