/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import java.util.Collection;
import java.util.function.Predicate;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public interface Chunk
extends PersistentDataHolder {
    public int getX();

    public int getZ();

    default public long getChunkKey() {
        return Chunk.getChunkKey(this.getX(), this.getZ());
    }

    public static long getChunkKey(@NotNull Location loc) {
        return Chunk.getChunkKey((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4);
    }

    public static long getChunkKey(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    @NotNull
    public World getWorld();

    @NotNull
    public Block getBlock(int var1, int var2, int var3);

    @NotNull
    public ChunkSnapshot getChunkSnapshot();

    @NotNull
    public ChunkSnapshot getChunkSnapshot(boolean var1, boolean var2, boolean var3);

    public boolean isEntitiesLoaded();

    @NotNull
    public Entity[] getEntities();

    @NotNull
    default public BlockState[] getTileEntities() {
        return this.getTileEntities(true);
    }

    @NotNull
    public BlockState[] getTileEntities(boolean var1);

    @NotNull
    public Collection<BlockState> getTileEntities(@NotNull Predicate<Block> var1, boolean var2);

    public boolean isGenerated();

    public boolean isLoaded();

    public boolean load(boolean var1);

    public boolean load();

    public boolean unload(boolean var1);

    public boolean unload();

    public boolean isSlimeChunk();

    public boolean isForceLoaded();

    public void setForceLoaded(boolean var1);

    public boolean addPluginChunkTicket(@NotNull Plugin var1);

    public boolean removePluginChunkTicket(@NotNull Plugin var1);

    @NotNull
    public Collection<Plugin> getPluginChunkTickets();

    public long getInhabitedTime();

    public void setInhabitedTime(long var1);

    public boolean contains(@NotNull BlockData var1);

    public boolean contains(@NotNull Biome var1);

    @NotNull
    public LoadLevel getLoadLevel();

    public static enum LoadLevel {
        INACCESSIBLE,
        BORDER,
        TICKING,
        ENTITY_TICKING,
        UNLOADED;

    }
}

