/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingFlag;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.ColumnFileReader;

public final class Tiny2Reader {
    public static List<String> getNamespaces(Reader reader) throws IOException {
        return Tiny2Reader.getNamespaces(new ColumnFileReader(reader, '\t'));
    }

    private static List<String> getNamespaces(ColumnFileReader reader) throws IOException {
        String ns;
        if (!reader.nextCol("tiny") || reader.nextIntCol() != 2 || reader.nextIntCol() < 0) {
            throw new IOException("invalid/unsupported tiny file: no tiny 2 header");
        }
        ArrayList<String> ret = new ArrayList<String>();
        while ((ns = reader.nextCol()) != null) {
            ret.add(ns);
        }
        return ret;
    }

    public static void read(Reader reader, MappingVisitor visitor) throws IOException {
        Tiny2Reader.read(new ColumnFileReader(reader, '\t'), visitor);
    }

    private static void read(ColumnFileReader reader, MappingVisitor visitor) throws IOException {
        String dstNamespace;
        if (!reader.nextCol("tiny") || reader.nextIntCol() != 2 || reader.nextIntCol() < 0) {
            throw new IOException("invalid/unsupported tiny file: no tiny 2 header");
        }
        String srcNamespace = reader.nextCol();
        ArrayList<String> dstNamespaces = new ArrayList<String>();
        while ((dstNamespace = reader.nextCol()) != null) {
            dstNamespaces.add(dstNamespace);
        }
        int dstNsCount = dstNamespaces.size();
        if (visitor.getFlags().contains((Object)MappingFlag.NEEDS_MULTIPLE_PASSES)) {
            reader.mark();
        }
        boolean firstIteration = true;
        boolean escapeNames = false;
        while (true) {
            boolean visitHeader;
            if (visitHeader = visitor.visitHeader()) {
                visitor.visitNamespaces(srcNamespace, dstNamespaces);
            }
            if (visitHeader || firstIteration) {
                while (reader.nextLine(1)) {
                    if (!visitHeader) {
                        if (escapeNames || !reader.nextCol("escaped-names")) continue;
                        escapeNames = true;
                        continue;
                    }
                    String key = reader.nextCol();
                    if (key == null) {
                        throw new IOException("missing property key in line " + reader.getLineNumber());
                    }
                    String value = reader.nextEscapedCol();
                    if (key.equals("escaped-names")) {
                        escapeNames = true;
                    }
                    visitor.visitMetadata(key, value);
                }
            }
            if (visitor.visitContent()) {
                while (reader.nextLine(0)) {
                    if (!reader.nextCol("c")) continue;
                    String srcName = reader.nextCol(escapeNames);
                    if (srcName == null || srcName.isEmpty()) {
                        throw new IOException("missing class-name-a in line " + reader.getLineNumber());
                    }
                    if (!visitor.visitClass(srcName)) continue;
                    Tiny2Reader.readClass(reader, dstNsCount, escapeNames, visitor);
                }
            }
            if (visitor.visitEnd()) break;
            reader.reset();
            firstIteration = false;
        }
    }

    private static void readClass(ColumnFileReader reader, int dstNsCount, boolean escapeNames, MappingVisitor visitor) throws IOException {
        Tiny2Reader.readDstNames(reader, MappedElementKind.CLASS, dstNsCount, escapeNames, visitor);
        if (!visitor.visitElementContent(MappedElementKind.CLASS)) {
            return;
        }
        while (reader.nextLine(1)) {
            String srcName;
            String srcDesc;
            if (reader.nextCol("f")) {
                srcDesc = reader.nextCol(escapeNames);
                if (srcDesc == null || srcDesc.isEmpty()) {
                    throw new IOException("missing field-desc-a in line " + reader.getLineNumber());
                }
                srcName = reader.nextCol(escapeNames);
                if (srcName == null || srcName.isEmpty()) {
                    throw new IOException("missing field-name-a in line " + reader.getLineNumber());
                }
                if (!visitor.visitField(srcName, srcDesc)) continue;
                Tiny2Reader.readElement(reader, MappedElementKind.FIELD, dstNsCount, escapeNames, visitor);
                continue;
            }
            if (reader.nextCol("m")) {
                srcDesc = reader.nextCol(escapeNames);
                if (srcDesc == null || srcDesc.isEmpty()) {
                    throw new IOException("missing method-desc-a in line " + reader.getLineNumber());
                }
                srcName = reader.nextCol(escapeNames);
                if (srcName == null || srcName.isEmpty()) {
                    throw new IOException("missing method-name-a in line " + reader.getLineNumber());
                }
                if (!visitor.visitMethod(srcName, srcDesc)) continue;
                Tiny2Reader.readMethod(reader, dstNsCount, escapeNames, visitor);
                continue;
            }
            if (!reader.nextCol("c")) continue;
            Tiny2Reader.readComment(reader, MappedElementKind.CLASS, visitor);
        }
    }

    private static void readMethod(ColumnFileReader reader, int dstNsCount, boolean escapeNames, MappingVisitor visitor) throws IOException {
        Tiny2Reader.readDstNames(reader, MappedElementKind.METHOD, dstNsCount, escapeNames, visitor);
        if (!visitor.visitElementContent(MappedElementKind.METHOD)) {
            return;
        }
        while (reader.nextLine(2)) {
            int lvIndex;
            if (reader.nextCol("p")) {
                lvIndex = reader.nextIntCol();
                if (lvIndex < 0) {
                    throw new IOException("missing/invalid parameter lv-index in line " + reader.getLineNumber());
                }
                String srcName = reader.nextCol(escapeNames);
                if (srcName == null) {
                    throw new IOException("missing var-name-a column in line " + reader.getLineNumber());
                }
                if (srcName.isEmpty()) {
                    srcName = null;
                }
                if (!visitor.visitMethodArg(-1, lvIndex, srcName)) continue;
                Tiny2Reader.readElement(reader, MappedElementKind.METHOD_ARG, dstNsCount, escapeNames, visitor);
                continue;
            }
            if (reader.nextCol("v")) {
                lvIndex = reader.nextIntCol();
                if (lvIndex < 0) {
                    throw new IOException("missing/invalid variable lv-index in line " + reader.getLineNumber());
                }
                int startOpIdx = reader.nextIntCol();
                if (startOpIdx < 0) {
                    throw new IOException("missing/invalid variable lv-start-offset in line " + reader.getLineNumber());
                }
                int lvtRowIndex = reader.nextIntCol();
                String srcName = reader.nextCol(escapeNames);
                if (srcName == null) {
                    throw new IOException("missing var-name-a column in line " + reader.getLineNumber());
                }
                if (srcName.isEmpty()) {
                    srcName = null;
                }
                if (!visitor.visitMethodVar(lvtRowIndex, lvIndex, startOpIdx, srcName)) continue;
                Tiny2Reader.readElement(reader, MappedElementKind.METHOD_VAR, dstNsCount, escapeNames, visitor);
                continue;
            }
            if (!reader.nextCol("c")) continue;
            Tiny2Reader.readComment(reader, MappedElementKind.METHOD, visitor);
        }
    }

    private static void readElement(ColumnFileReader reader, MappedElementKind kind, int dstNsCount, boolean escapeNames, MappingVisitor visitor) throws IOException {
        Tiny2Reader.readDstNames(reader, kind, dstNsCount, escapeNames, visitor);
        if (!visitor.visitElementContent(kind)) {
            return;
        }
        while (reader.nextLine(kind.level + 1)) {
            if (!reader.nextCol("c")) continue;
            Tiny2Reader.readComment(reader, kind, visitor);
        }
    }

    private static void readComment(ColumnFileReader reader, MappedElementKind subjectKind, MappingVisitor visitor) throws IOException {
        String comment = reader.nextEscapedCol();
        if (comment == null) {
            throw new IOException("missing comment in line " + reader.getLineNumber());
        }
        visitor.visitComment(subjectKind, comment);
    }

    private static void readDstNames(ColumnFileReader reader, MappedElementKind subjectKind, int dstNsCount, boolean escapeNames, MappingVisitor visitor) throws IOException {
        for (int dstNs = 0; dstNs < dstNsCount; ++dstNs) {
            String name = reader.nextCol(escapeNames);
            if (name == null) {
                throw new IOException("missing name columns in line " + reader.getLineNumber());
            }
            if (name.isEmpty()) continue;
            visitor.visitDstName(subjectKind, dstNs, name);
        }
    }
}

