/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Armadillo;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CreakingTransient;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Warden;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public enum EntityEffect {
    ARROW_PARTICLES(0, TippedArrow.class),
    RABBIT_JUMP(1, Rabbit.class),
    RESET_SPAWNER_MINECART_DELAY(1, SpawnerMinecart.class),
    HURT(2, LivingEntity.class),
    DEATH(3, Entity.class),
    EGG_BREAK(3, Egg.class),
    SNOWBALL_BREAK(3, Snowball.class),
    ENTITY_DEATH(3, LivingEntity.class),
    FANG_ATTACK(4, EvokerFangs.class),
    HOGLIN_ATTACK(4, Hoglin.class),
    IRON_GOLEN_ATTACK(4, IronGolem.class),
    RAVAGER_ATTACK(4, Ravager.class),
    WARDEN_ATTACK(4, Warden.class),
    ZOGLIN_ATTACK(4, Zoglin.class),
    WOLF_SMOKE(6, Tameable.class),
    TAMING_FAILED(6, Tameable.class),
    TAMING_SUCCEEDED(7, Tameable.class),
    WOLF_HEARTS(7, Tameable.class),
    WOLF_SHAKE(8, Wolf.class),
    SHEEP_EAT(10, Entity.class),
    SHEEP_EAT_GRASS(10, Sheep.class),
    TNT_MINECART_IGNITE(10, ExplosiveMinecart.class),
    IRON_GOLEM_ROSE(11, IronGolem.class),
    VILLAGER_HEART(12, Villager.class),
    VILLAGER_ANGRY(13, Villager.class),
    VILLAGER_HAPPY(14, Villager.class),
    WITCH_MAGIC(15, Witch.class),
    ZOMBIE_TRANSFORM(16, ZombieVillager.class),
    FIREWORK_EXPLODE(17, Firework.class),
    LOVE_HEARTS(18, Ageable.class),
    SQUID_ROTATE(19, Squid.class),
    ENTITY_POOF(20, LivingEntity.class),
    GUARDIAN_TARGET(21, Guardian.class),
    SHIELD_BLOCK(29, LivingEntity.class),
    SHIELD_BREAK(30, LivingEntity.class),
    ARMOR_STAND_HIT(32, ArmorStand.class),
    THORNS_HURT(33, LivingEntity.class),
    IRON_GOLEM_SHEATH(34, IronGolem.class),
    TOTEM_RESURRECT(35, LivingEntity.class),
    HURT_DROWN(36, LivingEntity.class),
    HURT_EXPLOSION(37, LivingEntity.class),
    DOLPHIN_FED(38, Dolphin.class),
    RAVAGER_STUNNED(39, Ravager.class),
    CAT_TAME_FAIL(40, Cat.class),
    CAT_TAME_SUCCESS(41, Cat.class),
    VILLAGER_SPLASH(42, Villager.class),
    PLAYER_BAD_OMEN_RAID(43, Player.class),
    HURT_BERRY_BUSH(44, LivingEntity.class),
    FOX_CHEW(45, Fox.class),
    TELEPORT_ENDER(46, LivingEntity.class),
    BREAK_EQUIPMENT_MAIN_HAND(47, LivingEntity.class),
    BREAK_EQUIPMENT_OFF_HAND(48, LivingEntity.class),
    BREAK_EQUIPMENT_HELMET(49, LivingEntity.class),
    BREAK_EQUIPMENT_CHESTPLATE(50, LivingEntity.class),
    BREAK_EQUIPMENT_LEGGINGS(51, LivingEntity.class),
    BREAK_EQUIPMENT_BOOTS(52, LivingEntity.class),
    HONEY_BLOCK_SLIDE_PARTICLES(53, Entity.class),
    HONEY_BLOCK_FALL_PARTICLES(54, LivingEntity.class),
    SWAP_HAND_ITEMS(55, LivingEntity.class),
    WOLF_SHAKE_STOP(56, Wolf.class),
    GOAT_LOWER_HEAD(58, Goat.class),
    GOAT_RAISE_HEAD(59, Goat.class),
    SPAWN_DEATH_SMOKE(60, LivingEntity.class),
    WARDEN_TENDRIL_SHAKE(61, Warden.class),
    WARDEN_SONIC_ATTACK(62, Warden.class),
    SNIFFER_DIG(63, Sniffer.class),
    ARMADILLO_PEEK(64, Armadillo.class),
    BODY_BREAK(65, LivingEntity.class),
    SHAKE(66, CreakingTransient.class);

    private final byte data;
    private final Class<? extends Entity> applicable;

    private EntityEffect(int data, Class<? extends Entity> clazz) {
        this.data = (byte)data;
        this.applicable = clazz;
    }

    @ApiStatus.Internal
    public byte getData() {
        return this.data;
    }

    @NotNull
    public Class<? extends Entity> getApplicable() {
        return this.applicable;
    }

    public boolean isApplicableTo(@NotNull Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.isApplicableTo(entity.getClass());
    }

    public boolean isApplicableTo(@NotNull Class<? extends Entity> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Class cannot be null");
        return this.applicable.isAssignableFrom(clazz);
    }
}

