/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.logger.slf4j;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.logger.slf4j.ComponentLoggerProvider;
import net.kyori.adventure.text.logger.slf4j.WrappingComponentLoggerImpl;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.util.Services;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Handler {
    private static final ComponentLoggerProvider PROVIDER = Services.service(ComponentLoggerProvider.class).orElse(LoggerFactory.getILoggerFactory() instanceof ComponentLoggerProvider ? (ComponentLoggerProvider)LoggerFactory.getILoggerFactory() : new DefaultProvider());

    private Handler() {
    }

    static ComponentLogger logger(String name) {
        return PROVIDER.logger(LoggerHelperImpl.INSTANCE, name);
    }

    static final class LoggerHelperImpl
    implements ComponentLoggerProvider.LoggerHelper {
        static final LoggerHelperImpl INSTANCE = new LoggerHelperImpl();

        LoggerHelperImpl() {
        }

        @Override
        public Function<Component, String> plainSerializer() {
            return comp -> {
                Component translated = GlobalTranslator.render((Component)comp, (Locale)Locale.getDefault());
                StringBuilder contents = new StringBuilder();
                ComponentFlattener.basic().flatten(translated, contents::append);
                return contents.toString();
            };
        }

        @Override
        @NotNull
        public ComponentLogger delegating(@NotNull Logger base, @NotNull Function<Component, String> serializer) {
            return new WrappingComponentLoggerImpl(base, serializer);
        }
    }

    static final class DefaultProvider
    implements ComponentLoggerProvider {
        private final Map<String, ComponentLogger> loggers = new ConcurrentHashMap<String, ComponentLogger>();

        DefaultProvider() {
        }

        @Override
        @NotNull
        public ComponentLogger logger(@NotNull ComponentLoggerProvider.LoggerHelper helper, @NotNull String name) {
            ComponentLogger initial = this.loggers.get(name);
            if (initial != null) {
                return initial;
            }
            Logger backing = LoggerFactory.getLogger((String)name);
            ComponentLogger created = helper.delegating(backing, helper.plainSerializer());
            ComponentLogger existing = this.loggers.putIfAbsent(name, created);
            return existing == null ? created : existing;
        }
    }
}

