/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.custom;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.util.CommandArgumentUpgrader;
import com.google.common.base.Suppliers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public final class V3818_Commands {
    private static final int VERSION = 3818;
    private static final boolean DISABLE_COMMAND_CONVERTER = Boolean.getBoolean("Paper.DisableCommandConverter");
    private static final Logger LOGGER = LogUtils.getLogger();

    public static String toCommandFormat(CompoundTag components) {
        StringBuilder ret = new StringBuilder();
        ret.append('[');
        Iterator<String> iterator = components.getAllKeys().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            ret.append(key);
            ret.append('=');
            ret.append(components.get(key).toString());
            if (!iterator.hasNext()) continue;
            ret.append(',');
        }
        ret.append(']');
        return ret.toString();
    }

    public static JsonElement convertToJson(Tag tag) {
        return (JsonElement)new Dynamic<Tag>(NbtOps.INSTANCE, tag).convert(JsonOps.INSTANCE).getValue();
    }

    public static void walkComponent(JsonElement primitive) {
        JsonElement extra;
        JsonPrimitive showTextPrimitive;
        JsonObject hoverEvent;
        JsonElement showText;
        JsonElement hoverEventElement;
        if (!(primitive instanceof JsonObject)) {
            if (primitive instanceof JsonArray) {
                JsonArray array = (JsonArray)primitive;
                for (JsonElement component : array) {
                    V3818_Commands.walkComponent(component);
                }
            }
            return;
        }
        JsonObject root = (JsonObject)primitive;
        JsonElement clickEventElement = root.get("clickEvent");
        if (clickEventElement instanceof JsonObject) {
            JsonObject clickEvent = (JsonObject)clickEventElement;
            JsonElement actionElement = clickEvent.get("action");
            JsonElement cmdElement = clickEvent.get("value");
            if (actionElement instanceof JsonPrimitive) {
                JsonPrimitive action = (JsonPrimitive)actionElement;
                if (cmdElement instanceof JsonPrimitive) {
                    JsonPrimitive cmd = (JsonPrimitive)cmdElement;
                    String actionString = action.getAsString();
                    String cmdString = cmd.getAsString();
                    if (actionString.equals("suggest_command") && cmdString.startsWith("/") || actionString.equals("run_command")) {
                        try {
                            Object res = MCDataConverter.convert(MCTypeRegistry.DATACONVERTER_CUSTOM_TYPE_COMMAND, cmdString, 3700, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                            if (res instanceof String) {
                                String newCmd = (String)res;
                                clickEvent.addProperty("value", newCmd);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error("Failed to convert command '" + cmdString + "'", (Throwable)ex);
                        }
                    }
                }
            }
        }
        if ((hoverEventElement = root.get("hoverEvent")) instanceof JsonObject && (showText = (hoverEvent = (JsonObject)hoverEventElement).get("action")) instanceof JsonPrimitive && (showTextPrimitive = (JsonPrimitive)showText).getAsString().equals("show_item")) {
            JsonElement valueElement;
            JsonElement contentsElement = hoverEvent.get("contents");
            if (contentsElement instanceof JsonObject) {
                JsonObject contents = (JsonObject)contentsElement;
                JsonElement idElement = contents.get("id");
                JsonElement tagElement = contents.get("tag");
                if (idElement instanceof JsonPrimitive) {
                    JsonPrimitive idPrimitive = (JsonPrimitive)idElement;
                    CompoundTag itemNBT = new CompoundTag();
                    itemNBT.putString("id", idPrimitive.getAsString());
                    itemNBT.putInt("Count", 1);
                    if (tagElement instanceof JsonPrimitive) {
                        JsonPrimitive tagPrimitive = (JsonPrimitive)tagElement;
                        try {
                            CompoundTag tag = TagParser.parseTag(tagPrimitive.getAsString());
                            itemNBT.put("tag", tag);
                        }
                        catch (CommandSyntaxException commandSyntaxException) {
                            // empty catch block
                        }
                    }
                    CompoundTag converted = MCDataConverter.convertTag(MCTypeRegistry.ITEM_STACK, itemNBT, 3700, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                    contents.remove("tag");
                    contents.addProperty("id", converted.getString("id"));
                    if (converted.contains("components", 10)) {
                        contents.add("components", V3818_Commands.convertToJson(converted.getCompound("components")));
                    }
                }
            }
            if ((valueElement = hoverEvent.get("value")) instanceof JsonPrimitive) {
                JsonPrimitive valuePrimitive = (JsonPrimitive)valueElement;
                try {
                    CompoundTag itemNBT = TagParser.parseTag(valuePrimitive.getAsString());
                    if (itemNBT.contains("id", 8)) {
                        boolean explicitCount = itemNBT.contains("Count", 99);
                        if (!explicitCount) {
                            itemNBT.putInt("Count", 1);
                        }
                        CompoundTag converted = MCDataConverter.convertTag(MCTypeRegistry.ITEM_STACK, itemNBT, 3700, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                        hoverEvent.remove("value");
                        JsonObject contents = new JsonObject();
                        hoverEvent.add("contents", (JsonElement)contents);
                        contents.addProperty("id", converted.getString("id"));
                        if (explicitCount) {
                            contents.addProperty("count", (Number)converted.getInt("count"));
                        }
                        if (converted.contains("components", 10)) {
                            contents.add("components", V3818_Commands.convertToJson(converted.getCompound("components")));
                        }
                    }
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        if ((extra = root.get("extra")) instanceof JsonArray) {
            JsonArray array = (JsonArray)extra;
            for (JsonElement component : array) {
                V3818_Commands.walkComponent(component);
            }
        }
    }

    private static String walkComponent(String json) {
        if (json == null || json.isEmpty()) {
            return json;
        }
        try {
            JsonElement element = JsonParser.parseString((String)json);
            V3818_Commands.walkComponent(element);
            return GsonHelper.toStableString(element);
        }
        catch (JsonParseException ex) {
            return json;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to convert text component '" + json + "'", (Throwable)ex);
            return json;
        }
    }

    public static void register_5() {
        if (DISABLE_COMMAND_CONVERTER) {
            return;
        }
        MCTypeRegistry.DATACONVERTER_CUSTOM_TYPE_COMMAND.addConverter(new DataConverter<Object, Object>(3818, 5){
            private static final Supplier<CommandArgumentUpgrader> COMMAND_UPGRADER = Suppliers.memoize(() -> CommandArgumentUpgrader.upgrader_1_20_4_to_1_20_5(999));

            @Override
            public Object convert(Object data, long sourceVersion, long toVersion) {
                if (!(data instanceof String)) {
                    return null;
                }
                String cmd = (String)data;
                try {
                    return COMMAND_UPGRADER.get().upgradeCommandArguments(cmd, cmd.startsWith("/"));
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to convert command '" + cmd + "'", (Throwable)ex);
                    return null;
                }
            }
        });
        MCTypeRegistry.DATA_COMPONENTS.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(3818, 5){

            private static void walkPath(MapType<String> data, String path) {
                String str = data.getString(path);
                if (str == null) {
                    return;
                }
                String newStr = V3818_Commands.walkComponent(str);
                if (newStr != null) {
                    data.setString(path, newStr);
                }
            }

            private static void walkBookContent(MapType<String> data, String path) {
                if (data == null) {
                    return;
                }
                MapType content = data.getMap(path);
                if (content == null) {
                    return;
                }
                ListType pages = content.getList("pages", ObjectType.MAP);
                if (pages == null) {
                    return;
                }
                int len = pages.size();
                for (int i = 0; i < len; ++i) {
                    MapType<String> text = pages.getMap(i);
                    2.walkPath(text, "raw");
                    2.walkPath(text, "filtered");
                }
            }

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                2.walkBookContent(data, "minecraft:written_book_content");
                return null;
            }
        });
        DataConverter<MapType<String>, MapType<String>> signTileConverter = new DataConverter<MapType<String>, MapType<String>>(3818, 5){

            private static void walkText(MapType<String> data, String path) {
                ListType filteredMessages;
                if (data == null) {
                    return;
                }
                MapType text = data.getMap(path);
                if (text == null) {
                    return;
                }
                ListType messages = text.getList("messages", ObjectType.STRING);
                if (messages != null) {
                    int len = Math.min(4, messages.size());
                    for (int i = 0; i < len; ++i) {
                        messages.setString(i, V3818_Commands.walkComponent(messages.getString(i)));
                    }
                }
                if ((filteredMessages = text.getList("filtered_messages", ObjectType.STRING)) != null) {
                    int len = Math.min(4, filteredMessages.size());
                    for (int i = 0; i < len; ++i) {
                        filteredMessages.setString(i, V3818_Commands.walkComponent(filteredMessages.getString(i)));
                    }
                }
            }

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                3.walkText(data, "front_text");
                3.walkText(data, "back_text");
                return null;
            }
        };
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:sign", signTileConverter);
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:hanging_sign", signTileConverter);
    }
}

