/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public final class V1460 {
    private static final Map<String, String> MOTIVE_REMAP = new HashMap<String, String>();
    private static final int VERSION = 1460;

    public static void register() {
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:painting", new DataConverter<MapType<String>, MapType<String>>(1460){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                String motive = data.getString("Motive");
                if (motive != null) {
                    motive = motive.toLowerCase(Locale.ROOT);
                    data.setString("Motive", new ResourceLocation(MOTIVE_REMAP.getOrDefault(motive, motive)).toString());
                }
                return null;
            }
        });
    }

    private V1460() {
    }

    static {
        MOTIVE_REMAP.put("donkeykong", "donkey_kong");
        MOTIVE_REMAP.put("burningskull", "burning_skull");
        MOTIVE_REMAP.put("skullandroses", "skull_and_roses");
    }
}

