/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.maplist;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.world.level.chunk.LevelChunk;

public final class ChunkList
implements Iterable<LevelChunk> {
    protected final Long2IntOpenHashMap chunkToIndex = new Long2IntOpenHashMap(2, 0.8f);
    protected static final LevelChunk[] EMPTY_LIST = new LevelChunk[0];
    protected LevelChunk[] chunks;
    protected int count;

    public ChunkList() {
        this.chunkToIndex.defaultReturnValue(Integer.MIN_VALUE);
        this.chunks = EMPTY_LIST;
    }

    public int size() {
        return this.count;
    }

    public boolean contains(LevelChunk chunk) {
        return this.chunkToIndex.containsKey(chunk.coordinateKey);
    }

    public boolean remove(LevelChunk chunk) {
        int index = this.chunkToIndex.remove(chunk.coordinateKey);
        if (index == Integer.MIN_VALUE) {
            return false;
        }
        int endIndex = --this.count;
        LevelChunk end = this.chunks[endIndex];
        if (index != endIndex) {
            this.chunkToIndex.put(end.coordinateKey, index);
        }
        this.chunks[index] = end;
        this.chunks[endIndex] = null;
        return true;
    }

    public boolean add(LevelChunk chunk) {
        int count = this.count;
        int currIndex = this.chunkToIndex.putIfAbsent(chunk.coordinateKey, count);
        if (currIndex != Integer.MIN_VALUE) {
            return false;
        }
        LevelChunk[] list = this.chunks;
        if (list.length == count) {
            list = this.chunks = Arrays.copyOf(list, (int)Math.max(4L, (long)count * 2L));
        }
        list[count] = chunk;
        this.count = count + 1;
        return true;
    }

    public LevelChunk getChecked(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + index + " is out of bounds, size: " + this.count);
        }
        return this.chunks[index];
    }

    public LevelChunk getUnchecked(int index) {
        return this.chunks[index];
    }

    public LevelChunk[] getRawData() {
        return this.chunks;
    }

    public void clear() {
        this.chunkToIndex.clear();
        Arrays.fill(this.chunks, 0, this.count, null);
        this.count = 0;
    }

    @Override
    public Iterator<LevelChunk> iterator() {
        return new Iterator<LevelChunk>(){
            LevelChunk lastRet;
            int current;

            @Override
            public boolean hasNext() {
                return this.current < ChunkList.this.count;
            }

            @Override
            public LevelChunk next() {
                if (this.current >= ChunkList.this.count) {
                    throw new NoSuchElementException();
                }
                this.lastRet = ChunkList.this.chunks[this.current++];
                return this.lastRet;
            }

            @Override
            public void remove() {
                LevelChunk lastRet = this.lastRet;
                if (lastRet == null) {
                    throw new IllegalStateException();
                }
                this.lastRet = null;
                ChunkList.this.remove(lastRet);
                --this.current;
            }
        };
    }
}

