/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.player.AsyncChatCommandDecorateEvent;
import io.papermc.paper.event.player.AsyncChatDecorateEvent;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ImprovedChatDecorator
implements ChatDecorator {
    private final MinecraftServer server;

    public ImprovedChatDecorator(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public CompletableFuture<Component> decorate(@Nullable ServerPlayer sender, Component message) {
        return ImprovedChatDecorator.decorate(this.server, sender, null, message);
    }

    @Override
    public CompletableFuture<Component> decorate(@Nullable ServerPlayer sender, @Nullable CommandSourceStack commandSourceStack, Component message) {
        return ImprovedChatDecorator.decorate(this.server, sender, commandSourceStack, message);
    }

    private static CompletableFuture<Component> decorate(MinecraftServer server, @Nullable ServerPlayer player, @Nullable CommandSourceStack commandSourceStack, Component originalMessage) {
        return CompletableFuture.supplyAsync(() -> {
            net.kyori.adventure.text.Component initialResult = PaperAdventure.asAdventure(originalMessage);
            @Nullable CraftPlayer craftPlayer = player == null ? null : player.getBukkitEntity();
            Object event = commandSourceStack != null ? new AsyncChatCommandDecorateEvent((Player)craftPlayer, initialResult) : new AsyncChatDecorateEvent((Player)craftPlayer, initialResult);
            if (event.callEvent()) {
                return PaperAdventure.asVanilla(event.result());
            }
            return originalMessage;
        }, server.chatExecutor);
    }
}

