/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.light;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.starlight.common.light.BlockStarLightEngine;
import ca.spottedleaf.starlight.common.light.SkyStarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import io.papermc.paper.util.CoordinateUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public final class LightQueue {
    protected final Long2ObjectOpenHashMap<ChunkTasks> chunkTasks = new Long2ObjectOpenHashMap();
    protected final StarLightInterface manager;
    protected final ServerLevel world;

    public LightQueue(StarLightInterface manager) {
        this.manager = manager;
        this.world = (ServerLevel)manager.getWorld();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lowerPriority(int chunkX, int chunkZ, PrioritisedExecutor.Priority priority) {
        ChunkTasks task;
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            task = (ChunkTasks)this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        }
        if (task != null) {
            task.lowerPriority(priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int chunkX, int chunkZ, PrioritisedExecutor.Priority priority) {
        ChunkTasks task;
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            task = (ChunkTasks)this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        }
        if (task != null) {
            task.setPriority(priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raisePriority(int chunkX, int chunkZ, PrioritisedExecutor.Priority priority) {
        ChunkTasks task;
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            task = (ChunkTasks)this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        }
        if (task != null) {
            task.raisePriority(priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrioritisedExecutor.Priority getPriority(int chunkX, int chunkZ) {
        ChunkTasks task;
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            task = (ChunkTasks)this.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        }
        if (task != null) {
            return task.getPriority();
        }
        return PrioritisedExecutor.Priority.COMPLETING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            return this.chunkTasks.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkTasks queueBlockChange(BlockPos pos) {
        ChunkTasks tasks;
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> new ChunkTasks(keyInMap, this.manager, this));
            tasks.changedPositions.add(pos.immutable());
        }
        tasks.schedule();
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkTasks queueSectionChange(SectionPos pos, boolean newEmptyValue) {
        ChunkTasks tasks;
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> new ChunkTasks(keyInMap, this.manager, this));
            if (tasks.changedSectionSet == null) {
                tasks.changedSectionSet = new Boolean[this.manager.maxSection - this.manager.minSection + 1];
            }
            tasks.changedSectionSet[pos.getY() - this.manager.minSection] = newEmptyValue;
        }
        tasks.schedule();
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkTasks queueChunkLightTask(ChunkPos pos, BooleanSupplier lightTask, PrioritisedExecutor.Priority priority) {
        ChunkTasks tasks;
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> new ChunkTasks(keyInMap, this.manager, this, priority));
            if (tasks.lightTasks == null) {
                tasks.lightTasks = new ArrayList<BooleanSupplier>();
            }
            tasks.lightTasks.add(lightTask);
        }
        tasks.schedule();
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkTasks queueChunkSkylightEdgeCheck(SectionPos pos, ShortCollection sections) {
        ChunkTasks tasks;
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> new ChunkTasks(keyInMap, this.manager, this));
            ShortOpenHashSet queuedEdges = tasks.queuedEdgeChecksSky;
            if (queuedEdges == null) {
                queuedEdges = tasks.queuedEdgeChecksSky = new ShortOpenHashSet();
            }
            queuedEdges.addAll(sections);
        }
        tasks.schedule();
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkTasks queueChunkBlocklightEdgeCheck(SectionPos pos, ShortCollection sections) {
        ChunkTasks tasks;
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), keyInMap -> new ChunkTasks(keyInMap, this.manager, this));
            ShortOpenHashSet queuedEdges = tasks.queuedEdgeChecksBlock;
            if (queuedEdges == null) {
                queuedEdges = tasks.queuedEdgeChecksBlock = new ShortOpenHashSet();
            }
            queuedEdges.addAll(sections);
        }
        tasks.schedule();
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChunk(ChunkPos pos) {
        ChunkTasks tasks;
        LightQueue lightQueue = this;
        synchronized (lightQueue) {
            tasks = (ChunkTasks)this.chunkTasks.remove(CoordinateUtils.getChunkKey(pos));
        }
        if (tasks != null && tasks.cancel()) {
            tasks.onComplete.complete(null);
        }
    }

    public static final class ChunkTasks
    implements Runnable {
        public final CompletableFuture<Void> onComplete = new CompletableFuture();
        public boolean isTicketAdded;
        public final long chunkCoordinate;
        private final StarLightInterface lightEngine;
        private final LightQueue queue;
        private final PrioritisedExecutor.PrioritisedTask task;
        private final Set<BlockPos> changedPositions = new HashSet<BlockPos>();
        private Boolean[] changedSectionSet;
        private ShortOpenHashSet queuedEdgeChecksSky;
        private ShortOpenHashSet queuedEdgeChecksBlock;
        private List<BooleanSupplier> lightTasks;

        public ChunkTasks(long chunkCoordinate, StarLightInterface lightEngine, LightQueue queue) {
            this(chunkCoordinate, lightEngine, queue, PrioritisedExecutor.Priority.NORMAL);
        }

        public ChunkTasks(long chunkCoordinate, StarLightInterface lightEngine, LightQueue queue, PrioritisedExecutor.Priority priority) {
            this.chunkCoordinate = chunkCoordinate;
            this.lightEngine = lightEngine;
            this.queue = queue;
            this.task = queue.world.chunkTaskScheduler.radiusAwareScheduler.createTask(CoordinateUtils.getChunkX(chunkCoordinate), CoordinateUtils.getChunkZ(chunkCoordinate), ChunkStatus.LIGHT.writeRadius, this, priority);
        }

        public void schedule() {
            this.task.queue();
        }

        public boolean cancel() {
            return this.task.cancel();
        }

        public PrioritisedExecutor.Priority getPriority() {
            return this.task.getPriority();
        }

        public void lowerPriority(PrioritisedExecutor.Priority priority) {
            this.task.lowerPriority(priority);
        }

        public void setPriority(PrioritisedExecutor.Priority priority) {
            this.task.setPriority(priority);
        }

        public void raisePriority(PrioritisedExecutor.Priority priority) {
            this.task.raisePriority(priority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LightQueue lightQueue = this.queue;
            synchronized (lightQueue) {
                this.queue.chunkTasks.remove(this.chunkCoordinate);
            }
            boolean litChunk = false;
            if (this.lightTasks != null) {
                for (BooleanSupplier run : this.lightTasks) {
                    if (!run.getAsBoolean()) continue;
                    litChunk = true;
                    break;
                }
            }
            SkyStarLightEngine skyEngine = this.lightEngine.getSkyLightEngine();
            BlockStarLightEngine blockEngine = this.lightEngine.getBlockLightEngine();
            try {
                long coordinate = this.chunkCoordinate;
                int chunkX = CoordinateUtils.getChunkX(coordinate);
                int chunkZ = CoordinateUtils.getChunkZ(coordinate);
                Set<BlockPos> positions = this.changedPositions;
                Boolean[] sectionChanges = this.changedSectionSet;
                if (!litChunk) {
                    if (!(skyEngine == null || positions.isEmpty() && sectionChanges == null)) {
                        skyEngine.blocksChangedInChunk(this.lightEngine.getLightAccess(), chunkX, chunkZ, positions, sectionChanges);
                    }
                    if (!(blockEngine == null || positions.isEmpty() && sectionChanges == null)) {
                        blockEngine.blocksChangedInChunk(this.lightEngine.getLightAccess(), chunkX, chunkZ, positions, sectionChanges);
                    }
                    if (skyEngine != null && this.queuedEdgeChecksSky != null) {
                        skyEngine.checkChunkEdges(this.lightEngine.getLightAccess(), chunkX, chunkZ, (ShortCollection)this.queuedEdgeChecksSky);
                    }
                    if (blockEngine != null && this.queuedEdgeChecksBlock != null) {
                        blockEngine.checkChunkEdges(this.lightEngine.getLightAccess(), chunkX, chunkZ, (ShortCollection)this.queuedEdgeChecksBlock);
                    }
                }
                this.onComplete.complete(null);
            }
            finally {
                this.lightEngine.releaseSkyLightEngine(skyEngine);
                this.lightEngine.releaseBlockLightEngine(blockEngine);
            }
        }
    }
}

