/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import io.papermc.paper.command.PaperSubcommand;
import io.papermc.paper.util.MCUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FixLightCommand
implements PaperSubcommand {
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        this.doFixLight(sender, args);
        return true;
    }

    private void doFixLight(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"Only players can use this command", (TextColor)NamedTextColor.RED));
            return;
        }
        @Nullable Runnable post = null;
        int radius = 2;
        if (args.length > 0) {
            try {
                int parsed = Integer.parseInt(args[0]);
                if (parsed < 0) {
                    sender.sendMessage((Component)Component.text((String)"Radius cannot be negative!", (TextColor)NamedTextColor.RED));
                    return;
                }
                int maxRadius = 32;
                radius = Math.min(32, parsed);
                if (radius != parsed) {
                    post = () -> sender.sendMessage((Component)Component.text((String)("Radius '" + parsed + "' was not in the required range [0, 32], it was lowered to the maximum (32 chunks)."), (TextColor)NamedTextColor.RED));
                }
            }
            catch (Exception e) {
                sender.sendMessage((Component)Component.text((String)("'" + args[0] + "' is not a valid number."), (TextColor)NamedTextColor.RED));
                return;
            }
        }
        CraftPlayer player = (CraftPlayer)sender;
        ServerPlayer handle = player.getHandle();
        ServerLevel world = (ServerLevel)handle.level();
        ThreadedLevelLightEngine lightengine = world.getChunkSource().getLightEngine();
        this.starlightFixLight(handle, world, lightengine, radius, post);
    }

    private void starlightFixLight(ServerPlayer sender, ServerLevel world, ThreadedLevelLightEngine lightengine, int radius, @Nullable Runnable done) {
        long start = System.nanoTime();
        LinkedHashSet<ChunkPos> chunks = new LinkedHashSet<ChunkPos>(MCUtil.getSpiralOutChunks(sender.blockPosition(), radius));
        int[] pending = new int[1];
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            ChunkPos chunkPos2 = (ChunkPos)iterator.next();
            @Nullable ChunkAccess chunk = (ChunkAccess)world.getChunkSource().getChunkForLighting(chunkPos2.x, chunkPos2.z);
            if (chunk == null || !chunk.isLightCorrect() || !chunk.getStatus().isOrAfter(ChunkStatus.LIGHT)) {
                iterator.remove();
                continue;
            }
            pending[0] = pending[0] + 1;
        }
        int[] relitChunks = new int[1];
        lightengine.relight(chunks, chunkPos -> {
            relitChunks[0] = relitChunks[0] + 1;
            sender.getBukkitEntity().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append(new Component[]{Component.text((String)"Relit chunk ", (TextColor)NamedTextColor.BLUE), Component.text((String)chunkPos.toString()), Component.text((String)", progress: ", (TextColor)NamedTextColor.BLUE), Component.text((String)((int)Math.round(100.0 * (double)relitChunks[0] / (double)pending[0]) + "%"))}));
        }, totalRelit -> {
            long end = System.nanoTime();
            long diff = Math.round(1.0E-6 * (double)(end - start));
            sender.getBukkitEntity().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append(new Component[]{Component.text((String)"Relit ", (TextColor)NamedTextColor.BLUE), Component.text((int)totalRelit), Component.text((String)" chunks. Took ", (TextColor)NamedTextColor.BLUE), Component.text((String)(diff + "ms"))}));
            if (done != null) {
                done.run();
            }
        });
        sender.getBukkitEntity().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.BLUE)).append(new Component[]{Component.text((String)"Relighting "), Component.text((int)pending[0], (TextColor)NamedTextColor.DARK_AQUA), Component.text((String)" chunks")}));
    }
}

