/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.lifecycle.event.types;

import io.papermc.paper.plugin.lifecycle.event.LifecycleEvent;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import io.papermc.paper.plugin.lifecycle.event.handler.LifecycleEventHandler;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.PrioritizedLifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.PrioritizedLifecycleEventHandlerConfigurationImpl;
import io.papermc.paper.plugin.lifecycle.event.types.AbstractLifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class PrioritizableLifecycleEventType<O extends LifecycleEventOwner, E extends LifecycleEvent>
extends AbstractLifecycleEventType<O, E, PrioritizedLifecycleEventHandlerConfiguration<O>, PrioritizedLifecycleEventHandlerConfigurationImpl<O, E>>
implements LifecycleEventType.Prioritizable<O, E> {
    private static final Comparator<PrioritizedHandler<?, ?>> COMPARATOR = Comparator.comparing(PrioritizedHandler::priority, (o1, o2) -> {
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1.isEmpty()) {
            return 1;
        }
        if (o2.isEmpty()) {
            return -1;
        }
        return Integer.compare(o1.getAsInt(), o2.getAsInt());
    });
    private final List<PrioritizedHandler<O, E>> handlers = new ArrayList<PrioritizedHandler<O, E>>();

    public PrioritizableLifecycleEventType(String name, Class<? extends O> ownerType) {
        super(name, ownerType);
    }

    public PrioritizedLifecycleEventHandlerConfiguration<O> newHandler(LifecycleEventHandler<? super E> handler) {
        return new PrioritizedLifecycleEventHandlerConfigurationImpl(handler, this);
    }

    @Override
    protected void register(O owner, LifecycleEventHandler<? super E> handler, PrioritizedLifecycleEventHandlerConfigurationImpl<O, E> config) {
        this.handlers.add(new PrioritizedHandler<O, E>(new AbstractLifecycleEventType.RegisteredHandler<O, E>(owner, handler), config.priority()));
        this.handlers.sort(COMPARATOR);
    }

    @Override
    public void forEachHandler(Consumer<? super AbstractLifecycleEventType.RegisteredHandler<O, E>> consumer, Predicate<? super AbstractLifecycleEventType.RegisteredHandler<O, E>> predicate) {
        for (PrioritizedHandler<O, E> handler : this.handlers) {
            if (!predicate.test(handler.handler())) continue;
            consumer.accept(handler.handler());
        }
    }

    @Override
    public void removeMatching(Predicate<? super AbstractLifecycleEventType.RegisteredHandler<O, E>> predicate) {
        this.handlers.removeIf(prioritizedHandler -> predicate.test(prioritizedHandler.handler()));
    }

    private record PrioritizedHandler<O extends LifecycleEventOwner, E extends LifecycleEvent>(AbstractLifecycleEventType.RegisteredHandler<O, E> handler, OptionalInt priority) {
    }
}

