/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;

public interface SharedSuggestionProvider {
    public Collection<String> getOnlinePlayerNames();

    default public Collection<String> getCustomTabSugggestions() {
        return this.getOnlinePlayerNames();
    }

    default public Collection<String> getSelectedEntities() {
        return Collections.emptyList();
    }

    public Collection<String> getAllTeams();

    public Stream<ResourceLocation> getAvailableSounds();

    public Stream<ResourceLocation> getRecipeNames();

    public CompletableFuture<Suggestions> customSuggestion(CommandContext<?> var1);

    default public Collection<TextCoordinates> getRelevantCoordinates() {
        return Collections.singleton(TextCoordinates.DEFAULT_GLOBAL);
    }

    default public Collection<TextCoordinates> getAbsoluteCoordinates() {
        return Collections.singleton(TextCoordinates.DEFAULT_GLOBAL);
    }

    public Set<ResourceKey<Level>> levels();

    public RegistryAccess registryAccess();

    public FeatureFlagSet enabledFeatures();

    default public void suggestRegistryElements(Registry<?> registry, ElementSuggestionType suggestedIdType, SuggestionsBuilder builder) {
        if (suggestedIdType.shouldSuggestTags()) {
            SharedSuggestionProvider.suggestResource(registry.getTagNames().map(TagKey::location), builder, "#");
        }
        if (suggestedIdType.shouldSuggestElements()) {
            SharedSuggestionProvider.suggestResource(registry.keySet(), builder);
        }
    }

    public CompletableFuture<Suggestions> suggestRegistryElements(ResourceKey<? extends Registry<?>> var1, ElementSuggestionType var2, SuggestionsBuilder var3, CommandContext<?> var4);

    public boolean hasPermission(int var1);

    public static <T> void filterResources(Iterable<T> candidates, String remaining, Function<T, ResourceLocation> identifier, Consumer<T> action) {
        boolean bl = remaining.indexOf(58) > -1;
        for (T object : candidates) {
            ResourceLocation resourceLocation = identifier.apply(object);
            if (bl) {
                String string = resourceLocation.toString();
                if (!SharedSuggestionProvider.matchesSubStr(remaining, string)) continue;
                action.accept(object);
                continue;
            }
            if (!SharedSuggestionProvider.matchesSubStr(remaining, resourceLocation.getNamespace()) && (!resourceLocation.getNamespace().equals("minecraft") || !SharedSuggestionProvider.matchesSubStr(remaining, resourceLocation.getPath()))) continue;
            action.accept(object);
        }
    }

    public static <T> void filterResources(Iterable<T> candidates, String remaining, String prefix, Function<T, ResourceLocation> identifier, Consumer<T> action) {
        if (remaining.isEmpty()) {
            candidates.forEach(action);
        } else {
            String string = Strings.commonPrefix((CharSequence)remaining, (CharSequence)prefix);
            if (!string.isEmpty()) {
                String string2 = remaining.substring(string.length());
                SharedSuggestionProvider.filterResources(candidates, string2, identifier, action);
            }
        }
    }

    public static CompletableFuture<Suggestions> suggestResource(Iterable<ResourceLocation> candidates, SuggestionsBuilder builder, String prefix) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        SharedSuggestionProvider.filterResources(candidates, string, prefix, id -> id, id -> builder.suggest(prefix + String.valueOf(id)));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestResource(Stream<ResourceLocation> candidates, SuggestionsBuilder builder, String prefix) {
        return SharedSuggestionProvider.suggestResource(candidates::iterator, builder, prefix);
    }

    public static CompletableFuture<Suggestions> suggestResource(Iterable<ResourceLocation> candidates, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        SharedSuggestionProvider.filterResources(candidates, string, id -> id, id -> builder.suggest(id.toString()));
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> suggestResource(Iterable<T> candidates, SuggestionsBuilder builder, Function<T, ResourceLocation> identifier, Function<T, Message> tooltip) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        SharedSuggestionProvider.filterResources(candidates, string, identifier, object -> builder.suggest(((ResourceLocation)identifier.apply(object)).toString(), (Message)tooltip.apply(object)));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestResource(Stream<ResourceLocation> candidates, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggestResource(candidates::iterator, builder);
    }

    public static <T> CompletableFuture<Suggestions> suggestResource(Stream<T> candidates, SuggestionsBuilder builder, Function<T, ResourceLocation> identifier, Function<T, Message> tooltip) {
        return SharedSuggestionProvider.suggestResource(candidates::iterator, builder, identifier, tooltip);
    }

    public static CompletableFuture<Suggestions> suggestCoordinates(String remaining, Collection<TextCoordinates> candidates, SuggestionsBuilder builder, Predicate<String> predicate) {
        ArrayList list;
        block4: {
            String[] strings;
            block5: {
                block3: {
                    list = Lists.newArrayList();
                    if (!Strings.isNullOrEmpty((String)remaining)) break block3;
                    for (TextCoordinates textCoordinates : candidates) {
                        String string = textCoordinates.x + " " + textCoordinates.y + " " + textCoordinates.z;
                        if (!predicate.test(string)) continue;
                        list.add(textCoordinates.x);
                        list.add(textCoordinates.x + " " + textCoordinates.y);
                        list.add(string);
                    }
                    break block4;
                }
                strings = remaining.split(" ");
                if (strings.length != 1) break block5;
                for (TextCoordinates textCoordinates2 : candidates) {
                    String string2 = strings[0] + " " + textCoordinates2.y + " " + textCoordinates2.z;
                    if (!predicate.test(string2)) continue;
                    list.add(strings[0] + " " + textCoordinates2.y);
                    list.add(string2);
                }
                break block4;
            }
            if (strings.length != 2) break block4;
            for (TextCoordinates textCoordinates3 : candidates) {
                String string3 = strings[0] + " " + strings[1] + " " + textCoordinates3.z;
                if (!predicate.test(string3)) continue;
                list.add(string3);
            }
        }
        return SharedSuggestionProvider.suggest(list, builder);
    }

    public static CompletableFuture<Suggestions> suggest2DCoordinates(String remaining, Collection<TextCoordinates> candidates, SuggestionsBuilder builder, Predicate<String> predicate) {
        ArrayList list;
        block3: {
            block2: {
                list = Lists.newArrayList();
                if (!Strings.isNullOrEmpty((String)remaining)) break block2;
                for (TextCoordinates textCoordinates : candidates) {
                    String string = textCoordinates.x + " " + textCoordinates.z;
                    if (!predicate.test(string)) continue;
                    list.add(textCoordinates.x);
                    list.add(string);
                }
                break block3;
            }
            String[] strings = remaining.split(" ");
            if (strings.length != 1) break block3;
            for (TextCoordinates textCoordinates2 : candidates) {
                String string2 = strings[0] + " " + textCoordinates2.z;
                if (!predicate.test(string2)) continue;
                list.add(string2);
            }
        }
        return SharedSuggestionProvider.suggest(list, builder);
    }

    public static CompletableFuture<Suggestions> suggest(Iterable<String> candidates, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string2 : candidates) {
            if (!SharedSuggestionProvider.matchesSubStr(string, string2.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string2);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(Stream<String> candidates, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        candidates.filter(candidate -> SharedSuggestionProvider.matchesSubStr(string, candidate.toLowerCase(Locale.ROOT))).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(String[] candidates, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string2 : candidates) {
            if (!SharedSuggestionProvider.matchesSubStr(string, string2.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string2);
        }
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> suggest(Iterable<T> candidates, SuggestionsBuilder builder, Function<T, String> suggestionText, Function<T, Message> tooltip) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (T object : candidates) {
            String string2 = suggestionText.apply(object);
            if (!SharedSuggestionProvider.matchesSubStr(string, string2.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string2, tooltip.apply(object));
        }
        return builder.buildFuture();
    }

    public static boolean matchesSubStr(String remaining, String candidate) {
        int i = 0;
        while (!candidate.startsWith(remaining, i)) {
            int k;
            int j = candidate.indexOf(46, i);
            if (Math.max(j, k = candidate.indexOf(95, i)) < 0) {
                return false;
            }
            i = j >= 0 && k >= 0 ? Math.min(k, j) : (j >= 0 ? j : k);
            ++i;
        }
        return true;
    }

    public static class TextCoordinates {
        public static final TextCoordinates DEFAULT_LOCAL = new TextCoordinates("^", "^", "^");
        public static final TextCoordinates DEFAULT_GLOBAL = new TextCoordinates("~", "~", "~");
        public final String x;
        public final String y;
        public final String z;

        public TextCoordinates(String x, String y, String z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static enum ElementSuggestionType {
        TAGS,
        ELEMENTS,
        ALL;


        public boolean shouldSuggestTags() {
            return this == TAGS || this == ALL;
        }

        public boolean shouldSuggestElements() {
            return this == ELEMENTS || this == ALL;
        }
    }
}

