/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableObject;

public class ItemParser {
    static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM = new DynamicCommandExceptionType(id -> Component.translatableEscape("argument.item.id.invalid", id));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType(id -> Component.translatableEscape("arguments.item.component.unknown", id));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType((type, error) -> Component.translatableEscape("arguments.item.component.malformed", type, error));
    static final SimpleCommandExceptionType ERROR_EXPECTED_COMPONENT = new SimpleCommandExceptionType((Message)Component.translatable("arguments.item.component.expected"));
    static final DynamicCommandExceptionType ERROR_REPEATED_COMPONENT = new DynamicCommandExceptionType(type -> Component.translatableEscape("arguments.item.component.repeated", type));
    private static final DynamicCommandExceptionType ERROR_MALFORMED_ITEM = new DynamicCommandExceptionType(error -> Component.translatableEscape("arguments.item.malformed", error));
    public static final char SYNTAX_START_COMPONENTS = '[';
    public static final char SYNTAX_END_COMPONENTS = ']';
    public static final char SYNTAX_COMPONENT_SEPARATOR = ',';
    public static final char SYNTAX_COMPONENT_ASSIGNMENT = '=';
    static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    final HolderLookup.RegistryLookup<Item> items;
    final DynamicOps<Tag> registryOps;
    final boolean allowRemoves;

    public ItemParser(HolderLookup.Provider registriesLookup) {
        this(registriesLookup, false);
    }

    public ItemParser(HolderLookup.Provider registriesLookup, boolean allowRemoves) {
        this.allowRemoves = allowRemoves;
        this.items = registriesLookup.lookupOrThrow(Registries.ITEM);
        this.registryOps = registriesLookup.createSerializationContext(NbtOps.INSTANCE);
    }

    public ItemResult parse(StringReader reader) throws CommandSyntaxException {
        final MutableObject mutableObject = new MutableObject();
        final DataComponentMap.Builder builder = DataComponentMap.builder();
        final DataComponentPatch.Builder patchBuilder = DataComponentPatch.builder();
        this.parse(reader, new Visitor(){

            @Override
            public void visitItem(Holder<Item> item) {
                mutableObject.setValue(item);
            }

            @Override
            public <T> void visitComponent(DataComponentType<T> type, T value) {
                builder.set(type, value);
                patchBuilder.set(type, value);
            }

            @Override
            public <T> void visitComponentRemove(DataComponentType<T> type) {
                patchBuilder.remove(type);
            }
        });
        Holder holder = Objects.requireNonNull((Holder)mutableObject.getValue(), "Parser gave no item");
        DataComponentMap dataComponentMap = builder.build();
        ItemParser.validateComponents(reader, holder, dataComponentMap);
        return new ItemResult(holder, dataComponentMap, this.allowRemoves ? patchBuilder.build() : null);
    }

    private static void validateComponents(StringReader reader, Holder<Item> item, DataComponentMap components) throws CommandSyntaxException {
        DataComponentMap dataComponentMap = DataComponentMap.composite(item.value().components(), components);
        DataResult<Unit> dataResult = ItemStack.validateComponents(dataComponentMap);
        dataResult.getOrThrow(error -> ERROR_MALFORMED_ITEM.createWithContext((ImmutableStringReader)reader, error));
    }

    public void parse(StringReader reader, Visitor callbacks) throws CommandSyntaxException {
        int i = reader.getCursor();
        try {
            new State(reader, callbacks).parse();
        }
        catch (CommandSyntaxException var5) {
            reader.setCursor(i);
            throw var5;
        }
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        SuggestionsVisitor suggestionsVisitor = new SuggestionsVisitor();
        State state = new State(stringReader, suggestionsVisitor);
        try {
            state.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return suggestionsVisitor.resolveSuggestions(builder, stringReader);
    }

    public static interface Visitor {
        default public void visitItem(Holder<Item> item) {
        }

        default public <T> void visitComponent(DataComponentType<T> type, T value) {
        }

        default public <T> void visitComponentRemove(DataComponentType<T> type) {
        }

        default public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestor) {
        }
    }

    public record ItemResult(Holder<Item> item, DataComponentMap components, @Nullable DataComponentPatch patch) {
    }

    class State {
        private final StringReader reader;
        private final Visitor visitor;

        State(StringReader reader, Visitor callbacks) {
            this.reader = reader;
            this.visitor = callbacks;
        }

        public void parse() throws CommandSyntaxException {
            this.visitor.visitSuggestions(this::suggestItem);
            this.readItem();
            this.visitor.visitSuggestions(this::suggestStartComponents);
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.visitor.visitSuggestions(SUGGEST_NOTHING);
                this.readComponents();
            }
        }

        private void readItem() throws CommandSyntaxException {
            int i = this.reader.getCursor();
            ResourceLocation resourceLocation = ResourceLocation.read(this.reader);
            this.visitor.visitItem((Holder<Item>)ItemParser.this.items.get(ResourceKey.create(Registries.ITEM, resourceLocation)).orElseThrow(() -> {
                this.reader.setCursor(i);
                return ERROR_UNKNOWN_ITEM.createWithContext((ImmutableStringReader)this.reader, (Object)resourceLocation);
            }));
        }

        private void readComponents() throws CommandSyntaxException {
            this.reader.expect('[');
            this.visitor.visitSuggestions(this::suggestComponentAssignment);
            ReferenceArraySet set = new ReferenceArraySet();
            while (this.reader.canRead() && this.reader.peek() != ']') {
                DataComponentType<?> dataComponentType;
                boolean removing;
                this.reader.skipWhitespace();
                boolean bl = removing = ItemParser.this.allowRemoves && this.reader.canRead() && this.reader.peek() == '!';
                if (removing) {
                    this.reader.skip();
                    this.visitor.visitSuggestions(builder -> this.suggestComponentAssignment((SuggestionsBuilder)builder, false));
                }
                if (!set.add(dataComponentType = State.readComponentType(this.reader))) {
                    throw ERROR_REPEATED_COMPONENT.create(dataComponentType);
                }
                if (removing) {
                    this.visitor.visitComponentRemove(dataComponentType);
                } else {
                    this.visitor.visitSuggestions(this::suggestAssignment);
                    this.reader.skipWhitespace();
                    this.reader.expect('=');
                    this.visitor.visitSuggestions(SUGGEST_NOTHING);
                    this.reader.skipWhitespace();
                    this.readComponent(dataComponentType);
                }
                this.reader.skipWhitespace();
                this.visitor.visitSuggestions(this::suggestNextOrEndComponents);
                if (!this.reader.canRead() || this.reader.peek() != ',') break;
                this.reader.skip();
                this.reader.skipWhitespace();
                this.visitor.visitSuggestions(this::suggestComponentAssignment);
                if (this.reader.canRead()) continue;
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)this.reader);
            }
            this.reader.expect(']');
            this.visitor.visitSuggestions(SUGGEST_NOTHING);
        }

        public static DataComponentType<?> readComponentType(StringReader reader) throws CommandSyntaxException {
            if (!reader.canRead()) {
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)reader);
            }
            int i = reader.getCursor();
            ResourceLocation resourceLocation = ResourceLocation.read(reader);
            DataComponentType<?> dataComponentType = BuiltInRegistries.DATA_COMPONENT_TYPE.get(resourceLocation);
            if (dataComponentType != null && !dataComponentType.isTransient()) {
                return dataComponentType;
            }
            reader.setCursor(i);
            throw ERROR_UNKNOWN_COMPONENT.createWithContext((ImmutableStringReader)reader, (Object)resourceLocation);
        }

        private <T> void readComponent(DataComponentType<T> type) throws CommandSyntaxException {
            int i = this.reader.getCursor();
            Tag tag = new TagParser(this.reader).readValue();
            DataResult dataResult = type.codecOrThrow().parse(ItemParser.this.registryOps, (Object)tag);
            this.visitor.visitComponent(type, dataResult.getOrThrow(error -> {
                this.reader.setCursor(i);
                return ERROR_MALFORMED_COMPONENT.createWithContext((ImmutableStringReader)this.reader, (Object)type.toString(), error);
            }));
        }

        private CompletableFuture<Suggestions> suggestStartComponents(SuggestionsBuilder builder) {
            if (builder.getRemaining().isEmpty()) {
                builder.suggest(String.valueOf('['));
            }
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestNextOrEndComponents(SuggestionsBuilder builder) {
            if (builder.getRemaining().isEmpty()) {
                builder.suggest(String.valueOf(','));
                builder.suggest(String.valueOf(']'));
            }
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestAssignment(SuggestionsBuilder builder) {
            if (builder.getRemaining().isEmpty()) {
                builder.suggest(String.valueOf('='));
            }
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder builder) {
            return SharedSuggestionProvider.suggestResource(ItemParser.this.items.listElementIds().map(ResourceKey::location), builder);
        }

        private CompletableFuture<Suggestions> suggestComponentAssignment(SuggestionsBuilder builder) {
            return this.suggestComponentAssignment(builder, true);
        }

        private CompletableFuture<Suggestions> suggestComponentAssignment(SuggestionsBuilder builder, boolean suggestRemove) {
            String string = builder.getRemaining().toLowerCase(Locale.ROOT);
            if (suggestRemove && string.isBlank()) {
                builder.suggest("!", (Message)Component.literal("Remove a data component"));
            }
            SharedSuggestionProvider.filterResources(BuiltInRegistries.DATA_COMPONENT_TYPE.entrySet(), string, entry -> ((ResourceKey)entry.getKey()).location(), entry -> {
                DataComponentType dataComponentType = (DataComponentType)entry.getValue();
                if (dataComponentType.codec() != null) {
                    ResourceLocation resourceLocation = ((ResourceKey)entry.getKey()).location();
                    builder.suggest(resourceLocation.toString() + (suggestRemove ? "=" : ""));
                }
            });
            return builder.buildFuture();
        }
    }

    static class SuggestionsVisitor
    implements Visitor {
        private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

        SuggestionsVisitor() {
        }

        @Override
        public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestor) {
            this.suggestions = suggestor;
        }

        public CompletableFuture<Suggestions> resolveSuggestions(SuggestionsBuilder builder, StringReader reader) {
            return this.suggestions.apply(builder.createOffset(reader.getCursor()));
        }
    }
}

