/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Codec;
import com.mojang.serialization.JavaOps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public class Cloner<T> {
    private final Codec<T> directCodec;

    Cloner(Codec<T> elementCodec) {
        this.directCodec = elementCodec;
    }

    public T clone(T value, HolderLookup.Provider subsetRegistry, HolderLookup.Provider fullRegistry) {
        RegistryOps dynamicOps = subsetRegistry.createSerializationContext(JavaOps.INSTANCE);
        RegistryOps dynamicOps2 = fullRegistry.createSerializationContext(JavaOps.INSTANCE);
        Object object = this.directCodec.encodeStart(dynamicOps, value).getOrThrow(error -> new IllegalStateException("Failed to encode: " + error));
        return (T)this.directCodec.parse(dynamicOps2, object).getOrThrow(error -> new IllegalStateException("Failed to decode: " + error));
    }

    public static class Factory {
        private final Map<ResourceKey<? extends Registry<?>>, Cloner<?>> codecs = new HashMap();

        public <T> Factory addCodec(ResourceKey<? extends Registry<? extends T>> registryRef, Codec<T> elementCodec) {
            this.codecs.put(registryRef, new Cloner<T>(elementCodec));
            return this;
        }

        @Nullable
        public <T> Cloner<T> cloner(ResourceKey<? extends Registry<? extends T>> registryRef) {
            return this.codecs.get(registryRef);
        }
    }
}

