/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record TypedDataComponent<T>(DataComponentType<T> type, T value) {
    public static final StreamCodec<RegistryFriendlyByteBuf, TypedDataComponent<?>> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, TypedDataComponent<?>>(){

        @Override
        @Override
        public TypedDataComponent<?> decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            DataComponentType dataComponentType = (DataComponentType)DataComponentType.STREAM_CODEC.decode(registryFriendlyByteBuf);
            return 1.decodeTyped(registryFriendlyByteBuf, dataComponentType);
        }

        private static <T> TypedDataComponent<T> decodeTyped(RegistryFriendlyByteBuf buf, DataComponentType<T> type) {
            return new TypedDataComponent<T>(type, type.streamCodec().decode(buf));
        }

        @Override
        @Override
        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, TypedDataComponent<?> typedDataComponent) {
            1.encodeCap(registryFriendlyByteBuf, typedDataComponent);
        }

        private static <T> void encodeCap(RegistryFriendlyByteBuf buf, TypedDataComponent<T> component) {
            DataComponentType.STREAM_CODEC.encode(buf, component.type());
            component.type().streamCodec().encode(buf, component.value());
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.encode((RegistryFriendlyByteBuf)((Object)buf), (TypedDataComponent)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.decode((RegistryFriendlyByteBuf)((Object)buf));
        }
    };

    static TypedDataComponent<?> fromEntryUnchecked(Map.Entry<DataComponentType<?>, Object> entry) {
        return TypedDataComponent.createUnchecked(entry.getKey(), entry.getValue());
    }

    static <T> TypedDataComponent<T> createUnchecked(DataComponentType<T> type, Object value) {
        return new TypedDataComponent<Object>(type, value);
    }

    public void applyTo(PatchedDataComponentMap components) {
        components.set(this.type, this.value);
    }

    public <D> DataResult<D> encodeValue(DynamicOps<D> ops) {
        Codec<T> codec = this.type.codec();
        if (codec == null) {
            return DataResult.error(() -> "Component of type " + String.valueOf(this.type) + " is not encodable");
        }
        return codec.encodeStart(ops, this.value);
    }

    @Override
    @Override
    public String toString() {
        return String.valueOf(this.type) + "=>" + String.valueOf(this.value);
    }
}

