/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemListReport
implements DataProvider {
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public ItemListReport(PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookupFuture) {
        this.output = output;
        this.registries = registryLookupFuture;
    }

    @Override
    @Override
    public CompletableFuture<?> run(CachedOutput writer) {
        Path path = this.output.getOutputFolder(PackOutput.Target.REPORTS).resolve("items.json");
        return this.registries.thenCompose(registryLookup -> {
            JsonObject jsonObject = new JsonObject();
            RegistryOps registryOps = registryLookup.createSerializationContext(JsonOps.INSTANCE);
            registryLookup.lookupOrThrow(Registries.ITEM).listElements().forEach(entry -> {
                JsonObject jsonObject2 = new JsonObject();
                JsonArray jsonArray = new JsonArray();
                ((Item)entry.value()).components().forEach(component -> jsonArray.add(ItemListReport.dumpComponent(component, registryOps)));
                jsonObject2.add("components", (JsonElement)jsonArray);
                jsonObject.add(entry.getRegisteredName(), (JsonElement)jsonObject2);
            });
            return DataProvider.saveStable(writer, (JsonElement)jsonObject, path);
        });
    }

    private static <T> JsonElement dumpComponent(TypedDataComponent<T> component, DynamicOps<JsonElement> ops) {
        ResourceLocation resourceLocation = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(component.type());
        JsonElement jsonElement = (JsonElement)component.encodeValue(ops).getOrThrow(error -> new IllegalStateException("Failed to serialize component " + String.valueOf(resourceLocation) + ": " + error));
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", resourceLocation.toString());
        jsonObject.add("value", jsonElement);
        return jsonObject;
    }

    @Override
    @Override
    public final String getName() {
        return "Item List";
    }
}

