/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceKey<LootTable>> requiredTables;
    private final List<SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootTableProvider(PackOutput output, Set<ResourceKey<LootTable>> lootTableIds, List<SubProviderEntry> lootTypeGenerators, CompletableFuture<HolderLookup.Provider> registryLookupFuture) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "loot_tables");
        this.subProviders = lootTypeGenerators;
        this.requiredTables = lootTableIds;
        this.registries = registryLookupFuture;
    }

    @Override
    @Override
    public CompletableFuture<?> run(CachedOutput writer) {
        return this.registries.thenCompose(registryLookup -> this.run(writer, (HolderLookup.Provider)registryLookup));
    }

    private CompletableFuture<?> run(CachedOutput writer, HolderLookup.Provider registryLookup) {
        MappedRegistry<LootTable> writableRegistry = new MappedRegistry<LootTable>(Registries.LOOT_TABLE, Lifecycle.experimental());
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        this.subProviders.forEach(arg_0 -> LootTableProvider.lambda$run$2(registryLookup, (Map)map, writableRegistry, arg_0));
        writableRegistry.freeze();
        ProblemReporter.Collector collector = new ProblemReporter.Collector();
        HolderGetter.Provider provider = new RegistryAccess.ImmutableRegistryAccess(List.of(writableRegistry)).freeze().asGetterLookup();
        ValidationContext validationContext = new ValidationContext(collector, LootContextParamSets.ALL_PARAMS, provider);
        Sets.SetView set = Sets.difference(this.requiredTables, writableRegistry.registryKeySet());
        for (ResourceKey resourceKey : set) {
            collector.report("Missing built-in table: " + String.valueOf(resourceKey.location()));
        }
        writableRegistry.holders().forEach(entry -> ((LootTable)entry.value()).validate(validationContext.setParams(((LootTable)entry.value()).getParamSet()).enterElement("{" + String.valueOf(entry.key().location()) + "}", entry.key())));
        Multimap<String, String> multimap = collector.get();
        if (!multimap.isEmpty()) {
            multimap.forEach((name, message) -> LOGGER.warn("Found validation problem in {}: {}", name, message));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])writableRegistry.entrySet().stream().map(entry -> {
            ResourceKey resourceKey = (ResourceKey)entry.getKey();
            LootTable lootTable = (LootTable)entry.getValue();
            Path path = this.pathProvider.json(resourceKey.location());
            return DataProvider.saveStable(writer, registryLookup, LootTable.DIRECT_CODEC, lootTable, path);
        }).toArray(CompletableFuture[]::new));
    }

    private static ResourceLocation sequenceIdForLootTable(ResourceKey<LootTable> lootTableKey) {
        return lootTableKey.location();
    }

    @Override
    @Override
    public final String getName() {
        return "Loot Tables";
    }

    private static /* synthetic */ void lambda$run$2(HolderLookup.Provider provider, Map map, WritableRegistry writableRegistry, SubProviderEntry lootTypeGenerator) {
        lootTypeGenerator.provider().get().generate(provider, (lootTable, builder) -> {
            ResourceLocation resourceLocation = LootTableProvider.sequenceIdForLootTable(lootTable);
            ResourceLocation resourceLocation2 = map.put(RandomSequence.seedForKey(resourceLocation), resourceLocation);
            if (resourceLocation2 != null) {
                Util.logAndPauseIfInIde("Loot table random sequence seed collision on " + String.valueOf(resourceLocation2) + " and " + String.valueOf(lootTable.location()));
            }
            builder.setRandomSequence(resourceLocation);
            LootTable lootTable2 = builder.setParamSet(subProviderEntry.paramSet).build();
            writableRegistry.register(lootTable, lootTable2, RegistrationInfo.BUILT_IN);
        });
    }

    public record SubProviderEntry(Supplier<LootTableSubProvider> provider, LootContextParamSet paramSet) {
    }
}

