/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.level.ItemLike;

public interface RecipeBuilder {
    public static final ResourceLocation ROOT_RECIPE_ADVANCEMENT = new ResourceLocation("recipes/root");

    public RecipeBuilder unlockedBy(String var1, Criterion<?> var2);

    public RecipeBuilder group(@Nullable String var1);

    public Item getResult();

    public void save(RecipeOutput var1, ResourceLocation var2);

    default public void save(RecipeOutput exporter) {
        this.save(exporter, RecipeBuilder.getDefaultRecipeId(this.getResult()));
    }

    default public void save(RecipeOutput exporter, String recipePath) {
        ResourceLocation resourceLocation2 = new ResourceLocation(recipePath);
        ResourceLocation resourceLocation = RecipeBuilder.getDefaultRecipeId(this.getResult());
        if (resourceLocation2.equals(resourceLocation)) {
            throw new IllegalStateException("Recipe " + recipePath + " should remove its 'save' argument as it is equal to default one");
        }
        this.save(exporter, resourceLocation2);
    }

    public static ResourceLocation getDefaultRecipeId(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey(item.asItem());
    }

    public static CraftingBookCategory determineBookCategory(RecipeCategory category) {
        return switch (category) {
            case RecipeCategory.BUILDING_BLOCKS -> CraftingBookCategory.BUILDING;
            case RecipeCategory.TOOLS, RecipeCategory.COMBAT -> CraftingBookCategory.EQUIPMENT;
            case RecipeCategory.REDSTONE -> CraftingBookCategory.REDSTONE;
            default -> CraftingBookCategory.MISC;
        };
    }
}

