/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.mojang.logging.LogUtils;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.slf4j.Logger;

public class StructureUpdater
implements SnbtToNbt.Filter {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public CompoundTag apply(String name, CompoundTag nbt) {
        return name.startsWith("data/minecraft/structures/") ? StructureUpdater.update(name, nbt) : nbt;
    }

    public static CompoundTag update(String name, CompoundTag nbt) {
        StructureTemplate structureTemplate = new StructureTemplate();
        int i = NbtUtils.getDataVersion(nbt, 500);
        int j = 3798;
        if (i < 3798) {
            LOGGER.warn("SNBT Too old, do not forget to update: {} < {}: {}", new Object[]{i, 3798, name});
        }
        CompoundTag compoundTag = MCDataConverter.convertTag(MCTypeRegistry.STRUCTURE, nbt, i, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        structureTemplate.load(BuiltInRegistries.BLOCK.asLookup(), compoundTag);
        return structureTemplate.save(new CompoundTag());
    }
}

