/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerLevel;

public class GameTestBatchFactory {
    private static final int MAX_TESTS_PER_BATCH = 50;

    public static Collection<GameTestBatch> fromTestFunction(Collection<TestFunction> testFunctions, ServerLevel world) {
        Map<String, List<TestFunction>> map = testFunctions.stream().collect(Collectors.groupingBy(TestFunction::batchName));
        return map.entrySet().stream().flatMap(entry -> {
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            return Streams.mapWithIndex(Lists.partition((List)list, (int)50).stream(), (states, index) -> GameTestBatchFactory.toGameTestBatch(states.stream().map(testFunction -> GameTestBatchFactory.toGameTestInfo(testFunction, 0, world)).toList(), string, index));
        }).toList();
    }

    public static GameTestInfo toGameTestInfo(TestFunction testFunction, int rotationSteps, ServerLevel world) {
        return new GameTestInfo(testFunction, StructureUtils.getRotationForRotationSteps(rotationSteps), world, RetryOptions.noRetries());
    }

    public static GameTestRunner.GameTestBatcher fromGameTestInfo() {
        return states -> {
            Map<String, List<GameTestInfo>> map = states.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(state -> state.getTestFunction().batchName()));
            return map.entrySet().stream().flatMap(entry -> {
                String string = (String)entry.getKey();
                List list = (List)entry.getValue();
                return Streams.mapWithIndex(Lists.partition((List)list, (int)50).stream(), (states, index) -> GameTestBatchFactory.toGameTestBatch(List.copyOf(states), string, index));
            }).toList();
        };
    }

    private static GameTestBatch toGameTestBatch(List<GameTestInfo> states, String batchId, long index) {
        Consumer<ServerLevel> consumer = GameTestRegistry.getBeforeBatchFunction(batchId);
        Consumer<ServerLevel> consumer2 = GameTestRegistry.getAfterBatchFunction(batchId);
        return new GameTestBatch(batchId + ":" + index, states, consumer, consumer2);
    }
}

