/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.zip.Deflater;
import javax.annotation.Nullable;
import net.minecraft.network.VarInt;

public class CompressionEncoder
extends MessageToByteEncoder<ByteBuf> {
    @Nullable
    private final byte[] encodeBuf;
    @Nullable
    private final Deflater deflater;
    @Nullable
    private final VelocityCompressor compressor;
    private int threshold;

    public CompressionEncoder(int compressionThreshold) {
        this(null, compressionThreshold);
    }

    public CompressionEncoder(@Nullable VelocityCompressor compressor, int compressionThreshold) {
        this.threshold = compressionThreshold;
        if (compressor == null) {
            this.encodeBuf = new byte[8192];
            this.deflater = new Deflater();
        } else {
            this.encodeBuf = null;
            this.deflater = null;
        }
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) throws Exception {
        int i = byteBuf.readableBytes();
        if (i > 0x800000) {
            throw new IllegalArgumentException("Packet too big (is " + i + ", should be less than 8388608)");
        }
        if (i < this.threshold) {
            VarInt.write(byteBuf2, 0);
            byteBuf2.writeBytes(byteBuf);
        } else {
            if (this.deflater != null) {
                byte[] bs = new byte[i];
                byteBuf.readBytes(bs);
                VarInt.write(byteBuf2, bs.length);
                this.deflater.setInput(bs, 0, i);
                this.deflater.finish();
                while (!this.deflater.finished()) {
                    int j = this.deflater.deflate(this.encodeBuf);
                    byteBuf2.writeBytes(this.encodeBuf, 0, j);
                }
                this.deflater.reset();
                return;
            }
            VarInt.write(byteBuf2, i);
            ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)channelHandlerContext.alloc(), (Native)this.compressor, (ByteBuf)byteBuf);
            try {
                this.compressor.deflate(compatibleIn, byteBuf2);
            }
            finally {
                compatibleIn.release();
            }
        }
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        if (this.compressor != null) {
            int initialBufferSize = msg.readableBytes() + 1;
            return MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (int)initialBufferSize);
        }
        return super.allocateBuffer(ctx, (Object)msg, preferDirect);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.compressor != null) {
            this.compressor.close();
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int compressionThreshold) {
        this.threshold = compressionThreshold;
    }
}

