/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenTrackedEntry;
import net.minecraft.network.chat.MessageSignature;

public class LastSeenMessagesValidator {
    private final int lastSeenCount;
    private final ObjectList<LastSeenTrackedEntry> trackedMessages = new ObjectArrayList();
    @Nullable
    private MessageSignature lastPendingMessage;

    public LastSeenMessagesValidator(int size) {
        this.lastSeenCount = size;
        for (int i = 0; i < size; ++i) {
            this.trackedMessages.add(null);
        }
    }

    public void addPending(MessageSignature signature) {
        if (!signature.equals(this.lastPendingMessage)) {
            this.trackedMessages.add((Object)new LastSeenTrackedEntry(signature, true));
            this.lastPendingMessage = signature;
        }
    }

    public int trackedMessagesCount() {
        return this.trackedMessages.size();
    }

    public boolean applyOffset(int index) {
        int i = this.trackedMessages.size() - this.lastSeenCount;
        if (index >= 0 && index <= i) {
            this.trackedMessages.removeElements(0, index);
            return true;
        }
        return false;
    }

    public Optional<LastSeenMessages> applyUpdate(LastSeenMessages.Update acknowledgment) {
        if (!this.applyOffset(acknowledgment.offset())) {
            return Optional.empty();
        }
        ObjectArrayList objectList = new ObjectArrayList(acknowledgment.acknowledged().cardinality());
        if (acknowledgment.acknowledged().length() > this.lastSeenCount) {
            return Optional.empty();
        }
        for (int i = 0; i < this.lastSeenCount; ++i) {
            boolean bl = acknowledgment.acknowledged().get(i);
            LastSeenTrackedEntry lastSeenTrackedEntry = (LastSeenTrackedEntry)this.trackedMessages.get(i);
            if (bl) {
                if (lastSeenTrackedEntry == null) {
                    return Optional.empty();
                }
                this.trackedMessages.set(i, (Object)lastSeenTrackedEntry.acknowledge());
                objectList.add((Object)lastSeenTrackedEntry.signature());
                continue;
            }
            if (lastSeenTrackedEntry != null && !lastSeenTrackedEntry.pending()) {
                return Optional.empty();
            }
            this.trackedMessages.set(i, null);
        }
        return Optional.of(new LastSeenMessages((List<MessageSignature>)objectList));
    }
}

