/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamMemberEncoder;
import net.minecraft.resources.ResourceLocation;

public interface CustomPacketPayload {
    public Type<? extends CustomPacketPayload> type();

    public static <B extends ByteBuf, T extends CustomPacketPayload> StreamCodec<B, T> codec(StreamMemberEncoder<B, T> encoder, StreamDecoder<B, T> decoder) {
        return StreamCodec.ofMember(encoder, decoder);
    }

    public static <T extends CustomPacketPayload> Type<T> createType(String id) {
        return new Type(new ResourceLocation(id));
    }

    public static <B extends FriendlyByteBuf> StreamCodec<B, CustomPacketPayload> codec(final FallbackProvider<B> unknownCodecFactory, List<TypeAndCodec<? super B, ?>> types) {
        final Map<ResourceLocation, StreamCodec> map = types.stream().collect(Collectors.toUnmodifiableMap(type -> type.type().id(), TypeAndCodec::codec));
        return new StreamCodec<B, CustomPacketPayload>(){

            private StreamCodec<? super B, ? extends CustomPacketPayload> findCodec(ResourceLocation id) {
                StreamCodec streamCodec = (StreamCodec)map.get(id);
                if (streamCodec != null) {
                    return streamCodec;
                }
                return unknownCodecFactory.create(id);
            }

            private <T extends CustomPacketPayload> void writeCap(B value, Type<T> id, CustomPacketPayload payload) {
                ((FriendlyByteBuf)((Object)value)).writeResourceLocation(id.id());
                StreamCodec streamCodec = this.findCodec(id.id);
                streamCodec.encode(value, payload);
            }

            @Override
            @Override
            public void encode(B friendlyByteBuf, CustomPacketPayload customPacketPayload) {
                this.writeCap(friendlyByteBuf, customPacketPayload.type(), customPacketPayload);
            }

            @Override
            @Override
            public CustomPacketPayload decode(B friendlyByteBuf) {
                ResourceLocation resourceLocation = ((FriendlyByteBuf)((Object)friendlyByteBuf)).readResourceLocation();
                return (CustomPacketPayload)this.findCodec(resourceLocation).decode(friendlyByteBuf);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.encode((Object)((Object)((FriendlyByteBuf)((Object)buf))), (CustomPacketPayload)value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.decode((B)((Object)((FriendlyByteBuf)((Object)buf))));
            }
        };
    }

    public record Type<T extends CustomPacketPayload>(ResourceLocation id) {
    }

    public static interface FallbackProvider<B extends FriendlyByteBuf> {
        public StreamCodec<B, ? extends CustomPacketPayload> create(ResourceLocation var1);
    }

    public record TypeAndCodec<B extends FriendlyByteBuf, T extends CustomPacketPayload>(Type<T> type, StreamCodec<B, T> codec) {
    }
}

