/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.BossEvent;

public class ClientboundBossEventPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundBossEventPacket> STREAM_CODEC = Packet.codec(ClientboundBossEventPacket::write, ClientboundBossEventPacket::new);
    private static final int FLAG_DARKEN = 1;
    private static final int FLAG_MUSIC = 2;
    private static final int FLAG_FOG = 4;
    private final UUID id;
    private final Operation operation;
    static final Operation REMOVE_OPERATION = new Operation(){

        @Override
        @Override
        public OperationType getType() {
            return OperationType.REMOVE;
        }

        @Override
        @Override
        public void dispatch(UUID uuid, Handler consumer) {
            consumer.remove(uuid);
        }

        @Override
        @Override
        public void write(RegistryFriendlyByteBuf buf) {
        }
    };

    private ClientboundBossEventPacket(UUID uuid, Operation action) {
        this.id = uuid;
        this.operation = action;
    }

    private ClientboundBossEventPacket(RegistryFriendlyByteBuf buf) {
        this.id = buf.readUUID();
        OperationType operationType = buf.readEnum(OperationType.class);
        this.operation = operationType.reader.decode(buf);
    }

    public static ClientboundBossEventPacket createAddPacket(BossEvent bar) {
        return new ClientboundBossEventPacket(bar.getId(), new AddOperation(bar));
    }

    public static ClientboundBossEventPacket createRemovePacket(UUID uuid) {
        return new ClientboundBossEventPacket(uuid, REMOVE_OPERATION);
    }

    public static ClientboundBossEventPacket createUpdateProgressPacket(BossEvent bar) {
        return new ClientboundBossEventPacket(bar.getId(), new UpdateProgressOperation(bar.getProgress()));
    }

    public static ClientboundBossEventPacket createUpdateNamePacket(BossEvent bar) {
        return new ClientboundBossEventPacket(bar.getId(), new UpdateNameOperation(bar.getName()));
    }

    public static ClientboundBossEventPacket createUpdateStylePacket(BossEvent bar) {
        return new ClientboundBossEventPacket(bar.getId(), new UpdateStyleOperation(bar.getColor(), bar.getOverlay()));
    }

    public static ClientboundBossEventPacket createUpdatePropertiesPacket(BossEvent bar) {
        return new ClientboundBossEventPacket(bar.getId(), new UpdatePropertiesOperation(bar.shouldDarkenScreen(), bar.shouldPlayBossMusic(), bar.shouldCreateWorldFog()));
    }

    private void write(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.id);
        buf.writeEnum(this.operation.getType());
        this.operation.write(buf);
    }

    static int encodeProperties(boolean darkenSky, boolean dragonMusic, boolean thickenFog) {
        int i = 0;
        if (darkenSky) {
            i |= 1;
        }
        if (dragonMusic) {
            i |= 2;
        }
        if (thickenFog) {
            i |= 4;
        }
        return i;
    }

    @Override
    @Override
    public PacketType<ClientboundBossEventPacket> type() {
        return GamePacketTypes.CLIENTBOUND_BOSS_EVENT;
    }

    @Override
    @Override
    public void handle(ClientGamePacketListener listener) {
        listener.handleBossUpdate(this);
    }

    public void dispatch(Handler consumer) {
        this.operation.dispatch(this.id, consumer);
    }

    static interface Operation {
        public OperationType getType();

        public void dispatch(UUID var1, Handler var2);

        public void write(RegistryFriendlyByteBuf var1);
    }

    static enum OperationType {
        ADD(AddOperation::new),
        REMOVE(buf -> REMOVE_OPERATION),
        UPDATE_PROGRESS(UpdateProgressOperation::new),
        UPDATE_NAME(UpdateNameOperation::new),
        UPDATE_STYLE(UpdateStyleOperation::new),
        UPDATE_PROPERTIES(UpdatePropertiesOperation::new);

        final StreamDecoder<RegistryFriendlyByteBuf, Operation> reader;

        private OperationType(StreamDecoder<RegistryFriendlyByteBuf, Operation> parser) {
            this.reader = parser;
        }
    }

    static class AddOperation
    implements Operation {
        private final Component name;
        private final float progress;
        private final BossEvent.BossBarColor color;
        private final BossEvent.BossBarOverlay overlay;
        private final boolean darkenScreen;
        private final boolean playMusic;
        private final boolean createWorldFog;

        AddOperation(BossEvent bar) {
            this.name = bar.getName();
            this.progress = bar.getProgress();
            this.color = bar.getColor();
            this.overlay = bar.getOverlay();
            this.darkenScreen = bar.shouldDarkenScreen();
            this.playMusic = bar.shouldPlayBossMusic();
            this.createWorldFog = bar.shouldCreateWorldFog();
        }

        private AddOperation(RegistryFriendlyByteBuf buf) {
            this.name = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(buf);
            this.progress = buf.readFloat();
            this.color = buf.readEnum(BossEvent.BossBarColor.class);
            this.overlay = buf.readEnum(BossEvent.BossBarOverlay.class);
            short i = buf.readUnsignedByte();
            this.darkenScreen = (i & 1) > 0;
            this.playMusic = (i & 2) > 0;
            this.createWorldFog = (i & 4) > 0;
        }

        @Override
        @Override
        public OperationType getType() {
            return OperationType.ADD;
        }

        @Override
        @Override
        public void dispatch(UUID uuid, Handler consumer) {
            consumer.add(uuid, this.name, this.progress, this.color, this.overlay, this.darkenScreen, this.playMusic, this.createWorldFog);
        }

        @Override
        @Override
        public void write(RegistryFriendlyByteBuf buf) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(buf, this.name);
            buf.writeFloat(this.progress);
            buf.writeEnum(this.color);
            buf.writeEnum(this.overlay);
            buf.writeByte(ClientboundBossEventPacket.encodeProperties(this.darkenScreen, this.playMusic, this.createWorldFog));
        }
    }

    record UpdateProgressOperation(float progress) implements Operation
    {
        private UpdateProgressOperation(RegistryFriendlyByteBuf buf) {
            this(buf.readFloat());
        }

        @Override
        @Override
        public OperationType getType() {
            return OperationType.UPDATE_PROGRESS;
        }

        @Override
        @Override
        public void dispatch(UUID uuid, Handler consumer) {
            consumer.updateProgress(uuid, this.progress);
        }

        @Override
        @Override
        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeFloat(this.progress);
        }
    }

    record UpdateNameOperation(Component name) implements Operation
    {
        private UpdateNameOperation(RegistryFriendlyByteBuf buf) {
            this((Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(buf));
        }

        @Override
        @Override
        public OperationType getType() {
            return OperationType.UPDATE_NAME;
        }

        @Override
        @Override
        public void dispatch(UUID uuid, Handler consumer) {
            consumer.updateName(uuid, this.name);
        }

        @Override
        @Override
        public void write(RegistryFriendlyByteBuf buf) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(buf, this.name);
        }
    }

    static class UpdateStyleOperation
    implements Operation {
        private final BossEvent.BossBarColor color;
        private final BossEvent.BossBarOverlay overlay;

        UpdateStyleOperation(BossEvent.BossBarColor color, BossEvent.BossBarOverlay style) {
            this.color = color;
            this.overlay = style;
        }

        private UpdateStyleOperation(RegistryFriendlyByteBuf buf) {
            this.color = buf.readEnum(BossEvent.BossBarColor.class);
            this.overlay = buf.readEnum(BossEvent.BossBarOverlay.class);
        }

        @Override
        @Override
        public OperationType getType() {
            return OperationType.UPDATE_STYLE;
        }

        @Override
        @Override
        public void dispatch(UUID uuid, Handler consumer) {
            consumer.updateStyle(uuid, this.color, this.overlay);
        }

        @Override
        @Override
        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeEnum(this.color);
            buf.writeEnum(this.overlay);
        }
    }

    static class UpdatePropertiesOperation
    implements Operation {
        private final boolean darkenScreen;
        private final boolean playMusic;
        private final boolean createWorldFog;

        UpdatePropertiesOperation(boolean darkenSky, boolean dragonMusic, boolean thickenFog) {
            this.darkenScreen = darkenSky;
            this.playMusic = dragonMusic;
            this.createWorldFog = thickenFog;
        }

        private UpdatePropertiesOperation(RegistryFriendlyByteBuf buf) {
            short i = buf.readUnsignedByte();
            this.darkenScreen = (i & 1) > 0;
            this.playMusic = (i & 2) > 0;
            this.createWorldFog = (i & 4) > 0;
        }

        @Override
        @Override
        public OperationType getType() {
            return OperationType.UPDATE_PROPERTIES;
        }

        @Override
        @Override
        public void dispatch(UUID uuid, Handler consumer) {
            consumer.updateProperties(uuid, this.darkenScreen, this.playMusic, this.createWorldFog);
        }

        @Override
        @Override
        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeByte(ClientboundBossEventPacket.encodeProperties(this.darkenScreen, this.playMusic, this.createWorldFog));
        }
    }

    public static interface Handler {
        default public void add(UUID uuid, Component name, float percent, BossEvent.BossBarColor color, BossEvent.BossBarOverlay style, boolean darkenSky, boolean dragonMusic, boolean thickenFog) {
        }

        default public void remove(UUID uuid) {
        }

        default public void updateProgress(UUID uuid, float percent) {
        }

        default public void updateName(UUID uuid, Component name) {
        }

        default public void updateStyle(UUID id, BossEvent.BossBarColor color, BossEvent.BossBarOverlay style) {
        }

        default public void updateProperties(UUID uuid, boolean darkenSky, boolean dragonMusic, boolean thickenFog) {
        }
    }
}

