/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionLibrary;
import org.slf4j.Logger;

public class ServerFunctionManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation TICK_FUNCTION_TAG = new ResourceLocation("tick");
    private static final ResourceLocation LOAD_FUNCTION_TAG = new ResourceLocation("load");
    private final MinecraftServer server;
    private List<CommandFunction<CommandSourceStack>> ticking = ImmutableList.of();
    private boolean postReload;
    private ServerFunctionLibrary library;

    public ServerFunctionManager(MinecraftServer server, ServerFunctionLibrary loader) {
        this.server = server;
        this.library = loader;
        this.postReload(loader);
    }

    public CommandDispatcher<CommandSourceStack> getDispatcher() {
        return this.server.getCommands().getDispatcher();
    }

    public void tick() {
        if (this.server.tickRateManager().runsNormally()) {
            if (this.postReload) {
                this.postReload = false;
                Collection<CommandFunction<CommandSourceStack>> collection = this.library.getTag(LOAD_FUNCTION_TAG);
                this.executeTagFunctions(collection, LOAD_FUNCTION_TAG);
            }
            this.executeTagFunctions(this.ticking, TICK_FUNCTION_TAG);
        }
    }

    private void executeTagFunctions(Collection<CommandFunction<CommandSourceStack>> functions, ResourceLocation label) {
        Objects.requireNonNull(label);
        for (CommandFunction<CommandSourceStack> commandfunction : functions) {
            this.execute(commandfunction, this.getGameLoopSender());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandFunction<CommandSourceStack> function, CommandSourceStack source) {
        try {
            InstantiatedFunction<CommandSourceStack> instantiatedfunction = function.instantiate(null, this.getDispatcher());
            Commands.executeCommandInContext(source, executioncontext -> ExecutionContext.queueInitialFunctionCall(executioncontext, instantiatedfunction, source, CommandResultCallback.EMPTY));
        }
        catch (FunctionInstantiationException instantiatedfunction) {
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to execute function {}", (Object)function.id(), (Object)exception);
        }
    }

    public void replaceLibrary(ServerFunctionLibrary loader) {
        this.library = loader;
        this.postReload(loader);
    }

    private void postReload(ServerFunctionLibrary loader) {
        this.ticking = ImmutableList.copyOf(loader.getTag(TICK_FUNCTION_TAG));
        this.postReload = true;
    }

    public CommandSourceStack getGameLoopSender() {
        return this.server.createCommandSourceStack().withPermission(2).withSuppressedOutput();
    }

    public Optional<CommandFunction<CommandSourceStack>> get(ResourceLocation id) {
        return this.library.getFunction(id);
    }

    public Collection<CommandFunction<CommandSourceStack>> getTag(ResourceLocation id) {
        return this.library.getTag(id);
    }

    public Iterable<ResourceLocation> getFunctionNames() {
        return this.library.getFunctions().keySet();
    }

    public Iterable<ResourceLocation> getTagNames() {
        return this.library.getAvailableTags();
    }
}

