/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EffectCommands {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.effect.give.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_SPECIFIC_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.effect.clear.specific.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("effect").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal("clear").executes(commandcontext -> EffectCommands.clearEffects((CommandSourceStack)commandcontext.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)commandcontext.getSource()).getEntityOrException())))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).executes(commandcontext -> EffectCommands.clearEffects((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets")))).then(Commands.argument("effect", ResourceArgument.resource(registryAccess, Registries.MOB_EFFECT)).executes(commandcontext -> EffectCommands.clearEffect((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)commandcontext, "effect"))))))).then(Commands.literal("give").then(Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("effect", ResourceArgument.resource(registryAccess, Registries.MOB_EFFECT)).executes(commandcontext -> EffectCommands.giveEffect((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)commandcontext, "effect"), null, 0, true))).then(((RequiredArgumentBuilder)Commands.argument("seconds", IntegerArgumentType.integer((int)1, (int)1000000)).executes(commandcontext -> EffectCommands.giveEffect((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)commandcontext, "effect"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seconds"), 0, true))).then(((RequiredArgumentBuilder)Commands.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(commandcontext -> EffectCommands.giveEffect((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)commandcontext, "effect"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"amplifier"), true))).then(Commands.argument("hideParticles", BoolArgumentType.bool()).executes(commandcontext -> EffectCommands.giveEffect((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)commandcontext, "effect"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)commandcontext, (String)"hideParticles"))))))).then(((LiteralArgumentBuilder)Commands.literal("infinite").executes(commandcontext -> EffectCommands.giveEffect((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)commandcontext, "effect"), -1, 0, true))).then(((RequiredArgumentBuilder)Commands.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(commandcontext -> EffectCommands.giveEffect((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)commandcontext, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"amplifier"), true))).then(Commands.argument("hideParticles", BoolArgumentType.bool()).executes(commandcontext -> EffectCommands.giveEffect((CommandSourceStack)commandcontext.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)commandcontext, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)commandcontext, (String)"hideParticles")))))))))));
    }

    private static int giveEffect(CommandSourceStack source, Collection<? extends Entity> targets, Holder<MobEffect> statusEffect, @Nullable Integer seconds, int amplifier, boolean showParticles) throws CommandSyntaxException {
        MobEffect mobeffectlist = statusEffect.value();
        int j = 0;
        int k = seconds != null ? (mobeffectlist.isInstantenous() ? seconds : (seconds == -1 ? -1 : seconds * 20)) : (mobeffectlist.isInstantenous() ? 1 : 600);
        for (Entity entity : targets) {
            MobEffectInstance mobeffect;
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).addEffect(mobeffect = new MobEffectInstance(statusEffect, k, amplifier, false, showParticles), source.getEntity(), EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++j;
        }
        if (j == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.effect.give.success.single", mobeffectlist.getDisplayName(), ((Entity)targets.iterator().next()).getDisplayName(), k / 20), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.effect.give.success.multiple", mobeffectlist.getDisplayName(), targets.size(), k / 20), true);
        }
        return j;
    }

    private static int clearEffects(CommandSourceStack source, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).removeAllEffects(EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.effect.clear.everything.success.single", ((Entity)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.effect.clear.everything.success.multiple", targets.size()), true);
        }
        return i;
    }

    private static int clearEffect(CommandSourceStack source, Collection<? extends Entity> targets, Holder<MobEffect> statusEffect) throws CommandSyntaxException {
        MobEffect mobeffectlist = statusEffect.value();
        int i = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).removeEffect(statusEffect, EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_CLEAR_SPECIFIC_FAILED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.effect.clear.specific.success.single", mobeffectlist.getDisplayName(), ((Entity)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.effect.clear.specific.success.multiple", mobeffectlist.getDisplayName(), targets.size()), true);
        }
        return i;
    }
}

