/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.purpurmc.purpur.PurpurConfig;

public class GameModeCommand {
    public static final int PERMISSION_LEVEL = 2;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("gamemode").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument("gamemode", GameModeArgument.gameMode()).executes(commandContext -> GameModeCommand.setMode((CommandContext<CommandSourceStack>)commandContext, Collections.singleton(((CommandSourceStack)commandContext.getSource()).getPlayerOrException()), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)commandContext, "gamemode")))).then(Commands.argument("target", EntityArgument.players()).executes(commandContext -> GameModeCommand.setMode((CommandContext<CommandSourceStack>)commandContext, EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandContext, "target"), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)commandContext, "gamemode")))))));
    }

    private static void logGamemodeChange(CommandSourceStack source, ServerPlayer player, GameType gameMode) {
        MutableComponent component = Component.translatable("gameMode." + gameMode.getName());
        if (source.getEntity() == player) {
            source.sendSuccess(() -> Component.translatable("commands.gamemode.success.self", component), true);
        } else {
            if (source.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) {
                player.sendSystemMessage(Component.translatable("gameMode.changed", component));
            }
            source.sendSuccess(() -> Component.translatable("commands.gamemode.success.other", player.getDisplayName(), component), true);
        }
    }

    private static int setMode(CommandContext<CommandSourceStack> context, Collection<ServerPlayer> targets, GameType gameMode) {
        if (PurpurConfig.commandGamemodeRequiresPermission) {
            String gamemode = gameMode.getName();
            CommandSourceStack sender = (CommandSourceStack)context.getSource();
            if (!sender.testPermission(2, "minecraft.command.gamemode." + gamemode)) {
                return 0;
            }
            Entity entity = sender.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (!(targets.size() <= 1 && targets.contains(player) || sender.testPermission(2, "minecraft.command.gamemode." + gamemode + ".other"))) {
                    return 0;
                }
            }
        }
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            PlayerGameModeChangeEvent event = serverPlayer.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.COMMAND, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.empty());
            if (event != null && !event.isCancelled()) {
                GameModeCommand.logGamemodeChange((CommandSourceStack)context.getSource(), serverPlayer, gameMode);
                ++i;
                continue;
            }
            if (event == null || event.cancelMessage() == null) continue;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> PaperAdventure.asVanilla(event.cancelMessage()), true);
        }
        return i;
    }
}

