/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.event.player.PlayerKickEvent;

public class KickCommand {
    private static final SimpleCommandExceptionType ERROR_KICKING_OWNER = new SimpleCommandExceptionType((Message)Component.translatable("commands.kick.owner.failed"));
    private static final SimpleCommandExceptionType ERROR_SINGLEPLAYER = new SimpleCommandExceptionType((Message)Component.translatable("commands.kick.singleplayer.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("kick").requires(source -> source.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(context -> KickCommand.kickPlayers((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), Component.translatable("multiplayer.disconnect.kicked")))).then(Commands.argument("reason", MessageArgument.message()).executes(context -> KickCommand.kickPlayers((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), MessageArgument.getMessage((CommandContext<CommandSourceStack>)context, "reason")))))));
    }

    private static int kickPlayers(CommandSourceStack source, Collection<ServerPlayer> targets, Component reason) throws CommandSyntaxException {
        if (!source.getServer().isPublished()) {
            throw ERROR_SINGLEPLAYER.create();
        }
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            if (source.getServer().isSingleplayerOwner(serverPlayer.getGameProfile())) continue;
            serverPlayer.connection.disconnect(reason, PlayerKickEvent.Cause.KICK_COMMAND);
            source.sendSuccess(() -> Component.translatable("commands.kick.success", serverPlayer.getDisplayName(), reason), true);
            ++i;
        }
        if (i == 0) {
            throw ERROR_KICKING_OWNER.create();
        }
        return i;
    }
}

