/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.util.TickThread;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.DebugBuffer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ChunkHolder {
    public static final ChunkResult<ChunkAccess> UNLOADED_CHUNK = ChunkResult.error("Unloaded chunk");
    public static final CompletableFuture<ChunkResult<ChunkAccess>> UNLOADED_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK);
    public static final ChunkResult<LevelChunk> UNLOADED_LEVEL_CHUNK = ChunkResult.error("Unloaded level chunk");
    public static final ChunkResult<ChunkAccess> NOT_DONE_YET = ChunkResult.error("Not done yet");
    private static final CompletableFuture<ChunkResult<LevelChunk>> UNLOADED_LEVEL_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_LEVEL_CHUNK);
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private final LevelHeightAccessor levelHeightAccessor;
    @Nullable
    private final DebugBuffer<ChunkSaveDebug> chunkToSaveHistory;
    public final ChunkPos pos;
    private boolean hasChangedSections;
    private final ShortSet[] changedBlocksPerSection;
    private final BitSet blockChangedLightSectionFilter;
    private final BitSet skyChangedLightSectionFilter;
    private final LevelLightEngine lightEngine;
    private final LevelChangeListener onLevelChange;
    public final PlayerProvider playerProvider;
    private final ChunkMap chunkMap;
    public final NewChunkHolder newChunkHolder;
    private final ReferenceList<ServerPlayer> playersSentChunkTo = new ReferenceList();

    public final LevelChunk getSendingChunk() {
        LevelChunk ret = this.chunkMap.level.getChunkSource().getChunkAtIfLoadedImmediately(this.pos.x, this.pos.z);
        if (ret != null && ret.areNeighboursLoaded(1)) {
            return ret;
        }
        return null;
    }

    public void onChunkAdd() {
        if (this.needsBroadcastChanges()) {
            this.chunkMap.needsChangeBroadcasting.add((Object)this);
        }
    }

    public void onChunkRemove() {
        if (this.needsBroadcastChanges()) {
            this.chunkMap.needsChangeBroadcasting.remove((Object)this);
        }
    }

    public void addPlayer(ServerPlayer player) {
        if (!this.playersSentChunkTo.add(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.pos) + " in world '" + this.chunkMap.level.getWorld().getName() + "' to player " + String.valueOf(player));
        }
    }

    public void removePlayer(ServerPlayer player) {
        if (!this.playersSentChunkTo.remove(player)) {
            throw new IllegalStateException("Have not sent chunk " + String.valueOf(this.pos) + " in world '" + this.chunkMap.level.getWorld().getName() + "' to player " + String.valueOf(player));
        }
    }

    public boolean hasChunkBeenSent() {
        return this.playersSentChunkTo.size() != 0;
    }

    public boolean hasBeenSent(ServerPlayer to) {
        return this.playersSentChunkTo.contains(to);
    }

    public ChunkHolder(ChunkPos pos, LevelHeightAccessor world, LevelLightEngine lightingProvider, PlayerProvider playersWatchingChunkProvider, NewChunkHolder newChunkHolder) {
        this.newChunkHolder = newChunkHolder;
        this.chunkToSaveHistory = null;
        this.blockChangedLightSectionFilter = new BitSet();
        this.skyChangedLightSectionFilter = new BitSet();
        this.pos = pos;
        this.levelHeightAccessor = world;
        this.lightEngine = lightingProvider;
        this.onLevelChange = null;
        this.playerProvider = playersWatchingChunkProvider;
        this.changedBlocksPerSection = new ShortSet[world.getSectionsCount()];
        this.chunkMap = (ChunkMap)playersWatchingChunkProvider;
    }

    @Nullable
    public ChunkAccess getAvailableChunkNow() {
        return this.newChunkHolder.getCurrentChunk();
    }

    public LevelChunk getFullChunkNow() {
        ChunkAccess chunkAccess;
        if (!this.isFullChunkReady() || !((chunkAccess = this.getAvailableChunkNow()) instanceof LevelChunk)) {
            return null;
        }
        LevelChunk chunk = (LevelChunk)chunkAccess;
        return chunk;
    }

    public LevelChunk getFullChunkNowUnchecked() {
        LevelChunk chunk;
        ChunkAccess chunkAccess = this.getAvailableChunkNow();
        return chunkAccess instanceof LevelChunk ? (chunk = (LevelChunk)chunkAccess) : null;
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getFutureIfPresentUnchecked(ChunkStatus leastStatus) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getFutureIfPresent(ChunkStatus leastStatus) {
        throw new UnsupportedOperationException();
    }

    public final CompletableFuture<ChunkResult<LevelChunk>> getTickingChunkFuture() {
        throw new UnsupportedOperationException();
    }

    public final CompletableFuture<ChunkResult<LevelChunk>> getEntityTickingChunkFuture() {
        throw new UnsupportedOperationException();
    }

    public final CompletableFuture<ChunkResult<LevelChunk>> getFullChunkFuture() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public final LevelChunk getTickingChunk() {
        if (!this.isTickingReady()) {
            return null;
        }
        return (LevelChunk)this.getAvailableChunkNow();
    }

    public CompletableFuture<?> getChunkSendSyncFuture() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public LevelChunk getChunkToSend() {
        return this.getSendingChunk();
    }

    @Nullable
    public ChunkStatus getLastAvailableStatus() {
        return this.newChunkHolder.getCurrentGenStatus();
    }

    @Nullable
    public ChunkStatus getChunkHolderStatus() {
        return this.newChunkHolder.getCurrentGenStatus();
    }

    @Nullable
    public ChunkAccess getLastAvailable() {
        return this.newChunkHolder.getCurrentChunk();
    }

    public void blockChanged(BlockPos pos) {
        if (this.playersSentChunkTo.size() == 0) {
            return;
        }
        LevelChunk chunk = this.getSendingChunk();
        if (chunk != null) {
            int i = this.levelHeightAccessor.getSectionIndex(pos.getY());
            if (i < 0 || i >= this.changedBlocksPerSection.length) {
                return;
            }
            if (this.changedBlocksPerSection[i] == null) {
                this.hasChangedSections = true;
                this.addToBroadcastMap();
                this.changedBlocksPerSection[i] = new ShortOpenHashSet();
            }
            this.changedBlocksPerSection[i].add(SectionPos.sectionRelativePos(pos));
        }
    }

    public void sectionLightChanged(LightLayer lightType, int y) {
        ChunkAccess ichunkaccess = this.getAvailableChunkNow();
        if (ichunkaccess != null) {
            ichunkaccess.setUnsaved(true);
            LevelChunk chunk = this.getSendingChunk();
            if (this.playersSentChunkTo.size() != 0 && chunk != null) {
                int j = this.lightEngine.getMinLightSection();
                int k = this.lightEngine.getMaxLightSection();
                if (y >= j && y <= k) {
                    this.addToBroadcastMap();
                    int l = y - j;
                    if (lightType == LightLayer.SKY) {
                        this.skyChangedLightSectionFilter.set(l);
                    } else {
                        this.blockChangedLightSectionFilter.set(l);
                    }
                }
            }
        }
    }

    public void broadcast(Packet<?> packet, boolean onChunkViewEdge) {
        this.broadcast(this.getPlayers(onChunkViewEdge), packet);
    }

    public final boolean needsBroadcastChanges() {
        return this.hasChangedSections || !this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty();
    }

    private void addToBroadcastMap() {
        TickThread.ensureTickThread(this.chunkMap.level, this.pos, "Asynchronous ChunkHolder update is not allowed");
        this.chunkMap.needsChangeBroadcasting.add((Object)this);
    }

    public void broadcastChanges(LevelChunk chunk) {
        if (this.needsBroadcastChanges()) {
            List<ServerPlayer> list;
            Level world = chunk.getLevel();
            if (!this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
                list = this.getPlayers(true);
                if (!list.isEmpty()) {
                    ClientboundLightUpdatePacket packetplayoutlightupdate = new ClientboundLightUpdatePacket(chunk.getPos(), this.lightEngine, this.skyChangedLightSectionFilter, this.blockChangedLightSectionFilter);
                    this.broadcast(list, packetplayoutlightupdate);
                }
                this.skyChangedLightSectionFilter.clear();
                this.blockChangedLightSectionFilter.clear();
            }
            if (this.hasChangedSections) {
                list = this.getPlayers(false);
                for (int i = 0; i < this.changedBlocksPerSection.length; ++i) {
                    ShortSet shortset = this.changedBlocksPerSection[i];
                    if (shortset == null) continue;
                    this.changedBlocksPerSection[i] = null;
                    if (list.isEmpty()) continue;
                    int j = this.levelHeightAccessor.getSectionYFromSectionIndex(i);
                    SectionPos sectionposition = SectionPos.of(chunk.getPos(), j);
                    if (shortset.size() == 1) {
                        BlockPos blockposition = sectionposition.relativeToBlockPos(shortset.iterator().nextShort());
                        BlockState iblockdata = world.getBlockState(blockposition);
                        this.broadcast(list, new ClientboundBlockUpdatePacket(blockposition, iblockdata));
                        this.broadcastBlockEntityIfNeeded(list, world, blockposition, iblockdata);
                        continue;
                    }
                    LevelChunkSection chunksection = chunk.getSection(i);
                    ClientboundSectionBlocksUpdatePacket packetplayoutmultiblockchange = new ClientboundSectionBlocksUpdatePacket(sectionposition, shortset, chunksection);
                    this.broadcast(list, packetplayoutmultiblockchange);
                    List<ServerPlayer> finalList = list;
                    packetplayoutmultiblockchange.runUpdates((blockposition1, iblockdata1) -> this.broadcastBlockEntityIfNeeded(finalList, world, (BlockPos)blockposition1, (BlockState)iblockdata1));
                }
                this.hasChangedSections = false;
            }
        }
    }

    private void broadcastBlockEntityIfNeeded(List<ServerPlayer> players, Level world, BlockPos pos, BlockState state) {
        if (state.hasBlockEntity()) {
            this.broadcastBlockEntity(players, world, pos);
        }
    }

    private void broadcastBlockEntity(List<ServerPlayer> players, Level world, BlockPos pos) {
        Packet<ClientGamePacketListener> packet;
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity != null && (packet = tileentity.getUpdatePacket()) != null) {
            this.broadcast(players, packet);
        }
    }

    public List<ServerPlayer> getPlayers(boolean onlyOnWatchDistanceEdge) {
        ArrayList<ServerPlayer> ret = new ArrayList<ServerPlayer>();
        int len = this.playersSentChunkTo.size();
        for (int i = 0; i < len; ++i) {
            ServerPlayer player = this.playersSentChunkTo.getUnchecked(i);
            if (onlyOnWatchDistanceEdge && !this.chunkMap.level.playerChunkLoader.isChunkSent(player, this.pos.x, this.pos.z, onlyOnWatchDistanceEdge)) continue;
            ret.add(player);
        }
        return ret;
    }

    private void broadcast(List<ServerPlayer> players, Packet<?> packet) {
        players.forEach(entityplayer -> entityplayer.connection.send(packet));
    }

    public FullChunkStatus getFullStatus() {
        return this.newChunkHolder.getChunkStatus();
    }

    public final ChunkPos getPos() {
        return this.pos;
    }

    public final int getTicketLevel() {
        return this.newChunkHolder.getTicketLevel();
    }

    public void replaceProtoChunk(ImposterProtoChunk chunk) {
        throw new UnsupportedOperationException();
    }

    public List<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>> getAllFutures() {
        throw new UnsupportedOperationException();
    }

    public final boolean isEntityTickingReady() {
        return this.newChunkHolder.isEntityTickingReady();
    }

    public final boolean isTickingReady() {
        return this.newChunkHolder.isTickingReady();
    }

    public final boolean isFullChunkReady() {
        return this.newChunkHolder.isFullChunkReady();
    }

    @FunctionalInterface
    public static interface LevelChangeListener {
        public void onLevelChange(ChunkPos var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface PlayerProvider {
        public List<ServerPlayer> getPlayers(ChunkPos var1, boolean var2);
    }

    private record ChunkSaveDebug(Thread thread, CompletableFuture<?> future, String source) {
    }
}

