/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.world.level.ChunkPos;

public class ChunkTaskPriorityQueue<T> {
    public static final int PRIORITY_LEVEL_COUNT = ChunkLevel.MAX_LEVEL + 2;
    private final List<Long2ObjectLinkedOpenHashMap<List<Optional<T>>>> taskQueue = IntStream.range(0, PRIORITY_LEVEL_COUNT).mapToObj(i -> new Long2ObjectLinkedOpenHashMap()).collect(Collectors.toList());
    private volatile int firstQueue = PRIORITY_LEVEL_COUNT;
    private final String name;
    private final LongSet acquired = new LongOpenHashSet();
    private final int maxTasks;

    public ChunkTaskPriorityQueue(String name, int maxSize) {
        this.name = name;
        this.maxTasks = maxSize;
    }

    protected void resortChunkTasks(int fromLevel, ChunkPos pos, int toLevel) {
        if (fromLevel >= PRIORITY_LEVEL_COUNT) {
            return;
        }
        Long2ObjectLinkedOpenHashMap<List<Optional<T>>> long2ObjectLinkedOpenHashMap = this.taskQueue.get(fromLevel);
        List list = (List)long2ObjectLinkedOpenHashMap.remove(pos.toLong());
        if (fromLevel == this.firstQueue) {
            while (this.hasWork() && this.taskQueue.get(this.firstQueue).isEmpty()) {
                ++this.firstQueue;
            }
        }
        if (list != null && !list.isEmpty()) {
            ((List)this.taskQueue.get(toLevel).computeIfAbsent(pos.toLong(), l -> Lists.newArrayList())).addAll(list);
            this.firstQueue = Math.min(this.firstQueue, toLevel);
        }
    }

    protected void submit(Optional<T> element, long pos, int level) {
        ((List)this.taskQueue.get(level).computeIfAbsent(pos, l -> Lists.newArrayList())).add(element);
        this.firstQueue = Math.min(this.firstQueue, level);
    }

    protected void release(long pos, boolean removeElement) {
        for (Long2ObjectLinkedOpenHashMap<List<Optional<T>>> long2ObjectLinkedOpenHashMap : this.taskQueue) {
            List list = (List)long2ObjectLinkedOpenHashMap.get(pos);
            if (list == null) continue;
            if (removeElement) {
                list.clear();
            } else {
                list.removeIf(optional -> optional.isEmpty());
            }
            if (!list.isEmpty()) continue;
            long2ObjectLinkedOpenHashMap.remove(pos);
        }
        while (this.hasWork() && this.taskQueue.get(this.firstQueue).isEmpty()) {
            ++this.firstQueue;
        }
        this.acquired.remove(pos);
    }

    private Runnable acquire(long pos) {
        return () -> this.acquired.add(pos);
    }

    @Nullable
    public Stream<Either<T, Runnable>> pop() {
        if (this.acquired.size() >= this.maxTasks) {
            return null;
        }
        if (this.hasWork()) {
            int i = this.firstQueue;
            Long2ObjectLinkedOpenHashMap<List<Optional<T>>> long2ObjectLinkedOpenHashMap = this.taskQueue.get(i);
            long l = long2ObjectLinkedOpenHashMap.firstLongKey();
            List list = (List)long2ObjectLinkedOpenHashMap.removeFirst();
            while (this.hasWork() && this.taskQueue.get(this.firstQueue).isEmpty()) {
                ++this.firstQueue;
            }
            return list.stream().map(optional -> optional.map(Either::left).orElseGet(() -> Either.right(this.acquire(l))));
        }
        return null;
    }

    public boolean hasWork() {
        return this.firstQueue < PRIORITY_LEVEL_COUNT;
    }

    @Override
    public String toString() {
        return this.name + " " + this.firstQueue + "...";
    }

    @VisibleForTesting
    LongSet getAcquired() {
        return new LongOpenHashSet((LongCollection)this.acquired);
    }
}

