/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.scheduling.ChunkHolderManager;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public abstract class DistanceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    static final int PLAYER_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    final Long2ObjectMap<ObjectSet<ServerPlayer>> playersPerChunk = new Long2ObjectOpenHashMap();
    public static final int MOB_SPAWN_RANGE = 8;
    private final ChunkMap chunkMap;

    public ChunkHolderManager getChunkHolderManager() {
        return this.chunkMap.level.chunkTaskScheduler.chunkHolderManager;
    }

    protected DistanceManager(Executor workerExecutor, Executor mainThreadExecutor, ChunkMap chunkMap) {
        this.chunkMap = chunkMap;
    }

    protected void purgeStaleTickets() {
        this.getChunkHolderManager().tick();
    }

    private static int getTicketLevelAt(SortedArraySet<Ticket<?>> tickets) {
        return !tickets.isEmpty() ? tickets.first().getTicketLevel() : ChunkLevel.MAX_LEVEL + 1;
    }

    protected abstract boolean isChunkToRemove(long var1);

    @Nullable
    protected abstract ChunkHolder getChunk(long var1);

    @Nullable
    protected abstract ChunkHolder updateChunkScheduling(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean runAllUpdates(ChunkMap chunkStorage) {
        return this.getChunkHolderManager().processTicketUpdates();
    }

    boolean addTicket(long i, Ticket<?> ticket) {
        AsyncCatcher.catchOp("ChunkMapDistance::addTicket");
        return this.getChunkHolderManager().addTicketAtLevel(ticket.getType(), i, ticket.getTicketLevel(), ticket.key);
    }

    boolean removeTicket(long i, Ticket<?> ticket) {
        AsyncCatcher.catchOp("ChunkMapDistance::removeTicket");
        return this.getChunkHolderManager().removeTicketAtLevel(ticket.getType(), i, ticket.getTicketLevel(), ticket.key);
    }

    public <T> void addTicket(TicketType<T> type, ChunkPos pos, int level, T argument) {
        this.getChunkHolderManager().addTicketAtLevel(type, pos, level, argument);
    }

    public <T> void removeTicket(TicketType<T> type, ChunkPos pos, int level, T argument) {
        this.getChunkHolderManager().removeTicketAtLevel(type, pos, level, argument);
    }

    public <T> void addRegionTicket(TicketType<T> type, ChunkPos pos, int radius, T argument) {
        this.addRegionTicketAtDistance(type, pos, radius, argument);
    }

    public <T> boolean addRegionTicketAtDistance(TicketType<T> tickettype, ChunkPos chunkcoordintpair, int i, T t0) {
        return this.getChunkHolderManager().addTicketAtLevel(tickettype, chunkcoordintpair, ChunkLevel.byStatus(FullChunkStatus.FULL) - i, t0);
    }

    public <T> void removeRegionTicket(TicketType<T> type, ChunkPos pos, int radius, T argument) {
        this.removeRegionTicketAtDistance(type, pos, radius, argument);
    }

    public <T> boolean removeRegionTicketAtDistance(TicketType<T> tickettype, ChunkPos chunkcoordintpair, int i, T t0) {
        return this.getChunkHolderManager().removeTicketAtLevel(tickettype, chunkcoordintpair, ChunkLevel.byStatus(FullChunkStatus.FULL) - i, t0);
    }

    protected void updateChunkForced(ChunkPos pos, boolean forced) {
        Ticket<ChunkPos> ticket = new Ticket<ChunkPos>(TicketType.FORCED, ChunkMap.FORCED_TICKET_LEVEL, pos, 0L);
        long i = pos.toLong();
        if (forced) {
            this.addTicket(i, ticket);
        } else {
            this.removeTicket(i, ticket);
        }
    }

    public void addPlayer(SectionPos pos, ServerPlayer player) {
        ChunkPos chunkcoordintpair = pos.chunk();
        long i = chunkcoordintpair.toLong();
    }

    public void removePlayer(SectionPos pos, ServerPlayer player) {
        ChunkPos chunkcoordintpair = pos.chunk();
        long i = chunkcoordintpair.toLong();
        ObjectSet objectset = (ObjectSet)this.playersPerChunk.get(i);
        if (objectset == null) {
            return;
        }
        if (objectset != null) {
            objectset.remove((Object)player);
        }
        if (objectset == null || objectset.isEmpty()) {
            this.playersPerChunk.remove(i);
        }
    }

    public boolean inEntityTickingRange(long chunkPos) {
        ChunkHolder holder = this.chunkMap.getVisibleChunkIfPresent(chunkPos);
        return holder != null && holder.isEntityTickingReady();
    }

    public boolean inBlockTickingRange(long chunkPos) {
        ChunkHolder holder = this.chunkMap.getVisibleChunkIfPresent(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected String getTicketDebugString(long pos) {
        return this.getChunkHolderManager().getTicketDebugString(pos);
    }

    protected void updatePlayerTickets(int viewDistance) {
        this.chunkMap.setServerViewDistance(viewDistance);
    }

    public int getSimulationDistance() {
        return this.chunkMap.level.playerChunkLoader.getAPITickDistance();
    }

    public void updateSimulationDistance(int simulationDistance) {
        this.chunkMap.level.playerChunkLoader.setTickDistance(simulationDistance);
    }

    public int getNaturalSpawnChunkCount() {
        return this.chunkMap.playerMobSpawnMap.size();
    }

    public boolean hasPlayersNearby(long chunkPos) {
        return this.chunkMap.playerMobSpawnMap.getObjectsInRange(chunkPos) != null;
    }

    public String getDebugStatus() {
        return "No DistanceManager stats available";
    }

    public void removeTicketsOnClosing() {
    }

    public boolean hasTickets() {
        throw new UnsupportedOperationException();
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        this.getChunkHolderManager().removeAllTicketsFor(ticketType, ticketLevel, ticketIdentifier);
    }

    private class FixedPlayerDistanceChunkTracker
    extends ChunkTracker {
        protected final Long2ByteMap chunks;
        protected final int maxDistance;

        protected FixedPlayerDistanceChunkTracker(int i) {
            super(i + 2, 16, 256);
            this.chunks = new Long2ByteOpenHashMap();
            this.maxDistance = i;
            this.chunks.defaultReturnValue((byte)(i + 2));
        }

        @Override
        protected int getLevel(long id) {
            return this.chunks.get(id);
        }

        @Override
        protected void setLevel(long id, int level) {
            byte b0 = level > this.maxDistance ? this.chunks.remove(id) : this.chunks.put(id, (byte)level);
            this.onLevelChange(id, b0, level);
        }

        protected void onLevelChange(long pos, int oldDistance, int distance) {
        }

        @Override
        protected int getLevelFromSource(long id) {
            return this.havePlayer(id) ? 0 : Integer.MAX_VALUE;
        }

        private boolean havePlayer(long chunkPos) {
            ObjectSet objectset = (ObjectSet)DistanceManager.this.playersPerChunk.get(chunkPos);
            return objectset != null && !objectset.isEmpty();
        }

        public void runAllUpdates() {
            this.runUpdates(Integer.MAX_VALUE);
        }

        private void dumpChunks(String path) {
            try (FileOutputStream fileoutputstream = new FileOutputStream(new File(path));){
                for (Long2ByteMap.Entry it_unimi_dsi_fastutil_longs_long2bytemap_entry : this.chunks.long2ByteEntrySet()) {
                    ChunkPos chunkcoordintpair = new ChunkPos(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getLongKey());
                    String s1 = Byte.toString(it_unimi_dsi_fastutil_longs_long2bytemap_entry.getByteValue());
                    fileoutputstream.write((chunkcoordintpair.x + "\t" + chunkcoordintpair.z + "\t" + s1 + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException ioexception) {
                LOGGER.error("Failed to dump chunks to {}", (Object)path, (Object)ioexception);
            }
        }
    }
}

