/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.starlight.common.light.StarLightInterface;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.light.LightQueue;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.bukkit.Bukkit;
import org.slf4j.Logger;

public class ThreadedLevelLightEngine
extends LevelLightEngine
implements AutoCloseable {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ChunkMap chunkMap;
    public final StarLightInterface theLightEngine;
    public final boolean hasBlockLight;
    public final boolean hasSkyLight;
    protected long relightCounter;
    private final Long2IntOpenHashMap chunksBeingWorkedOn = new Long2IntOpenHashMap();

    public ThreadedLevelLightEngine(LightChunkGetter chunkProvider, ChunkMap chunkStorage, boolean hasBlockLight, ProcessorMailbox<Runnable> processor, ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> executor) {
        super(chunkProvider, false, false);
        this.chunkMap = chunkStorage;
        this.hasBlockLight = true;
        this.hasSkyLight = hasBlockLight;
        this.theLightEngine = new StarLightInterface(chunkProvider, this.hasSkyLight, this.hasBlockLight, this);
    }

    protected final ChunkAccess getChunk(int chunkX, int chunkZ) {
        return ((ServerLevel)this.theLightEngine.getWorld()).getChunkSource().getChunkAtImmediately(chunkX, chunkZ);
    }

    public int relight(Set<ChunkPos> chunks_param, Consumer<ChunkPos> chunkLightCallback, IntConsumer onComplete) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Must only be called on the main thread");
        }
        LinkedHashSet<ChunkPos> chunks = new LinkedHashSet<ChunkPos>(chunks_param);
        HashMap<ChunkPos, Long> ticketIds = new HashMap<ChunkPos, Long>();
        int totalChunks = 0;
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            ChunkPos chunkPos = (ChunkPos)iterator.next();
            ChunkAccess chunk = (ChunkAccess)((ServerLevel)this.theLightEngine.getWorld()).getChunkSource().getChunkForLighting(chunkPos.x, chunkPos.z);
            if (chunk == null || !chunk.isLightCorrect() || !chunk.getStatus().isOrAfter(ChunkStatus.LIGHT)) {
                iterator.remove();
                continue;
            }
            Long id = this.relightCounter++;
            ((ServerLevel)this.theLightEngine.getWorld()).getChunkSource().addTicketAtLevel(TicketType.CHUNK_RELIGHT, chunkPos, MCUtil.getTicketLevelFor(ChunkStatus.LIGHT), id);
            ticketIds.put(chunkPos, id);
            ++totalChunks;
        }
        this.chunkMap.level.chunkTaskScheduler.radiusAwareScheduler.queueInfiniteRadiusTask(() -> this.theLightEngine.relightChunks(chunks, chunkPos -> {
            chunkLightCallback.accept((ChunkPos)chunkPos);
            ((ServerLevel)this.theLightEngine.getWorld()).getChunkSource().mainThreadProcessor.execute(() -> {
                ((ServerLevel)this.theLightEngine.getWorld()).getChunkSource().chunkMap.getUpdatingChunkIfPresent(chunkPos.toLong()).broadcast(new ClientboundLightUpdatePacket((ChunkPos)chunkPos, this, null, null), false);
                ((ServerLevel)this.theLightEngine.getWorld()).getChunkSource().removeTicketAtLevel(TicketType.CHUNK_RELIGHT, (ChunkPos)chunkPos, MCUtil.getTicketLevelFor(ChunkStatus.LIGHT), (Long)ticketIds.get(chunkPos));
            });
        }, onComplete));
        this.tryScheduleUpdate();
        return totalChunks;
    }

    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<LightQueue.ChunkTasks> runnable) {
        ServerLevel world = (ServerLevel)this.theLightEngine.getWorld();
        ChunkAccess center = this.theLightEngine.getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.getStatus().isOrAfter(ChunkStatus.LIGHT)) {
            return;
        }
        if (center.getStatus() != ChunkStatus.FULL) {
            runnable.get();
            return;
        }
        if (!world.getChunkSource().chunkMap.mainThreadExecutor.isSameThread()) {
            world.getChunkSource().chunkMap.mainThreadExecutor.execute(() -> this.queueTaskForSection(chunkX, chunkY, chunkZ, runnable));
            return;
        }
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        LightQueue.ChunkTasks updateFuture = runnable.get();
        if (updateFuture == null) {
            return;
        }
        if (updateFuture.isTicketAdded) {
            return;
        }
        updateFuture.isTicketAdded = true;
        int references = this.chunksBeingWorkedOn.addTo(key, 1);
        if (references == 0) {
            ChunkPos pos = new ChunkPos(chunkX, chunkZ);
            world.getChunkSource().addRegionTicket(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, pos);
        }
        ((CompletableFuture)updateFuture.onComplete.thenAcceptAsync(ignore -> {
            int newReferences = this.chunksBeingWorkedOn.get(key);
            if (newReferences == 1) {
                this.chunksBeingWorkedOn.remove(key);
                ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                world.getChunkSource().removeRegionTicket(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, pos);
            } else {
                this.chunksBeingWorkedOn.put(key, newReferences - 1);
            }
        }, (Executor)world.getChunkSource().chunkMap.mainThreadExecutor)).whenComplete((ignore, thr) -> {
            if (thr != null) {
                LOGGER.error("Failed to remove ticket level for post chunk task " + String.valueOf(new ChunkPos(chunkX, chunkZ)), thr);
            }
        });
    }

    @Override
    public boolean hasLightWork() {
        return this.theLightEngine.hasUpdates();
    }

    @Override
    public LayerLightEventListener getLayerListener(LightLayer lightType) {
        return lightType == LightLayer.BLOCK ? this.theLightEngine.getBlockReader() : this.theLightEngine.getSkyReader();
    }

    @Override
    public int getRawBrightness(BlockPos pos, int ambientDarkness) {
        int sky = this.theLightEngine.getSkyReader().getLightValue(pos) - ambientDarkness;
        if (sky == 15) {
            return 15;
        }
        int block = this.theLightEngine.getBlockReader().getLightValue(pos);
        return Math.max(sky, block);
    }

    @Override
    public void close() {
    }

    @Override
    public int runLightUpdates() {
        throw Util.pauseInIde(new UnsupportedOperationException("Ran automatically on a different thread!"));
    }

    @Override
    public void checkBlock(BlockPos pos) {
        BlockPos posCopy = pos.immutable();
        this.queueTaskForSection(posCopy.getX() >> 4, posCopy.getY() >> 4, posCopy.getZ() >> 4, () -> this.theLightEngine.blockChange(posCopy));
    }

    protected void updateChunkStatus(ChunkPos pos) {
    }

    @Override
    public void updateSectionStatus(SectionPos pos, boolean notReady) {
        this.queueTaskForSection(pos.getX(), pos.getY(), pos.getZ(), () -> this.theLightEngine.sectionChange(pos, notReady));
    }

    @Override
    public void propagateLightSources(ChunkPos chunkPos) {
    }

    @Override
    public void setLightEnabled(ChunkPos pos, boolean retainData) {
    }

    @Override
    public void queueSectionData(LightLayer lightType, SectionPos pos, @Nullable DataLayer nibbles) {
    }

    private void addTask(int x, int z, TaskType stage, Runnable task) {
        throw new UnsupportedOperationException();
    }

    private void addTask(int x, int z, IntSupplier completedLevelSupplier, TaskType stage, Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retainData(ChunkPos pos, boolean retainData) {
    }

    public CompletableFuture<ChunkAccess> initializeLight(ChunkAccess chunk, boolean bl) {
        return CompletableFuture.completedFuture(chunk);
    }

    public CompletableFuture<ChunkAccess> lightChunk(ChunkAccess chunk, boolean excludeBlocks) {
        throw new UnsupportedOperationException();
    }

    public void tryScheduleUpdate() {
    }

    private void runUpdate() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<?> waitForPendingTasks(int x, int z) {
        return CompletableFuture.runAsync(() -> {}, callback -> this.addTask(x, z, TaskType.POST_UPDATE, callback));
    }

    private /* synthetic */ void lambda$initializeLight$24(ChunkPos chunkPos, Runnable task) {
        this.addTask(chunkPos.x, chunkPos.z, TaskType.POST_UPDATE, task);
    }

    private /* synthetic */ ChunkAccess lambda$initializeLight$23(ChunkPos chunkPos, boolean bl, ChunkAccess chunk) {
        super.setLightEnabled(chunkPos, bl);
        super.retainData(chunkPos, false);
        return chunk;
    }

    private static /* synthetic */ String lambda$initializeLight$22(ChunkPos chunkPos) {
        return "initializeLight: " + String.valueOf(chunkPos);
    }

    private /* synthetic */ void lambda$initializeLight$21(ChunkAccess chunk, ChunkPos chunkPos) {
        LevelChunkSection[] levelChunkSections = chunk.getSections();
        for (int i = 0; i < chunk.getSectionsCount(); ++i) {
            LevelChunkSection levelChunkSection = levelChunkSections[i];
            if (levelChunkSection.hasOnlyAir()) continue;
            int j = this.levelHeightAccessor.getSectionYFromSectionIndex(i);
            super.updateSectionStatus(SectionPos.of(chunkPos, j), false);
        }
    }

    private static /* synthetic */ String lambda$retainData$20(ChunkPos pos) {
        return "retainData " + String.valueOf(pos);
    }

    private /* synthetic */ void lambda$retainData$19(ChunkPos pos, boolean retainData) {
        super.retainData(pos, retainData);
    }

    private static /* synthetic */ int lambda$retainData$18() {
        return 0;
    }

    private static /* synthetic */ String lambda$queueSectionData$17(SectionPos pos) {
        return "queueData " + String.valueOf(pos);
    }

    private /* synthetic */ void lambda$queueSectionData$16(LightLayer lightType, SectionPos pos, DataLayer nibbles) {
        super.queueSectionData(lightType, pos, nibbles);
    }

    private static /* synthetic */ int lambda$queueSectionData$15() {
        return 0;
    }

    private static /* synthetic */ String lambda$setLightEnabled$14(ChunkPos pos, boolean retainData) {
        return "enableLight " + String.valueOf(pos) + " " + retainData;
    }

    private /* synthetic */ void lambda$setLightEnabled$13(ChunkPos pos, boolean retainData) {
        super.setLightEnabled(pos, retainData);
    }

    private static /* synthetic */ String lambda$propagateLightSources$12(ChunkPos chunkPos) {
        return "propagateLight " + String.valueOf(chunkPos);
    }

    private /* synthetic */ void lambda$propagateLightSources$11(ChunkPos chunkPos) {
        super.propagateLightSources(chunkPos);
    }

    private static /* synthetic */ String lambda$updateChunkStatus$9(ChunkPos pos) {
        return "updateChunkStatus " + String.valueOf(pos) + " true";
    }

    private /* synthetic */ void lambda$updateChunkStatus$8(ChunkPos pos) {
        super.retainData(pos, false);
        super.setLightEnabled(pos, false);
        for (int i = this.getMinLightSection(); i < this.getMaxLightSection(); ++i) {
            super.queueSectionData(LightLayer.BLOCK, SectionPos.of(pos, i), null);
            super.queueSectionData(LightLayer.SKY, SectionPos.of(pos, i), null);
        }
        for (int j = this.levelHeightAccessor.getMinSection(); j < this.levelHeightAccessor.getMaxSection(); ++j) {
            super.updateSectionStatus(SectionPos.of(pos, j), true);
        }
    }

    private static /* synthetic */ int lambda$updateChunkStatus$7() {
        return 0;
    }

    static enum TaskType {
        PRE_UPDATE,
        POST_UPDATE;

    }
}

