/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Objects;
import net.minecraft.server.level.TicketType;

public final class Ticket<T>
implements Comparable<Ticket<?>> {
    private final TicketType<T> type;
    private final int ticketLevel;
    public final T key;
    public long removeDelay;

    public Ticket(TicketType<T> type, int level, T argument, long removeDelay) {
        this.removeDelay = removeDelay;
        this.type = type;
        this.ticketLevel = level;
        this.key = argument;
    }

    @Override
    public int compareTo(Ticket<?> ticket) {
        int i = Integer.compare(this.ticketLevel, ticket.ticketLevel);
        if (i != 0) {
            return i;
        }
        int j = Integer.compare(System.identityHashCode(this.type), System.identityHashCode(ticket.type));
        return j != 0 ? j : this.type.getComparator().compare(this.key, ticket.key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof Ticket)) return false;
        Ticket ticket = (Ticket)object;
        if (this.ticketLevel != ticket.ticketLevel) return false;
        if (!Objects.equals(this.type, ticket.type)) return false;
        if (!Objects.equals(this.key, ticket.key)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.ticketLevel, this.key);
    }

    public String toString() {
        return "Ticket[" + String.valueOf(this.type) + " " + this.ticketLevel + " (" + String.valueOf(this.key) + ")] to die in " + this.removeDelay;
    }

    public TicketType<T> getType() {
        return this.type;
    }

    public int getTicketLevel() {
        return this.ticketLevel;
    }

    protected void setCreatedTick(long tickCreated) {
        throw new UnsupportedOperationException();
    }

    protected boolean timedOut(long currentTick) {
        throw new UnsupportedOperationException();
    }
}

