/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;
import org.bukkit.plugin.Plugin;

public class TicketType<T> {
    public static final TicketType<Long> FUTURE_AWAIT = TicketType.create("future_await", Long::compareTo);
    public static final TicketType<Long> ASYNC_LOAD = TicketType.create("async_load", Long::compareTo);
    private final String name;
    private final Comparator<T> comparator;
    public long timeout;
    public static final TicketType<Unit> START = TicketType.create("start", (unit, unit1) -> 0);
    public static final TicketType<Unit> DRAGON = TicketType.create("dragon", (unit, unit1) -> 0);
    public static final TicketType<ChunkPos> PLAYER = TicketType.create("player", Comparator.comparingLong(ChunkPos::toLong));
    public static final TicketType<ChunkPos> FORCED = TicketType.create("forced", Comparator.comparingLong(ChunkPos::toLong));
    public static final TicketType<ChunkPos> LIGHT = TicketType.create("light", Comparator.comparingLong(ChunkPos::toLong));
    public static final TicketType<BlockPos> PORTAL = TicketType.create("portal", Vec3i::compareTo, 300);
    public static final TicketType<Integer> POST_TELEPORT = TicketType.create("post_teleport", Integer::compareTo, 5);
    public static final TicketType<ChunkPos> UNKNOWN = TicketType.create("unknown", Comparator.comparingLong(ChunkPos::toLong), 1);
    public static final TicketType<Unit> PLUGIN = TicketType.create("plugin", (a, b) -> 0);
    public static final TicketType<Plugin> PLUGIN_TICKET = TicketType.create("plugin_ticket", (plugin1, plugin2) -> plugin1.getClass().getName().compareTo(plugin2.getClass().getName()));
    public static final TicketType<Long> CHUNK_RELIGHT = TicketType.create("light_update", Long::compareTo);
    public static final TicketType<Long> CHUNK_LOAD = TicketType.create("chunk_load", Long::compareTo);
    public static final TicketType<Long> STATUS_UPGRADE = TicketType.create("status_upgrade", Long::compareTo);
    public static final TicketType<Long> ENTITY_LOAD = TicketType.create("entity_load", Long::compareTo);
    public static final TicketType<Long> POI_LOAD = TicketType.create("poi_load", Long::compareTo);
    public static final TicketType<Unit> UNLOAD_COOLDOWN = TicketType.create("unload_cooldown", (u1, u2) -> 0, 100);
    public static final TicketType<Long> NON_FULL_SYNC_LOAD = TicketType.create("non_full_sync_load", Long::compareTo);
    public static final TicketType<ChunkPos> DELAY_UNLOAD = TicketType.create("delay_unload", Comparator.comparingLong(ChunkPos::toLong), 1);

    public static <T> TicketType<T> create(String name, Comparator<T> argumentComparator) {
        return new TicketType<T>(name, argumentComparator, 0L);
    }

    public static <T> TicketType<T> create(String name, Comparator<T> argumentComparator, int expiryTicks) {
        return new TicketType<T>(name, argumentComparator, expiryTicks);
    }

    protected TicketType(String name, Comparator<T> argumentComparator, long expiryTicks) {
        this.name = name;
        this.comparator = argumentComparator;
        this.timeout = expiryTicks;
    }

    public String toString() {
        return this.name;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public long timeout() {
        return this.timeout;
    }
}

