/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.VisibleForDebug;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.Waitable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;

public abstract class ServerCommonPacketListenerImpl
implements ServerCommonPacketListener,
CraftPlayer.TransferCookieConnection {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int LATENCY_CHECK_INTERVAL = 15000;
    private static final int CLOSED_LISTENER_TIMEOUT = 15000;
    private static final net.minecraft.network.chat.Component TIMEOUT_DISCONNECTION_MESSAGE = net.minecraft.network.chat.Component.translatable("disconnect.timeout");
    static final net.minecraft.network.chat.Component DISCONNECT_UNEXPECTED_QUERY = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.unexpected_query_response");
    protected final MinecraftServer server;
    public final Connection connection;
    private final boolean transferred;
    private long keepAliveTime = Util.getMillis();
    private boolean keepAlivePending;
    private long keepAliveChallenge;
    private long closedListenerTime;
    private boolean closed = false;
    private LongList keepAlives = new LongArrayList();
    private int latency;
    private volatile boolean suspendFlushingOnServerThread = false;
    public final Map<UUID, ResourcePackCallback> packCallbacks = new ConcurrentHashMap<UUID, ResourcePackCallback>();
    private static final long KEEPALIVE_LIMIT = Long.getLong("paper.playerconnection.keepalive", 30L) * 1000L;
    protected static final ResourceLocation MINECRAFT_BRAND = new ResourceLocation("brand");
    protected static final ResourceLocation PURPUR_CLIENT = new ResourceLocation("purpur", "client");
    protected final ServerPlayer player;
    protected final CraftServer cserver;
    public boolean processedDisconnect;
    private static final ResourceLocation CUSTOM_REGISTER = new ResourceLocation("register");
    private static final ResourceLocation CUSTOM_UNREGISTER = new ResourceLocation("unregister");

    @Override
    public boolean isTransferred() {
        return this.transferred;
    }

    @Override
    public ConnectionProtocol getProtocol() {
        return this.protocol();
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        this.send(packet);
    }

    public ServerCommonPacketListenerImpl(MinecraftServer minecraftserver, Connection networkmanager, CommonListenerCookie commonlistenercookie, ServerPlayer player) {
        this.server = minecraftserver;
        this.connection = networkmanager;
        this.keepAliveTime = Util.getMillis();
        this.latency = commonlistenercookie.latency();
        this.transferred = commonlistenercookie.transferred();
        this.player = player;
        this.player.transferCookieConnection = this;
        this.cserver = minecraftserver.server;
    }

    public CraftPlayer getCraftPlayer() {
        return this.player == null ? null : this.player.getBukkitEntity();
    }

    private void close() {
        if (!this.closed) {
            this.closedListenerTime = Util.getMillis();
            this.closed = true;
        }
    }

    @Override
    public void onDisconnect(net.minecraft.network.chat.Component reason) {
        this.onDisconnect(reason, null);
    }

    public void onDisconnect(net.minecraft.network.chat.Component reason, @Nullable Component quitMessage) {
        if (this.isSingleplayerOwner()) {
            LOGGER.info("Stopping singleplayer server as player logged out");
            this.server.halt(false);
        }
    }

    @Override
    public void handleKeepAlive(ServerboundKeepAlivePacket packet) {
        if (PurpurConfig.useAlternateKeepAlive) {
            if (this.keepAlivePending && !this.keepAlives.isEmpty() && this.keepAlives.contains(packet.getId())) {
                int ping = (int)(Util.getMillis() - packet.getId());
                this.latency = (this.latency * 3 + ping) / 4;
                this.keepAlivePending = false;
                this.keepAlives.clear();
            }
        } else if (this.keepAlivePending && packet.getId() == this.keepAliveChallenge) {
            int i = (int)(Util.getMillis() - this.keepAliveTime);
            this.latency = (this.latency * 3 + i) / 4;
            this.keepAlivePending = false;
        } else if (!this.isSingleplayerOwner()) {
            this.server.submit(() -> this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE, PlayerKickEvent.Cause.TIMEOUT));
        }
    }

    @Override
    public void handlePong(ServerboundPongPacket packet) {
    }

    @Override
    public void handleCustomPayload(ServerboundCustomPayloadPacket packet) {
        CustomPacketPayload customPacketPayload = packet.payload();
        if (customPacketPayload instanceof BrandPayload) {
            BrandPayload brandPayload = (BrandPayload)customPacketPayload;
            this.player.clientBrandName = brandPayload.brand();
        }
        if (!(packet.payload() instanceof DiscardedPayload)) {
            return;
        }
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        ResourceLocation identifier = packet.payload().type().id();
        ByteBuf payload = ((DiscardedPayload)packet.payload()).data();
        if (identifier.equals(CUSTOM_REGISTER)) {
            try {
                String channels = payload.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().addChannel(channel);
                }
            }
            catch (Exception ex) {
                ServerGamePacketListenerImpl.LOGGER.error("Couldn't register custom payload", (Throwable)ex);
                this.disconnect("Invalid payload REGISTER!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        } else if (identifier.equals(PURPUR_CLIENT)) {
            try {
                this.player.purpurClient = true;
            }
            catch (Exception ex) {}
        } else if (identifier.equals(CUSTOM_UNREGISTER)) {
            try {
                String channels = payload.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().removeChannel(channel);
                }
            }
            catch (Exception ex) {
                ServerGamePacketListenerImpl.LOGGER.error("Couldn't unregister custom payload", (Throwable)ex);
                this.disconnect("Invalid payload UNREGISTER!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        } else {
            try {
                byte[] data = new byte[payload.readableBytes()];
                payload.readBytes(data);
                if (identifier.equals(MINECRAFT_BRAND)) {
                    try {
                        this.player.clientBrandName = new FriendlyByteBuf(Unpooled.copiedBuffer((byte[])data)).readUtf(256);
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        this.player.clientBrandName = "illegal";
                    }
                }
                this.cserver.getMessenger().dispatchIncomingMessage((Player)this.player.getBukkitEntity(), identifier.toString(), data);
            }
            catch (Exception ex) {
                ServerGamePacketListenerImpl.LOGGER.error("Couldn't dispatch custom payload", (Throwable)ex);
                this.disconnect("Invalid custom payload!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        }
    }

    public final boolean isDisconnected() {
        return !this.player.joining && !this.connection.isConnected() || this.processedDisconnect;
    }

    @Override
    public void handleResourcePackResponse(ServerboundResourcePackPacket packet) {
        PlayerResourcePackStatusEvent.Status packStatus;
        ResourcePackCallback callback;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.server);
        if (packet.action() == ServerboundResourcePackPacket.Action.DECLINED && this.server.isResourcePackRequired()) {
            LOGGER.info("Disconnecting {} due to resource pack {} rejection", (Object)this.playerProfile().getName(), (Object)packet.id());
            this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.requiredTexturePrompt.disconnect"), PlayerKickEvent.Cause.RESOURCE_PACK_REJECTION);
        }
        if ((callback = packet.action().isTerminal() ? this.packCallbacks.remove(packet.id()) : this.packCallbacks.get(packet.id())) != null) {
            callback.packEventReceived(packet.id(), ResourcePackStatus.valueOf((String)packet.action().name()), (Audience)this.getCraftPlayer());
        }
        this.player.getBukkitEntity().resourcePackStatus = packStatus = PlayerResourcePackStatusEvent.Status.values()[packet.action().ordinal()];
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getCraftPlayer(), packet.id(), packStatus));
    }

    @Override
    public void handleCookieResponse(ServerboundCookieResponsePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.server);
        if (this.player.getBukkitEntity().handleCookieResponse(packet)) {
            return;
        }
        this.disconnect(DISCONNECT_UNEXPECTED_QUERY, PlayerKickEvent.Cause.INVALID_COOKIE);
    }

    protected void keepConnectionAlive() {
        long currentTime = Util.getMillis();
        long elapsedTime = currentTime - this.keepAliveTime;
        if (PurpurConfig.useAlternateKeepAlive) {
            if (elapsedTime >= 1000L) {
                if (this.keepAlivePending && !this.processedDisconnect && (long)this.keepAlives.size() * 1000L >= KEEPALIVE_LIMIT) {
                    this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE, PlayerKickEvent.Cause.TIMEOUT);
                } else if (this.checkIfClosed(currentTime)) {
                    this.keepAlivePending = true;
                    this.keepAliveTime = currentTime;
                    this.keepAlives.add(currentTime);
                    this.send(new ClientboundKeepAlivePacket(currentTime));
                }
            }
        } else if (!this.isSingleplayerOwner() && elapsedTime >= 15000L) {
            if (this.keepAlivePending && !this.processedDisconnect && elapsedTime >= KEEPALIVE_LIMIT) {
                this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE, PlayerKickEvent.Cause.TIMEOUT);
            } else if (this.checkIfClosed(currentTime)) {
                this.keepAlivePending = true;
                this.keepAliveTime = currentTime;
                this.keepAliveChallenge = currentTime;
                this.send(new ClientboundKeepAlivePacket(this.keepAliveChallenge));
            }
        }
    }

    private boolean checkIfClosed(long time) {
        if (this.closed) {
            if (time - this.closedListenerTime >= 15000L) {
                this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE, PlayerKickEvent.Cause.TIMEOUT);
            }
            return false;
        }
        return true;
    }

    public void suspendFlushing() {
        this.suspendFlushingOnServerThread = true;
    }

    public void resumeFlushing() {
        this.suspendFlushingOnServerThread = false;
        this.connection.flushChannel();
    }

    public void send(Packet<?> packet) {
        this.send(packet, null);
    }

    public void send(Packet<?> packet, @Nullable PacketSendListener callbacks) {
        if (packet == null || this.processedDisconnect) {
            return;
        }
        if (packet instanceof ClientboundSetDefaultSpawnPositionPacket) {
            ClientboundSetDefaultSpawnPositionPacket packet6 = (ClientboundSetDefaultSpawnPositionPacket)packet;
            this.player.compassTarget = CraftLocation.toBukkit(packet6.pos, this.getCraftPlayer().getWorld());
        }
        if (packet.isTerminal()) {
            this.close();
        }
        boolean flag = !this.suspendFlushingOnServerThread || !this.server.isSameThread();
        try {
            this.connection.send(packet, callbacks, flag);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Sending packet");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Packet being sent");
            crashreportsystemdetails.setDetail("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashreport);
        }
    }

    @Deprecated
    @DoNotUse
    public void disconnect(String s) {
        this.disconnect((Component)LegacyComponentSerializer.legacySection().deserialize(s), PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(String s, PlayerKickEvent.Cause cause) {
        this.disconnect((Component)LegacyComponentSerializer.legacySection().deserialize(s), cause);
    }

    @Deprecated
    @DoNotUse
    public void disconnect(net.minecraft.network.chat.Component reason) {
        this.disconnect(PaperAdventure.asAdventure(reason), PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(net.minecraft.network.chat.Component reason, PlayerKickEvent.Cause cause) {
        this.disconnect(PaperAdventure.asAdventure(reason), cause);
    }

    public void disconnect(final Component reason, final PlayerKickEvent.Cause cause) {
        if (this.processedDisconnect) {
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable waitable = new Waitable(){

                protected Object evaluate() {
                    ServerCommonPacketListenerImpl.this.disconnect(reason, cause);
                    return null;
                }
            };
            this.server.processQueue.add(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        TranslatableComponent leaveMessage = Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? this.player.getBukkitEntity().displayName() : Component.text((String)this.player.getScoreboardName())});
        PlayerKickEvent event = new PlayerKickEvent((Player)this.player.getBukkitEntity(), reason, (Component)leaveMessage, cause);
        if (this.cserver.getServer().isRunning()) {
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return;
        }
        net.minecraft.network.chat.Component ichatbasecomponent = PaperAdventure.asVanilla(event.reason());
        this.player.quitReason = PlayerQuitEvent.QuitReason.KICKED;
        this.connection.send(new ClientboundDisconnectPacket(ichatbasecomponent), PacketSendListener.thenRun(() -> this.connection.disconnect(ichatbasecomponent)));
        this.onDisconnect(ichatbasecomponent, event.leaveMessage());
        this.connection.setReadOnly();
        MinecraftServer minecraftserver = this.server;
        Connection networkmanager = this.connection;
        Objects.requireNonNull(this.connection);
        minecraftserver.scheduleOnMain(networkmanager::handleDisconnection);
    }

    protected boolean isSingleplayerOwner() {
        return this.server.isSingleplayerOwner(this.playerProfile());
    }

    protected abstract GameProfile playerProfile();

    @VisibleForDebug
    public GameProfile getOwner() {
        return this.playerProfile();
    }

    public int latency() {
        return this.latency;
    }

    protected CommonListenerCookie createCookie(ClientInformation syncedOptions) {
        return new CommonListenerCookie(this.playerProfile(), this.latency, syncedOptions, this.transferred);
    }
}

