/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendSuggestionsEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.ChatProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.brigadier.TagParseCommandSyntaxException;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.event.player.CartographyItemEvent;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import io.papermc.paper.event.player.PlayerPickItemEvent;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.translation.Translator;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundBlockEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSampleSubscriptionPacket;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.network.protocol.game.ServerboundEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket;
import net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.network.protocol.game.ServerboundSetBeaconPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandMinecartPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSetJigsawBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.network.TextFilter;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.util.FutureChain;
import net.minecraft.util.Mth;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.LazyPlayerSet;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.player.PlayerBookTooLargeEvent;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public class ServerGamePacketListenerImpl
extends ServerCommonPacketListenerImpl
implements ServerGamePacketListener,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_BLOCK_UPDATES_TO_ACK = -1;
    private static final int TRACKED_MESSAGE_DISCONNECT_THRESHOLD = 4096;
    private static final int MAXIMUM_FLYING_TICKS = 80;
    private static final net.minecraft.network.chat.Component CHAT_VALIDATION_FAILED = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.chat_validation_failed");
    private static final net.minecraft.network.chat.Component INVALID_COMMAND_SIGNATURE = net.minecraft.network.chat.Component.translatable("chat.disabled.invalid_command_signature").withStyle(ChatFormatting.RED);
    private static final int MAX_COMMAND_SUGGESTIONS = 1000;
    public ServerPlayer player;
    public final PlayerChunkSender chunkSender;
    private int tickCount;
    private int ackBlockChangesUpTo = -1;
    private final AtomicInteger chatSpamTickCount = new AtomicInteger();
    private final AtomicInteger tabSpamLimiter = new AtomicInteger();
    private final AtomicInteger recipeSpamPackets = new AtomicInteger();
    private int dropSpamTickCount;
    private double firstGoodX;
    private double firstGoodY;
    private double firstGoodZ;
    private double lastGoodX;
    private double lastGoodY;
    private double lastGoodZ;
    @Nullable
    private net.minecraft.world.entity.Entity lastVehicle;
    private double vehicleFirstGoodX;
    private double vehicleFirstGoodY;
    private double vehicleFirstGoodZ;
    private double vehicleLastGoodX;
    private double vehicleLastGoodY;
    private double vehicleLastGoodZ;
    @Nullable
    private Vec3 awaitingPositionFromClient;
    private int awaitingTeleport;
    private int awaitingTeleportTime;
    private boolean clientIsFloating;
    private int aboveGroundTickCount;
    private boolean clientVehicleIsFloating;
    private int aboveGroundVehicleTickCount;
    private int receivedMovePacketCount;
    private int knownMovePacketCount;
    @Nullable
    private RemoteChatSession chatSession;
    private boolean hasLoggedExpiry = false;
    private SignedMessageChain.Decoder signedMessageDecoder;
    private final LastSeenMessagesValidator lastSeenMessages = new LastSeenMessagesValidator(20);
    private final MessageSignatureCache messageSignatureCache = MessageSignatureCache.createDefault();
    private final FutureChain chatMessageChain;
    private boolean waitingForSwitchToConfig;
    private static final int MAX_SIGN_LINE_LENGTH = Integer.getInteger("Paper.maxSignLength", 80);
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private boolean hasMoved = false;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private final LoadingCache<CraftPlayer, Boolean> kickPermissionCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<CraftPlayer, Boolean>(this){

        public Boolean load(CraftPlayer player) {
            return player.hasPermission("purpur.bypassIdleKick");
        }
    });
    private static final ExecutorService TAB_COMPLETE_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Tab Complete Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(MinecraftServer.LOGGER)).build());
    private int limitedPackets;
    private long lastLimitedPacket = -1L;

    public ServerGamePacketListenerImpl(MinecraftServer server, Connection connection, ServerPlayer player, CommonListenerCookie clientData) {
        super(server, connection, clientData, player);
        this.chunkSender = new PlayerChunkSender(connection.isMemoryConnection());
        this.player = player;
        player.connection = this;
        player.getTextFilter().join();
        UUID uuid = player.getUUID();
        Objects.requireNonNull(server);
        this.signedMessageDecoder = SignedMessageChain.Decoder.unsigned(uuid, server::enforceSecureProfile);
        this.chatMessageChain = new FutureChain(server.chatExecutor);
    }

    @Override
    public void tick() {
        int spam;
        if (this.ackBlockChangesUpTo > -1) {
            this.send(new ClientboundBlockChangedAckPacket(this.ackBlockChangesUpTo));
            this.ackBlockChangesUpTo = -1;
        }
        this.resetPosition();
        this.player.xo = this.player.getX();
        this.player.yo = this.player.getY();
        this.player.zo = this.player.getZ();
        this.player.doTick();
        this.player.absMoveTo(this.firstGoodX, this.firstGoodY, this.firstGoodZ, this.player.getYRot(), this.player.getXRot());
        ++this.tickCount;
        this.knownMovePacketCount = this.receivedMovePacketCount;
        if (this.clientIsFloating && !this.player.isSleeping() && !this.player.isPassenger() && !this.player.isDeadOrDying()) {
            if (++this.aboveGroundTickCount > this.getMaximumFlyingTicks(this.player)) {
                LOGGER.warn("{} was kicked for floating too long!", (Object)this.player.getName().getString());
                this.disconnect(GlobalConfiguration.get().messages.kick.flyingPlayer, PlayerKickEvent.Cause.FLYING_PLAYER);
                return;
            }
        } else {
            this.clientIsFloating = false;
            this.aboveGroundTickCount = 0;
        }
        this.lastVehicle = this.player.getRootVehicle();
        if (this.lastVehicle != this.player && this.lastVehicle.getControllingPassenger() == this.player) {
            this.vehicleFirstGoodX = this.lastVehicle.getX();
            this.vehicleFirstGoodY = this.lastVehicle.getY();
            this.vehicleFirstGoodZ = this.lastVehicle.getZ();
            this.vehicleLastGoodX = this.lastVehicle.getX();
            this.vehicleLastGoodY = this.lastVehicle.getY();
            this.vehicleLastGoodZ = this.lastVehicle.getZ();
            if (this.clientVehicleIsFloating && this.lastVehicle.getControllingPassenger() == this.player) {
                if (++this.aboveGroundVehicleTickCount > this.getMaximumFlyingTicks(this.lastVehicle)) {
                    LOGGER.warn("{} was kicked for floating a vehicle too long!", (Object)this.player.getName().getString());
                    this.disconnect(GlobalConfiguration.get().messages.kick.flyingVehicle, PlayerKickEvent.Cause.FLYING_VEHICLE);
                    return;
                }
            } else {
                this.clientVehicleIsFloating = false;
                this.aboveGroundVehicleTickCount = 0;
            }
        } else {
            this.lastVehicle = null;
            this.clientVehicleIsFloating = false;
            this.aboveGroundVehicleTickCount = 0;
        }
        this.keepConnectionAlive();
        while ((spam = this.chatSpamTickCount.get()) > 0 && !this.chatSpamTickCount.compareAndSet(spam, spam - 1)) {
        }
        if (this.tabSpamLimiter.get() > 0) {
            this.tabSpamLimiter.getAndDecrement();
        }
        if (this.recipeSpamPackets.get() > 0) {
            this.recipeSpamPackets.getAndDecrement();
        }
        if (this.dropSpamTickCount > 0) {
            --this.dropSpamTickCount;
        }
        if (this.player.getLastActionTime() > 0L && this.server.getPlayerIdleTimeout() > 0 && Util.getMillis() - this.player.getLastActionTime() > (long)this.server.getPlayerIdleTimeout() * 1000L * 60L && !this.player.wonGame) {
            this.player.setAfk(true);
            if (!this.player.level().purpurConfig.idleTimeoutKick || !Boolean.parseBoolean(System.getenv("PURPUR_FORCE_IDLE_KICK")) && ((Boolean)this.kickPermissionCache.getUnchecked((Object)this.player.getBukkitEntity())).booleanValue()) {
                return;
            }
            this.player.resetLastActionTime();
            this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.idling"), PlayerKickEvent.Cause.IDLING);
        }
        if (!this.hasLoggedExpiry && this.chatSession != null && this.chatSession.profilePublicKey().data().hasExpired()) {
            LOGGER.info("Player profile key for {} has expired!", (Object)this.player.getName().getString());
            this.hasLoggedExpiry = true;
        }
    }

    private int getMaximumFlyingTicks(net.minecraft.world.entity.Entity vehicle) {
        double d0 = vehicle.getGravity();
        if (d0 < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double d1 = 0.08 / d0;
        return Mth.ceil(80.0 * Math.max(d1, 1.0));
    }

    public void resetPosition() {
        this.firstGoodX = this.player.getX();
        this.firstGoodY = this.player.getY();
        this.firstGoodZ = this.player.getZ();
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected() && !this.waitingForSwitchToConfig;
    }

    @Override
    public boolean shouldHandleMessage(Packet<?> packet) {
        return super.shouldHandleMessage(packet) ? true : this.waitingForSwitchToConfig && this.connection.isConnected() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile playerProfile() {
        return this.player.getGameProfile();
    }

    private <T, R> CompletableFuture<R> filterTextPacket(T text, BiFunction<TextFilter, T, CompletableFuture<R>> filterer) {
        return filterer.apply(this.player.getTextFilter(), (TextFilter)text).thenApply(object -> {
            if (!this.isAcceptingMessages()) {
                LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<FilteredText> filterTextPacket(String text) {
        return this.filterTextPacket(text, TextFilter::processStreamMessage);
    }

    private CompletableFuture<List<FilteredText>> filterTextPacket(List<String> texts) {
        return this.filterTextPacket(texts, TextFilter::processMessageBundle);
    }

    @Override
    public void handlePlayerInput(ServerboundPlayerInputPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        this.player.setPlayerInput(packet.getXxa(), packet.getZza(), packet.isJumping(), packet.isShiftKeyDown());
    }

    private static boolean containsInvalidValues(double x, double y, double z, float yaw, float pitch) {
        return Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z) || !Floats.isFinite((float)pitch) || !Floats.isFinite((float)yaw);
    }

    private static double clampHorizontal(double d) {
        return Mth.clamp(d, -3.0E7, 3.0E7);
    }

    private static double clampVertical(double d) {
        return Mth.clamp(d, -2.0E7, 2.0E7);
    }

    @Override
    public void handleMoveVehicle(ServerboundMoveVehiclePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (ServerGamePacketListenerImpl.containsInvalidValues(packet.getX(), packet.getY(), packet.getZ(), packet.getYRot(), packet.getXRot())) {
            this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.invalid_vehicle_movement"), PlayerKickEvent.Cause.INVALID_VEHICLE_MOVEMENT);
        } else {
            net.minecraft.world.entity.Entity entity = this.player.getRootVehicle();
            if (this.awaitingPositionFromClient != null || this.player.isImmobile() || entity.isRemoved()) {
                return;
            }
            if (entity != this.player && entity.getControllingPassenger() == this.player && entity == this.lastVehicle) {
                LivingEntity entityliving;
                double d5;
                double d4;
                double d3;
                double d2;
                double d1;
                double d0;
                ServerLevel worldserver = this.player.serverLevel();
                double prevX = this.player.getX();
                double prevY = this.player.getY();
                double prevZ = this.player.getZ();
                float prevYaw = this.player.getYRot();
                float prevPitch = this.player.getXRot();
                double fromX = d0 = entity.getX();
                double fromY = d1 = entity.getY();
                double fromZ = d2 = entity.getZ();
                double toX = d3 = ServerGamePacketListenerImpl.clampHorizontal(packet.getX());
                double toY = d4 = ServerGamePacketListenerImpl.clampVertical(packet.getY());
                double toZ = d5 = ServerGamePacketListenerImpl.clampHorizontal(packet.getZ());
                float f = Mth.wrapDegrees(packet.getYRot());
                float f1 = Mth.wrapDegrees(packet.getXRot());
                double d6 = d3 - this.vehicleFirstGoodX;
                double d7 = d4 - this.vehicleFirstGoodY;
                double d8 = d5 - this.vehicleFirstGoodZ;
                double d9 = entity.getDeltaMovement().lengthSqr();
                double currDeltaX = toX - fromX;
                double currDeltaY = toY - fromY;
                double currDeltaZ = toZ - fromZ;
                double d10 = Math.max(d6 * d6 + d7 * d7 + d8 * d8, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                double otherFieldX = d3 - this.vehicleLastGoodX;
                double otherFieldY = d4 - this.vehicleLastGoodY - 1.0E-6;
                double otherFieldZ = d5 - this.vehicleLastGoodZ;
                d10 = Math.max(d10, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.receivedMovePacketCount;
                int i = this.receivedMovePacketCount - this.knownMovePacketCount;
                if (i > Math.max(this.allowedPlayerTicks, 5)) {
                    LOGGER.debug(this.player.getScoreboardName() + " is sending move packets too frequently (" + i + " packets since last tick)");
                    i = 1;
                }
                this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.player.getAbilities().flying ? (double)(this.player.getAbilities().flyingSpeed * 20.0f) : (double)(this.player.getAbilities().walkingSpeed * 10.0f);
                speed *= 2.0;
                if (!(!this.player.level().paperConfig().chunks.preventMovingIntoUnloadedChunks || worldserver.areChunksLoadedForMove(this.player.getBoundingBox().expandTowards(new Vec3(toX, toY, toZ).subtract(this.player.position()))) && worldserver.areChunksLoadedForMove(entity.getBoundingBox().expandTowards(new Vec3(toX, toY, toZ).subtract(entity.position()))))) {
                    this.connection.send(new ClientboundMoveVehiclePacket(entity));
                    return;
                }
                if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i * speed, 2.0)) && !this.isSingleplayerOwner()) {
                    LOGGER.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.getName().getString(), this.player.getName().getString(), d6, d7, d8});
                    this.send(new ClientboundMoveVehiclePacket(entity));
                    return;
                }
                AABB oldBox = entity.getBoundingBox();
                d6 = d3 - this.vehicleLastGoodX;
                d7 = d4 - this.vehicleLastGoodY - 1.0E-6;
                d8 = d5 - this.vehicleLastGoodZ;
                boolean flag1 = entity.verticalCollisionBelow;
                if (entity instanceof LivingEntity && (entityliving = (LivingEntity)entity).onClimbable()) {
                    entityliving.resetFallDistance();
                }
                entity.move(MoverType.PLAYER, new Vec3(d6, d7, d8));
                boolean didCollide = toX != entity.getX() || toY != entity.getY() || toZ != entity.getZ();
                double d11 = d7;
                d6 = d3 - entity.getX();
                d7 = d4 - entity.getY();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.getZ();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag2 = false;
                if (d10 > SpigotConfig.movedWronglyThreshold) {
                    flag2 = true;
                    LOGGER.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.getName().getString(), this.player.getName().getString(), Math.sqrt(d10)});
                }
                entity.absMoveTo(d3, d4, d5, f, f1);
                this.player.absMoveTo(d3, d4, d5, this.player.getYRot(), this.player.getXRot());
                boolean teleportBack = flag2;
                if (!teleportBack) {
                    AABB newBox = entity.getBoundingBox();
                    if (didCollide || !oldBox.equals(newBox)) {
                        teleportBack = this.hasNewCollision(worldserver, entity, oldBox, newBox);
                    }
                }
                if (teleportBack) {
                    entity.absMoveTo(d0, d1, d2, f, f1);
                    this.player.absMoveTo(d0, d1, d2, this.player.getYRot(), this.player.getXRot());
                    this.send(new ClientboundMoveVehiclePacket(entity));
                    return;
                }
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = prevX;
                    this.lastPosY = prevY;
                    this.lastPosZ = prevZ;
                    this.lastYaw = prevYaw;
                    this.lastPitch = prevPitch;
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = player.getLocation().clone();
                to.setX(packet.getX());
                to.setY(packet.getY());
                to.setZ(packet.getZ());
                to.setYaw(packet.getYRot());
                to.setPitch(packet.getXRot());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.player.isImmobile()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    if (!to.getWorld().getUID().equals(from.getWorld().getUID()) || to.getBlockX() != from.getBlockX() || to.getBlockY() != from.getBlockY() || to.getBlockZ() != from.getBlockZ() || to.getYaw() != from.getYaw() || to.getPitch() != from.getPitch()) {
                        this.player.resetLastActionTime();
                    }
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((org.bukkit.entity.Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.teleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.player.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.player.serverLevel().getChunkSource().move(this.player);
                this.player.checkMovementStatistics(this.player.getX() - d0, this.player.getY() - d1, this.player.getZ() - d2);
                this.clientVehicleIsFloating = d11 >= -0.03125 && !flag1 && !this.server.isFlightAllowed() && !entity.isNoGravity() && this.noBlocksAround(entity);
                this.vehicleLastGoodX = entity.getX();
                this.vehicleLastGoodY = entity.getY();
                this.vehicleLastGoodZ = entity.getZ();
            }
        }
    }

    private boolean noBlocksAround(net.minecraft.world.entity.Entity entity) {
        AABB box = entity.getBoundingBox().inflate(0.0625).expandTowards(0.0, -0.55, 0.0);
        int minX = Mth.floor(box.minX);
        int minY = Mth.floor(box.minY);
        int minZ = Mth.floor(box.minZ);
        int maxX = Mth.floor(box.maxX);
        int maxY = Mth.floor(box.maxY);
        int maxZ = Mth.floor(box.maxZ);
        Level world = entity.level();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    pos.set(x, y, z);
                    BlockState type = world.getBlockStateIfLoaded(pos);
                    if (type == null || type.isAir()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void handleAcceptTeleportPacket(ServerboundAcceptTeleportationPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (packet.getId() == this.awaitingTeleport) {
            if (this.awaitingPositionFromClient == null) {
                this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
                LOGGER.warn("Disconnected on accept teleport packet. Was not expecting position data from client at this time");
                return;
            }
            this.player.moveTo(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            this.lastGoodX = this.awaitingPositionFromClient.x;
            this.lastGoodY = this.awaitingPositionFromClient.y;
            this.lastGoodZ = this.awaitingPositionFromClient.z;
            if (this.player.isChangingDimension()) {
                this.player.hasChangedDimension();
            }
            this.awaitingPositionFromClient = null;
            this.player.serverLevel().getChunkSource().move(this.player);
        }
    }

    @Override
    public void handleRecipeBookSeenRecipePacket(ServerboundRecipeBookSeenRecipePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        Optional<RecipeHolder<?>> optional = this.server.getRecipeManager().byKey(packet.getRecipe());
        ServerRecipeBook recipebookserver = this.player.getRecipeBook();
        Objects.requireNonNull(recipebookserver);
        optional.ifPresent(recipebookserver::removeHighlight);
    }

    @Override
    public void handleRecipeBookChangeSettingsPacket(ServerboundRecipeBookChangeSettingsPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        CraftEventFactory.callRecipeBookSettingsEvent(this.player, packet.getBookType(), packet.isOpen(), packet.isFiltering());
        this.player.getRecipeBook().setBookSetting(packet.getBookType(), packet.isOpen(), packet.isFiltering());
    }

    @Override
    public void handleSeenAdvancements(ServerboundSeenAdvancementsPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (packet.getAction() == ServerboundSeenAdvancementsPacket.Action.OPENED_TAB) {
            ResourceLocation minecraftkey = Objects.requireNonNull(packet.getTab());
            AdvancementHolder advancementholder = this.server.getAdvancements().get(minecraftkey);
            if (advancementholder != null) {
                this.player.getAdvancements().setSelectedTab(advancementholder);
            }
        }
    }

    @Override
    public void handleCustomCommandSuggestions(ServerboundCommandSuggestionPacket packet) {
        int index;
        if (this.chatSpamTickCount.addAndGet(GlobalConfiguration.get().spamLimiter.tabSpamIncrement) > GlobalConfiguration.get().spamLimiter.tabSpamLimit && !this.server.getPlayerList().isOp(this.player.getGameProfile())) {
            this.disconnect(net.minecraft.network.chat.Component.translatable("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        if (packet.getCommand().length() > 64 && ((index = packet.getCommand().indexOf(32)) == -1 || index >= 64)) {
            this.disconnect(net.minecraft.network.chat.Component.translatable("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        TAB_COMPLETE_EXECUTOR.execute(() -> this.handleCustomCommandSuggestions0(packet));
    }

    private void handleCustomCommandSuggestions0(ServerboundCommandSuggestionPacket packet) {
        Object completions;
        StringReader stringreader = new StringReader(packet.getCommand());
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        AsyncTabCompleteEvent event = new AsyncTabCompleteEvent((CommandSender)this.getCraftPlayer(), packet.getCommand(), true, null);
        event.callEvent();
        Object object = completions = event.isCancelled() ? ImmutableList.of() : event.completions();
        if (!event.isHandled()) {
            if (event.isCancelled()) {
                return;
            }
            this.server.scheduleOnMain(() -> this.sendServerSuggestions(packet, stringreader));
        } else if (!completions.isEmpty()) {
            SuggestionsBuilder builder0 = new SuggestionsBuilder(packet.getCommand(), stringreader.getTotalLength());
            SuggestionsBuilder builder = builder0.createOffset(builder0.getInput().lastIndexOf(32) + 1);
            Iterator iterator = completions.iterator();
            while (iterator.hasNext()) {
                AsyncTabCompleteEvent.Completion completion = (AsyncTabCompleteEvent.Completion)iterator.next();
                Integer intSuggestion = Ints.tryParse((String)completion.suggestion());
                if (intSuggestion != null) {
                    builder.suggest(intSuggestion.intValue(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                    continue;
                }
                builder.suggest(completion.suggestion(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
            }
            Suggestions suggestions = (Suggestions)builder.buildFuture().join();
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((org.bukkit.entity.Player)this.getCraftPlayer(), suggestions, packet.getCommand());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.connection.send(new ClientboundCommandSuggestionsPacket(packet.getId(), ServerGamePacketListenerImpl.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        }
    }

    private static Suggestions limitTo(Suggestions suggestions, int size) {
        return suggestions.getList().size() <= size ? suggestions : new Suggestions(suggestions.getRange(), suggestions.getList().subList(0, size));
    }

    private void sendServerSuggestions(ServerboundCommandSuggestionPacket packet, StringReader stringreader) {
        ParseResults<CommandSourceStack> parseresults = this.server.getCommands().getDispatcher().parse(stringreader, this.player.createCommandSourceStack());
        if (!parseresults.getExceptions().isEmpty() && parseresults.getExceptions().values().stream().anyMatch(e -> e instanceof TagParseCommandSyntaxException)) {
            this.disconnect(net.minecraft.network.chat.Component.translatable("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
            return;
        }
        this.server.getCommands().getDispatcher().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
            if (!SpigotConfig.sendNamespaced && suggestions.getRange().getStart() <= 1) {
                suggestions.getList().removeIf(suggestion -> suggestion.getText().contains(":"));
            }
            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((org.bukkit.entity.Player)this.getCraftPlayer(), suggestions, packet.getCommand());
            suggestEvent.setCancelled(suggestions.isEmpty());
            if (suggestEvent.callEvent()) {
                this.send(new ClientboundCommandSuggestionsPacket(packet.getId(), ServerGamePacketListenerImpl.limitTo(suggestEvent.getSuggestions(), 1000)));
            }
        });
    }

    @Override
    public void handleSetCommandBlock(ServerboundSetCommandBlockPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.notEnabled"));
        } else if (!(this.player.canUseGameMasterBlocks() || this.player.isCreative() && this.player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.notAllowed"));
        } else {
            BaseCommandBlock commandblocklistenerabstract = null;
            CommandBlockEntity tileentitycommand = null;
            BlockPos blockposition = packet.getPos();
            BlockEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof CommandBlockEntity) {
                tileentitycommand = (CommandBlockEntity)tileentity;
                commandblocklistenerabstract = tileentitycommand.getCommandBlock();
            }
            String s = packet.getCommand();
            boolean flag = packet.isTrackOutput();
            if (commandblocklistenerabstract != null) {
                CommandBlockEntity.Mode tileentitycommand_type = tileentitycommand.getMode();
                BlockState iblockdata = this.player.level().getBlockState(blockposition);
                Direction enumdirection = iblockdata.getValue(CommandBlock.FACING);
                BlockState iblockdata2 = switch (packet.getMode()) {
                    case CommandBlockEntity.Mode.SEQUENCE -> Blocks.CHAIN_COMMAND_BLOCK.defaultBlockState();
                    case CommandBlockEntity.Mode.AUTO -> Blocks.REPEATING_COMMAND_BLOCK.defaultBlockState();
                    default -> Blocks.COMMAND_BLOCK.defaultBlockState();
                };
                BlockState iblockdata3 = (BlockState)((BlockState)iblockdata2.setValue(CommandBlock.FACING, enumdirection)).setValue(CommandBlock.CONDITIONAL, packet.isConditional());
                if (iblockdata3 != iblockdata) {
                    this.player.level().setBlock(blockposition, iblockdata3, 2);
                    tileentity.setBlockState(iblockdata3);
                    this.player.level().getChunkAt(blockposition).setBlockEntity(tileentity);
                }
                commandblocklistenerabstract.setCommand(s);
                commandblocklistenerabstract.setTrackOutput(flag);
                if (!flag) {
                    commandblocklistenerabstract.setLastOutput(null);
                }
                tileentitycommand.setAutomatic(packet.isAutomatic());
                if (tileentitycommand_type != packet.getMode()) {
                    tileentitycommand.onModeSwitch();
                }
                commandblocklistenerabstract.onUpdated();
                if (!StringUtil.isNullOrEmpty(s)) {
                    this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.setCommand.success", s));
                }
            }
        }
    }

    @Override
    public void handleSetCommandMinecart(ServerboundSetCommandMinecartPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.notEnabled"));
        } else if (!(this.player.canUseGameMasterBlocks() || this.player.isCreative() && this.player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.notAllowed"));
        } else {
            BaseCommandBlock commandblocklistenerabstract = packet.getCommandBlock(this.player.level());
            if (commandblocklistenerabstract != null) {
                commandblocklistenerabstract.setCommand(packet.getCommand());
                commandblocklistenerabstract.setTrackOutput(packet.isTrackOutput());
                if (!packet.isTrackOutput()) {
                    commandblocklistenerabstract.setLastOutput(null);
                }
                commandblocklistenerabstract.onUpdated();
                this.player.sendSystemMessage(net.minecraft.network.chat.Component.translatable("advMode.setCommand.success", packet.getCommand()));
            }
        }
    }

    @Override
    public void handlePickItem(ServerboundPickItemPacket packet) {
        int sourceSlot;
        int targetSlot;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (packet.getSlot() < 0 || packet.getSlot() >= this.player.getInventory().items.size()) {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.player.getName().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        CraftPlayer bukkitPlayer = this.player.getBukkitEntity();
        PlayerPickItemEvent event = new PlayerPickItemEvent((org.bukkit.entity.Player)bukkitPlayer, targetSlot = this.player.getInventory().getSuitableHotbarSlot(), sourceSlot = packet.getSlot());
        if (!event.callEvent()) {
            return;
        }
        this.player.getInventory().pickSlot(event.getSourceSlot(), event.getTargetSlot());
        this.player.connection.send(new ClientboundContainerSetSlotPacket(-2, 0, this.player.getInventory().selected, this.player.getInventory().getItem(this.player.getInventory().selected)));
        this.player.connection.send(new ClientboundContainerSetSlotPacket(-2, 0, packet.getSlot(), this.player.getInventory().getItem(packet.getSlot())));
        this.player.connection.send(new ClientboundSetCarriedItemPacket(this.player.getInventory().selected));
    }

    @Override
    public void handleRenameItem(ServerboundRenameItemPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        AbstractContainerMenu container = this.player.containerMenu;
        if (container instanceof AnvilMenu) {
            AnvilMenu containeranvil = (AnvilMenu)container;
            if (!containeranvil.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)containeranvil);
                return;
            }
            containeranvil.setItemName(packet.getName());
        }
    }

    @Override
    public void handleSetBeaconPacket(ServerboundSetBeaconPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        AbstractContainerMenu container = this.player.containerMenu;
        if (container instanceof BeaconMenu) {
            BeaconMenu containerbeacon = (BeaconMenu)container;
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
                return;
            }
            containerbeacon.updateEffects(packet.primary(), packet.secondary());
        }
    }

    @Override
    public void handleSetStructureBlock(ServerboundSetStructureBlockPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos blockposition = packet.getPos();
            BlockState iblockdata = this.player.level().getBlockState(blockposition);
            BlockEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof StructureBlockEntity) {
                StructureBlockEntity tileentitystructure = (StructureBlockEntity)tileentity;
                tileentitystructure.setMode(packet.getMode());
                tileentitystructure.setStructureName(packet.getName());
                tileentitystructure.setStructurePos(packet.getOffset());
                tileentitystructure.setStructureSize(packet.getSize());
                tileentitystructure.setMirror(packet.getMirror());
                tileentitystructure.setRotation(packet.getRotation());
                tileentitystructure.setMetaData(packet.getData());
                tileentitystructure.setIgnoreEntities(packet.isIgnoreEntities());
                tileentitystructure.setShowAir(packet.isShowAir());
                tileentitystructure.setShowBoundingBox(packet.isShowBoundingBox());
                tileentitystructure.setIntegrity(packet.getIntegrity());
                tileentitystructure.setSeed(packet.getSeed());
                if (tileentitystructure.hasStructureName()) {
                    String s = tileentitystructure.getStructureName();
                    if (packet.getUpdateType() == StructureBlockEntity.UpdateType.SAVE_AREA) {
                        if (tileentitystructure.saveStructure()) {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.save_success", s), false);
                        } else {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.save_failure", s), false);
                        }
                    } else if (packet.getUpdateType() == StructureBlockEntity.UpdateType.LOAD_AREA) {
                        if (!tileentitystructure.isStructureLoadable()) {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.load_not_found", s), false);
                        } else if (tileentitystructure.placeStructureIfSameSize(this.player.serverLevel())) {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.load_success", s), false);
                        } else {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.load_prepare", s), false);
                        }
                    } else if (packet.getUpdateType() == StructureBlockEntity.UpdateType.SCAN_AREA) {
                        if (tileentitystructure.detectSize()) {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.size_success", s), false);
                        } else {
                            this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.player.displayClientMessage(net.minecraft.network.chat.Component.translatable("structure_block.invalid_structure_name", packet.getName()), false);
                }
                tileentitystructure.setChanged();
                this.player.level().sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void handleSetJigsawBlock(ServerboundSetJigsawBlockPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos blockposition = packet.getPos();
            BlockState iblockdata = this.player.level().getBlockState(blockposition);
            BlockEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof JigsawBlockEntity) {
                JigsawBlockEntity tileentityjigsaw = (JigsawBlockEntity)tileentity;
                tileentityjigsaw.setName(packet.getName());
                tileentityjigsaw.setTarget(packet.getTarget());
                tileentityjigsaw.setPool(ResourceKey.create(Registries.TEMPLATE_POOL, packet.getPool()));
                tileentityjigsaw.setFinalState(packet.getFinalState());
                tileentityjigsaw.setJoint(packet.getJoint());
                tileentityjigsaw.setPlacementPriority(packet.getPlacementPriority());
                tileentityjigsaw.setSelectionPriority(packet.getSelectionPriority());
                tileentityjigsaw.setChanged();
                this.player.level().sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void handleJigsawGenerate(ServerboundJigsawGeneratePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos blockposition = packet.getPos();
            BlockEntity tileentity = this.player.level().getBlockEntity(blockposition);
            if (tileentity instanceof JigsawBlockEntity) {
                JigsawBlockEntity tileentityjigsaw = (JigsawBlockEntity)tileentity;
                tileentityjigsaw.generate(this.player.serverLevel(), packet.levels(), packet.keepJigsaws());
            }
        }
    }

    @Override
    public void handleSelectTrade(ServerboundSelectTradePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        int i = packet.getItem();
        AbstractContainerMenu container = this.player.containerMenu;
        if (container instanceof MerchantMenu) {
            MerchantMenu containermerchant = (MerchantMenu)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.player, i, containermerchant);
            if (tradeSelectEvent.isCancelled()) {
                this.player.getBukkitEntity().updateInventory();
                return;
            }
            if (!containermerchant.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)containermerchant);
                return;
            }
            containermerchant.setSelectionHint(i);
            containermerchant.tryMoveItems(i);
        }
    }

    @Override
    public void handleEditBook(ServerboundEditBookPacket packet) {
        if (!this.cserver.isPrimaryThread()) {
            List<String> pageList = packet.pages();
            long byteTotal = 0L;
            int maxBookPageSize = GlobalConfiguration.get().itemValidation.bookSize.pageMax;
            double multiplier = Math.max(0.3, Math.min(1.0, GlobalConfiguration.get().itemValidation.bookSize.totalMultiplier));
            long byteAllowed = maxBookPageSize;
            int slot = packet.slot();
            ItemStack itemstack = net.minecraft.world.entity.player.Inventory.isHotbarSlot(slot) || slot == 40 ? this.player.getInventory().getItem(slot) : ItemStack.EMPTY;
            for (String testString : pageList) {
                int byteLength = testString.getBytes(StandardCharsets.UTF_8).length;
                if (byteLength > 1024) {
                    LOGGER.warn(this.player.getScoreboardName() + " tried to send a book with with a page too large!");
                    PlayerBookTooLargeEvent event = new PlayerBookTooLargeEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), itemstack.asBukkitCopy());
                    if (event.shouldKickPlayer()) {
                        this.server.scheduleOnMain(() -> this.disconnect("Book too large!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
                    }
                    return;
                }
                byteTotal += (long)byteLength;
                int length = testString.length();
                int multibytes = 0;
                if (byteLength != length) {
                    for (char c : testString.toCharArray()) {
                        if (c <= '\u007f') continue;
                        ++multibytes;
                    }
                }
                byteAllowed = (long)((double)byteAllowed + (double)maxBookPageSize * Math.min(1.0, Math.max(0.1, (double)length / 255.0)) * multiplier);
                if (multibytes <= 1) continue;
                byteAllowed -= (long)multibytes;
            }
            if (byteTotal > byteAllowed) {
                LOGGER.warn(this.player.getScoreboardName() + " tried to send too large of a book. Book Size: " + byteTotal + " - Allowed:  " + byteAllowed + " - Pages: " + pageList.size());
                PlayerBookTooLargeEvent event = new PlayerBookTooLargeEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), itemstack.asBukkitCopy());
                if (event.shouldKickPlayer()) {
                    this.server.scheduleOnMain(() -> this.disconnect("Book too large!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
                }
                return;
            }
        }
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.server.scheduleOnMain(() -> this.disconnect("Book edited too quickly!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i = packet.slot();
        if (net.minecraft.world.entity.player.Inventory.isHotbarSlot(i) || i == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packet.title();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            Stream stream = packet.pages().stream().limit(100L);
            Objects.requireNonNull(list);
            stream.forEach(list::add);
            boolean hasEditPerm = this.getCraftPlayer().hasPermission("purpur.book.color.edit");
            boolean hasSignPerm = hasEditPerm || this.getCraftPlayer().hasPermission("purpur.book.color.sign");
            Consumer<List> consumer = optional.isPresent() ? list1 -> this.signBook((FilteredText)list1.get(0), list1.subList(1, list1.size()), i, hasSignPerm) : list1 -> this.updateBookContents((List<FilteredText>)list1, i, hasEditPerm);
            this.filterTextPacket(list).thenAcceptAsync(consumer, (Executor)this.server);
        }
    }

    private void updateBookContents(List<FilteredText> pages, int slotId) {
        this.updateBookContents(pages, slotId, false);
    }

    private void updateBookContents(List<FilteredText> pages, int slotId, boolean hasPerm) {
        ItemStack handItem = this.player.getInventory().getItem(slotId);
        ItemStack itemstack = handItem.copy();
        if (itemstack.is(Items.WRITABLE_BOOK)) {
            List<Filterable<String>> list1 = pages.stream().map(filteredText -> this.filterableFromOutgoing((FilteredText)filteredText).map(s -> this.color((String)s, hasPerm))).toList();
            itemstack.set(DataComponents.WRITABLE_BOOK_CONTENT, new WritableBookContent(list1));
            this.player.getInventory().setItem(slotId, CraftEventFactory.handleEditBookEvent(this.player, slotId, handItem, itemstack));
        }
    }

    private void signBook(FilteredText title, List<FilteredText> pages, int slotId) {
        this.signBook(title, pages, slotId, false);
    }

    private void signBook(FilteredText title, List<FilteredText> pages, int slotId, boolean hasPerm) {
        ItemStack itemstack = this.player.getInventory().getItem(slotId);
        if (itemstack.is(Items.WRITABLE_BOOK)) {
            ItemStack itemstack1 = itemstack.transmuteCopy(Items.WRITTEN_BOOK, 1);
            itemstack1.remove(DataComponents.WRITABLE_BOOK_CONTENT);
            List<Filterable<net.minecraft.network.chat.Component>> list1 = pages.stream().map(filteredtext1 -> this.filterableFromOutgoing((FilteredText)filteredtext1).map(s -> this.hexColor((String)s, hasPerm))).toList();
            itemstack1.set(DataComponents.WRITTEN_BOOK_CONTENT, new WrittenBookContent(this.filterableFromOutgoing(title).map(s -> this.color((String)s, hasPerm)), this.player.getName().getString(), 0, list1, true));
            CraftEventFactory.handleEditBookEvent(this.player, slotId, itemstack, itemstack1);
            this.player.getInventory().setItem(slotId, itemstack);
        }
    }

    private Filterable<String> filterableFromOutgoing(FilteredText message) {
        return this.player.isTextFilteringEnabled() ? Filterable.passThrough(message.filteredOrEmpty()) : Filterable.from(message);
    }

    private net.minecraft.network.chat.Component hexColor(String str, boolean hasPerm) {
        return hasPerm ? PaperAdventure.asVanilla((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(str)) : net.minecraft.network.chat.Component.literal(str);
    }

    private String color(String str, boolean hasPerm) {
        return hasPerm ? ChatColor.color((String)str, (boolean)false) : str;
    }

    @Override
    public void handleEntityTagQuery(ServerboundEntityTagQueryPacket packet) {
        net.minecraft.world.entity.Entity entity;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.hasPermissions(2) && (entity = this.player.level().getEntity(packet.getEntityId())) != null) {
            CompoundTag nbttagcompound = entity.saveWithoutId(new CompoundTag());
            this.player.connection.send(new ClientboundTagQueryPacket(packet.getTransactionId(), nbttagcompound));
        }
    }

    @Override
    public void handleContainerSlotStateChanged(ServerboundContainerSlotStateChangedPacket packet) {
        CrafterMenu craftermenu;
        Container iinventory;
        AbstractContainerMenu container;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (!this.player.isSpectator() && packet.containerId() == this.player.containerMenu.containerId && (container = this.player.containerMenu) instanceof CrafterMenu && (iinventory = (craftermenu = (CrafterMenu)container).getContainer()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)iinventory;
            crafterblockentity.setSlotState(packet.slotId(), packet.newState());
        }
    }

    @Override
    public void handleBlockEntityTagQuery(ServerboundBlockEntityTagQueryPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.hasPermissions(2)) {
            BlockEntity tileentity = this.player.level().getBlockEntity(packet.getPos());
            CompoundTag nbttagcompound = tileentity != null ? tileentity.saveWithoutMetadata(this.player.registryAccess()) : null;
            this.player.connection.send(new ClientboundTagQueryPacket(packet.getTransactionId(), nbttagcompound));
        }
    }

    @Override
    public void handleMovePlayer(ServerboundMovePlayerPacket packet) {
        boolean invalidPitch;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        boolean invalidX = Double.isNaN(packet.getX(0.0));
        boolean invalidY = Double.isNaN(packet.getY(0.0));
        boolean invalidZ = Double.isNaN(packet.getZ(0.0));
        boolean invalidYaw = !Floats.isFinite((float)packet.getYRot(0.0f));
        boolean bl = invalidPitch = !Floats.isFinite((float)packet.getXRot(0.0f));
        if (invalidX || invalidY || invalidZ || invalidYaw || invalidPitch) {
            this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
            LOGGER.warn(String.format("Disconnected on move player packet. Invalid data: x=%b, y=%b, z=%b, yaw=%b, pitch=%b", invalidX, invalidY, invalidZ, invalidYaw, invalidPitch));
        } else {
            ServerLevel worldserver = this.player.serverLevel();
            if (!this.player.wonGame && !this.player.isImmobile()) {
                if (this.tickCount == 0) {
                    this.resetPosition();
                }
                if (this.awaitingPositionFromClient != null) {
                    this.allowedPlayerTicks = 20;
                } else {
                    float f1;
                    float f;
                    double d2;
                    double d1;
                    double d0;
                    this.awaitingTeleportTime = this.tickCount;
                    double toX = d0 = ServerGamePacketListenerImpl.clampHorizontal(packet.getX(this.player.getX()));
                    double toY = d1 = ServerGamePacketListenerImpl.clampVertical(packet.getY(this.player.getY()));
                    double toZ = d2 = ServerGamePacketListenerImpl.clampHorizontal(packet.getZ(this.player.getZ()));
                    float toYaw = f = Mth.wrapDegrees(packet.getYRot(this.player.getYRot()));
                    float toPitch = f1 = Mth.wrapDegrees(packet.getXRot(this.player.getXRot()));
                    if (this.player.isPassenger()) {
                        this.player.absMoveTo(this.player.getX(), this.player.getY(), this.player.getZ(), f, f1);
                        this.player.serverLevel().getChunkSource().move(this.player);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.player.getX();
                        double prevY = this.player.getY();
                        double prevZ = this.player.getZ();
                        float prevYaw = this.player.getYRot();
                        float prevPitch = this.player.getXRot();
                        double d3 = this.player.getX();
                        double d4 = this.player.getY();
                        double d5 = this.player.getZ();
                        double d6 = d0 - this.firstGoodX;
                        double d7 = d1 - this.firstGoodY;
                        double d8 = d2 - this.firstGoodZ;
                        double d9 = this.player.getDeltaMovement().lengthSqr();
                        double currDeltaX = toX - prevX;
                        double currDeltaY = toY - prevY;
                        double currDeltaZ = toZ - prevZ;
                        double d10 = Math.max(d6 * d6 + d7 * d7 + d8 * d8, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                        double otherFieldX = d0 - this.lastGoodX;
                        double otherFieldY = d1 - this.lastGoodY;
                        double otherFieldZ = d2 - this.lastGoodZ;
                        d10 = Math.max(d10, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                        if (this.player.isSleeping()) {
                            if (d10 > 1.0) {
                                this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), f, f1);
                            }
                        } else {
                            PlayerFailMoveEvent event;
                            PlayerFailMoveEvent event2;
                            boolean didCollide;
                            boolean flag1;
                            boolean flag = this.player.isFallFlying();
                            if (worldserver.tickRateManager().runsNormally()) {
                                PlayerFailMoveEvent event3;
                                ++this.receivedMovePacketCount;
                                int i = this.receivedMovePacketCount - this.knownMovePacketCount;
                                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                                if (i > Math.max(this.allowedPlayerTicks, 5)) {
                                    LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.player.getName().getString(), (Object)i);
                                    i = 1;
                                }
                                this.allowedPlayerTicks = packet.hasRot || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                                double speed = this.player.getAbilities().flying ? (double)(this.player.getAbilities().flyingSpeed * 20.0f) : (double)(this.player.getAbilities().walkingSpeed * 10.0f);
                                if (!(!this.player.level().paperConfig().chunks.preventMovingIntoUnloadedChunks || this.player.getX() == toX && this.player.getZ() == toZ || worldserver.areChunksLoadedForMove(this.player.getBoundingBox().expandTowards(new Vec3(toX, toY, toZ).subtract(this.player.position()))) || (event3 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_INTO_UNLOADED_CHUNK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed())) {
                                    this.internalTeleport(this.player.getX(), this.player.getY(), this.player.getZ(), this.player.getYRot(), this.player.getXRot(), Collections.emptySet());
                                    return;
                                }
                                if (!(this.player.isChangingDimension() || this.player.level().getGameRules().getBoolean(GameRules.RULE_DISABLE_ELYTRA_MOVEMENT_CHECK) && flag)) {
                                    PlayerFailMoveEvent event4;
                                    float f2;
                                    float f3 = f2 = flag ? 300.0f : 100.0f;
                                    if (d10 - d9 > Math.max((double)f2, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i * speed, 2.0)) && !this.isSingleplayerOwner() && !(event4 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed()) {
                                        if (event4.getLogWarning()) {
                                            LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{this.player.getName().getString(), d6, d7, d8});
                                        }
                                        this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), this.player.getYRot(), this.player.getXRot());
                                        return;
                                    }
                                }
                            }
                            AABB axisalignedbb = this.player.getBoundingBox();
                            d6 = d0 - this.lastGoodX;
                            d7 = d1 - this.lastGoodY;
                            d8 = d2 - this.lastGoodZ;
                            boolean bl2 = flag1 = d7 > 0.0;
                            if (this.player.onGround() && !packet.isOnGround() && flag1) {
                                PlayerJumpEvent event5;
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.hasPos) {
                                    to.setX(packet.x);
                                    to.setY(packet.y);
                                    to.setZ(packet.z);
                                }
                                if (packet.hasRot) {
                                    to.setYaw(packet.yRot);
                                    to.setPitch(packet.xRot);
                                }
                                if ((event5 = new PlayerJumpEvent((org.bukkit.entity.Player)player, from, to)).callEvent()) {
                                    this.player.jumpFromGround();
                                } else {
                                    from = event5.getFrom();
                                    this.internalTeleport(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch(), Collections.emptySet());
                                    return;
                                }
                            }
                            boolean flag2 = this.player.verticalCollisionBelow;
                            this.player.move(MoverType.PLAYER, new Vec3(d6, d7, d8));
                            this.player.onGround = packet.isOnGround();
                            boolean bl3 = didCollide = toX != this.player.getX() || toY != this.player.getY() || toZ != this.player.getZ();
                            if (this.awaitingPositionFromClient != null) {
                                return;
                            }
                            double d11 = d7;
                            d6 = d0 - this.player.getX();
                            d7 = d1 - this.player.getY();
                            if (d7 > -0.5 || d7 < 0.5) {
                                d7 = 0.0;
                            }
                            d8 = d2 - this.player.getZ();
                            d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            boolean movedWrongly = false;
                            if (!(this.player.isChangingDimension() || !(d10 > SpigotConfig.movedWronglyThreshold) || this.player.isSleeping() || this.player.gameMode.isCreative() || this.player.gameMode.getGameModeForPlayer() == GameType.SPECTATOR || (event2 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_WRONGLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed())) {
                                movedWrongly = true;
                                if (event2.getLogWarning()) {
                                    LOGGER.warn("{} moved wrongly!, ({})", (Object)this.player.getName().getString(), (Object)d11);
                                }
                            }
                            boolean teleportBack = !this.player.noPhysics && !this.player.isSleeping() && movedWrongly;
                            this.player.absMoveTo(d0, d1, d2, f, f1);
                            if (!(this.player.noPhysics || this.player.isSleeping() || teleportBack)) {
                                AABB newBox = this.player.getBoundingBox();
                                if (didCollide || !axisalignedbb.equals(newBox)) {
                                    teleportBack = this.hasNewCollision(worldserver, this.player, axisalignedbb, newBox);
                                }
                            }
                            if (teleportBack && (event = this.fireFailMove(PlayerFailMoveEvent.FailReason.CLIPPED_INTO_BLOCK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed()) {
                                teleportBack = false;
                            }
                            if (teleportBack) {
                                this.internalTeleport(d3, d4, d5, f, f1, Collections.emptySet());
                                this.player.doCheckFallDamage(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5, packet.isOnGround());
                            } else {
                                this.player.absMoveTo(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                if (!this.hasMoved) {
                                    this.lastPosX = prevX;
                                    this.lastPosY = prevY;
                                    this.lastPosZ = prevZ;
                                    this.lastYaw = prevYaw;
                                    this.lastPitch = prevPitch;
                                    this.hasMoved = true;
                                }
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.hasPos) {
                                    to.setX(packet.x);
                                    to.setY(packet.y);
                                    to.setZ(packet.z);
                                }
                                if (packet.hasRot) {
                                    to.setYaw(packet.yRot);
                                    to.setPitch(packet.xRot);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.player.isImmobile()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    if (!to.getWorld().getUID().equals(from.getWorld().getUID()) || to.getBlockX() != from.getBlockX() || to.getBlockY() != from.getBlockY() || to.getBlockZ() != from.getBlockZ() || to.getYaw() != from.getYaw() || to.getPitch() != from.getPitch()) {
                                        this.player.resetLastActionTime();
                                    }
                                    Location oldTo = to.clone();
                                    PlayerMoveEvent event6 = new PlayerMoveEvent((org.bukkit.entity.Player)player, from, to);
                                    this.cserver.getPluginManager().callEvent((Event)event6);
                                    if (event6.isCancelled()) {
                                        this.teleport(from);
                                        return;
                                    }
                                    if (!oldTo.equals((Object)event6.getTo()) && !event6.isCancelled()) {
                                        this.player.getBukkitEntity().teleport(event6.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                        return;
                                    }
                                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                        this.justTeleported = false;
                                        return;
                                    }
                                }
                                this.player.absMoveTo(d0, d1, d2, f, f1);
                                boolean flag4 = this.player.isAutoSpinAttack();
                                this.clientIsFloating = d11 >= -0.03125 && !flag2 && this.player.gameMode.getGameModeForPlayer() != GameType.SPECTATOR && !this.server.isFlightAllowed() && !this.player.getAbilities().mayfly && !this.player.hasEffect(MobEffects.LEVITATION) && !flag && !flag4 && this.noBlocksAround(this.player);
                                this.player.serverLevel().getChunkSource().move(this.player);
                                this.player.doCheckFallDamage(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5, packet.isOnGround());
                                this.player.setOnGroundWithKnownMovement(packet.isOnGround(), new Vec3(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5));
                                if (flag1) {
                                    this.player.resetFallDistance();
                                }
                                if (packet.isOnGround() || this.player.isInLiquid() || this.player.onClimbable() || this.player.isSpectator() || flag || flag4) {
                                    this.player.resetCurrentImpulseContext();
                                }
                                if (!(!this.player.level().purpurConfig.dontRunWithScissors || !this.player.isSprinting() || this.player.level().purpurConfig.ignoreScissorsInWater && this.player.isInWater() || this.player.level().purpurConfig.ignoreScissorsInLava && this.player.isInLava() || !this.isScissor(this.player.getItemInHand(InteractionHand.MAIN_HAND)) && !this.isScissor(this.player.getItemInHand(InteractionHand.OFF_HAND)) || (int)(Math.random() * 10.0) != 0)) {
                                    this.player.hurt(this.player.damageSources().scissors(), (float)this.player.level().purpurConfig.scissorsRunningDamage);
                                    if (!PurpurConfig.dontRunWithScissors.isBlank()) {
                                        this.player.sendActionBarMessage(PurpurConfig.dontRunWithScissors);
                                    }
                                }
                                this.player.checkMovementStatistics(this.player.getX() - d3, this.player.getY() - d4, this.player.getZ() - d5);
                                this.lastGoodX = this.player.getX();
                                this.lastGoodY = this.player.getY();
                                this.lastGoodZ = this.player.getZ();
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean hasNewCollision(ServerLevel world, net.minecraft.world.entity.Entity entity, AABB oldBox, AABB newBox) {
        int i;
        ArrayList<AABB> collisionsBB = new ArrayList<AABB>();
        ArrayList<VoxelShape> collisionsVoxel = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisions(world, entity, newBox, collisionsVoxel, collisionsBB, 6, null, null);
        int len = collisionsBB.size();
        for (i = 0; i < len; ++i) {
            AABB box = (AABB)collisionsBB.get(i);
            if (CollisionUtil.voxelShapeIntersect(box, oldBox)) continue;
            return true;
        }
        len = collisionsVoxel.size();
        for (i = 0; i < len; ++i) {
            VoxelShape voxel = (VoxelShape)collisionsVoxel.get(i);
            if (CollisionUtil.voxelShapeIntersectNoEmpty(voxel, oldBox)) continue;
            return true;
        }
        return false;
    }

    public boolean isScissor(ItemStack stack) {
        if (!stack.is(Items.SHEARS)) {
            return false;
        }
        CustomModelData customModelData = stack.get(DataComponents.CUSTOM_MODEL_DATA);
        return customModelData == null || customModelData.value() == 0;
    }

    private boolean isPlayerCollidingWithAnythingNew(LevelReader world, AABB box, double newX, double newY, double newZ) {
        VoxelShape voxelshape1;
        AABB axisalignedbb1 = this.player.getBoundingBox().move(newX - this.player.getX(), newY - this.player.getY(), newZ - this.player.getZ());
        Iterable<VoxelShape> iterable = world.getCollisions(this.player, axisalignedbb1.deflate(1.0E-5f));
        VoxelShape voxelshape = Shapes.create(box.deflate(1.0E-5f));
        Iterator<VoxelShape> iterator = iterable.iterator();
        do {
            if (iterator.hasNext()) continue;
            return !PurpurConfig.kickForOutOfOrderChat;
        } while (Shapes.joinIsNotEmpty(voxelshape1 = iterator.next(), voxelshape, BooleanOp.AND));
        return true;
    }

    public void teleport(double x, double y, double z, float yaw, float pitch) {
        this.teleport(x, y, z, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleport(double d0, double d1, double d2, float f, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.teleport(d0, d1, d2, f, f1, Collections.emptySet(), cause);
    }

    public void teleport(double x, double y, double z, float yaw, float pitch, Set<RelativeMovement> flags) {
        this.teleport(x, y, z, yaw, pitch, flags, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f, float f1, Set<RelativeMovement> set, PlayerTeleportEvent.TeleportCause cause) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        double x = d0;
        double y = d1;
        double z = d2;
        float yaw = f;
        float pitch = f1;
        Location to = new Location(this.getCraftPlayer().getWorld(), x, y, z, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(d0, d1, d2, f, f1, set);
            return false;
        }
        EnumSet<TeleportFlag.Relative> relativeFlags = EnumSet.noneOf(TeleportFlag.Relative.class);
        for (RelativeMovement relativeArgument : set) {
            relativeFlags.add(CraftPlayer.toApiRelativeFlag(relativeArgument));
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((org.bukkit.entity.Player)player, from.clone(), to.clone(), cause, Set.copyOf(relativeFlags));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f = to.getYaw();
            f1 = to.getPitch();
        }
        this.internalTeleport(d0, d1, d2, f, f1, set);
        return event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet());
    }

    public void internalTeleport(double d0, double d1, double d2, float f, float f1, Set<RelativeMovement> set) {
        AsyncCatcher.catchOp("teleport");
        if (this.player.isRemoved()) {
            LOGGER.info("Attempt to teleport removed player {} restricted", (Object)this.player.getScoreboardName());
            if (this.server.isDebugging()) {
                TraceUtil.dumpTraceForThread("Attempt to teleport removed player");
            }
            return;
        }
        if (Float.isNaN(f)) {
            f = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        this.justTeleported = true;
        double d3 = set.contains((Object)RelativeMovement.X) ? this.player.getX() : 0.0;
        double d4 = set.contains((Object)RelativeMovement.Y) ? this.player.getY() : 0.0;
        double d5 = set.contains((Object)RelativeMovement.Z) ? this.player.getZ() : 0.0;
        float f2 = set.contains((Object)RelativeMovement.Y_ROT) ? this.player.getYRot() : 0.0f;
        float f3 = set.contains((Object)RelativeMovement.X_ROT) ? this.player.getXRot() : 0.0f;
        this.awaitingPositionFromClient = new Vec3(d0, d1, d2);
        if (++this.awaitingTeleport == Integer.MAX_VALUE) {
            this.awaitingTeleport = 0;
        }
        this.lastPosX = this.awaitingPositionFromClient.x;
        this.lastPosY = this.awaitingPositionFromClient.y;
        this.lastPosZ = this.awaitingPositionFromClient.z;
        this.lastYaw = f;
        this.lastPitch = f1;
        this.awaitingTeleportTime = this.tickCount;
        this.player.resetCurrentImpulseContext();
        this.player.moveTo(d0, d1, d2, f, f1);
        this.player.connection.send(new ClientboundPlayerPositionPacket(d0 - d3, d1 - d4, d2 - d5, f - f2, f1 - f3, set, this.awaitingTeleport));
    }

    @Override
    public void handlePlayerAction(ServerboundPlayerActionPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        BlockPos blockposition = packet.getPos();
        this.player.resetLastActionTime();
        ServerboundPlayerActionPacket.Action packetplayinblockdig_enumplayerdigtype = packet.getAction();
        switch (packetplayinblockdig_enumplayerdigtype) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.player.isSpectator()) {
                    ItemStack itemstack = this.player.getItemInHand(InteractionHand.OFF_HAND);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror(this.player.getItemInHand(InteractionHand.MAIN_HAND));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((org.bukkit.entity.Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                    this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.player.setItemInHand(InteractionHand.OFF_HAND, this.player.getItemInHand(InteractionHand.MAIN_HAND));
                    } else {
                        this.player.setItemInHand(InteractionHand.OFF_HAND, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.player.setItemInHand(InteractionHand.MAIN_HAND, itemstack);
                    } else {
                        this.player.setItemInHand(InteractionHand.MAIN_HAND, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                    }
                    this.player.stopUsingItem();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.player.isSpectator()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            LOGGER.warn(this.player.getScoreboardName() + " dropped their items too quickly!");
                            this.disconnect("You dropped your items too quickly (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
                            return;
                        }
                    }
                    this.player.drop(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.player.isSpectator()) {
                    this.player.drop(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.player.releaseUsingItem();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                if (this.player.level().getChunkIfLoadedImmediately(blockposition.getX() >> 4, blockposition.getZ() >> 4) == null) {
                    this.player.connection.ackBlockChangesUpTo(packet.getSequence());
                    return;
                }
                this.player.gameMode.capturedBlockEntity = false;
                this.player.gameMode.captureSentBlockEntities = true;
                this.player.gameMode.handleBlockBreakAction(blockposition, packetplayinblockdig_enumplayerdigtype, packet.getDirection(), this.player.level().getMaxBuildHeight(), packet.getSequence());
                this.player.connection.ackBlockChangesUpTo(packet.getSequence());
                this.player.gameMode.captureSentBlockEntities = false;
                if (this.player.gameMode.capturedBlockEntity) {
                    this.send(new ClientboundBlockChangedAckPacket(this.ackBlockChangesUpTo));
                    this.player.connection.ackBlockChangesUpTo = -1;
                    this.player.gameMode.capturedBlockEntity = false;
                    BlockEntity tileentity = this.player.level().getBlockEntity(blockposition);
                    if (tileentity != null) {
                        this.player.connection.send(tileentity.getUpdatePacket());
                    }
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean wasBlockPlacementAttempt(ServerPlayer player, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return (item instanceof BlockItem || item instanceof BucketItem) && !player.getCooldowns().isOnCooldown(item);
    }

    private static int getSpamThreshold() {
        return GlobalConfiguration.get().spamLimiter.incomingPacketThreshold;
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < (long)ServerGamePacketListenerImpl.getSpamThreshold() && this.limitedPackets++ >= 8) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= (long)ServerGamePacketListenerImpl.getSpamThreshold()) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void handleUseItemOn(ServerboundUseItemOnPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        this.player.connection.ackBlockChangesUpTo(packet.getSequence());
        ServerLevel worldserver = this.player.serverLevel();
        InteractionHand enumhand = packet.getHand();
        ItemStack itemstack = this.player.getItemInHand(enumhand);
        if (itemstack.isItemEnabled(worldserver.enabledFeatures())) {
            BlockHitResult movingobjectpositionblock = packet.getHitResult();
            Vec3 vec3d = movingobjectpositionblock.getLocation();
            if (!(Double.isFinite(vec3d.x) && Double.isFinite(vec3d.y) && Double.isFinite(vec3d.z))) {
                return;
            }
            BlockPos blockposition = movingobjectpositionblock.getBlockPos();
            if (this.player.canInteractWithBlock(blockposition, 1.0)) {
                Vec3 vec3d1 = vec3d.subtract(Vec3.atCenterOf(blockposition));
                double d0 = 1.0000001;
                if (Math.abs(vec3d1.x()) < 1.0000001 && Math.abs(vec3d1.y()) < 1.0000001 && Math.abs(vec3d1.z()) < 1.0000001) {
                    Direction enumdirection = movingobjectpositionblock.getDirection();
                    this.player.resetLastActionTime();
                    int i = this.player.level().getMaxBuildHeight();
                    if (blockposition.getY() < i) {
                        if (this.awaitingPositionFromClient == null && (worldserver.mayInteract(this.player, blockposition) || worldserver.paperConfig().spawn.allowUsingSignsInsideSpawnProtection && worldserver.getBlockState(blockposition).getBlock() instanceof SignBlock)) {
                            InteractionResult enuminteractionresult = this.player.gameMode.useItemOn(this.player, worldserver, itemstack, enumhand, movingobjectpositionblock);
                            if (enuminteractionresult.consumesAction()) {
                                CriteriaTriggers.ANY_BLOCK_USE.trigger(this.player, movingobjectpositionblock.getBlockPos(), itemstack.copy());
                            }
                            if (enumdirection == Direction.UP && !enuminteractionresult.consumesAction() && blockposition.getY() >= i - 1 && ServerGamePacketListenerImpl.wasBlockPlacementAttempt(this.player, itemstack)) {
                                MutableComponent ichatmutablecomponent = net.minecraft.network.chat.Component.translatable("build.tooHigh", i - 1).withStyle(ChatFormatting.RED);
                                this.player.sendSystemMessage(ichatmutablecomponent, true);
                            } else if (enuminteractionresult.shouldSwing() && !this.player.gameMode.interactResult) {
                                this.player.swing(enumhand, true);
                            }
                        }
                    } else {
                        MutableComponent ichatmutablecomponent1 = net.minecraft.network.chat.Component.translatable("build.tooHigh", i - 1).withStyle(ChatFormatting.RED);
                        this.player.sendSystemMessage(ichatmutablecomponent1, true);
                    }
                    this.player.connection.send(new ClientboundBlockUpdatePacket(worldserver, blockposition));
                    this.player.connection.send(new ClientboundBlockUpdatePacket(worldserver, blockposition.relative(enumdirection)));
                } else {
                    LOGGER.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.player.getGameProfile().getName(), vec3d, blockposition});
                }
            }
        }
    }

    @Override
    public void handleUseItem(ServerboundUseItemPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        this.ackBlockChangesUpTo(packet.getSequence());
        ServerLevel worldserver = this.player.serverLevel();
        InteractionHand enumhand = packet.getHand();
        ItemStack itemstack = this.player.getItemInHand(enumhand);
        this.player.resetLastActionTime();
        if (!itemstack.isEmpty() && itemstack.isItemEnabled(worldserver.enabledFeatures())) {
            boolean cancelled;
            float f1 = this.player.getXRot();
            float f2 = this.player.getYRot();
            double d0 = this.player.getX();
            double d1 = this.player.getY() + (double)this.player.getEyeHeight();
            double d2 = this.player.getZ();
            Vec3 vec3d = new Vec3(d0, d1, d2);
            float f3 = Mth.cos(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = Mth.sin(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f5 = -Mth.cos(-f1 * ((float)Math.PI / 180));
            float f6 = Mth.sin(-f1 * ((float)Math.PI / 180));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.player.gameMode.getGameModeForPlayer() == GameType.CREATIVE ? 5.0 : 4.5;
            Vec3 vec3d1 = vec3d.add((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            BlockHitResult movingobjectposition = this.player.level().clip(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, this.player));
            if (movingobjectposition == null || ((HitResult)movingobjectposition).getType() != HitResult.Type.BLOCK) {
                if (this.player.gameMode.shiftClickMended(itemstack)) {
                    return;
                }
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event;
                BlockHitResult movingobjectpositionblock = movingobjectposition;
                cancelled = this.player.gameMode.firedInteract && this.player.gameMode.interactPosition.equals(movingobjectpositionblock.getBlockPos()) && this.player.gameMode.interactHand == enumhand && ItemStack.isSameItemSameComponents(this.player.gameMode.interactItemStack, itemstack) ? this.player.gameMode.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.getBlockPos(), movingobjectpositionblock.getDirection(), itemstack, true, enumhand, movingobjectpositionblock.getLocation())).useItemInHand() == Event.Result.DENY;
                this.player.gameMode.firedInteract = false;
            }
            if (cancelled) {
                this.player.resyncUsingItem(this.player);
                this.player.getBukkitEntity().updateInventory();
                return;
            }
            itemstack = this.player.getItemInHand(enumhand);
            if (itemstack.isEmpty()) {
                return;
            }
            InteractionResult enuminteractionresult = this.player.gameMode.useItem(this.player, worldserver, itemstack, enumhand);
            if (enuminteractionresult.shouldSwing()) {
                this.player.swing(enumhand, true);
            }
        }
    }

    @Override
    public void handleTeleportToEntityPacket(ServerboundTeleportToEntityPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isSpectator()) {
            for (ServerLevel worldserver : this.server.getAllLevels()) {
                net.minecraft.world.entity.Entity entity = packet.getEntity(worldserver);
                if (entity == null) continue;
                this.player.teleportTo(worldserver, entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot(), PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void handlePaddleBoat(ServerboundPaddleBoatPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
        if (entity instanceof Boat) {
            Boat entityboat = (Boat)entity;
            entityboat.setPaddleState(packet.getLeft(), packet.getRight());
        }
    }

    @Override
    public void onDisconnect(net.minecraft.network.chat.Component reason) {
        this.onDisconnect(reason, null);
    }

    @Override
    public void onDisconnect(net.minecraft.network.chat.Component reason, @Nullable Component quitMessage) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        LOGGER.info("{} lost connection: {}", (Object)this.player.getName().getString(), (Object)reason.getString());
        this.removePlayerFromWorld(quitMessage);
        super.onDisconnect(reason, quitMessage);
    }

    private void removePlayerFromWorld() {
        this.removePlayerFromWorld(null);
    }

    private void removePlayerFromWorld(@Nullable Component quitMessage) {
        this.chatMessageChain.close();
        this.player.disconnect();
        Component component = quitMessage = quitMessage == null ? this.server.getPlayerList().remove(this.player) : this.server.getPlayerList().remove(this.player, quitMessage);
        if (quitMessage != null && !quitMessage.equals((Object)Component.empty())) {
            this.server.getPlayerList().broadcastSystemMessage(PaperAdventure.asVanilla(quitMessage), false);
        }
        this.player.getTextFilter().leave();
    }

    public void ackBlockChangesUpTo(int sequence) {
        if (sequence < 0) {
            this.disconnect("Expected packet sequence nr >= 0", PlayerKickEvent.Cause.ILLEGAL_ACTION);
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.ackBlockChangesUpTo = Math.max(sequence, this.ackBlockChangesUpTo);
    }

    @Override
    public void handleSetCarriedItem(ServerboundSetCarriedItemPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        if (packet.getSlot() >= 0 && packet.getSlot() < net.minecraft.world.entity.player.Inventory.getSelectionSize()) {
            if (packet.getSlot() == this.player.getInventory().selected) {
                return;
            }
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((org.bukkit.entity.Player)this.getCraftPlayer(), this.player.getInventory().selected, packet.getSlot());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.send(new ClientboundSetCarriedItemPacket(this.player.getInventory().selected));
                this.player.resetLastActionTime();
                return;
            }
            if (this.player.getInventory().selected != packet.getSlot() && this.player.getUsedItemHand() == InteractionHand.MAIN_HAND) {
                this.player.stopUsingItem();
            }
            this.player.getInventory().selected = packet.getSlot();
            this.player.resetLastActionTime();
        } else {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.player.getName().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
        }
    }

    @Override
    public void handleChat(ServerboundChatPacket packet) {
        if (this.server.isStopped()) {
            return;
        }
        Optional<LastSeenMessages> optional = this.unpackAndApplyLastSeen(packet.lastSeenMessages());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.message(), () -> {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.getSignedMessage(packet, (LastSeenMessages)optional.get());
                }
                catch (SignedMessageChain.DecodeException signedmessagechain_a) {
                    this.handleMessageDecodeFailure(signedmessagechain_a);
                    return;
                }
                CompletionStage completablefuture = this.filterTextPacket(playerchatmessage.signedContent()).thenApplyAsync(Function.identity(), (Executor)this.server.chatExecutor);
                CompletableFuture<net.minecraft.network.chat.Component> componentFuture = this.server.getChatDecorator().decorate(this.player, null, playerchatmessage.decoratedContent());
                this.chatMessageChain.append(CompletableFuture.allOf(new CompletableFuture[]{completablefuture, componentFuture}), arg_0 -> this.lambda$handleChat$16(playerchatmessage, componentFuture, (CompletableFuture)completablefuture, arg_0));
            }, false);
        }
    }

    @Override
    public void handleChatCommand(ServerboundChatCommandPacket packet) {
        this.tryHandleChat(packet.command(), () -> {
            if (this.player.hasDisconnected()) {
                return;
            }
            this.performUnsignedChatCommand(packet.command());
            this.detectRateSpam("/" + packet.command());
        }, true);
    }

    private void performUnsignedChatCommand(String command) {
        String command1 = "/" + command;
        if (SpigotConfig.logCommands) {
            LOGGER.info(this.player.getScoreboardName() + " issued server command: " + command1);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((org.bukkit.entity.Player)this.getCraftPlayer(), command1, (Set)new LazyPlayerSet(this.server));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandSourceStack> parseresults = this.parseCommand(command);
        if (this.server.enforceSecureProfile() && SignableCommand.hasSignableArguments(parseresults)) {
            LOGGER.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.player.getGameProfile().getName(), (Object)command);
            this.player.sendSystemMessage(INVALID_COMMAND_SIGNATURE);
        } else {
            this.server.getCommands().performCommand(parseresults, command);
        }
    }

    @Override
    public void handleSignedChatCommand(ServerboundChatCommandSignedPacket packet) {
        Optional<LastSeenMessages> optional = this.unpackAndApplyLastSeen(packet.lastSeenMessages());
        if (!optional.isEmpty()) {
            this.tryHandleChat(packet.command(), () -> {
                if (this.player.hasDisconnected()) {
                    return;
                }
                this.performSignedChatCommand(packet, (LastSeenMessages)optional.get());
                this.detectRateSpam("/" + packet.command());
            }, true);
        }
    }

    private void performSignedChatCommand(ServerboundChatCommandSignedPacket packet, LastSeenMessages lastSeenMessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + packet.command();
        if (SpigotConfig.logCommands) {
            LOGGER.info(this.player.getScoreboardName() + " issued server command: " + (String)command);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((org.bukkit.entity.Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.server));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandSourceStack> parseresults = this.parseCommand((String)command);
        try {
            map = packet.command().equals(command) ? this.collectSignedArguments(packet, SignableCommand.of(parseresults), lastSeenMessages) : Collections.emptyMap();
        }
        catch (SignedMessageChain.DecodeException signedmessagechain_a) {
            this.handleMessageDecodeFailure(signedmessagechain_a);
            return;
        }
        CommandSigningContext.SignedArguments commandsigningcontext_a = new CommandSigningContext.SignedArguments(map);
        parseresults = Commands.mapSource(parseresults, commandlistenerwrapper -> commandlistenerwrapper.withSigningContext(commandsigningcontext_a, this.chatMessageChain));
        this.server.getCommands().performCommand(parseresults, (String)command);
    }

    private void handleMessageDecodeFailure(SignedMessageChain.DecodeException exception) {
        LOGGER.warn("Failed to update secure chat state for {}: '{}'", (Object)this.player.getGameProfile().getName(), (Object)exception.getComponent().getString());
        this.player.sendSystemMessage(exception.getComponent().copy().withStyle(ChatFormatting.RED));
    }

    private <S> Map<String, PlayerChatMessage> collectSignedArguments(ServerboundChatCommandSignedPacket packet, SignableCommand<S> arguments, LastSeenMessages lastSeenMessages) throws SignedMessageChain.DecodeException {
        SignableCommand.Argument signablecommand_a1;
        List<ArgumentSignatures.Entry> list = packet.argumentSignatures().entries();
        List<SignableCommand.Argument<S>> list1 = arguments.arguments();
        if (list.isEmpty()) {
            return this.collectUnsignedArguments(list1);
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.Entry argumentsignatures_a : list) {
            SignableCommand.Argument<S> signablecommand_a = arguments.getArgument(argumentsignatures_a.name());
            if (signablecommand_a == null) {
                this.signedMessageDecoder.setChainBroken();
                throw ServerGamePacketListenerImpl.createSignedArgumentMismatchException(packet.command(), list, list1);
            }
            SignedMessageBody signedmessagebody = new SignedMessageBody(signablecommand_a.value(), packet.timeStamp(), packet.salt(), lastSeenMessages);
            map.put(signablecommand_a.name(), this.signedMessageDecoder.unpack(argumentsignatures_a.signature(), signedmessagebody));
        }
        Iterator<Record> iterator = list1.iterator();
        do {
            if (iterator.hasNext()) continue;
            return map;
        } while (map.containsKey((signablecommand_a1 = (SignableCommand.Argument)iterator.next()).name()));
        throw ServerGamePacketListenerImpl.createSignedArgumentMismatchException(packet.command(), list, list1);
    }

    private <S> Map<String, PlayerChatMessage> collectUnsignedArguments(List<SignableCommand.Argument<S>> arguments) throws SignedMessageChain.DecodeException {
        HashMap<String, PlayerChatMessage> map = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.Argument<S> signablecommand_a : arguments) {
            SignedMessageBody signedmessagebody = SignedMessageBody.unsigned(signablecommand_a.value());
            map.put(signablecommand_a.name(), this.signedMessageDecoder.unpack(null, signedmessagebody));
        }
        return map;
    }

    private static <S> SignedMessageChain.DecodeException createSignedArgumentMismatchException(String command, List<ArgumentSignatures.Entry> actual, List<SignableCommand.Argument<S>> expected) {
        String s1 = actual.stream().map(ArgumentSignatures.Entry::name).collect(Collectors.joining(", "));
        String s2 = expected.stream().map(SignableCommand.Argument::name).collect(Collectors.joining(", "));
        LOGGER.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{command, s1, s2});
        return new SignedMessageChain.DecodeException(INVALID_COMMAND_SIGNATURE);
    }

    private ParseResults<CommandSourceStack> parseCommand(String command) {
        CommandDispatcher<CommandSourceStack> com_mojang_brigadier_commanddispatcher = this.server.getCommands().getDispatcher();
        return com_mojang_brigadier_commanddispatcher.parse(command, this.player.createCommandSourceStack());
    }

    private void tryHandleChat(String s, Runnable runnable, boolean sync) {
        if (ServerGamePacketListenerImpl.isChatMessageIllegal(s)) {
            this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS);
        } else if (this.player.isRemoved() || this.player.getChatVisibility() == ChatVisiblity.HIDDEN) {
            this.send(new ClientboundSystemChatPacket(net.minecraft.network.chat.Component.translatable("chat.disabled.options").withStyle(ChatFormatting.RED), false));
        } else {
            this.player.resetLastActionTime();
            if (sync) {
                this.server.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> unpackAndApplyLastSeen(LastSeenMessages.Update acknowledgment) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.lastSeenMessages;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional = this.lastSeenMessages.applyUpdate(acknowledgment);
            if (optional.isEmpty()) {
                LOGGER.warn("Failed to validate message acknowledgements from {}", (Object)this.player.getName().getString());
                this.disconnect(CHAT_VALIDATION_FAILED, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
            return optional;
        }
    }

    public static boolean isChatMessageIllegal(String message) {
        for (int i = 0; i < message.length(); ++i) {
            if (StringUtil.isAllowedChatCharacter(message.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public void chat(String s, PlayerChatMessage original, boolean async) {
        if (s.isEmpty() || this.player.getChatVisibility() == ChatVisiblity.HIDDEN) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.create(original);
        if (this.player.getChatVisibility() != ChatVisiblity.SYSTEM) {
            if (!async && !Bukkit.isPrimaryThread()) {
                AsyncCatcher.catchOp("Asynchronous player chat is not allowed here");
            }
            ChatProcessor cp = new ChatProcessor(this.server, this.player, original, async);
            cp.process();
        }
    }

    @Deprecated
    public void handleCommand(String s) {
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        this.performUnsignedChatCommand(s);
    }

    private PlayerChatMessage getSignedMessage(ServerboundChatPacket packet, LastSeenMessages lastSeenMessages) throws SignedMessageChain.DecodeException {
        SignedMessageBody signedmessagebody = new SignedMessageBody(packet.message(), packet.timeStamp(), packet.salt(), lastSeenMessages);
        return this.signedMessageDecoder.unpack(packet.signature(), signedmessagebody);
    }

    private void broadcastChatMessage(PlayerChatMessage message) {
        String s = message.signedContent();
        if (s.isEmpty()) {
            LOGGER.warn(this.player.getScoreboardName() + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s;
            this.server.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    ServerGamePacketListenerImpl.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.player.getChatVisibility() == ChatVisiblity.SYSTEM) {
            this.send(new ClientboundSystemChatPacket(net.minecraft.network.chat.Component.translatable("chat.cannotSend").withStyle(ChatFormatting.RED), false));
        } else {
            this.chat(s, message, true);
        }
        this.detectRateSpam(s);
    }

    private void detectRateSpam(String s) {
        boolean counted = true;
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || !s.startsWith(exclude)) continue;
            counted = false;
            break;
        }
        if (counted && this.chatSpamTickCount.addAndGet(20) > 200 && !this.server.getPlayerList().isOp(this.player.getGameProfile())) {
            this.disconnect(net.minecraft.network.chat.Component.translatable("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChatAck(ServerboundChatAckPacket packet) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.lastSeenMessages;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            if (!this.lastSeenMessages.applyOffset(packet.offset())) {
                LOGGER.warn("Failed to validate message acknowledgements from {}", (Object)this.player.getName().getString());
                this.disconnect(CHAT_VALIDATION_FAILED, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void handleAnimate(ServerboundSwingPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        float f1 = this.player.getXRot();
        float f2 = this.player.getYRot();
        double d0 = this.player.getX();
        double d1 = this.player.getY() + (double)this.player.getEyeHeight();
        double d2 = this.player.getZ();
        Location origin = new Location((World)this.player.level().getWorld(), d0, d1, d2, f2, f1);
        double d3 = this.player.gameMode.getGameModeForPlayer() == GameType.CREATIVE ? 5.0 : 4.5;
        RayTraceResult result = this.player.level().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.0, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.player.getBukkitEntity() && this.player.getBukkitEntity().canSee((Entity)entity) && !handle.isSpectator() && handle.isPickable() && !handle.isPassengerOfSameVehicle(this.player);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_AIR, this.player.getInventory().getSelected(), InteractionHand.MAIN_HAND);
        } else {
            GameType gameType = this.player.gameMode.getGameModeForPlayer();
            if (gameType == GameType.ADVENTURE && result.getHitBlock() != null) {
                CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_BLOCK, ((CraftBlock)result.getHitBlock()).getPosition(), CraftBlock.blockFaceToNotch(result.getHitBlockFace()), this.player.getInventory().getSelected(), InteractionHand.MAIN_HAND);
            } else if (gameType != GameType.CREATIVE && result.getHitEntity() != null && origin.toVector().distanceSquared(result.getHitPosition()) > 9.0) {
                CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_AIR, this.player.getInventory().getSelected(), InteractionHand.MAIN_HAND);
            }
        }
        PlayerArmSwingEvent event = new PlayerArmSwingEvent((org.bukkit.entity.Player)this.getCraftPlayer(), CraftEquipmentSlot.getHand(packet.getHand()));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.player.swing(packet.getHand());
    }

    @Override
    public void handlePlayerCommand(ServerboundPlayerCommandPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isRemoved()) {
            return;
        }
        switch (packet.getAction()) {
            case PRESS_SHIFT_KEY: 
            case RELEASE_SHIFT_KEY: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((org.bukkit.entity.Player)this.getCraftPlayer(), packet.getAction() == ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case START_SPRINTING: 
            case STOP_SPRINTING: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((org.bukkit.entity.Player)this.getCraftPlayer(), packet.getAction() == ServerboundPlayerCommandPacket.Action.START_SPRINTING);
                this.cserver.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.player.resetLastActionTime();
        switch (packet.getAction()) {
            case PRESS_SHIFT_KEY: {
                this.player.setShiftKeyDown(true);
                if (!this.player.level().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) break;
                this.player.removeEntitiesOnShoulder();
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.player.setShiftKeyDown(false);
                break;
            }
            case START_SPRINTING: {
                this.player.setSprinting(true);
                break;
            }
            case STOP_SPRINTING: {
                this.player.setSprinting(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.player.isSleeping()) break;
                this.player.stopSleepInBed(false, true);
                this.awaitingPositionFromClient = this.player.position();
                break;
            }
            case START_RIDING_JUMP: {
                net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
                if (!(entity instanceof PlayerRideableJumping)) break;
                PlayerRideableJumping ijumpable = (PlayerRideableJumping)((Object)entity);
                int i = packet.getData();
                if (!ijumpable.canJump() || i <= 0) break;
                ijumpable.handleStartJump(i);
                break;
            }
            case STOP_RIDING_JUMP: {
                net.minecraft.world.entity.Entity entity = this.player.getControlledVehicle();
                if (!(entity instanceof PlayerRideableJumping)) break;
                PlayerRideableJumping ijumpable = (PlayerRideableJumping)((Object)entity);
                ijumpable.handleStopJump();
                break;
            }
            case OPEN_INVENTORY: {
                net.minecraft.world.entity.Entity entity = this.player.getVehicle();
                if (!(entity instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)((Object)entity);
                hascustominventoryscreen.openCustomInventoryScreen(this.player);
                break;
            }
            case START_FALL_FLYING: {
                if (this.player.tryToStartFallFlying()) break;
                this.player.stopFallFlying();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingMessage(PlayerChatMessage message) {
        MessageSignature messagesignature = message.signature();
        if (messagesignature != null) {
            int i;
            this.messageSignatureCache.push(message.signedBody(), message.signature());
            LastSeenMessagesValidator lastseenmessagesvalidator = this.lastSeenMessages;
            LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
            synchronized (lastSeenMessagesValidator) {
                this.lastSeenMessages.addPending(messagesignature);
                i = this.lastSeenMessages.trackedMessagesCount();
            }
            if (i > 4096) {
                this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.too_many_pending_chats"), PlayerKickEvent.Cause.TOO_MANY_PENDING_CHATS);
            }
        }
    }

    public void sendPlayerChatMessage(PlayerChatMessage message, ChatType.Bound params) {
        if (!this.getCraftPlayer().canSeePlayer(message.link().sender())) {
            this.sendDisguisedChatMessage(message.decoratedContent(), params);
            return;
        }
        this.send(new ClientboundPlayerChatPacket(message.link().sender(), message.link().index(), message.signature(), message.signedBody().pack(this.messageSignatureCache), message.unsignedContent(), message.filterMask(), params));
        this.addPendingMessage(message);
    }

    public void sendDisguisedChatMessage(net.minecraft.network.chat.Component message, ChatType.Bound params) {
        this.send(new ClientboundDisguisedChatPacket(message, params));
    }

    public SocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public SocketAddress getRawAddress() {
        if (this.connection.channel.remoteAddress() == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return this.connection.channel.remoteAddress();
    }

    public void switchToConfig() {
        this.waitingForSwitchToConfig = true;
        this.removePlayerFromWorld();
        this.send(ClientboundStartConfigurationPacket.INSTANCE);
        this.connection.setupOutboundProtocol(ConfigurationProtocols.CLIENTBOUND);
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket packet) {
        this.connection.send(new ClientboundPongResponsePacket(packet.getTime()));
    }

    @Override
    public void handleInteract(final ServerboundInteractPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        final ServerLevel worldserver = this.player.serverLevel();
        final net.minecraft.world.entity.Entity entity = packet.getTarget(worldserver);
        if (entity == this.player && !this.player.isSpectator()) {
            this.disconnect("Cannot interact with self!", PlayerKickEvent.Cause.SELF_INTERACTION);
            return;
        }
        this.player.resetLastActionTime();
        this.player.setShiftKeyDown(packet.isUsingSecondaryAction());
        if (entity != null) {
            if (!worldserver.getWorldBorder().isWithinBounds(entity.blockPosition())) {
                return;
            }
            AABB axisalignedbb = entity.getBoundingBox();
            if (this.player.canInteractWithEntity(axisalignedbb, 1.0)) {
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.ticksSinceLastInteraction = 0;
                }
                packet.dispatch(new ServerboundInteractPacket.Handler(){

                    private void performInteraction(InteractionHand enumhand, EntityInteraction playerconnection_a, PlayerInteractEntityEvent event) {
                        ItemStack itemstack = ServerGamePacketListenerImpl.this.player.getItemInHand(enumhand);
                        if (itemstack.isItemEnabled(worldserver.enabledFeatures())) {
                            ItemStack itemstack1 = itemstack.copy();
                            ItemStack itemInHand = ServerGamePacketListenerImpl.this.player.getItemInHand(enumhand);
                            boolean triggerLeashUpdate = itemInHand != null && itemInHand.getItem() == Items.LEAD && entity instanceof Mob;
                            Item origItem = ServerGamePacketListenerImpl.this.player.getInventory().getSelected() == null ? null : ServerGamePacketListenerImpl.this.player.getInventory().getSelected().getItem();
                            ServerGamePacketListenerImpl.this.cserver.getPluginManager().callEvent((Event)event);
                            ServerGamePacketListenerImpl.this.player.processClick(enumhand);
                            if (entity instanceof Bucketable && entity instanceof LivingEntity && origItem != null && origItem.asItem() == Items.WATER_BUCKET && (event.isCancelled() || ServerGamePacketListenerImpl.this.player.getInventory().getSelected() == null || ServerGamePacketListenerImpl.this.player.getInventory().getSelected().getItem() != origItem)) {
                                entity.resendPossiblyDesyncedEntityData(ServerGamePacketListenerImpl.this.player);
                                ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                            }
                            if (triggerLeashUpdate && (event.isCancelled() || ServerGamePacketListenerImpl.this.player.getInventory().getSelected() == null || ServerGamePacketListenerImpl.this.player.getInventory().getSelected().getItem() != origItem)) {
                                ServerGamePacketListenerImpl.this.send(new ClientboundSetEntityLinkPacket(entity, ((Mob)entity).getLeashHolder()));
                            }
                            if (event.isCancelled() || ServerGamePacketListenerImpl.this.player.getInventory().getSelected() == null || ServerGamePacketListenerImpl.this.player.getInventory().getSelected().getItem() != origItem) {
                                entity.refreshEntityData(ServerGamePacketListenerImpl.this.player);
                                if (entity instanceof Allay) {
                                    ServerGamePacketListenerImpl.this.send(new ClientboundSetEquipmentPacket(entity.getId(), Arrays.stream(net.minecraft.world.entity.EquipmentSlot.values()).map(slot -> Pair.of((Object)slot, (Object)((LivingEntity)entity).getItemBySlot((net.minecraft.world.entity.EquipmentSlot)slot).copy())).collect(Collectors.toList()), true));
                                    ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                                }
                            }
                            if (event.isCancelled()) {
                                ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                                return;
                            }
                            InteractionResult enuminteractionresult = playerconnection_a.run(ServerGamePacketListenerImpl.this.player, entity, enumhand);
                            if (!itemInHand.isEmpty() && itemInHand.getCount() <= -1) {
                                ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                            }
                            if (enuminteractionresult.consumesAction()) {
                                CriteriaTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(ServerGamePacketListenerImpl.this.player, enuminteractionresult.indicateItemUse() ? itemstack1 : ItemStack.EMPTY, entity);
                                if (enuminteractionresult.shouldSwing()) {
                                    ServerGamePacketListenerImpl.this.player.swing(enumhand, true);
                                }
                            }
                        }
                    }

                    @Override
                    public void onInteraction(InteractionHand hand) {
                        this.performInteraction(hand, Player::interactOn, new PlayerInteractEntityEvent((org.bukkit.entity.Player)ServerGamePacketListenerImpl.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void onInteraction(InteractionHand hand, Vec3 pos) {
                        this.performInteraction(hand, (entityplayer, entity1, enumhand1) -> entity1.interactAt(entityplayer, pos, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((org.bukkit.entity.Player)ServerGamePacketListenerImpl.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(pos.x, pos.y, pos.z), hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void onAttack() {
                        AbstractArrow entityarrow;
                        if (!(entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity == ServerGamePacketListenerImpl.this.player && !ServerGamePacketListenerImpl.this.player.isSpectator() || entity instanceof AbstractArrow && !(entityarrow = (AbstractArrow)entity).isAttackable())) {
                            ItemStack itemstack = ServerGamePacketListenerImpl.this.player.getItemInHand(InteractionHand.MAIN_HAND);
                            if (!itemstack.isItemEnabled(worldserver.enabledFeatures())) {
                                return;
                            }
                            ServerGamePacketListenerImpl.this.player.attack(entity);
                            if (!itemstack.isEmpty() && itemstack.getCount() <= -1) {
                                ServerGamePacketListenerImpl.this.player.containerMenu.sendAllDataToRemote();
                            }
                            return;
                        }
                        ServerGamePacketListenerImpl.this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.invalid_entity_attacked"), PlayerKickEvent.Cause.INVALID_ENTITY_ATTACKED);
                        LOGGER.warn("Player {} tried to attack an invalid entity", (Object)ServerGamePacketListenerImpl.this.player.getName().getString());
                    }
                });
            }
        } else {
            packet.dispatch(new ServerboundInteractPacket.Handler(){

                @Override
                public void onInteraction(InteractionHand hand) {
                    CraftEventFactory.callPlayerUseUnknownEntityEvent(ServerGamePacketListenerImpl.this.player, packet, hand, null);
                }

                @Override
                public void onInteraction(InteractionHand hand, Vec3 pos) {
                    CraftEventFactory.callPlayerUseUnknownEntityEvent(ServerGamePacketListenerImpl.this.player, packet, hand, pos);
                }

                @Override
                public void onAttack() {
                    CraftEventFactory.callPlayerUseUnknownEntityEvent(ServerGamePacketListenerImpl.this.player, packet, InteractionHand.MAIN_HAND, null);
                }
            });
        }
    }

    @Override
    public void handleClientCommand(ServerboundClientCommandPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        this.player.resetLastActionTime();
        ServerboundClientCommandPacket.Action packetplayinclientcommand_enumclientcommand = packet.getAction();
        switch (packetplayinclientcommand_enumclientcommand) {
            case PERFORM_RESPAWN: {
                if (this.player.wonGame) {
                    this.player.wonGame = false;
                    this.player = this.server.getPlayerList().respawn(this.player, this.server.getLevel(this.player.getRespawnDimension()), true, null, true, PlayerRespawnEvent.RespawnReason.END_PORTAL, PlayerRespawnEvent.RespawnFlag.END_PORTAL);
                    CriteriaTriggers.CHANGED_DIMENSION.trigger(this.player, Level.END, Level.OVERWORLD);
                    break;
                }
                if (this.player.getHealth() > 0.0f) {
                    return;
                }
                this.player = this.server.getPlayerList().respawn(this.player, false, PlayerRespawnEvent.RespawnReason.DEATH);
                if (!this.server.isHardcore()) break;
                this.player.setGameMode(GameType.SPECTATOR, PlayerGameModeChangeEvent.Cause.HARDCORE_DEATH, null);
                this.player.level().getGameRules().getRule(GameRules.RULE_SPECTATORSGENERATECHUNKS).set(false, this.player.serverLevel());
                break;
            }
            case REQUEST_STATS: {
                this.player.getStats().sendStats(this.player);
            }
        }
    }

    @Override
    public void handleContainerClose(ServerboundContainerClosePacket packet) {
        this.handleContainerClose(packet, InventoryCloseEvent.Reason.PLAYER);
    }

    public void handleContainerClose(ServerboundContainerClosePacket packet, InventoryCloseEvent.Reason reason) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.player, reason);
        this.player.doCloseContainer();
    }

    @Override
    public void handleContainerClick(ServerboundContainerClickPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId == packet.getContainerId() && this.player.containerMenu.stillValid(this.player)) {
            boolean cancelled = this.player.isSpectator();
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                int i = packet.getSlotNum();
                if (!this.player.containerMenu.isValidSlotIndex(i)) {
                    LOGGER.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.player.getName(), i, this.player.containerMenu.slots.size()});
                } else {
                    boolean flag = packet.getStateId() != this.player.containerMenu.getStateId();
                    this.player.containerMenu.suppressRemoteUpdates();
                    if (packet.getSlotNum() < -1 && packet.getSlotNum() != -999) {
                        return;
                    }
                    InventoryView inventory = this.player.containerMenu.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType(packet.getSlotNum());
                    org.bukkit.event.inventory.ClickType click = org.bukkit.event.inventory.ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.EMPTY;
                    switch (packet.getClickType()) {
                        case PICKUP: {
                            if (packet.getButtonNum() == 0) {
                                click = org.bukkit.event.inventory.ClickType.LEFT;
                            } else if (packet.getButtonNum() == 1) {
                                click = org.bukkit.event.inventory.ClickType.RIGHT;
                            }
                            if (packet.getButtonNum() != 0 && packet.getButtonNum() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (packet.getSlotNum() == -999) {
                                if (this.player.containerMenu.getCarried().isEmpty()) break;
                                action = packet.getButtonNum() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (packet.getSlotNum() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.player.containerMenu.getSlot(packet.getSlotNum());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.getItem();
                            ItemStack cursor = this.player.containerMenu.getCarried();
                            if (clickedItem.isEmpty()) {
                                if (cursor.isEmpty()) break;
                                action = packet.getButtonNum() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.mayPickup(this.player)) break;
                            if (cursor.isEmpty()) {
                                action = packet.getButtonNum() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.mayPlace(cursor)) {
                                if (ItemStack.isSameItemSameComponents(clickedItem, cursor)) {
                                    int toPlace = packet.getButtonNum() == 0 ? cursor.getCount() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.getMaxStackSize() - clickedItem.getCount());
                                    if ((toPlace = Math.min(toPlace, slot.container.getMaxStackSize() - clickedItem.getCount())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.getCount()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.getCount() > slot.getMaxStackSize()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.isSameItemSameComponents(cursor, clickedItem) || clickedItem.getCount() < 0 || clickedItem.getCount() + cursor.getCount() > cursor.getMaxStackSize()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case QUICK_MOVE: {
                            if (packet.getButtonNum() == 0) {
                                click = org.bukkit.event.inventory.ClickType.SHIFT_LEFT;
                            } else if (packet.getButtonNum() == 1) {
                                click = org.bukkit.event.inventory.ClickType.SHIFT_RIGHT;
                            }
                            if (packet.getButtonNum() != 0 && packet.getButtonNum() != 1) break;
                            if (packet.getSlotNum() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.player.containerMenu.getSlot(packet.getSlotNum());
                            if (slot != null && slot.mayPickup(this.player) && slot.hasItem()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case SWAP: {
                            if ((packet.getButtonNum() < 0 || packet.getButtonNum() >= 9) && packet.getButtonNum() != 40) break;
                            if (packet.getSlotNum() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = packet.getButtonNum() == 40 ? org.bukkit.event.inventory.ClickType.SWAP_OFFHAND : org.bukkit.event.inventory.ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.player.containerMenu.getSlot(packet.getSlotNum());
                            if (clickedSlot.mayPickup(this.player)) {
                                ItemStack hotbar = this.player.getInventory().getItem(packet.getButtonNum());
                                if (!hotbar.isEmpty() && clickedSlot.mayPlace(hotbar) || hotbar.isEmpty() && clickedSlot.hasItem()) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case CLONE: {
                            Slot slot;
                            if (packet.getButtonNum() == 2) {
                                click = org.bukkit.event.inventory.ClickType.MIDDLE;
                                if (packet.getSlotNum() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.player.containerMenu.getSlot(packet.getSlotNum());
                                if (slot != null && slot.hasItem() && this.player.getAbilities().instabuild && this.player.containerMenu.getCarried().isEmpty()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = org.bukkit.event.inventory.ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case THROW: {
                            Slot slot;
                            if (packet.getSlotNum() >= 0) {
                                if (packet.getButtonNum() == 0) {
                                    click = org.bukkit.event.inventory.ClickType.DROP;
                                    slot = this.player.containerMenu.getSlot(packet.getSlotNum());
                                    if (slot != null && slot.hasItem() && slot.mayPickup(this.player) && !slot.getItem().isEmpty() && slot.getItem().getItem() != Item.byBlock(Blocks.AIR)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packet.getButtonNum() != 1) break;
                                click = org.bukkit.event.inventory.ClickType.CONTROL_DROP;
                                slot = this.player.containerMenu.getSlot(packet.getSlotNum());
                                if (slot != null && slot.hasItem() && slot.mayPickup(this.player) && !slot.getItem().isEmpty() && slot.getItem().getItem() != Item.byBlock(Blocks.AIR)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = org.bukkit.event.inventory.ClickType.LEFT;
                            if (packet.getButtonNum() == 1) {
                                click = org.bukkit.event.inventory.ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case QUICK_CRAFT: {
                            this.player.containerMenu.clicked(packet.getSlotNum(), packet.getButtonNum(), packet.getClickType(), this.player);
                            break;
                        }
                        case PICKUP_ALL: {
                            click = org.bukkit.event.inventory.ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (packet.getSlotNum() < 0 || this.player.containerMenu.getCarried().isEmpty()) break;
                            ItemStack cursor = this.player.containerMenu.getCarried();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftItemType.minecraftToBukkit(cursor.getItem())) && !inventory.getBottomInventory().contains(CraftItemType.minecraftToBukkit(cursor.getItem()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packet.getClickType() != ClickType.QUICK_CRAFT) {
                        CartographyInventory cartographyInventory;
                        org.bukkit.inventory.ItemStack result;
                        org.bukkit.inventory.ItemStack result2;
                        Recipe recipe;
                        InventoryClickEvent event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, packet.getSlotNum(), click, action, packet.getButtonNum()) : new InventoryClickEvent(inventory, type, packet.getSlotNum(), click, action);
                        Inventory top = inventory.getTopInventory();
                        if (packet.getSlotNum() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, packet.getSlotNum(), click, action, packet.getButtonNum()) : new CraftItemEvent(recipe, inventory, type, packet.getSlotNum(), click, action);
                        }
                        if (packet.getSlotNum() == 3 && top instanceof SmithingInventory && (result2 = ((SmithingInventory)top).getResult()) != null) {
                            event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, packet.getSlotNum(), click, action, packet.getButtonNum()) : new SmithItemEvent(inventory, type, packet.getSlotNum(), click, action);
                        }
                        if (packet.getSlotNum() == 2 && top instanceof CartographyInventory && (result = (cartographyInventory = (CartographyInventory)top).getResult()) != null && !result.isEmpty()) {
                            event = click == org.bukkit.event.inventory.ClickType.NUMBER_KEY ? new CartographyItemEvent(inventory, type, packet.getSlotNum(), click, action, packet.getButtonNum()) : new CartographyItemEvent(inventory, type, packet.getSlotNum(), click, action);
                        }
                        event.setCancelled(cancelled);
                        AbstractContainerMenu oldContainer = this.player.containerMenu;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.player.containerMenu != oldContainer) {
                            return;
                        }
                        block9 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.player.containerMenu.clicked(i, packet.getButtonNum(), packet.getClickType(), this.player);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.player.containerMenu.sendAllDataToRemote();
                                        break block9;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.player.connection.send(new ClientboundContainerSetSlotPacket(-1, -1, this.player.inventoryMenu.incrementStateId(), this.player.containerMenu.getCarried()));
                                        this.player.connection.send(new ClientboundContainerSetSlotPacket(this.player.containerMenu.containerId, this.player.inventoryMenu.incrementStateId(), packet.getSlotNum(), this.player.containerMenu.getSlot(packet.getSlotNum()).getItem()));
                                        break block9;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.player.connection.send(new ClientboundContainerSetSlotPacket(this.player.containerMenu.containerId, this.player.inventoryMenu.incrementStateId(), packet.getSlotNum(), this.player.containerMenu.getSlot(packet.getSlotNum()).getItem()));
                                        break block9;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.player.connection.send(new ClientboundContainerSetSlotPacket(-1, -1, this.player.inventoryMenu.incrementStateId(), this.player.containerMenu.getCarried()));
                                        break block9;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.player.containerMenu.sendAllDataToRemote();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packet.getChangedSlots())) {
                        this.player.containerMenu.setRemoteSlotNoCopy(entry.getIntKey(), (ItemStack)entry.getValue());
                    }
                    this.player.containerMenu.setRemoteCarried(packet.getCarriedItem());
                    this.player.containerMenu.resumeRemoteUpdates();
                    if (flag) {
                        this.player.containerMenu.broadcastFullState();
                    } else {
                        this.player.containerMenu.broadcastChanges();
                    }
                }
            }
        }
    }

    @Override
    public void handlePlaceRecipe(ServerboundPlaceRecipePacket packet) {
        if (!Bukkit.isPrimaryThread() && this.recipeSpamPackets.addAndGet(GlobalConfiguration.get().spamLimiter.recipeSpamIncrement) > GlobalConfiguration.get().spamLimiter.recipeSpamLimit) {
            this.server.scheduleOnMain(() -> this.disconnect(net.minecraft.network.chat.Component.translatable("disconnect.spam"), PlayerKickEvent.Cause.SPAM));
            return;
        }
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        this.player.resetLastActionTime();
        if (!this.player.isSpectator() && this.player.containerMenu.containerId == packet.getContainerId() && this.player.containerMenu instanceof RecipeBookMenu) {
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                AbstractContainerMenu event;
                ResourceLocation recipeName = packet.getRecipe();
                boolean makeAll = packet.isShiftDown();
                PlayerRecipeBookClickEvent paperEvent = new PlayerRecipeBookClickEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(recipeName), makeAll);
                if (!paperEvent.callEvent()) {
                    return;
                }
                recipeName = CraftNamespacedKey.toMinecraft(paperEvent.getRecipe());
                makeAll = paperEvent.isMakeAll();
                if (org.bukkit.event.player.PlayerRecipeBookClickEvent.getHandlerList().getRegisteredListeners().length > 0) {
                    Recipe recipe = this.cserver.getRecipe(CraftNamespacedKey.fromMinecraft(recipeName));
                    if (recipe == null) {
                        return;
                    }
                    event = CraftEventFactory.callRecipeBookClickEvent(this.player, recipe, makeAll);
                    recipeName = CraftNamespacedKey.toMinecraft(((Keyed)event.getRecipe()).getKey());
                    makeAll = event.isShiftClick();
                }
                if (!((event = this.player.containerMenu) instanceof RecipeBookMenu)) {
                    return;
                }
                RecipeBookMenu recipeBookMenu = (RecipeBookMenu)event;
                boolean finalMakeAll = makeAll;
                this.server.getRecipeManager().byKey(recipeName).ifPresent(recipeholder -> recipeBookMenu.handlePlacement(finalMakeAll, (RecipeHolder<?>)recipeholder, this.player));
            }
        }
    }

    @Override
    public void handleContainerButtonClick(ServerboundContainerButtonClickPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId == packet.containerId() && !this.player.isSpectator()) {
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            } else {
                boolean flag = this.player.containerMenu.clickMenuButton(this.player, packet.buttonId());
                if (flag) {
                    this.player.containerMenu.broadcastChanges();
                }
            }
        }
    }

    @Override
    public void handleSetCreativeModeSlot(ServerboundSetCreativeModeSlotPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.gameMode.isCreative()) {
            boolean flag2;
            boolean flag = packet.slotNum() < 0;
            ItemStack itemstack = packet.itemStack();
            if (!itemstack.isItemEnabled(this.player.level().enabledFeatures())) {
                return;
            }
            CustomData customdata = itemstack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY);
            if (customdata.contains("x") && customdata.contains("y") && customdata.contains("z") && this.player.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                BlockPos blockposition = BlockEntity.getPosFromTag(customdata.getUnsafe());
                if (this.player.level().isLoaded(blockposition)) {
                    BlockEntity tileentity = null;
                    if (this.player.distanceToSqr(blockposition.getX(), blockposition.getY(), blockposition.getZ()) < 1024.0 && this.player.serverLevel().isLoadedAndInBounds(blockposition)) {
                        tileentity = this.player.level().getBlockEntity(blockposition);
                    }
                    if (tileentity != null) {
                        tileentity.saveToItem(itemstack, this.player.level().registryAccess());
                    }
                }
            }
            boolean flag1 = packet.slotNum() >= 1 && packet.slotNum() <= 45;
            boolean bl = flag2 = itemstack.isEmpty() || itemstack.getCount() <= itemstack.getMaxStackSize();
            if (flag || flag1 && !ItemStack.matches(this.player.inventoryMenu.getSlot(packet.slotNum()).getItem(), packet.itemStack())) {
                CraftInventoryView inventory = this.player.inventoryMenu.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packet.itemStack());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packet.slotNum() < 36) {
                    type = packet.slotNum() >= 5 && packet.slotNum() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : (int)packet.slotNum(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packet.slotNum() >= 0) {
                            this.player.connection.send(new ClientboundContainerSetSlotPacket(this.player.inventoryMenu.containerId, this.player.inventoryMenu.incrementStateId(), packet.slotNum(), this.player.inventoryMenu.getSlot(packet.slotNum()).getItem()));
                            this.player.connection.send(new ClientboundContainerSetSlotPacket(-1, this.player.inventoryMenu.incrementStateId(), -1, ItemStack.EMPTY));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.player.inventoryMenu.getSlot(packet.slotNum()).setByPlayer(itemstack);
                this.player.inventoryMenu.broadcastChanges();
            } else if (flag && flag2 && this.dropSpamTickCount < 200) {
                this.dropSpamTickCount += 20;
                this.player.drop(itemstack, true);
            }
        }
    }

    @Override
    public void handleSignUpdate(ServerboundSignUpdatePacket packet) {
        String[] lines = packet.getLines();
        for (int i = 0; i < lines.length; ++i) {
            int offset;
            if (MAX_SIGN_LINE_LENGTH <= 0 || lines[i].length() <= MAX_SIGN_LINE_LENGTH || (offset = lines[i].codePoints().limit(MAX_SIGN_LINE_LENGTH).map(Character::charCount).sum()) >= lines[i].length()) continue;
            lines[i] = lines[i].substring(0, offset);
        }
        List<String> list = Stream.of(lines).map(ChatFormatting::stripFormatting).collect(Collectors.toList());
        this.filterTextPacket(list).thenAcceptAsync(list1 -> this.updateSignText(packet, (List<FilteredText>)list1), (Executor)this.server);
    }

    private void updateSignText(ServerboundSignUpdatePacket packet, List<FilteredText> signText) {
        if (this.player.isImmobile()) {
            return;
        }
        this.player.resetLastActionTime();
        ServerLevel worldserver = this.player.serverLevel();
        BlockPos blockposition = packet.getPos();
        if (worldserver.hasChunkAt(blockposition)) {
            BlockEntity tileentity = worldserver.getBlockEntity(blockposition);
            if (!(tileentity instanceof SignBlockEntity)) {
                return;
            }
            SignBlockEntity tileentitysign = (SignBlockEntity)tileentity;
            tileentitysign.updateSignText(this.player, packet.isFrontText(), signText);
        }
    }

    @Override
    public void handlePlayerAbilities(ServerboundPlayerAbilitiesPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.getAbilities().mayfly && this.player.getAbilities().flying != packet.isFlying()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((org.bukkit.entity.Player)this.player.getBukkitEntity(), packet.isFlying());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.player.getAbilities().flying = packet.isFlying();
            } else {
                this.player.onUpdateAbilities();
            }
        }
    }

    @Override
    public void handleClientInformation(ServerboundClientInformationPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (packet.information().viewDistance() < 0) {
            LOGGER.warn("Disconnecting " + this.player.getScoreboardName() + " for invalid view distance: " + packet.information().viewDistance());
            this.disconnect("Invalid client settings", PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        this.player.updateOptions(packet.information());
        this.connection.channel.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)Translator.parseLocale((String)packet.information().language()));
    }

    @Override
    public void handleChangeDifficulty(ServerboundChangeDifficultyPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.hasPermissions(2) || this.isSingleplayerOwner()) {
            // empty if block
        }
    }

    @Override
    public void handleLockDifficulty(ServerboundLockDifficultyPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        if (this.player.hasPermissions(2) || this.isSingleplayerOwner()) {
            this.server.setDifficultyLocked(packet.isLocked());
        }
    }

    @Override
    public void handleChatSessionUpdate(ServerboundChatSessionUpdatePacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        RemoteChatSession.Data remotechatsession_a = packet.chatSession();
        ProfilePublicKey.Data profilepublickey_a = this.chatSession != null ? this.chatSession.profilePublicKey().data() : null;
        ProfilePublicKey.Data profilepublickey_a1 = remotechatsession_a.profilePublicKey();
        if (!Objects.equals(profilepublickey_a, profilepublickey_a1)) {
            if (profilepublickey_a != null && profilepublickey_a1.expiresAt().isBefore(profilepublickey_a.expiresAt())) {
                this.disconnect(ProfilePublicKey.EXPIRED_PROFILE_PUBLIC_KEY, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
            } else {
                try {
                    SignatureValidator signaturevalidator = this.server.getProfileKeySignatureValidator();
                    if (signaturevalidator == null) {
                        LOGGER.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.player.getGameProfile().getName());
                        return;
                    }
                    this.resetPlayerChatState(remotechatsession_a.validate(this.player.getGameProfile(), signaturevalidator));
                }
                catch (ProfilePublicKey.ValidationException profilepublickey_b) {
                    this.disconnect(profilepublickey_b.getComponent(), profilepublickey_b.kickCause);
                }
            }
        }
    }

    @Override
    public void handleConfigurationAcknowledged(ServerboundConfigurationAcknowledgedPacket packet) {
        if (!this.waitingForSwitchToConfig) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.connection.setupInboundProtocol(ConfigurationProtocols.SERVERBOUND, new ServerConfigurationPacketListenerImpl(this.server, this.connection, this.createCookie(this.player.clientInformation()), this.player));
    }

    @Override
    public void handleChunkBatchReceived(ServerboundChunkBatchReceivedPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        this.chunkSender.onChunkBatchReceivedByClient(packet.desiredChunksPerTick());
    }

    @Override
    public void handleDebugSampleSubscription(ServerboundDebugSampleSubscriptionPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.player.serverLevel());
        this.server.subscribeToDebugSample(this.player, packet.sampleType());
    }

    private void resetPlayerChatState(RemoteChatSession session) {
        this.chatSession = session;
        this.hasLoggedExpiry = false;
        this.signedMessageDecoder = session.createMessageDecoder(this.player.getUUID());
        this.chatMessageChain.append(() -> {
            this.player.setChatSession(session);
            this.server.getPlayerList().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.INITIALIZE_CHAT), (Collection<ServerPlayer>)List.of(this.player)), this.player);
        });
    }

    @Override
    public ServerPlayer getPlayer() {
        return this.player;
    }

    private PlayerFailMoveEvent fireFailMove(PlayerFailMoveEvent.FailReason failReason, double toX, double toY, double toZ, float toYaw, float toPitch, boolean logWarning) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
        Location to = new Location(player.getWorld(), toX, toY, toZ, toYaw, toPitch);
        PlayerFailMoveEvent event = new PlayerFailMoveEvent((org.bukkit.entity.Player)player, failReason, false, logWarning, from, to);
        event.callEvent();
        return event;
    }

    private /* synthetic */ void lambda$handleChat$16(PlayerChatMessage playerchatmessage, CompletableFuture componentFuture, CompletableFuture completablefuture, Void filteredtext) {
        PlayerChatMessage playerchatmessage1 = playerchatmessage.withUnsignedContent((net.minecraft.network.chat.Component)componentFuture.join()).filter(((FilteredText)completablefuture.join()).mask());
        this.broadcastChatMessage(playerchatmessage1);
    }

    @FunctionalInterface
    private static interface EntityInteraction {
        public InteractionResult run(ServerPlayer var1, net.minecraft.world.entity.Entity var2, InteractionHand var3);
    }
}

