/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    private static final Map<RecipeBookType, Pair<String, String>> TAG_FIELDS = ImmutableMap.of((Object)((Object)RecipeBookType.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookType, TypeSettings> states;

    private RecipeBookSettings(Map<RecipeBookType, TypeSettings> categoryOptions) {
        this.states = categoryOptions;
    }

    public RecipeBookSettings() {
        this(Util.make(Maps.newEnumMap(RecipeBookType.class), categoryOptions -> {
            for (RecipeBookType recipeBookType : RecipeBookType.values()) {
                categoryOptions.put(recipeBookType, new TypeSettings(false, false));
            }
        }));
    }

    public boolean isOpen(RecipeBookType category) {
        return this.states.get((Object)((Object)category)).open;
    }

    public void setOpen(RecipeBookType category, boolean open) {
        this.states.get((Object)((Object)category)).open = open;
    }

    public boolean isFiltering(RecipeBookType category) {
        return this.states.get((Object)((Object)category)).filtering;
    }

    public void setFiltering(RecipeBookType category, boolean filtering) {
        this.states.get((Object)((Object)category)).filtering = filtering;
    }

    public static RecipeBookSettings read(FriendlyByteBuf buf) {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            boolean bl = buf.readBoolean();
            boolean bl2 = buf.readBoolean();
            map.put(recipeBookType, new TypeSettings(bl, bl2));
        }
        return new RecipeBookSettings(map);
    }

    public void write(FriendlyByteBuf buf) {
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            TypeSettings typeSettings = this.states.get((Object)recipeBookType);
            if (typeSettings == null) {
                buf.writeBoolean(false);
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(typeSettings.open);
            buf.writeBoolean(typeSettings.filtering);
        }
    }

    public static RecipeBookSettings read(CompoundTag nbt) {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        TAG_FIELDS.forEach((category, pair) -> {
            boolean bl = nbt.getBoolean((String)pair.getFirst());
            boolean bl2 = nbt.getBoolean((String)pair.getSecond());
            map.put(category, new TypeSettings(bl, bl2));
        });
        return new RecipeBookSettings(map);
    }

    public void write(CompoundTag nbt) {
        TAG_FIELDS.forEach((category, pair) -> {
            TypeSettings typeSettings = this.states.get(category);
            nbt.putBoolean((String)pair.getFirst(), typeSettings.open);
            nbt.putBoolean((String)pair.getSecond(), typeSettings.filtering);
        });
    }

    public RecipeBookSettings copy() {
        EnumMap map = Maps.newEnumMap(RecipeBookType.class);
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            TypeSettings typeSettings = this.states.get((Object)recipeBookType);
            map.put(recipeBookType, typeSettings.copy());
        }
        return new RecipeBookSettings(map);
    }

    public void replaceFrom(RecipeBookSettings other) {
        this.states.clear();
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            TypeSettings typeSettings = other.states.get((Object)recipeBookType);
            this.states.put(recipeBookType, typeSettings.copy());
        }
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof RecipeBookSettings && this.states.equals(((RecipeBookSettings)object).states);
    }

    @Override
    public int hashCode() {
        return this.states.hashCode();
    }

    static final class TypeSettings {
        boolean open;
        boolean filtering;

        public TypeSettings(boolean guiOpen, boolean filteringCraftable) {
            this.open = guiOpen;
            this.filtering = filteringCraftable;
        }

        public TypeSettings copy() {
            return new TypeSettings(this.open, this.filtering);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof TypeSettings) {
                TypeSettings typeSettings = (TypeSettings)object;
                return this.open == typeSettings.open && this.filtering == typeSettings.filtering;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int i = this.open ? 1 : 0;
            i = 31 * i + (this.filtering ? 1 : 0);
            return i;
        }

        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }
    }
}

