/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.entity.player.Player;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Cancellable;

public class StatsCounter {
    protected final Object2IntMap<Stat<?>> stats = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());

    public StatsCounter() {
        this.stats.defaultReturnValue(0);
    }

    public void increment(Player player, Stat<?> stat, int value) {
        int j = (int)Math.min((long)this.getValue(stat) + (long)value, Integer.MAX_VALUE);
        Cancellable cancellable = CraftEventFactory.handleStatisticsIncrease(player, stat, this.getValue(stat), j);
        if (cancellable != null && cancellable.isCancelled()) {
            return;
        }
        this.setValue(player, stat, j);
    }

    public void setValue(Player player, Stat<?> stat, int value) {
        this.stats.put(stat, value);
    }

    public <T> int getValue(StatType<T> type, T stat) {
        return type.contains(stat) ? this.getValue(type.get(stat)) : 0;
    }

    public int getValue(Stat<?> stat) {
        return this.stats.getInt(stat);
    }
}

