/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.util.datafix.PackedBitStorage;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.util.datafix.fixes.References;
import org.slf4j.Logger;

public class ChunkPalettedStorageFix
extends DataFix {
    private static final int NORTH_WEST_MASK = 128;
    private static final int WEST_MASK = 64;
    private static final int SOUTH_WEST_MASK = 32;
    private static final int SOUTH_MASK = 16;
    private static final int SOUTH_EAST_MASK = 8;
    private static final int EAST_MASK = 4;
    private static final int NORTH_EAST_MASK = 2;
    private static final int NORTH_MASK = 1;
    static final Logger LOGGER = LogUtils.getLogger();
    static final BitSet VIRTUAL = new BitSet(256);
    static final BitSet FIX = new BitSet(256);
    static final Dynamic<?> PUMPKIN = BlockStateData.parse("{Name:'minecraft:pumpkin'}");
    static final Dynamic<?> SNOWY_PODZOL = BlockStateData.parse("{Name:'minecraft:podzol',Properties:{snowy:'true'}}");
    static final Dynamic<?> SNOWY_GRASS = BlockStateData.parse("{Name:'minecraft:grass_block',Properties:{snowy:'true'}}");
    static final Dynamic<?> SNOWY_MYCELIUM = BlockStateData.parse("{Name:'minecraft:mycelium',Properties:{snowy:'true'}}");
    static final Dynamic<?> UPPER_SUNFLOWER = BlockStateData.parse("{Name:'minecraft:sunflower',Properties:{half:'upper'}}");
    static final Dynamic<?> UPPER_LILAC = BlockStateData.parse("{Name:'minecraft:lilac',Properties:{half:'upper'}}");
    static final Dynamic<?> UPPER_TALL_GRASS = BlockStateData.parse("{Name:'minecraft:tall_grass',Properties:{half:'upper'}}");
    static final Dynamic<?> UPPER_LARGE_FERN = BlockStateData.parse("{Name:'minecraft:large_fern',Properties:{half:'upper'}}");
    static final Dynamic<?> UPPER_ROSE_BUSH = BlockStateData.parse("{Name:'minecraft:rose_bush',Properties:{half:'upper'}}");
    static final Dynamic<?> UPPER_PEONY = BlockStateData.parse("{Name:'minecraft:peony',Properties:{half:'upper'}}");
    static final Map<String, Dynamic<?>> FLOWER_POT_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        map.put("minecraft:air0", BlockStateData.parse("{Name:'minecraft:flower_pot'}"));
        map.put("minecraft:red_flower0", BlockStateData.parse("{Name:'minecraft:potted_poppy'}"));
        map.put("minecraft:red_flower1", BlockStateData.parse("{Name:'minecraft:potted_blue_orchid'}"));
        map.put("minecraft:red_flower2", BlockStateData.parse("{Name:'minecraft:potted_allium'}"));
        map.put("minecraft:red_flower3", BlockStateData.parse("{Name:'minecraft:potted_azure_bluet'}"));
        map.put("minecraft:red_flower4", BlockStateData.parse("{Name:'minecraft:potted_red_tulip'}"));
        map.put("minecraft:red_flower5", BlockStateData.parse("{Name:'minecraft:potted_orange_tulip'}"));
        map.put("minecraft:red_flower6", BlockStateData.parse("{Name:'minecraft:potted_white_tulip'}"));
        map.put("minecraft:red_flower7", BlockStateData.parse("{Name:'minecraft:potted_pink_tulip'}"));
        map.put("minecraft:red_flower8", BlockStateData.parse("{Name:'minecraft:potted_oxeye_daisy'}"));
        map.put("minecraft:yellow_flower0", BlockStateData.parse("{Name:'minecraft:potted_dandelion'}"));
        map.put("minecraft:sapling0", BlockStateData.parse("{Name:'minecraft:potted_oak_sapling'}"));
        map.put("minecraft:sapling1", BlockStateData.parse("{Name:'minecraft:potted_spruce_sapling'}"));
        map.put("minecraft:sapling2", BlockStateData.parse("{Name:'minecraft:potted_birch_sapling'}"));
        map.put("minecraft:sapling3", BlockStateData.parse("{Name:'minecraft:potted_jungle_sapling'}"));
        map.put("minecraft:sapling4", BlockStateData.parse("{Name:'minecraft:potted_acacia_sapling'}"));
        map.put("minecraft:sapling5", BlockStateData.parse("{Name:'minecraft:potted_dark_oak_sapling'}"));
        map.put("minecraft:red_mushroom0", BlockStateData.parse("{Name:'minecraft:potted_red_mushroom'}"));
        map.put("minecraft:brown_mushroom0", BlockStateData.parse("{Name:'minecraft:potted_brown_mushroom'}"));
        map.put("minecraft:deadbush0", BlockStateData.parse("{Name:'minecraft:potted_dead_bush'}"));
        map.put("minecraft:tallgrass2", BlockStateData.parse("{Name:'minecraft:potted_fern'}"));
        map.put("minecraft:cactus0", BlockStateData.getTag(2240));
    });
    static final Map<String, Dynamic<?>> SKULL_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        ChunkPalettedStorageFix.mapSkull(map, 0, "skeleton", "skull");
        ChunkPalettedStorageFix.mapSkull(map, 1, "wither_skeleton", "skull");
        ChunkPalettedStorageFix.mapSkull(map, 2, "zombie", "head");
        ChunkPalettedStorageFix.mapSkull(map, 3, "player", "head");
        ChunkPalettedStorageFix.mapSkull(map, 4, "creeper", "head");
        ChunkPalettedStorageFix.mapSkull(map, 5, "dragon", "head");
    });
    static final Map<String, Dynamic<?>> DOOR_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        ChunkPalettedStorageFix.mapDoor(map, "oak_door", 1024);
        ChunkPalettedStorageFix.mapDoor(map, "iron_door", 1136);
        ChunkPalettedStorageFix.mapDoor(map, "spruce_door", 3088);
        ChunkPalettedStorageFix.mapDoor(map, "birch_door", 3104);
        ChunkPalettedStorageFix.mapDoor(map, "jungle_door", 3120);
        ChunkPalettedStorageFix.mapDoor(map, "acacia_door", 3136);
        ChunkPalettedStorageFix.mapDoor(map, "dark_oak_door", 3152);
    });
    static final Map<String, Dynamic<?>> NOTE_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        for (int i = 0; i < 26; ++i) {
            map.put("true" + i, BlockStateData.parse("{Name:'minecraft:note_block',Properties:{powered:'true',note:'" + i + "'}}"));
            map.put("false" + i, BlockStateData.parse("{Name:'minecraft:note_block',Properties:{powered:'false',note:'" + i + "'}}"));
        }
    });
    private static final Int2ObjectMap<String> DYE_COLOR_MAP = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), map -> {
        map.put(0, (Object)"white");
        map.put(1, (Object)"orange");
        map.put(2, (Object)"magenta");
        map.put(3, (Object)"light_blue");
        map.put(4, (Object)"yellow");
        map.put(5, (Object)"lime");
        map.put(6, (Object)"pink");
        map.put(7, (Object)"gray");
        map.put(8, (Object)"light_gray");
        map.put(9, (Object)"cyan");
        map.put(10, (Object)"purple");
        map.put(11, (Object)"blue");
        map.put(12, (Object)"brown");
        map.put(13, (Object)"green");
        map.put(14, (Object)"red");
        map.put(15, (Object)"black");
    });
    static final Map<String, Dynamic<?>> BED_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        for (Int2ObjectMap.Entry entry : DYE_COLOR_MAP.int2ObjectEntrySet()) {
            if (Objects.equals(entry.getValue(), "red")) continue;
            ChunkPalettedStorageFix.addBeds(map, entry.getIntKey(), (String)entry.getValue());
        }
    });
    static final Map<String, Dynamic<?>> BANNER_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), map -> {
        for (Int2ObjectMap.Entry entry : DYE_COLOR_MAP.int2ObjectEntrySet()) {
            if (Objects.equals(entry.getValue(), "white")) continue;
            ChunkPalettedStorageFix.addBanners(map, 15 - entry.getIntKey(), (String)entry.getValue());
        }
    });
    static final Dynamic<?> AIR;
    private static final int SIZE = 4096;

    public ChunkPalettedStorageFix(Schema schema, boolean bl) {
        super(schema, bl);
    }

    private static void mapSkull(Map<String, Dynamic<?>> out, int variant, String mob, String block) {
        out.put(variant + "north", BlockStateData.parse("{Name:'minecraft:" + mob + "_wall_" + block + "',Properties:{facing:'north'}}"));
        out.put(variant + "east", BlockStateData.parse("{Name:'minecraft:" + mob + "_wall_" + block + "',Properties:{facing:'east'}}"));
        out.put(variant + "south", BlockStateData.parse("{Name:'minecraft:" + mob + "_wall_" + block + "',Properties:{facing:'south'}}"));
        out.put(variant + "west", BlockStateData.parse("{Name:'minecraft:" + mob + "_wall_" + block + "',Properties:{facing:'west'}}"));
        for (int i = 0; i < 16; ++i) {
            out.put("" + variant + i, BlockStateData.parse("{Name:'minecraft:" + mob + "_" + block + "',Properties:{rotation:'" + i + "'}}"));
        }
    }

    private static void mapDoor(Map<String, Dynamic<?>> out, String name, int firstStateId) {
        out.put("minecraft:" + name + "eastlowerleftfalsefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "eastlowerleftfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "eastlowerlefttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "eastlowerlefttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "eastlowerrightfalsefalse", BlockStateData.getTag(firstStateId));
        out.put("minecraft:" + name + "eastlowerrightfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "eastlowerrighttruefalse", BlockStateData.getTag(firstStateId + 4));
        out.put("minecraft:" + name + "eastlowerrighttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "eastupperleftfalsefalse", BlockStateData.getTag(firstStateId + 8));
        out.put("minecraft:" + name + "eastupperleftfalsetrue", BlockStateData.getTag(firstStateId + 10));
        out.put("minecraft:" + name + "eastupperlefttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "eastupperlefttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "eastupperrightfalsefalse", BlockStateData.getTag(firstStateId + 9));
        out.put("minecraft:" + name + "eastupperrightfalsetrue", BlockStateData.getTag(firstStateId + 11));
        out.put("minecraft:" + name + "eastupperrighttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "eastupperrighttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "northlowerleftfalsefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "northlowerleftfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "northlowerlefttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "northlowerlefttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "northlowerrightfalsefalse", BlockStateData.getTag(firstStateId + 3));
        out.put("minecraft:" + name + "northlowerrightfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "northlowerrighttruefalse", BlockStateData.getTag(firstStateId + 7));
        out.put("minecraft:" + name + "northlowerrighttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "northupperleftfalsefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "northupperleftfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "northupperlefttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "northupperlefttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "northupperrightfalsefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "northupperrightfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "northupperrighttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "northupperrighttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "southlowerleftfalsefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "southlowerleftfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "southlowerlefttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "southlowerlefttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "southlowerrightfalsefalse", BlockStateData.getTag(firstStateId + 1));
        out.put("minecraft:" + name + "southlowerrightfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "southlowerrighttruefalse", BlockStateData.getTag(firstStateId + 5));
        out.put("minecraft:" + name + "southlowerrighttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "southupperleftfalsefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "southupperleftfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "southupperlefttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "southupperlefttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "southupperrightfalsefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "southupperrightfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "southupperrighttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "southupperrighttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "westlowerleftfalsefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "westlowerleftfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "westlowerlefttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "westlowerlefttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "westlowerrightfalsefalse", BlockStateData.getTag(firstStateId + 2));
        out.put("minecraft:" + name + "westlowerrightfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "westlowerrighttruefalse", BlockStateData.getTag(firstStateId + 6));
        out.put("minecraft:" + name + "westlowerrighttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "westupperleftfalsefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "westupperleftfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "westupperlefttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "westupperlefttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        out.put("minecraft:" + name + "westupperrightfalsefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        out.put("minecraft:" + name + "westupperrightfalsetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        out.put("minecraft:" + name + "westupperrighttruefalse", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        out.put("minecraft:" + name + "westupperrighttruetrue", BlockStateData.parse("{Name:'minecraft:" + name + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
    }

    private static void addBeds(Map<String, Dynamic<?>> out, int colorId, String color) {
        out.put("southfalsefoot" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'south',occupied:'false',part:'foot'}}"));
        out.put("westfalsefoot" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'west',occupied:'false',part:'foot'}}"));
        out.put("northfalsefoot" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'north',occupied:'false',part:'foot'}}"));
        out.put("eastfalsefoot" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'east',occupied:'false',part:'foot'}}"));
        out.put("southfalsehead" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'south',occupied:'false',part:'head'}}"));
        out.put("westfalsehead" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'west',occupied:'false',part:'head'}}"));
        out.put("northfalsehead" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'north',occupied:'false',part:'head'}}"));
        out.put("eastfalsehead" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'east',occupied:'false',part:'head'}}"));
        out.put("southtruehead" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'south',occupied:'true',part:'head'}}"));
        out.put("westtruehead" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'west',occupied:'true',part:'head'}}"));
        out.put("northtruehead" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'north',occupied:'true',part:'head'}}"));
        out.put("easttruehead" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_bed',Properties:{facing:'east',occupied:'true',part:'head'}}"));
    }

    private static void addBanners(Map<String, Dynamic<?>> out, int colorId, String color) {
        for (int i = 0; i < 16; ++i) {
            out.put(i + "_" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_banner',Properties:{rotation:'" + i + "'}}"));
        }
        out.put("north_" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_wall_banner',Properties:{facing:'north'}}"));
        out.put("south_" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_wall_banner',Properties:{facing:'south'}}"));
        out.put("west_" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_wall_banner',Properties:{facing:'west'}}"));
        out.put("east_" + colorId, BlockStateData.parse("{Name:'minecraft:" + color + "_wall_banner',Properties:{facing:'east'}}"));
    }

    public static String getName(Dynamic<?> dynamic) {
        return dynamic.get("Name").asString("");
    }

    public static String getProperty(Dynamic<?> dynamic, String string) {
        return dynamic.get("Properties").get(string).asString("");
    }

    public static int idFor(CrudeIncrementalIntIdentityHashBiMap<Dynamic<?>> crudeIncrementalIntIdentityHashBiMap, Dynamic<?> dynamic) {
        int i = crudeIncrementalIntIdentityHashBiMap.getId(dynamic);
        if (i == -1) {
            i = crudeIncrementalIntIdentityHashBiMap.add(dynamic);
        }
        return i;
    }

    private Dynamic<?> fix(Dynamic<?> dynamic) {
        Optional optional = dynamic.get("Level").result();
        if (optional.isPresent() && ((Dynamic)((Object)optional.get())).get("Sections").asStreamOpt().result().isPresent()) {
            return dynamic.set("Level", new UpgradeChunk((Dynamic)((Object)optional.get())).write());
        }
        return dynamic;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.CHUNK);
        Type type2 = this.getOutputSchema().getType(References.CHUNK);
        return this.writeFixAndRead("ChunkPalettedStorageFix", type, type2, this::fix);
    }

    public static int getSideMask(boolean west, boolean east, boolean north, boolean south) {
        int i = 0;
        if (north) {
            i = east ? (i |= 2) : (west ? (i |= 0x80) : (i |= 1));
        } else if (south) {
            i = west ? (i |= 0x20) : (east ? (i |= 8) : (i |= 0x10));
        } else if (east) {
            i |= 4;
        } else if (west) {
            i |= 0x40;
        }
        return i;
    }

    static {
        FIX.set(2);
        FIX.set(3);
        FIX.set(110);
        FIX.set(140);
        FIX.set(144);
        FIX.set(25);
        FIX.set(86);
        FIX.set(26);
        FIX.set(176);
        FIX.set(177);
        FIX.set(175);
        FIX.set(64);
        FIX.set(71);
        FIX.set(193);
        FIX.set(194);
        FIX.set(195);
        FIX.set(196);
        FIX.set(197);
        VIRTUAL.set(54);
        VIRTUAL.set(146);
        VIRTUAL.set(25);
        VIRTUAL.set(26);
        VIRTUAL.set(51);
        VIRTUAL.set(53);
        VIRTUAL.set(67);
        VIRTUAL.set(108);
        VIRTUAL.set(109);
        VIRTUAL.set(114);
        VIRTUAL.set(128);
        VIRTUAL.set(134);
        VIRTUAL.set(135);
        VIRTUAL.set(136);
        VIRTUAL.set(156);
        VIRTUAL.set(163);
        VIRTUAL.set(164);
        VIRTUAL.set(180);
        VIRTUAL.set(203);
        VIRTUAL.set(55);
        VIRTUAL.set(85);
        VIRTUAL.set(113);
        VIRTUAL.set(188);
        VIRTUAL.set(189);
        VIRTUAL.set(190);
        VIRTUAL.set(191);
        VIRTUAL.set(192);
        VIRTUAL.set(93);
        VIRTUAL.set(94);
        VIRTUAL.set(101);
        VIRTUAL.set(102);
        VIRTUAL.set(160);
        VIRTUAL.set(106);
        VIRTUAL.set(107);
        VIRTUAL.set(183);
        VIRTUAL.set(184);
        VIRTUAL.set(185);
        VIRTUAL.set(186);
        VIRTUAL.set(187);
        VIRTUAL.set(132);
        VIRTUAL.set(139);
        VIRTUAL.set(199);
        AIR = BlockStateData.getTag(0);
    }

    static final class UpgradeChunk {
        private int sides;
        private final Section[] sections = new Section[16];
        private final Dynamic<?> level;
        private final int x;
        private final int z;
        private final Int2ObjectMap<Dynamic<?>> blockEntities = new Int2ObjectLinkedOpenHashMap(16);

        public UpgradeChunk(Dynamic<?> chunkTag) {
            this.level = chunkTag;
            this.x = chunkTag.get("xPos").asInt(0) << 4;
            this.z = chunkTag.get("zPos").asInt(0) << 4;
            chunkTag.get("TileEntities").asStreamOpt().ifSuccess(stream -> stream.forEach(blockEntityTag -> {
                int k;
                int i = blockEntityTag.get("x").asInt(0) - this.x & 0xF;
                int j = blockEntityTag.get("y").asInt(0);
                int l = j << 8 | (k = blockEntityTag.get("z").asInt(0) - this.z & 0xF) << 4 | i;
                if (this.blockEntities.put(l, (Object)blockEntityTag) != null) {
                    LOGGER.warn("In chunk: {}x{} found a duplicate block entity at position: [{}, {}, {}]", new Object[]{this.x, this.z, i, j, k});
                }
            }));
            boolean bl = chunkTag.get("convertedFromAlphaFormat").asBoolean(false);
            chunkTag.get("Sections").asStreamOpt().ifSuccess(stream -> stream.forEach(sectionTag -> {
                Section section = new Section((Dynamic<?>)((Object)((Object)sectionTag)));
                this.sides = section.upgrade(this.sides);
                this.sections[section.y] = section;
            }));
            for (Section section : this.sections) {
                if (section == null) continue;
                block14: for (Map.Entry entry : section.toFix.entrySet()) {
                    int i = section.y << 12;
                    switch ((Integer)entry.getKey()) {
                        case 2: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string;
                                int j = (Integer)intListIterator.next();
                                Dynamic<?> dynamic = this.getBlock(j |= i);
                                if (!"minecraft:grass_block".equals(ChunkPalettedStorageFix.getName(dynamic)) || !"minecraft:snow".equals(string = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative(j, Direction.UP)))) && !"minecraft:snow_layer".equals(string)) continue;
                                this.setBlock(j, SNOWY_GRASS);
                            }
                            continue block14;
                        }
                        case 3: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string2;
                                int k = (Integer)intListIterator.next();
                                Dynamic<?> dynamic2 = this.getBlock(k |= i);
                                if (!"minecraft:podzol".equals(ChunkPalettedStorageFix.getName(dynamic2)) || !"minecraft:snow".equals(string2 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative(k, Direction.UP)))) && !"minecraft:snow_layer".equals(string2)) continue;
                                this.setBlock(k, SNOWY_PODZOL);
                            }
                            continue block14;
                        }
                        case 110: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string3;
                                int l = (Integer)intListIterator.next();
                                Dynamic<?> dynamic3 = this.getBlock(l |= i);
                                if (!"minecraft:mycelium".equals(ChunkPalettedStorageFix.getName(dynamic3)) || !"minecraft:snow".equals(string3 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative(l, Direction.UP)))) && !"minecraft:snow_layer".equals(string3)) continue;
                                this.setBlock(l, SNOWY_MYCELIUM);
                            }
                            continue block14;
                        }
                        case 25: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int m = (Integer)intListIterator.next();
                                Dynamic<?> dynamic4 = this.removeBlockEntity(m |= i);
                                if (dynamic4 == null) continue;
                                String string4 = Boolean.toString(dynamic4.get("powered").asBoolean(false)) + (byte)Math.min(Math.max(dynamic4.get("note").asInt(0), 0), 24);
                                this.setBlock(m, NOTE_BLOCK_MAP.getOrDefault(string4, NOTE_BLOCK_MAP.get("false0")));
                            }
                            continue block14;
                        }
                        case 26: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string5;
                                int o;
                                int n = (Integer)intListIterator.next();
                                Dynamic<?> dynamic5 = this.getBlockEntity(n |= i);
                                Dynamic<?> dynamic6 = this.getBlock(n);
                                if (dynamic5 == null || (o = dynamic5.get("color").asInt(0)) == 14 || o < 0 || o >= 16 || !BED_BLOCK_MAP.containsKey(string5 = ChunkPalettedStorageFix.getProperty(dynamic6, "facing") + ChunkPalettedStorageFix.getProperty(dynamic6, "occupied") + ChunkPalettedStorageFix.getProperty(dynamic6, "part") + o)) continue;
                                this.setBlock(n, BED_BLOCK_MAP.get(string5));
                            }
                            continue block14;
                        }
                        case 176: 
                        case 177: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string6;
                                int q;
                                int p = (Integer)intListIterator.next();
                                Dynamic<?> dynamic7 = this.getBlockEntity(p |= i);
                                Dynamic<?> dynamic8 = this.getBlock(p);
                                if (dynamic7 == null || (q = dynamic7.get("Base").asInt(0)) == 15 || q < 0 || q >= 16 || !BANNER_BLOCK_MAP.containsKey(string6 = ChunkPalettedStorageFix.getProperty(dynamic8, (Integer)entry.getKey() == 176 ? "rotation" : "facing") + "_" + q)) continue;
                                this.setBlock(p, BANNER_BLOCK_MAP.get(string6));
                            }
                            continue block14;
                        }
                        case 86: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string7;
                                int r = (Integer)intListIterator.next();
                                Dynamic<?> dynamic9 = this.getBlock(r |= i);
                                if (!"minecraft:carved_pumpkin".equals(ChunkPalettedStorageFix.getName(dynamic9)) || !"minecraft:grass_block".equals(string7 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative(r, Direction.DOWN)))) && !"minecraft:dirt".equals(string7)) continue;
                                this.setBlock(r, PUMPKIN);
                            }
                            continue block14;
                        }
                        case 140: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int s = (Integer)intListIterator.next();
                                Dynamic<?> dynamic10 = this.removeBlockEntity(s |= i);
                                if (dynamic10 == null) continue;
                                String string8 = dynamic10.get("Item").asString("") + dynamic10.get("Data").asInt(0);
                                this.setBlock(s, FLOWER_POT_MAP.getOrDefault(string8, FLOWER_POT_MAP.get("minecraft:air0")));
                            }
                            continue block14;
                        }
                        case 144: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String string12;
                                int t = (Integer)intListIterator.next();
                                Dynamic<?> dynamic11 = this.getBlockEntity(t |= i);
                                if (dynamic11 == null) continue;
                                String string9 = String.valueOf(dynamic11.get("SkullType").asInt(0));
                                String string10 = ChunkPalettedStorageFix.getProperty(this.getBlock(t), "facing");
                                if ("up".equals(string10) || "down".equals(string10)) {
                                    String string11 = string9 + String.valueOf(dynamic11.get("Rot").asInt(0));
                                } else {
                                    string12 = string9 + string10;
                                }
                                dynamic11.remove("SkullType");
                                dynamic11.remove("facing");
                                dynamic11.remove("Rot");
                                this.setBlock(t, SKULL_MAP.getOrDefault(string12, SKULL_MAP.get("0north")));
                            }
                            continue block14;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                Dynamic<?> dynamic13;
                                int u = (Integer)intListIterator.next();
                                Dynamic<?> dynamic12 = this.getBlock(u |= i);
                                if (!ChunkPalettedStorageFix.getName(dynamic12).endsWith("_door") || !"lower".equals(ChunkPalettedStorageFix.getProperty(dynamic13 = this.getBlock(u), "half"))) continue;
                                int v = UpgradeChunk.relative(u, Direction.UP);
                                Dynamic<?> dynamic14 = this.getBlock(v);
                                String string13 = ChunkPalettedStorageFix.getName(dynamic13);
                                if (!string13.equals(ChunkPalettedStorageFix.getName(dynamic14))) continue;
                                String string14 = ChunkPalettedStorageFix.getProperty(dynamic13, "facing");
                                String string15 = ChunkPalettedStorageFix.getProperty(dynamic13, "open");
                                String string16 = bl ? "left" : ChunkPalettedStorageFix.getProperty(dynamic14, "hinge");
                                String string17 = bl ? "false" : ChunkPalettedStorageFix.getProperty(dynamic14, "powered");
                                this.setBlock(u, DOOR_MAP.get(string13 + string14 + "lower" + string16 + string15 + string17));
                                this.setBlock(v, DOOR_MAP.get(string13 + string14 + "upper" + string16 + string15 + string17));
                            }
                            continue block14;
                        }
                        case 175: {
                            IntListIterator intListIterator = ((IntList)entry.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int w = (Integer)intListIterator.next();
                                Dynamic<?> dynamic15 = this.getBlock(w |= i);
                                if (!"upper".equals(ChunkPalettedStorageFix.getProperty(dynamic15, "half"))) continue;
                                Dynamic<?> dynamic16 = this.getBlock(UpgradeChunk.relative(w, Direction.DOWN));
                                String string18 = ChunkPalettedStorageFix.getName(dynamic16);
                                if ("minecraft:sunflower".equals(string18)) {
                                    this.setBlock(w, UPPER_SUNFLOWER);
                                    continue;
                                }
                                if ("minecraft:lilac".equals(string18)) {
                                    this.setBlock(w, UPPER_LILAC);
                                    continue;
                                }
                                if ("minecraft:tall_grass".equals(string18)) {
                                    this.setBlock(w, UPPER_TALL_GRASS);
                                    continue;
                                }
                                if ("minecraft:large_fern".equals(string18)) {
                                    this.setBlock(w, UPPER_LARGE_FERN);
                                    continue;
                                }
                                if ("minecraft:rose_bush".equals(string18)) {
                                    this.setBlock(w, UPPER_ROSE_BUSH);
                                    continue;
                                }
                                if (!"minecraft:peony".equals(string18)) continue;
                                this.setBlock(w, UPPER_PEONY);
                            }
                            break;
                        }
                    }
                }
            }
        }

        @Nullable
        private Dynamic<?> getBlockEntity(int packedLocalPos) {
            return (Dynamic)((Object)this.blockEntities.get(packedLocalPos));
        }

        @Nullable
        private Dynamic<?> removeBlockEntity(int packedLocalPos) {
            return (Dynamic)((Object)this.blockEntities.remove(packedLocalPos));
        }

        public static int relative(int packedLocalPos, Direction direction) {
            switch (direction.getAxis().ordinal()) {
                case 0: {
                    int i = (packedLocalPos & 0xF) + direction.getAxisDirection().getStep();
                    return i < 0 || i > 15 ? -1 : packedLocalPos & 0xFFFFFFF0 | i;
                }
                case 1: {
                    int j = (packedLocalPos >> 8) + direction.getAxisDirection().getStep();
                    return j < 0 || j > 255 ? -1 : packedLocalPos & 0xFF | j << 8;
                }
                case 2: {
                    int k = (packedLocalPos >> 4 & 0xF) + direction.getAxisDirection().getStep();
                    return k < 0 || k > 15 ? -1 : packedLocalPos & 0xFFFFFF0F | k << 4;
                }
            }
            return -1;
        }

        private void setBlock(int packedLocalPos, Dynamic<?> dynamic) {
            if (packedLocalPos < 0 || packedLocalPos > 65535) {
                return;
            }
            Section section = this.getSection(packedLocalPos);
            if (section == null) {
                return;
            }
            section.setBlock(packedLocalPos & 0xFFF, dynamic);
        }

        @Nullable
        private Section getSection(int packedLocalPos) {
            int i = packedLocalPos >> 12;
            return i < this.sections.length ? this.sections[i] : null;
        }

        public Dynamic<?> getBlock(int packedLocalPos) {
            if (packedLocalPos < 0 || packedLocalPos > 65535) {
                return AIR;
            }
            Section section = this.getSection(packedLocalPos);
            if (section == null) {
                return AIR;
            }
            return section.getBlock(packedLocalPos & 0xFFF);
        }

        public Dynamic<?> write() {
            Dynamic<?> dynamic = this.level;
            dynamic = this.blockEntities.isEmpty() ? dynamic.remove("TileEntities") : dynamic.set("TileEntities", dynamic.createList(this.blockEntities.values().stream()));
            Dynamic dynamic2 = dynamic.emptyMap();
            ArrayList list = Lists.newArrayList();
            for (Section section : this.sections) {
                if (section == null) continue;
                list.add(section.write());
                dynamic2 = dynamic2.set(String.valueOf(section.y), dynamic2.createIntList(Arrays.stream(section.update.toIntArray())));
            }
            Dynamic dynamic3 = dynamic.emptyMap();
            dynamic3 = dynamic3.set("Sides", dynamic3.createByte((byte)this.sides));
            dynamic3 = dynamic3.set("Indices", dynamic2);
            return dynamic.set("UpgradeData", dynamic3).set("Sections", dynamic3.createList(list.stream()));
        }
    }

    public static enum Direction {
        DOWN(AxisDirection.NEGATIVE, Axis.Y),
        UP(AxisDirection.POSITIVE, Axis.Y),
        NORTH(AxisDirection.NEGATIVE, Axis.Z),
        SOUTH(AxisDirection.POSITIVE, Axis.Z),
        WEST(AxisDirection.NEGATIVE, Axis.X),
        EAST(AxisDirection.POSITIVE, Axis.X);

        private final Axis axis;
        private final AxisDirection axisDirection;

        private Direction(AxisDirection direction, Axis axis) {
            this.axis = axis;
            this.axisDirection = direction;
        }

        public AxisDirection getAxisDirection() {
            return this.axisDirection;
        }

        public Axis getAxis() {
            return this.axis;
        }

        public static enum Axis {
            X,
            Y,
            Z;

        }

        public static enum AxisDirection {
            POSITIVE(1),
            NEGATIVE(-1);

            private final int step;

            private AxisDirection(int offset) {
                this.step = offset;
            }

            public int getStep() {
                return this.step;
            }
        }
    }

    static class DataLayer {
        private static final int SIZE = 2048;
        private static final int NIBBLE_SIZE = 4;
        private final byte[] data;

        public DataLayer() {
            this.data = new byte[2048];
        }

        public DataLayer(byte[] contents) {
            this.data = contents;
            if (contents.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + contents.length);
            }
        }

        public int get(int x, int y, int z) {
            int i = this.getPosition(y << 8 | z << 4 | x);
            if (this.isFirst(y << 8 | z << 4 | x)) {
                return this.data[i] & 0xF;
            }
            return this.data[i] >> 4 & 0xF;
        }

        private boolean isFirst(int index) {
            return (index & 1) == 0;
        }

        private int getPosition(int index) {
            return index >> 1;
        }
    }

    static class Section {
        private final CrudeIncrementalIntIdentityHashBiMap<Dynamic<?>> palette = CrudeIncrementalIntIdentityHashBiMap.create(32);
        private final List<Dynamic<?>> listTag;
        private final Dynamic<?> section;
        private final boolean hasData;
        final Int2ObjectMap<IntList> toFix = new Int2ObjectLinkedOpenHashMap();
        final IntList update = new IntArrayList();
        public final int y;
        private final Set<Dynamic<?>> seen = Sets.newIdentityHashSet();
        private final int[] buffer = new int[4096];

        public Section(Dynamic<?> section) {
            this.listTag = Lists.newArrayList();
            this.section = section;
            this.y = section.get("Y").asInt(0);
            this.hasData = section.get("Blocks").result().isPresent();
        }

        public Dynamic<?> getBlock(int index) {
            if (index < 0 || index > 4095) {
                return AIR;
            }
            Dynamic<?> dynamic = this.palette.byId(this.buffer[index]);
            return dynamic == null ? AIR : dynamic;
        }

        public void setBlock(int pos, Dynamic<?> dynamic) {
            if (this.seen.add(dynamic)) {
                this.listTag.add("%%FILTER_ME%%".equals(ChunkPalettedStorageFix.getName(dynamic)) ? AIR : dynamic);
            }
            this.buffer[pos] = ChunkPalettedStorageFix.idFor(this.palette, dynamic);
        }

        public int upgrade(int sidesToUpgrade) {
            if (!this.hasData) {
                return sidesToUpgrade;
            }
            ByteBuffer byteBuffer2 = (ByteBuffer)this.section.get("Blocks").asByteBufferOpt().result().get();
            DataLayer dataLayer = this.section.get("Data").asByteBufferOpt().map(byteBuffer -> new DataLayer(DataFixUtils.toArray((ByteBuffer)byteBuffer))).result().orElseGet(DataLayer::new);
            DataLayer dataLayer2 = this.section.get("Add").asByteBufferOpt().map(byteBuffer -> new DataLayer(DataFixUtils.toArray((ByteBuffer)byteBuffer))).result().orElseGet(DataLayer::new);
            this.seen.add(AIR);
            ChunkPalettedStorageFix.idFor(this.palette, AIR);
            this.listTag.add(AIR);
            for (int i = 0; i < 4096; ++i) {
                int j = i & 0xF;
                int k = i >> 8 & 0xF;
                int l = i >> 4 & 0xF;
                int m = dataLayer2.get(j, k, l) << 12 | (byteBuffer2.get(i) & 0xFF) << 4 | dataLayer.get(j, k, l);
                if (FIX.get(m >> 4)) {
                    this.addFix(m >> 4, i);
                }
                if (VIRTUAL.get(m >> 4)) {
                    int n = ChunkPalettedStorageFix.getSideMask(j == 0, j == 15, l == 0, l == 15);
                    if (n == 0) {
                        this.update.add(i);
                    } else {
                        sidesToUpgrade |= n;
                    }
                }
                this.setBlock(i, BlockStateData.getTag(m));
            }
            return sidesToUpgrade;
        }

        private void addFix(int section, int index) {
            IntList intList = (IntList)this.toFix.get(section);
            if (intList == null) {
                intList = new IntArrayList();
                this.toFix.put(section, (Object)intList);
            }
            intList.add(index);
        }

        public Dynamic<?> write() {
            Dynamic<?> dynamic = this.section;
            if (!this.hasData) {
                return dynamic;
            }
            dynamic = dynamic.set("Palette", dynamic.createList(this.listTag.stream()));
            int i = Math.max(4, DataFixUtils.ceillog2((int)this.seen.size()));
            PackedBitStorage packedBitStorage = new PackedBitStorage(i, 4096);
            for (int j = 0; j < this.buffer.length; ++j) {
                packedBitStorage.set(j, this.buffer[j]);
            }
            dynamic = dynamic.set("BlockStates", dynamic.createLongList(Arrays.stream(packedBitStorage.getRaw())));
            dynamic = dynamic.remove("Blocks");
            dynamic = dynamic.remove("Data");
            dynamic = dynamic.remove("Add");
            return dynamic;
        }
    }
}

