/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public class EntityEquipmentToArmorAndHandFix
extends DataFix {
    public EntityEquipmentToArmorAndHandFix(Schema schema, boolean bl) {
        super(schema, bl);
    }

    public TypeRewriteRule makeRule() {
        return this.cap(this.getInputSchema().getTypeRaw(References.ITEM_STACK));
    }

    private <IS> TypeRewriteRule cap(Type<IS> type) {
        Type type2 = DSL.and((Type)DSL.optional((Type)DSL.field((String)"Equipment", (Type)DSL.list(type))), (Type)DSL.remainderType());
        Type type3 = DSL.and((Type)DSL.optional((Type)DSL.field((String)"ArmorItems", (Type)DSL.list(type))), (Type)DSL.optional((Type)DSL.field((String)"HandItems", (Type)DSL.list(type))), (Type)DSL.optional((Type)DSL.field((String)"body_armor_item", type)), (Type)DSL.remainderType());
        OpticFinder opticFinder = DSL.typeFinder((Type)type2);
        OpticFinder opticFinder2 = DSL.fieldFinder((String)"Equipment", (Type)DSL.list(type));
        return this.fixTypeEverywhereTyped("EntityEquipmentToArmorAndHandFix", this.getInputSchema().getType(References.ENTITY), this.getOutputSchema().getType(References.ENTITY), typed -> {
            Either<Object, Object> either = Either.right(DSL.unit());
            Either<Object, Object> either2 = Either.right(DSL.unit());
            Either either3 = Either.right(DSL.unit());
            Dynamic dynamic = (Dynamic)((Object)((Object)typed.getOrCreate(DSL.remainderFinder())));
            Optional optional = typed.getOptional(opticFinder2);
            if (optional.isPresent()) {
                List list = (List)optional.get();
                Object object = ((Pair)type.read(dynamic.emptyMap()).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created empty itemstack."))).getFirst();
                if (!list.isEmpty()) {
                    either = Either.left(Lists.newArrayList((Object[])new Object[]{list.get(0), object}));
                }
                if (list.size() > 1) {
                    ArrayList list2 = Lists.newArrayList((Object[])new Object[]{object, object, object, object});
                    for (int i = 1; i < Math.min(list.size(), 5); ++i) {
                        list2.set(i - 1, list.get(i));
                    }
                    either2 = Either.left(list2);
                }
            }
            Dynamic dynamic2 = dynamic;
            Optional optional2 = dynamic.get("DropChances").asStreamOpt().result();
            if (optional2.isPresent()) {
                Iterator iterator = Stream.concat((Stream)optional2.get(), Stream.generate(() -> dynamic2.createInt(0))).iterator();
                float f = ((Dynamic)((Object)((Object)iterator.next()))).asFloat(0.0f);
                if (dynamic.get("HandDropChances").result().isEmpty()) {
                    Dynamic dynamic3 = dynamic.createList(Stream.of(Float.valueOf(f), Float.valueOf(0.0f)).map(arg_0 -> dynamic.createFloat(arg_0)));
                    dynamic = dynamic.set("HandDropChances", dynamic3);
                }
                if (dynamic.get("ArmorDropChances").result().isEmpty()) {
                    Dynamic dynamic4 = dynamic.createList(Stream.of(Float.valueOf(((Dynamic)((Object)((Object)iterator.next()))).asFloat(0.0f)), Float.valueOf(((Dynamic)((Object)((Object)iterator.next()))).asFloat(0.0f)), Float.valueOf(((Dynamic)((Object)((Object)iterator.next()))).asFloat(0.0f)), Float.valueOf(((Dynamic)((Object)((Object)iterator.next()))).asFloat(0.0f))).map(arg_0 -> dynamic.createFloat(arg_0)));
                    dynamic = dynamic.set("ArmorDropChances", dynamic4);
                }
                dynamic = dynamic.remove("DropChances");
            }
            return typed.set(opticFinder, type3, (Object)Pair.of(either, (Object)Pair.of(either2, (Object)Pair.of(either3, (Object)((Object)dynamic)))));
        });
    }
}

